/***************************************************************************
 *  
 *  File:            Lists.h
 *  
 *  Description:     Include file for dealing with lists.
 * 
 *  Author:          Vicente Rey
 *
 *  Created:         22 May 1995
 *  
 *    (copyright by E.S.R.F.  March 1995)
 * 
 ***************************************************************************/
#ifndef LISTS_H
#define LISTS_H

#include <malloc.h>

typedef struct _ObjectList {
  struct _ObjectList   *next;
  struct _ObjectList   *prev;
  void                 *contents;
} ObjectList;

typedef struct _ListHeader {
  struct _ObjectList   *first;
  struct _ObjectList   *last;
} ListHeader;

#ifdef __STDC__
extern  ObjectList     *findInList();
extern  long		addToList(ListHeader *list,void *object,long size);
extern  long		linkToList(ListHeader *list,void *object);
extern  void		unlinkFromList(ListHeader *list,ObjectList *element);
#else
extern  ObjectList     *findInList();
extern  long		addToList();
extern  long		linkToList();
extern  void		unlinkFromList();
#endif /* __STDC__ */

#endif  /*  LISTS_H  */
