
/***************************************************************************
 *  
 *  File:            SpecFileP.h
 *  
 *  Description:     Include file for treating spec data files.
 * 
 *  Author:          Vicente Rey
 *
 *  Created:         2 March 1995
 *  
 *    (copyright by E.S.R.F.  March 1995)
 * 
 ***************************************************************************/
#ifndef SPECFILE_P_H
#define SPECFILE_P_H

/*
 * Defines.
 */
#define	  D_INFO		3   /*Number of data_info lines in sfData*/
#define   BUFFER_SIZE		100 /*Size of string buffer 
						        in sfOpen() */ 
#define   WAITING_FILE		       	0
#define   READING_SCAN		       	1
#define   READING_DATA		       	2
#define   READING_HEADER	       	3

#define   SF_COMMENT			'C'
#define   SF_DATE			'D'
#define   SF_EPOCH			'E'
#define   SF_FILE_NAME			'F'
#define   SF_GEOMETRY			'G'
#define   SF_INTENSITY			'I'
#define   SF_LABEL			'L'
#define   SF_MON_NORM			'M'
#define   SF_COLUMNS			'N'
#define   SF_MOTOR_NAMES		'O'
#define   SF_MOTOR_POSITIONS		'P'
#define   SF_RECIP_SPACE		'Q'
#define   SF_RESULTS			'R'
#define   SF_SCAN_NUM			'S'
#define   SF_TIME_NORM			'T'
#define   SF_USER_DEFINED		'U'
#define   SF_TEMPERATURE		'X'
#define   SF_MCA_DATA			'@'

long      sf_debug = 0;
long      sf_index = 1;

typedef struct _errors{
     int	code;
     char      *message;
} sf_errors ;

static
sf_errors errors[]={
{ SF_ERR_MEMORY_ALLOC		, "Memory allocation error ( SpecFile )"  },
{ SF_ERR_FILE_OPEN		, "File open error ( SpecFile )"	  },
{ SF_ERR_FILE_CLOSE		, "File close error ( SpecFile )"         },
{ SF_ERR_FILE_READ		, "File read error ( SpecFile )"	  },
{ SF_ERR_FILE_WRITE		, "File write error ( SpecFile )"	  },
{ SF_ERR_LINE_NOT_FOUND		, "Line not found error ( SpecFile )"	  },
{ SF_ERR_SCAN_NOT_FOUND		, "Scan not found error ( SpecFile )"	  },
{ SF_ERR_HEADER_NOT_FOUND	, "Header not found error ( SpecFile )"	  },
{ SF_ERR_LABEL_NOT_FOUND	, "Label not found error ( SpecFile )"	  },
{ SF_ERR_MOTOR_NOT_FOUND	, "Motor not found error ( SpecFile )"	  },
{ SF_ERR_POSITION_NOT_FOUND	, "Position not found error ( SpecFile )" },
{ SF_ERR_LINE_EMPTY		, "Line empty or wrong data error ( SpecFile )"},
{ SF_ERR_USER_NOT_FOUND		, "User not found error ( SpecFile )" 	  },
{ SF_ERR_COL_NOT_FOUND		, "Column not found error ( SpecFile )"	  },
/* MUST be always the last one : */
{ SF_ERR_NO_ERRORS		, "OK ( SpecFile )"			  },
};


/*
 * Function declarations.
 */
static  SpecFile       *sfOpenIndex();
/*
static  SpecFile       *sfOpen();
static  int             sfUpdate();
*/
static  SpecFile       *sfReadFile();
static  SpecFile       *sfReadIndex();
static  void             sfWriteIndex();
static  int             sfUpdateList();
static  long            getflength();

static  int		analyzeLine();
static  int		getScanOrder();
static  int		findIndex();
static  int		findNoAndOr();
static  ObjectList     *findScanByIndex();
static  ObjectList     *findScanByNo();
static  long	        findFirstInFile();

static  void		deleteScan();

static  long		mulstrtod();

static  char	       *readFileLine();   
static  char	       *findLine();
extern  char	       *readHeader();
static  long	        readHeaderLines();
static  char	       *readFirstFileC();

static  int		checkSameFile();
static  int		checkSameScan();
extern  int		checkAborted();
static  void		setScanCurrent();

static  void		freeArr();	

static  double	      **cpyDblArr();
static  char	      **cpyStrArr();
static  int		cpyBlock();
static  long		lines2words();
static  char	       *getStrFromArr();
static  char	       *findWordInLine();
static	int				setScanOrder();

#endif  /*  SPECFILE_P_H  */



