/***************************************************************************
 *  
 *  File:            SpecFile.h
 *  
 *  Description:     Include file for treating spec data files.
 * 
 *  Author:          Vicente Rey
 *
 *  Created:         2 March 1995
 *  
 *    (copyright by E.S.R.F.  March 1995)
 * 
 ***************************************************************************/
#ifndef SPECFILE_H
#define SPECFILE_H

#include <math.h>
#include <stdio.h>

#include <time.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include "Lists.h"

#ifdef SUN4
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif
/*
 * Defines.
 */
#define	  ROW			0  /* data_info index for no. of data rows  */
#define	  COL			1  /* data_info index for no. of data columns*/
#define	  REG			2  /* data_info index for regular            */

#define	  H			0
#define	  K			1
#define	  L			2
#define	  ABORTED	       -1
#define	  NOT_ABORTED		0

#define	  SF_ERR_NO_ERRORS			0
#define	  SF_ERR_MEMORY_ALLOC			1
#define   SF_ERR_FILE_OPEN			2
#define   SF_ERR_FILE_READ			3
#define   SF_ERR_LINE_NOT_FOUND			4
#define   SF_ERR_SCAN_NOT_FOUND			5
#define   SF_ERR_HEADER_NOT_FOUND		6
#define   SF_ERR_LABEL_NOT_FOUND		7
#define   SF_ERR_MOTOR_NOT_FOUND		8
#define   SF_ERR_POSITION_NOT_FOUND		9
#define   SF_ERR_LINE_EMPTY			10
#define   SF_ERR_USER_NOT_FOUND			11
#define   SF_ERR_WORD_NOT_FOUND			12
#define   SF_ERR_COL_NOT_FOUND			13
#define   SF_ERR_FILE_CLOSE			14
#define   SF_ERR_FILE_WRITE			15
#define   SF_ERR_LIST_NOT_FOUND			16

typedef struct _SpecFile{
  FILE		       *fd;
  char                 *sfname;
  long                  sflen;
  struct _ListHeader	list;
  long int		no_scans;
  ObjectList	       *current; 
  double	      **data;
  long		       *data_info;   
  char		      **labels;
  long int		no_labels;
  double	       *motor_pos;	
  long int      	no_motor_pos;	
  char		      **motor_names;   
  long int		no_motor_names;
  long int		header_offset;  
  long int		epoch;
  long int		end;
} SpecFile;

typedef struct _SpecFileOut{
  SpecFile		*sf;
  long			*list;
  long			 list_size;
  long			 last_header;
} SpecFileOut;

typedef struct _SpecScan {
  long int		index;
  long int		scan_no;
  long int     		order;
  long int		offset;
  long int		data_offset;
  long int		last_data_offset;
  long int		last_header;
  long int		data_lines;
  long int		header_lines_before;
  long int		header_lines_after;
} SpecScan;

/*
 * Function declarations.
 */
#ifdef __STDC__

extern	SpecFile       *SfOpen		( char *name, int *error ); 
extern	int             SfUpdate	( SpecFile *sf,int *error ); 
extern	int		SfClose		( SpecFile *sf );  

extern  long	        SfScanNo	( SpecFile *sf ); 
extern	long	       *SfList		( SpecFile *sf, int *error ); 
extern	long	        SfCondList	( SpecFile *sf, long cond, long **scan_list, int *error );
extern	long		SfIndex		( SpecFile *sf, long number, long order ); 
extern	long		SfIndexes	( SpecFile *sf, long number, long **indexlist ); 
extern	long		SfNumber	( SpecFile *sf, long index ); 
extern	long		SfOrder		( SpecFile *sf, long index ); 
extern	int		SfNumberOrder	( SpecFile *sf, long index, long *number, long *order );

extern	long		SfNoColumns	( SpecFile *sf, long index, int *error ); 
extern	long		SfEpoch		( SpecFile *sf, long index, int *error ); 
extern	char	       *SfDate		( SpecFile *sf, long index, int *error ); 
extern	char	       *SfCommand	( SpecFile *sf, long index, int *error );  

extern	long		SfHeader	( SpecFile *sf, long index, char	*string, char ***lines, int *error ); 
extern	long		SfNoHeaderBefore( SpecFile *sf, long index, int *error ); 
extern	long		SfFileHeader	( SpecFile *sf, long index, char *string, char ***lines, int *error ); 

extern	long		SfNoDataLines	( SpecFile *sf, long index, int *error ); 
extern	int	        SfData		( SpecFile *sf, long index, double ***data, long **data_info, int *error ); 
extern	long	        SfDataAsString	( SpecFile *sf, long index, char ***data, int *error ); 
extern	long		SfDataLine	( SpecFile *sf, long index, long line, double **data_line, int *error ); 
extern	long		SfDataCol	( SpecFile *sf, long index, long col, double **data_col, int *error ); 
extern	long		SfDataColByName	( SpecFile *sf, long index, char *label, double **data_col, int *error ); 

extern	long		SfAllLabels	( SpecFile *sf, long index, char ***labels, int *error ); 
extern	char	       *SfLabel		( SpecFile *sf, long index, long column, int *error ); 

extern  long	        SfAllMotors	( SpecFile *sf, long index, char ***names, int *error ); 
extern  char	       *SfMotor		( SpecFile *sf, long index, long number, int *error ); 
extern  long	        SfAllMotorPos	( SpecFile *sf, long index, double **pos, int *error ); 
extern  double	        SfMotorPos	( SpecFile *sf, long index, long number, int *error ); 
extern  double	        SfMotorPosByName( SpecFile *sf, long index, char *name, int *error ); 

extern  long	        SfGeometry	( SpecFile *sf, long index, char ***lines, int *error ); 
extern  char	       *SfFileDate	( SpecFile *sf, long index, int *error ); 
extern  char	       *SfUser		( SpecFile *sf, long index, int *error ); 
extern  char	       *SfTitle		( SpecFile *sf, long index, int *error ); 
extern  double	       *SfHKL		( SpecFile *sf, long index, int *error );

/* 
 * Write and write related functions
 */
extern  SpecFileOut    *SfoInit		( SpecFile *sf, int *error ); 
extern  void		SfoClose	( SpecFileOut *sfo ); 
extern  long		SfoSelectOne	( SpecFileOut *sfo, long index, int *error ); 
extern  long		SfoSelect	( SpecFileOut *sfo, long *list, int *error ); 
extern  long		SfoSelectRange	( SpecFileOut *sfo, long begin, long end, int *error ); 
extern  long		SfoSelectAll	( SpecFileOut *sfo, int *error ); 
extern  long	       	SfoRemoveOne	( SpecFileOut *sfo, long index, int *error ); 
extern  long	       	SfoRemove	( SpecFileOut *sfo, long *list, int *error ); 
extern  long	       	SfoRemoveRange	( SpecFileOut *sfo, long begin, long end, int *error ); 
extern  long	       	SfoRemoveAll	( SpecFileOut *sfo, int *error ); 
extern  long		SfoWrite	( SpecFileOut *sfo, char *name, int *error ); 
extern  long	        SfoGetList	( SpecFileOut *sfo, long **list, int *error ); 
/* 
 * Memory free functions
 */
extern  void		freeArrNZ       ( void ***ptr, long no_lines );
extern  void		freePtr		( void *ptr );

extern  char	       *SfError		( int code ); 
extern  void		SfDebugOn (); 
extern  void		SfDebugOff();  

#else

extern	SpecFile       *SfOpen();
extern	int		SfClose(); 
extern  int 	        SfSync();

extern  long	        SfScanNo();
extern	long	       *SfList();
extern	long	        SfCondList();
extern	long		SfIndex();
extern	long		SfIndexes();
extern	long		SfNumber();
extern	long		SfOrder();
extern	int		SfNumberOrder();

extern	long		SfNoColumns();
extern	long		SfEpoch();
extern	char	       *SfDate();
extern	char	       *SfCommand(); 
extern	double	       *SfHKL();

extern	long		SfHeader();
extern	long		SfNoHeaderBefore();
extern	long		SfFileHeader();

extern	long		SfNoDataLines();
extern	int	        SfData();
extern	long	        SfDataAsString();
extern	long		SfDataLine();
extern	long		SfDataCol();
extern	long		SfDataColByName();

extern	long		SfAllLabels();
extern	char	       *SfLabel();

extern  long	        SfAllMotor();
extern  char	       *SfMotor();
extern  long	        SfAllMotorPos();
extern  double	        SfMotorPos();
extern  double	        SfMotorPosByName();

extern  long	        SfGeometry();
extern  char	       *SfFileDate();
extern  char	       *SfUser();
extern  char	       *SfTitle();
/* 
 * Write and write related functions
 */
extern  SpecFileOut    *SfoInit();
extern  void		SfoClose();
extern  long		SfoSelectOne();
extern  long		SfoSelect();
extern  long		SfoSelectRange();
extern  long		SfoSelectAll();
extern  long	       	SfoRemoveOne();
extern  long	       	SfoRemove();
extern  long	       	SfoRemoveRange();
extern  long	       	SfoRemoveAll();
extern  long		SfoWrite();
extern  long	        SfoGetList();
/* 
 * Memory free functions
 */
extern  void		freeArrNZ();
extern  void		freePtr();

extern  char	       *SfError();
extern  void		SfDebugOn();
extern  void		SfDebugOff();
#endif  /* not __STDC__ */

#endif  /*  SPECFILE_H  */
