import sys
import os
import PyQt4.Qt as qt 
from PyQt4.Qt import *
# from PyQt4.Qt.QTableWidget  import *
from DocMenager import *
from general_Tree import Tree
from Tree_View import TreeView
from QTypeObject import *
import constVariable

QIconSet = QIcon

#*************************************CLASS WindowForCopy***********************************************************-

#*******************************CLASS TreeApp*******************************************************
class TreeApp(QMainWindow):

	def __init__(self,*args):
		apply(QMainWindow.__init__,(self,)+args)
		#print QWidget.windowState()
		#self.showFullScreen ()
		#setWState(Qt.WindowFullScreen)
		# self.setCaption('XMLGUI')
		self.setMinimumSize (QSize (300,300))
		self.windowActifList=[] #pour la passage antre les fenetres
		#self.start=1

		self.initActions()
		self.initMenuBar()
		self.initToolBar()
		self.initStatusBar()

		self.initWidjet()
		self.initElements()
		self.initChildren()
		self.initModification()
		self.initDefinition()

		self.slotNewTree()
		#self.initTree()
		#self.initView()

	def initActions(self):
		basedir=os.path.dirname(__file__)
		if basedir=="":
			basedir="."
		dirname=basedir+"/"
		filenew=dirname+'Icons/new.png'
		fileopen=dirname+'Icons/open.png'
		filesave=dirname+'Icons/Save.png'

		editundo=dirname+'Icons/Undo.png'
		editdef=dirname+'Icons/GoToDef.png'
		editcut=dirname+'Icons/cut2.png'
		editcopy=dirname+'Icons/copy.png'
		editcopySpec=dirname+'Icons/copySpec.png'
		editpast=dirname+'Icons/past.png'
		editdel=dirname+'Icons/delete.png'
		editfind=dirname+'Icons/Find.png'

		iconNew=QIconSet(QPixmap(filenew))
		iconOpen=QIconSet(QPixmap(fileopen))
		iconSave=QIconSet(QPixmap(filesave))

		iconUndo=QIconSet(QPixmap(editundo))
		iconDef=QIconSet(QPixmap(editdef))
		iconCut=QIconSet(QPixmap(editcut))
		iconCopy=QIconSet(QPixmap(editcopy))
		iconCopySpec=QIconSet(QPixmap(editcopySpec))
		iconPast=QIconSet(QPixmap(editpast))
		iconDel=QIconSet(QPixmap(editdel))
		iconFind=QIconSet(QPixmap(editfind))


		self.actions={}
		#les actions pour le menu File
		self.actions['fileNew']=QAction('New',iconNew,'&New',QAccel.stringToKey('CTRL+N'),self)
		self.actions['fileOpen']=QAction('Open',iconOpen,'&Open',QAccel.stringToKey('CTRL+O'),self)
		self.actions['fileOpenExamples']=QAction('Open Examples',iconOpen,'Open Examp&les',QAccel.stringToKey('CTRL+l'),self)
		self.actions['fileSave']=QAction('Save',iconSave,'&Save',QAccel.stringToKey('CTRL+S'),self)
		self.actions['fileSaveAs']=QAction(self)
		self.actions['fileSaveAs'].setMenuText ('Save as...')
		self.actions['fileExit']=QAction('Exit',QAccel.stringToKey('CTRL+Q'),self)

		#les actions pour le menu Edit
		self.actions['editUndo']=QAction('Undo',iconUndo,'&Undo', QAccel.stringToKey('CTRL+Z') ,self)
		self.actions['editDef']=QAction('Go to def',iconDef,'&Go to def', QAccel.stringToKey('CTRL+G') ,self)
		self.actions['editCut']=QAction('Cut',iconCut,'&Cut',QAccel.stringToKey('CTRL+X'),self)
		self.actions['editCopy']=QAction('Copy',iconCopy,'&Copy',QAccel.stringToKey('CTRL+C'),self)
		self.actions['editCopySpec']=QAction('Copy special',iconCopySpec,'&Copy special',QKeySequence ('CTRL+P'),self)
		self.actions['editPast']=QAction('Past',iconPast,'&Past',QAccel.stringToKey('CTRL+V'),self)
		self.actions['editDel']=QAction('Delete',iconDel,'&Delete',QAccel.stringToKey('CTRL+D'),self)
		self.actions['editFind']=QAction('Find',iconFind,'&Find',QAccel.stringToKey('CTRL+F'),self)
		self.actions['editFindNext']=QAction('Find next',QAccel.stringToKey('F3'),self)

		#les actions pour le menu View
		self.actions['viewElem']=QAction('Add element',QAccel.stringToKey('CTRL+A'),self)
		self.actions['viewElem'].setToggleAction(1)
		self.actions['viewElem'].setOn (1)

		self.actions['viewChild']=QAction('Add subelements',QAccel.stringToKey('CTRL+T'),self)
		self.actions['viewChild'].setToggleAction(1)
		self.actions['viewChild'].setOn (1)

		self.actions['viewEdit']=QAction('Edit element',QAccel.stringToKey('CTRL+E'),self)
		self.actions['viewEdit'].setToggleAction(1)
		self.actions['viewEdit'].setOn (1)

		self.actions['viewDef']=QAction('Definition of element',QAccel.stringToKey('CTRL+I'),self)
		self.actions['viewDef'].setToggleAction(1)
		self.actions['viewDef'].setOn (1)

		#les actions pour le menu Run
		self.actions['run']=QAction('Run',QAccel.stringToKey('CTRL+R'),self)
		#self.actions['stop']=QAction('Stop',QAccel.stringToKey('CTRL+B'),self)
		self.actions['graph']=QAction('Graph',QAccel.stringToKey('CTRL+M'),self)

		#les actions pour le menu Help
		self.actions['help']=QAction('Help',QAccel.stringToKey('F1'),self)
		self.actions['helpAut']=QAction('Automatical help',QAccel.stringToKey('CTRL+H'),self)
		self.actions['helpAut'].setToggleAction(1)
		self.actions['helpAut'].setOn (1)
		self.actions['helpAuthor']=QAction('Author',QAccel.stringToKey('F2'),self)


		#les signals pour  les actions de le menu File
		self.connect(self.actions['fileNew'],SIGNAL('activated()'),self.slotNewTree)
		self.connect(self.actions['fileOpen'],SIGNAL('activated()'),self.slotOpenFile)
		self.connect(self.actions['fileOpenExamples'],SIGNAL('activated()'),self.slotOpenFileExamples)
		self.connect(self.actions['fileSave'],SIGNAL('activated()'),self.slotGetStrForSave)
		self.connect(self.actions['fileSaveAs'],SIGNAL('activated()'),self.slotGetStrForSaveAs)
		self.connect(self.actions['fileExit'],SIGNAL('activated()'),self.slotExit)

		#les signals pour  les actions de le menu Edit
		self.connect(self.actions['editUndo'],SIGNAL('activated()'),self.slotUndo)
		self.connect(self.actions['editDef'],SIGNAL('activated()'),self.slotFindDef)
		self.connect(self.actions['editCut'],SIGNAL('activated()'),self.slotCut)
		self.connect(self.actions['editCopy'],SIGNAL('activated()'),self.slotCopy)
		self.connect(self.actions['editCopySpec'],SIGNAL('activated()'),self.slotCopySpecial)
		self.connect(self.actions['editPast'],SIGNAL('activated()'),self.slotInsert)
		self.connect(self.actions['editDel'],SIGNAL('activated()'),self.slotDelete)
		self.connect(self.actions['editFind'],SIGNAL('activated()'),self.slotFind)
		self.connect(self.actions['editFindNext'],SIGNAL('activated()'),self.slotFindNext)


		##les signals pour  les actions de le menu View
		self.connect(self.actions['viewElem'],SIGNAL('toggled ( bool)'),self.slotShowHideElement)
		self.connect(self.actions['viewChild'],SIGNAL('toggled ( bool)'),self.slotShowHideChildrenGroup)
		self.connect(self.actions['viewEdit'],SIGNAL('toggled ( bool)'),self.slotShowHideEdit)
		self.connect(self.actions['viewDef'],SIGNAL('toggled ( bool)'),self.slotShowHideDefinition)

		##les signals pour  les actions de le menu Run
		self.connect(self.actions['run'],SIGNAL('activated ()'),self.slotRun)
		#self.connect(self.actions['stop'],SIGNAL('activated ()'),self.slotStop)
		self.connect(self.actions['graph'],SIGNAL('activated ()'),self.slotGraph)

		##les signals pour  les actions de le menu Help
		self.connect(self.actions['help'],SIGNAL('activated ()'),self.slotGiveWhatsThis)
		self.connect(self.actions['helpAut'],SIGNAL('toggled ( bool)'),self.slotHelpAut)
		self.connect(self.actions['helpAuthor'],SIGNAL('activated ()'),self.slotGiveAuthor)


	def initMenuBar(self):
		#menu File
		self.menuFile=QPopupMenu()
		self.actions['fileNew'].addTo(self.menuFile)
		self.actions['fileNew'].setWhatsThis ('Creat the new file' )

		self.actions['fileOpen'].addTo(self.menuFile)
		self.actions['fileOpen'].setWhatsThis ('Open the file' )
		self.actions['fileOpenExamples'].addTo(self.menuFile)
		self.actions['fileOpenExamples'].setWhatsThis ('Open an Example file' )
		self.menuFile.insertSeparator()

		self.actions['fileSave'].addTo(self.menuFile)
		self.actions['fileSave'].setWhatsThis ('Save the file' )

		self.actions['fileSaveAs'].addTo(self.menuFile)
		self.menuFile.insertSeparator()

		self.actions['fileExit'].addTo(self.menuFile)

		#menu Edit
		self.menuEdit=QPopupMenu()
		self.actions['editUndo'].addTo(self.menuEdit)
		self.actions['editUndo'].setWhatsThis ('Undo' )

		self.actions['editDef'].addTo(self.menuEdit)
		self.actions['editDef'].setWhatsThis ('Go to definition' )
		self.menuEdit.insertSeparator()

		self.actions['editCut'].addTo(self.menuEdit)
		self.actions['editCut'].setWhatsThis ('Cut the element' )
		self.menuEdit.insertSeparator()


		self.actions['editCopy'].addTo(self.menuEdit)
		self.actions['editCopy'].setWhatsThis ('Copy the element (without names)' )

		self.actions['editCopySpec'].addTo(self.menuEdit)
		self.actions['editCopySpec'].setWhatsThis ('Copy the element (with names)' )
		self.menuEdit.insertSeparator()


		self.actions['editPast'].addTo(self.menuEdit)
		self.actions['editPast'].setWhatsThis ('Past the element' )

		self.actions['editDel'].addTo(self.menuEdit)
		self.actions['editDel'].setWhatsThis ('Delete the element' )

		self.actions['editFind'].addTo(self.menuEdit)
		self.actions['editFind'].setWhatsThis ('Find variables' )

		self.actions['editFindNext'].addTo(self.menuEdit)
		self.actions['editFindNext'].setWhatsThis ('Find next variable' )

		#menu View
		self.menuView=QPopupMenu()
		self.actions['viewElem'].addTo(self.menuView)
		self.actions['viewChild'].addTo(self.menuView)
		self.actions['viewEdit'].addTo(self.menuView)
		self.actions['viewDef'].addTo(self.menuView)
		#self.actions['viewElem'].setWhatsThis ('Show' )

		#menu Run
		self.menuRun=QPopupMenu()
		self.actions['run'].addTo(self.menuRun)
		#self.actions['stop'].addTo(self.menuRun)
		self.actions['graph'].addTo(self.menuRun)

		#menu Help
		self.menuHelp=QPopupMenu()
		self.actions['help'].addTo(self.menuHelp)
		self.actions['helpAut'].addTo(self.menuHelp)
		self.actions['helpAuthor'].addTo(self.menuHelp)

		self.menuBar().insertItem('&File',self.menuFile)
		self.menuBar().insertItem('&Edit',self.menuEdit)
		self.menuBar().insertItem('&View',self.menuView)
		self.menuBar().insertItem('&Run',self.menuRun)
		self.menuBar().insertItem('&Help',self.menuHelp)


	def initToolBar(self):
		self.toolBar=QToolBar(self,'operations')
		self.actions['fileNew'].addTo(self.toolBar)
		self.actions['fileOpen'].addTo(self.toolBar)
		self.actions['fileSave'].addTo(self.toolBar)
		self.toolBar.addSeparator ()

		self.actions['editUndo'].addTo(self.toolBar)
		self.actions['editDef'].addTo(self.toolBar)
		self.toolBar.addSeparator ()
		self.actions['editCut'].addTo(self.toolBar)
		self.actions['editCopy'].addTo(self.toolBar)
		self.actions['editCopySpec'].addTo(self.toolBar)
		self.actions['editPast'].addTo(self.toolBar)
		self.actions['editDel'].addTo(self.toolBar)
		self.toolBar.addSeparator ()
		self.actions['editFind'].addTo(self.toolBar)
		self.toolBar.addSeparator ()
		QWhatsThis.whatsThisButton(self.toolBar)

	def initStatusBar(self):
		basedir=os.path.dirname(__file__)
		if basedir=="":
			basedir="."
		dirname=basedir+"/"

		statusError=dirname+'Icons/warning.png'
		self.statusBar=QStatusBar(self)
		self.statusLabel=QLabel(self)
		self.statusBar.addWidget(self.statusLabel,0,1)
		self.statusLbForIcon=QLabel(self)
		self.statusLbForIcon.setPixmap (QPixmap(statusError))
		self.statusLbForIcon.hide()
		self.strMessage='        Use "Add subelements with attributes"'

		self.connect(self.statusBar,SIGNAL('messageChanged ( const QString &)'),self.slotMessageChanged)


	def initWidjet(self):
		#print 'ok widget'
		#self.cursor=QCursor()
		self.font=QFont("Courier",14)
		self.mainWidget=QWidget(self)
		self.mainLayout=QHBoxLayout(self.mainWidget,5,1)
		self.setCentralWidget(self.mainWidget)

		self.actifView=None
		self.bufferApp=None
		self.helpAut=1
		self.stringWarning=''

		self.leftLayout=QVBoxLayout(5)
		self.viewsSpace=QWorkspace (self.mainWidget)
		self.viewsSpace.cascade () #tile () #cascade ()
		self.leftLayout.addWidget(self.viewsSpace)
		self.connect(self.viewsSpace,SIGNAL('windowActivated(QWidget*)'),self.slotWindowActivated)
		#print self.viewsSpace.frameSize ()

		self.rightLayout=QVBoxLayout(5)

		self.docMenager=DocMenager(self)
		self.connect(self.docMenager,PYSIGNAL('sigChangedNumberOfDoc'),self.slotChangedNumberOfDoc )
		self.connect(self.docMenager,PYSIGNAL('sigShowMassegeWarning'),self.slotShowMessageWarning )
		self.connect(self.docMenager,PYSIGNAL('sigCreatview'),self.slotConnectView)
		self.connect(self.docMenager,PYSIGNAL('sigCreatDoc'),self.slotConnectDoc)
		#self.connect(self,SIGNAL('pixmapSizeChanged(bool)'),self.slotSizeChanged)


	def initElements(self):
		self.fontOther=QFont("Courier",11)

		self.elementsGroup=QVGroupBox( 'Add a new element',self.mainWidget)
		self.elementsGroup.setFont(self.fontOther)

		#self.titleElements=QLabel('Elements',self.mainWidget)
		self.elements=TableOfElem(self.elementsGroup)
		self.elements.setFont(self.fontOther)
		#self.windowActifList.append(self.elements)

		#self.connect(self.elements,PYSIGNAL('sigChangeWindow'),self.slotChangeWindow)
		self.connect(self.elements,PYSIGNAL('sigInsertHelp'),self.slotInsertHelp)

		self.lbType=QLabel('Enter the name of type',self.elementsGroup)
		self.lbType.setFont(self.fontOther)
		self.oldText=''

		self.leType=LnEditOfElem(self.elementsGroup)
		self.leType.setFont(self.fontOther)
		self.connect(self.leType,PYSIGNAL('sigDoInsert'),self.slotDoInsertHelp)
		self.connect(self.leType,SIGNAL('textChanged ( const QString & )'),self.slotTextChanged )

#		self.rightLayout.addWidget(self.titleElements)
		self.rightLayout.addWidget(self.elementsGroup,3 )



	def initChildren(self):
		basedir=os.path.dirname(__file__)
		if basedir=="":
			basedir="."
		dirname=basedir+"/"
		
		self.childrenGroup=QHGroupBox( 'Add subelements with attributes',self.mainWidget)
		self.childrenGroup.setFont(self.fontOther)

		#self.childrenGroup.setAlignment (Qt.AlignHCenter)
		self.children= TableForchildren(self.childrenGroup)
		self.connect(self.children,PYSIGNAL('sigTextChanged'),self.slotTextChangedInLE )
		self.connect(self.children,PYSIGNAL('sigTakeChildrenChecked'),self.slotTakeChildrenChecked)
		self.connect(self.children,PYSIGNAL('sigMessageError'),self.slotShowMessageError)

		#self.childrenLayout=QVBoxLayout(self.childrenGroup,5,1)
		self.buttonGroup=QVButtonGroup(self.childrenGroup)
		self.buttonGroup.setInsideSpacing (8)

		ChoiceAll=dirname+'Icons/choiceAll2.png'
		NotChoice=dirname+'Icons/Notchoice.png'
		ContrChoice=dirname+'Icons/Contraire.png'

		iconChoiceAll=QIconSet(QPixmap(ChoiceAll))
		iconNotChoice=QIconSet(QPixmap(NotChoice))
		iconContrChoice=QIconSet(QPixmap(ContrChoice))

		self.btChoiceAll=QPushButton(iconChoiceAll,'',self.buttonGroup)
		self.btChoiceAll.setMaximumSize(QSize (50,25))

		self.btNotChoice=QPushButton(iconNotChoice,'',self.buttonGroup)
		self.btNotChoice.setMaximumSize(QSize (50,25))

		self.btContrChoice=QPushButton(iconContrChoice,'',self.buttonGroup)
		self.btContrChoice.setMaximumSize(QSize (50,25))

		self.btOk=QPushButton('Ok',self.buttonGroup)
		self.btOk.setMaximumSize(QSize (50,25))
		self.buttonGroup.setFlat (1)

		self.connect(self.btChoiceAll,SIGNAL('clicked()'),self.children.slotCooseAll)
		self.connect(self.btNotChoice,SIGNAL('clicked()'),self.children.slotNoCoice)
		self.connect(self.btContrChoice,SIGNAL('clicked()'),self.children.slotContCoice)
		self.connect(self.btOk,SIGNAL('clicked()'),self.slotGetChildrenChecked)
		self.connect(self.children,PYSIGNAL('sigKeepFocus'),self.slotKeepFocus)


		self.rightLayout.addWidget(self.childrenGroup,2)

	def initModification(self):
		#la cellule ou on change la valeur pour <f> et <s>
		self.positionValue=0

		self.editGroup=QVGroupBox( 'Edit an element',self.mainWidget)
		self.editGroup.setFont(self.fontOther)

		self.modification= TableForEdit(self.editGroup)
		#le travail avec les commentaire
		self.comment=TextForComment(self.editGroup)
		self.comment.hide()


		self.btAddComment=QPushButton('Add new comment',self.editGroup)
		self.btAddComment.setMaximumSize(QSize (170,25))

		self.btOkComment=QPushButton('Modify',self.editGroup)
		self.btOkComment.setMaximumSize(QSize (100,25))
		self.btOkComment.hide()


		#self.connect(self.comment,PYSIGNAL('sigDoChangeComment'),self.slotDoChangeComment)
		self.connect(self.btAddComment,SIGNAL('clicked()'),self.slotAddComment)
		self.connect(self.btOkComment,SIGNAL('clicked()'),self.slotDoChangeComment)

		self.rightLayout.addWidget(self.editGroup,2)
		#self.editGroup.hide()

		self.connect(self.modification,PYSIGNAL('sigTypeChanged'),self.slotTypeChanged)
		self.connect(self.modification,PYSIGNAL('sigPointerChanged'),self.slotPointerChanged)
		self.connect(self.modification,PYSIGNAL('sigNameChanged'),self.slotNameChanged)
		self.connect(self.modification,PYSIGNAL('sigValueChanged'),self.slotValueChanged)
		self.connect(self.modification,PYSIGNAL('sigDoChangeType'),self.slotDoChangeType)
		self.connect(self.modification,PYSIGNAL('sigAttrValueChanged'),self.slotAttrValueChanged)
		self.connect(self.modification,PYSIGNAL('sigShowBigText'),self.slotShowBigText)
		self.connect(self.modification,PYSIGNAL('sigShowMessageWarning'),self.slotShowMessageWarning)


	def initDefinition(self):
		self.defGroup=QVGroupBox( 'Definition',self.mainWidget)
		self.defGroup.setFont(self.fontOther)

		self.definition=QTextEdit(self.defGroup)
		self.definition.setWordWrap (QTextEdit.NoWrap )
		self.definition.setTextFormat(self.definition.PlainText)
		self.definition.setReadOnly(1)
		self.definition.setFont(self.fontOther)
		#self.definition.setMinimumWidth(500)


		self.rightLayout.addWidget(self.defGroup,2)

		self.mainLayout.addLayout(self.leftLayout,3)
		self.mainLayout.addLayout(self.rightLayout,2)

	'''
	def slotSizeChanged(self,changed):
		if changed :
			print 'ok changed'
			newWidth=2*int(self.width()/3)
			self.view.setFixedWidth (newWidth)
	'''

	def queryCloseDocument(self,document):
		closeDocument=1
		if (document.isModified()):
			BoxQuestion=QMessageBox(self)
			strQuestion='Do you want to save the chages in  '+ document.title + ' ?'
			#BoxWarning.setFont (QFont("Courier",16))# self.font
			#BoxWarning.setTextFormat(Qt.PlainText )
			answer=BoxQuestion.question(self,'Warning',strQuestion,QMessageBox.Yes, QMessageBox.No,QMessageBox.Cancel)
			if(answer==BoxQuestion.Yes):
				closeDocument=self.slotGetStrForSave()
			elif (answer==BoxQuestion.Cancel):
				closeDocument=0
		return closeDocument

	def setActifView(self,view):
		self.actifView=view

	def isRunning(self,fileName):
		return 0

	def runFile(self,*args):
		program="/scisoft/ESRF_sw/linux_i386_03/PACKAGES/PPM/WRAPPERS/ppmxml"
		fileName=args[0]
		nameIfo=os.path.splitext(os.path.basename(fileName))
		pid = os.fork()
    		if not pid:
        		os.execvp(program, (program,) + args)
			#os.system(command)
    		return os.wait()


#-----------SLOTS of widjets-------------------------------------------------------------------
	def slotOpenFile(self):
		fileName = str(QFileDialog.getOpenFileName('',"XML files (*.xml)",self,"open file dialog",
                    "Choose a XML file" ))
		if (len(fileName)!=0):
			document=self.docMenager.documentWhithName(fileName)
			if (document!=None):
				#il faut faire la vue de ce fichier comme la vue active
				view=self.docMenager.view(document)[0]
				view.setFocus()
			else:
				f=open(fileName,'r')
				document=self.docMenager.createDocument()
				document.slotInitialise(f)
				document.setFileName(fileName)
				view=self.docMenager.view(document)[0]
				view.setCaption(document.title)
				view.setFocus()
				self.setEnabledUndo(0)
			
	def slotOpenFileExamples(self):
		fileName = str(QFileDialog.getOpenFileName(os.getenv("PPMEXAMPLES"),"XML files (*.xml)",self,"open file dialog",
                    "Choose a XML file" ))
		if (len(fileName)!=0):
			document=self.docMenager.documentWhithName(fileName)
			if (document!=None):
				#il faut faire la vue de ce fichier comme la vue active
				view=self.docMenager.view(document)[0]
				view.setFocus()
			else:
				f=open(fileName,'r')
				document=self.docMenager.createDocument()
				document.slotInitialise(f)
				document.setFileName(fileName)
				view=self.docMenager.view(document)[0]
				view.setCaption(document.title)
				view.setFocus()
				self.setEnabledUndo(0)


	def slotNewTree(self):
		document=self.docMenager.createDocument()
		 #if (self.start):
		self.actifView=self.docMenager.view(document)[0]
			#self.slotConnectView(self.actifView)
			#self.slotConnectDoc(document)
		document.slotNew()
		self.setEnabledUndo(0)
		#self.start=0

	def slotGetStrForSave(self):
		doSave=1
		#on recupere le document actif
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			if(document.isCorrect()):
				strErrorOfValidation=document.isValidated()
				if(len(strErrorOfValidation)==0):
					if (document.isModified()):
						document.slotGetStrForSave(0)
				else:
					doSave=0
					stringWarning='This document is not validated'

			else:
				doSave=0
				stringWarning='This document is not correct'
		if not doSave:self.slotShowBoxMessageWarning(stringWarning)
		return doSave

	def slotGetStrForSaveAs(self):
		doSave=1
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			if(document.isCorrect()):
				strErrorOfValidation=document.isValidated()
				if(len(strErrorOfValidation)==0):
					#if (document.isModified()):
					document.slotGetStrForSave(1)
				else:
					doSave=0
					stringWarning='This document is not validated'
			else:
				doSave=0
				stringWarning='This document is not correct'
		if not doSave:self.slotShowBoxMessageWarning(stringWarning)
		return doSave

	def slotExit(self):
		self.close()

	def closeEvent ( self,event):
		#self.emit(PYSIGNAL('sigCloseView'),())
		if (self.docMenager.closeAll()):
			apply( self.__class__.__bases__[0].closeEvent, (self,event))

	def slotWindowActivated(self,view):
		if (view!=None):
			self.actifView=view
			document=self.docMenager.document(view)
			if (document!=None): document.slotCanUndo()

	#on n'utilise pas
	def slotChangeWindow(self,indexOfWindow):
		#print 'ok change window'
		self.windowActifList[indexOfWindow].releaseKeyboard()
		self.windowActifList[indexOfWindow].clearFocus ()
		#self.windowActifList[indexOfWindow].unsetCursor ()
		newIndexOfWindow=(indexOfWindow+1)% len(self.windowActifList)
		#print newIndexOfWindow
		self.windowActifList[newIndexOfWindow].grabKeyboard ()
		self.windowActifList[newIndexOfWindow].setFocus ()
		#self.windowActifList[(indexOfWindow+1)% len(self.windowActifList)].setCursor(self.cursor)
		self.windowActifList[newIndexOfWindow].slotSetCurrentPosition()

	def slotHelpAut(self,helpAut):
		self.helpAut=helpAut


	def slotGiveAuthor(self):
		text='Copyright\nVorobeva Anastasiya   Vorobyeva Veronika\nnvorobeva@hotmail.fr  vorobyevav@yahoo.com \n\n\n\nCopyright 2002  by European Synchrotron Radiation Facility, Grenoble,France\n\n\n\t\t\t----------\n\t\t\tAll Rights Reserved \n\t\t\t----------\n\n\nPermission to use, copy, modify, and distribute this software and its\ndocumentation for any purpose and without fee is hereby granted,\nprovided that the above copyright notice appear in all copies and that\n both that copyright notice and this permission notice appear in\nsupporting documentation, and that the names of European Synchrotron\nRadiation Facility or ESRF or SCISOT not be used in advertising or\npublicity pertaining to distribution of the software without specific,\nwritten prior permission.\n\n\nEUROPEAN SYNCHROTRON RADIATION FACILITY DISCLAIMS ALL WARRANTIES WITH\nREGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF\nMERCHANTABILITY AND FITNESS, IN NO EVENT SHALL EUROPEAN SYNCHROTRON\nRADIATION FACILITY OR ESRF BE LIABLE FOR ANY SPECIAL, INDIRECT OR\nCONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OFUSE,\nDATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER\nTORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR\nPERFORMANCE OF THIS SOFTWARE.\n'
		self.slotShowMessageInformation(text)

	def slotUndo(self):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			document.slotUndo()


	def setEnabledUndo(self,status):
		self.actions['editUndo'].setEnabled(status)

	# apres l'appuie sur CTRL+F
	def slotFind(self):
		self.wFind=WindowForFind(self.mainWidget)
		self.wFind.move(QPoint(300,300))
		self.wFind.show()

		self.connect(self.wFind,PYSIGNAL('sigMessageError'),self.slotShowMessageError)
		self.connect(self.wFind,PYSIGNAL('sigFind'),self.slotFindVariables)

	#slot est appele apres clique sur Ok de la fenetre Find
	def slotFindVariables(self,nameToFind):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			document.slotFindVariable(nameToFind)

	# apres l'appuie sur F3
	def slotFindNext(self):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			document.slotFindNextVariable()

#------------SLOTS of DocMenager----------
	#def initTree(self):
	def slotConnectDoc(self,document):

		self.connect(document,PYSIGNAL('sigShowWindowCopy'),self.slotShowWindowCopy)
		self.connect(document,PYSIGNAL('sigWriteName'),self.slotWriteName)
		self.connect(document,PYSIGNAL('sigShowHelp'),self.slotShowHelp)
		self.connect(document,PYSIGNAL('sigShowChildren'),self.slotShowChildren)
		self.connect(document,PYSIGNAL('sigShowEdit'),self.slotShowEdit)
		self.connect(document,PYSIGNAL('sigShowComment'),self.slotShowComment)#A ajouter dans le general
		self.connect(document,PYSIGNAL('sigShowDef'),self.slotShowDef)
		self.connect(document,PYSIGNAL('sigSave'),self.slotSave)
		self.connect(document,PYSIGNAL('sigFillBuffer'),self.slotFillBuffer)
		self.connect(document,PYSIGNAL('sigEnabledUndo'),self.slotEnabledUndo)



		self.connect(document,PYSIGNAL('sigMessageQuestion'),self.slotShowMessageQuestion)
		self.connect(document,PYSIGNAL('sigMessageWarning'),self.slotShowMessageWarning)
		self.connect(document,PYSIGNAL('sigMessageError'),self.slotShowMessageError)
		self.connect(document,PYSIGNAL('sigShowBoxMessageWarning'),self.slotShowBoxMessageWarning)

	#def initView(self):
	def slotConnectView(self,view):
		view.setFont(self.font)

		self.connect(view,PYSIGNAL('sigViewDoubleClicked'),self.slotShowHideChildren)
		self.connect(view,PYSIGNAL('sigViewPressed'),self.slotShowHideChildren)
		self.connect(view,PYSIGNAL('sigDelete'),self.slotDelete)
		self.connect(view,PYSIGNAL('sigCopy'),self.slotCopy)
		self.connect(view,PYSIGNAL('sigInsert'),self.slotInsert)
		self.connect(view,PYSIGNAL('sigCut'),self.slotCut)
		self.connect(view,PYSIGNAL('sigCopySpecial'),self.slotCopySpecial)
		self.connect(view,PYSIGNAL('sigUndo'),self.slotUndo)


		self.connect(view,PYSIGNAL('sigGetHelp'),self.slotGetHelp)
		self.connect(view,PYSIGNAL('sigGetChildren'),self.slotGetChildren)
		self.connect(view,PYSIGNAL('sigGetEdit'),self.slotGetEdit)
		self.connect(view,PYSIGNAL('sigGetDef'),self.slotGetDef)
		self.connect(view,PYSIGNAL('sigChangeWindow'),self.slotChangeWindow)
		self.connect(view,PYSIGNAL('sigShowHelp'),self.slotShowHelpAut)

		self.connect(view,PYSIGNAL('sigCloseView'),self.slotCloseView)
		self.connect(view,PYSIGNAL('sigFindDef'),self.slotFindDef)
		self.connect(view,PYSIGNAL('sigChangeStatus'),self.slotChangeStatus)
		self.connect(view,PYSIGNAL('sigKeepFocus'),self.slotKeepFocus)
		self.connect(view,PYSIGNAL('sigShowMessageWarning'),self.slotShowMessageWarning)
		self.connect(view,PYSIGNAL('sigShowBoxMessageWarning'),self.slotShowBoxMessageWarning)
		self.connect(view,PYSIGNAL('sigDefinProblem'),self.slotDefinProblem)
		self.connect(view,PYSIGNAL('sigSelectCurrentElement'),self.slotSelectCurrentElement)



		#self.connect(view,PYSIGNAL('sigGiveWhatsThis'),self.slotGiveWhatsThis)
		#self.connect(view,PYSIGNAL('sigPutText'),self.slotPutText)



	def slotChangedNumberOfDoc(self):
		if (self.docMenager.numberOfDocuments()<1):
			self.actions['fileSave'].setEnabled(0)
			self.actions['fileSaveAs'].setEnabled(0)
			self.actions['editUndo'].setEnabled(0)
			self.actions['editCopy'].setEnabled(0)
			self.actions['editCut'].setEnabled(0)
			self.actions['editPast'].setEnabled(0)
			self.actions['editCopySpec'].setEnabled(0)
			self.actions['editDel'].setEnabled(0)
			self.actions['editDef'].setEnabled(0)
			self.actifView=None# atention !!!!!!!!!!!!!!!11
		else:
			self.actions['fileSave'].setEnabled(1)
			self.actions['fileSaveAs'].setEnabled(1)
			self.actions['editCopy'].setEnabled(1)
			self.actions['editCut'].setEnabled(1)
			self.actions['editPast'].setEnabled(1)
			self.actions['editCopySpec'].setEnabled(1)
			self.actions['editDel'].setEnabled(1)
			self.actions['editDef'].setEnabled(1)

#----------SLOTS of View-------------------------------------------------------------------
	def slotShowHideChildren(self):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				# l'ouverture/fermeture d'un element est possible si c'est la tag d'ouv.
				if (document.dict_link.isTagOpende(line)):
					#si la tag d'ouverture, on montre ou cache des enfants
					document.slotOpenClose(document.dict_link.getObject(line))
				else:
					#si la tag de fermeture ou toend on refreches les trois fentres
					self.slotGetHelp()
					self.slotGetEdit()
					self.slotGetDef()

	def slotDelete(self):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				document.slotDelete(document.dict_link.getObject(line))
				#self.setEnabledUndo(1)

	def slotCopy(self,spectialList=None):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				document.slotCopy(document.dict_link.getObject(line),spectialList)

	def slotInsert(self):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				# l'ouverture/fermeture d'un element est possible si c'est la tag d'ouv.
				if (document.dict_link.isTagOpende(line)):
					#on ajoute comme le premier enfant
					parent=document.dict_link.getObject(line)
					document.slotInsert(self.bufferApp,parentKnot=parent)
				else:
					#on ajoute le frere apres cet element
					after=document.dict_link.getObject(line)
					document.slotInsert(self.bufferApp,afterKnot=after)
				#self.setEnabledUndo(1)

	#insertion d'element dans l'rdre concret (pour les enfants avec les attribut,Children)
	def slotInsertOrder(self,ind):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				parent=document.dict_link.getObject(line)
				document.slotInsertOrder(self.bufferApp,parent,ind)
				#self.setEnabledUndo(1)


	def slotCut(self):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				document.slotCopy(document.dict_link.getObject(line))
				document.slotDelete(document.dict_link.getObject(line))


	def slotCopySpecial(self):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				document.slotCopySpecial(document.dict_link.getObject(line))

	def slotGetHelp(self):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				# l'ouverture/fermeture d'un element est possible si c'est la tag d'ouv.
				if (document.dict_link.isTagOpende(line)):
					#on ajoute comme le premier enfant
					child=document.dict_link.getObject(line)
					document.slotGetHelp(childKnots=child)
				else:
					#on ajoute le frere apres cet element
					sibling=document.dict_link.getObject(line)
					document.slotGetHelp(siblingKnots=sibling)

	def slotGetChildren(self):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				if (document.dict_link.isTagOpende(line)):
					document.slotGetChildren(document.dict_link.getObject(line))
				else:self.children.fillChildren([],[])


	def slotGetEdit(self):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				element=document.dict_link.getObject(line)
				if(element.isComment()): #a ecrire dans general_Tree
					document.slotGetComment(element)#a ecrire dans general_Tree
				else:
					document.slotGetEdit(element)


	def slotGetDef(self):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				document.slotGetDef(document.dict_link.getObject(line))

	def slotCloseView(self):
		if (self.actifView!=None):
			self.docMenager.closeView(self.actifView)

	def slotFindDef(self):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				document.slotFindDef(document .dict_link.getObject(line))

	# affichage de help qui depend quel widget est active
	def slotGiveWhatsThis(self):
		if (self.actifView!=None):
			# si l'utilisateur travail sur QtextEdit
			if(self.actifView.hasFocus ()):
				document=self.docMenager.document(self.actifView)
				position=self.actifView.getCurrentPosition()
				line=position[0]
				if (document.dict_link.has_key(line)):
					document.slotGiveWhatsThis(document .dict_link.getObject(line))
			# si l'utilisateur est sur les blocque Elements
			elif (self.elements.hasFocus ()):
				self.elements.ShowWhatsThis()

	'''def slotPutText(self,text):
		self.modification.setName(text)'''
	def slotShowHelpAut(self):
		if(self.helpAut):
			self.slotGiveWhatsThis()

	def slotChangeStatus(self,line,col):
		#self.statusBar.message('Line: '+str(line)+' Col: '+str(col))
		self.statusBar.clear()
		self.statusBar.removeWidget (self.statusLbForIcon )
		self.statusLbForIcon.hide()
		self.statusLabel.setText('Line: '+str(line+1)+' Col: '+str(col))
		
	# pour garder le focus sur QTextEdit
	def slotKeepFocus(self):
		if (self.actifView!=None):
			#pour positionner le focus sur QTextEdit
			self.children.setCurrentCell (0,0)
			self.modification.setCurrentCell (0,0)

	#permet de comprendre mieux le probleme avec l'element reference
	def slotDefinProblem(self):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				#si cet element a perdu son l'element-definition
				if document.defLost(document.dict_link.getObject(line)):
					warning="This element-'reference' lost the link with the element-defenition"
				else:#on a place l'element-reference plus haut que son l'element-definition correspondant
					warning="This element-'reference'  is placed either under the element-definition or in other document"
				self.slotShowMessageWarning(warning)

	#recupere les lines de debut et de fin d'element courrant
	def slotSelectCurrentElement(self):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				knot=document.dict_link.getObject(line)
				keys=document.dict_link.keys()
				minLine=line
				maxLine=line
				for key in keys:
					if (key!=line and document.dict_link.getObject(key)==knot):
						if(key<minLine):
							minLine=key
						elif(key>maxLine):
							maxLine=key
				self.actifView.slotShowCurrentElement(minLine,maxLine)

#---------SLOTS of Tree------------------------------------------------------------------
	def slotSave(self,strForSave,isSaveAs):
		document=self.docMenager.document(self.actifView)
		import pickle
		# operation save
		if (not isSaveAs):
			fileName=document.getFileName()
		if(isSaveAs or len(fileName)==0):
			showDialog=1
			fileName = str(QFileDialog.getSaveFileName("","XML files (*.xml)",self,"save file dialog",
				"Choose a filename to save under" ))
			while(os.path.exists(fileName) and showDialog) : # le fichier avec ce nom est deja existe
				# on demande si l'utilisateur veut le renplacer
				strQuestion='The file '+os.path.basename(fileName)+' already exists. Do you want to replace it?'
				BoxQuestion=QMessageBox(self)
				answer=BoxQuestion.question(self,'Warning',strQuestion,QMessageBox.Yes,QMessageBox.No)
				if(answer==BoxQuestion.No):
					fileName = str(QFileDialog.getSaveFileName("","XML files (*.xml)",self,"save file dialog","Choose a filename to save under" ))
				else:
					showDialog=0
		if (len(fileName)!=0):
			document.setFileName(fileName)
			document.setModified()
			#file_name='res.xml'
			f=open(fileName,'w')
			f.write(strForSave)
			f.close()
			self.actifView.setCaption(document.title)

	def slotShowWindowCopy(self,text):
		self.winCopy=WindowForCopy(text,self)
		self.connect(self.winCopy,PYSIGNAL('sigHasName'),self.slotHasName)
		self.connect(self.winCopy,PYSIGNAL('sigCopy'),self.slotCopy)
		self.winCopy.move(QPoint(250,250))
		self.winCopy.show()

	def slotWriteName(self,show,nLine):
		if (show):self.winCopy.slotShowLineEdit(nLine)

	def slotShowHelp(self,listElement,listInfo):
		self.contentOfElements=listElement
		self.contentOfInfo=listInfo
		self.leType.setText('')
		self.elements.fillTable(self.contentOfElements,self.contentOfInfo)
		#self.elements.setText(text)

	#def slotShowChildren(self,listAttrVal):
		#self.children.fillChildren(listAttrVal,self.contentOfElements)
	def slotShowChildren(self,listAttrVal,listTypeDefault):
		self.children.fillChildren(listAttrVal,listTypeDefault)

	def slotShowEdit(self,dictEdit):
		if(self.modification.isHidden ()):
			self.modification.show()
			self.btAddComment.show()
			self.comment.hide()
			self.btOkComment.hide()
		self.modification.fillEdit(dictEdit)

	def slotShowComment(self,textComment):
		if(self.comment.isHidden ()):
			self.comment.show()
			self.btOkComment.show()
			self.modification.hide()
			self.btAddComment.hide()
		self.comment.fillComment(textComment)

	def slotShowDef(self,text):
		self.definition.setText(text)

	def slotFillBuffer(self,object):
		self.bufferApp=object

        # le 3eme argument c'est le slot dans le tree a executer (pour que cette fonction soit generale)
	def slotShowMessageQuestion(self,strQuestion,slotFunction,*args):
		BoxWarning=QMessageBox(self)
		#BoxWarning.setFont (QFont("Courier",16))# self.font
		#BoxWarning.setTextFormat(Qt.PlainText )
		answer=BoxWarning.question(self,'Warning',strQuestion,QMessageBox.Yes,QMessageBox.No)
		if(answer==BoxWarning.Yes):
			#self.tree.slotDeleteKnot(knot)
			apply(slotFunction,(args))

	def slotShowMessageWarning(self,stringWarning,showIcon=1):
		self.stringWarning='        '+stringWarning
		self.statusBar.removeWidget (self.statusLbForIcon )
		self.statusBar.addWidget (self.statusLbForIcon)
		self.statusBar.message(self.stringWarning)
		if(showIcon):
			self.statusLbForIcon.show()
		'''BoxWarning=QMessageBox(self)
		BoxWarning.warning(self,'Warning',stringWarning)'''

	def slotShowBoxMessageWarning(self,stringWarning):
		BoxWarning=QMessageBox(self)
		BoxWarning.warning(self,'Warning',stringWarning)

	def slotShowMessageError(self,strError)	:
		BoxWarning=QMessageBox(self)
		BoxWarning.setFont ( self.font )
		BoxWarning.critical(self,'Error',strError)

	def slotShowMessageInformation(self,strInform):
		BoxWarning=QMessageBox(self)
		BoxWarning.setFont ( self.font )
		BoxWarning.information(self,'Information',strInform)

	#pour faire Enabled Undo
	def slotEnabledUndo(self,status):
		self.setEnabledUndo(status)



#--------Slots of winCopy---------------
	def slotHasName(self,nLine):
		document=self.docMenager.document(self.actifView)
		if (document.dict_linkCopy.has_key(nLine)):
			document.slotHasName(document.dict_linkCopy.getObject(nLine),nLine)

#--------------Slots d'Elements--------------------
	#pour inserer ou donner le message d'erreur a parit de lineEdit dans Elements
	def slotDoInsertHelp(self):
		if(self.elements.numRows()==1):
			self.elements.doInsert(0,0)
		else:
			if(self.elements.numRows()!=0):
				stringWarning='The choice of element is not unique'
			else:
				stringWarning='There are not element to insert'
			self.slotShowMessageWarning(stringWarning)

	#pour inserer dans l'abre a partir de l'aide
	#def slotInsertHelp(self,key,tag,ind=-1):
	def slotCreatInsert(self,tag,key,ind=-1):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			#document.slotFillBuffer(key, tag)
			object=document.creatNewKnot(tag,[key])
			self.slotFillBuffer(object)
			#self.slotInsert(line)
			if(ind==-1):
				self.slotInsert()
			else:
				self.slotInsertOrder(ind)

	def slotInsertHelp(self,tag,key):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				if(document.dict_link.isTagOpende(line)):
					object=document.dict_link.getObject(line)
					sibling=None
				else:
					object=document.dict_link.getObject(line).parent
					sibling=document.dict_link.getObject(line)
				if(object!=None):#pas pour la root de l'arbre
					if(object.tag in constVariable.perCoppia.keys()):
						#boucle pour ajouter la groupe des elements
						if((sibling!=None and sibling.tag == constVariable.perCoppia[object.tag][0]   ) or (sibling==None)):
							i=len(constVariable.perCoppia[object.tag])-1
							while (i>=0):
								tag=constVariable.perCoppia[object.tag][i]
								i-=1
								self.slotCreatInsert(tag,key)
					else:
						# si les enfants n'ont pas d'attrib on peut les ajouter "Add element"
						if not(document.knotHasKey(object)):
							self.slotCreatInsert(tag,key)
						else: # sinon "Add subelements with attr"
							# il faut donner le message dans status bar
							self.statusBar.removeWidget (self.statusLbForIcon )
							self.statusBar.addWidget (self.statusLbForIcon)
							self.statusBar.message(self.strMessage)
							self.statusLbForIcon.show()


	def slotTextChanged(self,text):
		#print 'ok leType'
		self.slotTextChangedInLE(text,self.leType,self.contentOfElements)

	# pour changer le list des elements quand on tappe dans LineEdit
	def slotTextChangedInLE(self,text,leObjet,listType):
		strText=str(text)
		#strText=str(self.leType.displayText ())
		newListEl=[]
		newListInfo=[]
		for element in listType :
			if (element.startswith(strText)): #if le debut de str est le meme
				newListEl.append(element)
				#ind=listType.index(element)
				ind=self.contentOfElements.index(element)
				newListInfo.append(self.contentOfInfo[ind])# l'info correspondante a element
		self.elements.fillTable(newListEl,newListInfo)
		if (len(newListEl)==1 and (len(strText)-len(self.oldText)>0)):
			leObjet.setText(newListEl[0])
		self.oldText=str(leObjet.displayText ())

	def slotShowHideElement(self,checked):
		if (checked):
			self.elementsGroup.show()
		else:
			self.elementsGroup.hide()
#----------SLOTS of Children------------------------
	#def slotTakeChildrenChecked(self,listKeyChecked,listTypeChecked):
	def slotTakeChildrenChecked(self,listKeyChecked,listTypeChecked,listIndice):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			document.memoriseOldText()
			i=0
			nbChildren=len(listKeyChecked)
			while (i< nbChildren):
				key=listKeyChecked[i]
				tag=listTypeChecked[i]
				ind=listIndice[i]
				#self.slotInsertHelp(key,tag,ind)
				self.slotCreatInsert(tag,key,ind)
				i+=1

	def slotShowHideChildrenGroup(self,checked):
		if (checked):
			self.childrenGroup.show()
		else:
			self.childrenGroup.hide()
		#self.children.item(0,1).setPaletteBackgroundColor( QColor (255,0,0) )

	def slotGetChildrenChecked(self):
		self.children.slotGetChildrenChecked() # a verifier pouquoi il etait comme l'arg self.contentOfElements?


#-----------Slots de Edit-------------
	def slotTypeChanged(self,newType):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				document.slotChangeType(document.dict_link.getObject(line),newType)
				#self.setEnabledUndo(1)

	def slotPointerChanged(self,isPointer):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				if(isPointer):
					document.slotFillPointer(document.dict_link.getObject(line))
				else:
					document.slotClearPonter(document.dict_link.getObject(line))
				#self.setEnabledUndo(1)

	def slotNameChanged(self,newText):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				document.slotChangeName(document.dict_link.getObject(line),newText)
				#self.setEnabledUndo(1)


	def slotValueChanged(self,newVal,index):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				document.slotChangeValue(document.dict_link.getObject(line),newVal,index)
				#self.setEnabledUndo(1)

	def slotShowHideEdit(self,checked):
		if (checked):
			self.editGroup.show()
		else:
			self.editGroup.hide()

	#si le coursor est sur la tag d'ouverture et on veut chager le type d'element on doit motrer quand meme les types des freres
	def slotDoChangeType(self):
		if (self.actifView!=None):
			contentType=self.contentOfElements
			contentInfo=self.contentOfInfo
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				#if (document.dict_link.isTagOpende(line)):
					#on montre dans la fenetre d'elements les types possibles pour changer ce type
				sibling=document.dict_link.getObject(line)
				document.slotGetHelp(siblingKnots=sibling,genericCase=0)
			self.contentOfElements=contentType
			self.contentOfInfo=contentInfo

	def slotAttrValueChanged(self,val,key,valDefaut):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				document.slotChangeAttrValue(document.dict_link.getObject(line),val,key,valDefaut)
				#self.setEnabledUndo(1)
	#permet d'ecrire la valeur pour <f> ou <s> dans une grande text pour comment
	def slotShowBigText(self,text,position):
		'''if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				object=document.dict_link.getObject(line)
				if (object.toend):'''
		#if(self.modification.isShown()):
		#pour garder le numero de celulle ou on change la valeur
		self.positionValue=position
		self.modification.hide()
		self.btAddComment.hide()
		self.comment.fillComment(text)
		self.comment.show()
		self.btOkComment.show()
		'''else:
			self.comment.hide()
			self.btOkComment.hide()
			self.modification.show()
			self.btAddComment.show()'''

	def slotAddComment(self):
		if (self.actifView!=None):
			self.slotCreatInsert('c','')
			#deplace le coursor sur le commentaire ajoute
			position=self.actifView.getCurrentPosition()
			self.actifView.slotChangeCursor(position[0]+1,position[1])
			self.slotSelectCurrentElement()
			self.modification.hide()
			self.btAddComment.hide()
			self.comment.fillComment('')
			self.comment.show()
			self.btOkComment.show()

	def slotDoChangeComment(self):#A ecrire dans le general
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			position=self.actifView.getCurrentPosition()
			line=position[0]
			if (document.dict_link.has_key(line)):
				newText=self.comment.getComment()
				object=document.dict_link.getObject(line)
				if (object.isComment()):#on modofie le commentaire
					document.slotChangeComment(object,newText)
				else:#on modifie la valeur pour <f> ou <s>
					if (object.toend):
						newText=newText.replace('\n','')
						newText=newText.replace('\t','')
						newText=newText.replace(' ','')
						self.slotValueChanged(newText,self.positionValue)


#----------Slots of Definition--------------
	def slotElementsClicked(self,line,pos):
		typeObject=str(self.definition.text(line))
		index=typeObject.find('\n')
		typeObject=typeObject[0:index]

	def slotShowHideDefinition(self,checked):
		if (checked):
			self.defGroup.show()
		else:
			self.defGroup.hide()

#-----------Slots of Menu Run
	def slotRun(self):
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			if(self.queryCloseDocument(document)):
				fileName=document.getFileName()
				if(len(fileName)!=0):
					if(not self.isRunning(fileName)):#a ecrire
						#fileProg='general_Tree.py'
						#self.statusBar.message('start of process...',10)
						status=self.runFile(fileName)#a ecrire
						if(status[1]!=0):
							strError='The execution did not finish successfully'
							self.slotShowMessageError(strError)
				else: pass

	def slotStop(self):
		pass

	def slotGraph(self):
		args=''
		if (self.actifView!=None):
			document=self.docMenager.document(self.actifView)
			args=document.getValKnot(parentTag='comparison_write',childTag='s')
		if(len(args)!=0):
			args+='1'
		basdir=os.path.dirname(__file__)
		if(basdir==""): basdir="./"
		command=basdir+'newplot '+args+' &'
		os.system(command)

#------------Slots of status bar------------
	# le changement du text dans satus bar
	def slotMessageChanged(self,message):
		if (message==self.strMessage):
			pass
		elif (message==self.stringWarning):
			pass
		else:
			self.statusBar.clear()
			self.statusBar.removeWidget (self.statusLbForIcon)
			self.statusLbForIcon.hide()


if __name__ == '__main__':
    #Creat application
    app_Interface=QApplication(sys.argv)
    win=TreeApp()
    #win.showFullScreen ()
    win.move(QPoint(0,0))

    #Visualisation
    win.show()
    app_Interface.connect(app_Interface,SIGNAL('lastWindowClosed()'),app_Interface,SLOT('quit()'))
    app_Interface.exec_loop()
