import sys
from PyQt4.Qt  import *
# from qttable import *
from TypeObject import Element

QTable=QTableWidget

class WindowForCopy(QMainWindow):
	def __init__(self,text,*args):
		apply(QMainWindow.__init__,(self,)+args)
		self.mainWidget=QWidget(self)
		self.textForLabel=text
		self.nbRows=text.count('\n')
		heiht=self.nbRows+5
		self.setCaption(' Window for copy ')
		#self.setMaximumSize(QSize (600,heiht))
		self.setMinimumSize(QSize (500,min(300,heiht)))



		self.mainLayout=QVBoxLayout(self.mainWidget,5,1)

		#north---------------
		self.northLayout=QHBoxLayout(5,'north')
		self.fillGrid()

		# south------------
		self.southLayout=QHBoxLayout(5,'south')
		self.btOk=QPushButton('Ok',self.mainWidget)
		self.btOk.setMaximumSize(QSize (50,25))
		self.southLayout.addWidget(self.btOk)

		self.mainLayout.addLayout(self.northLayout)
		self.mainLayout.addLayout(self.southLayout)

		self.setCentralWidget(self.mainWidget)

		self.connect(self.btOk,SIGNAL('clicked()'),self.slotGetInforamation)

	#le cas de QTable
	def fillGrid(self):
		self.grid=QTable(self.nbRows,3,self.mainWidget)
		self.grid.setHScrollBarMode(QScrollView.Auto )
		self.grid.setVScrollBarMode(QScrollView.Auto )
		self.grid.setColumnWidth(0,125)
		self.grid.setColumnWidth(1,150)
		self.northLayout.addWidget(self.grid)
		# titres--------------
		fontLabel=QFont("Courier",12)
		fontEdit=QFont("Courier",11)
		fontLabel.setBold(1)
		self.grid.setFont(fontEdit)
		self.grid.horizontalHeader().setFont(fontLabel)
		self.grid.horizontalHeader().setLabel ( 0, 'Add/keep name')
		self.grid.horizontalHeader().setLabel ( 1, 'New name')
		self.grid.horizontalHeader().setLabel ( 2, 'Object for copy')
		self.grid.verticalHeader().hide()
		self.grid.setLeftMargin(0)

		#rimplissage de la gride-----------------
		self.grid.setColumnReadOnly (2,1 )
		self.chechBox_list=[]
		fontLabel.setBold(0)
		i=0
		maxLen=0 #pour calculer la size de 3m colonne
		while (i<self.nbRows):
			# 1ere colonne -checkBox
			self.chechBox_list.append(QCheckTableItem (self.grid, ''))
			self.grid.setItem ( i, 0, self.chechBox_list[-1])
			# 2eme colonne -LineEdit
			self.grid.setText(i,1,'')
			self.grid.item(i,1).setEnabled (0)
			# 3eme colonne -LineEdit
			index=self.textForLabel.find('\n')
			labelText=self.textForLabel[0:index] #recupere une ligne du texte
			maxLen=max(maxLen,len(labelText))
			self.grid.setText(i,2,labelText)
			self.grid.ensureCellVisible(i,2)
			self.textForLabel=self.textForLabel[index+1:] # changemant du texte
			i+=1
		self.grid.setColumnWidth(2,max(150,maxLen*10))
		self.connect(self.grid,SIGNAL('valueChanged(int,int)'),self.slotToggled)


#--------------SLOTS WindowForCopy----------------------------------
	def slotToggled(self,row,column):
		if(column==0):
			checked=self.chechBox_list[row].isChecked()
			if (checked):
				self.slotChecked(row)
			else:
				self.slotNotChecked(row)

	def slotChecked(self,nLine):
		self.emit(PYSIGNAL('sigHasName'),(nLine,))

	def slotNotChecked(self,nLine):
		self.grid.setText(nLine,1,'')
		self.grid.item(nLine,1).setEnabled (0)


	def slotShowLineEdit(self,nLine):
		self.grid.item(nLine,1).setEnabled(1)

	def slotGetInforamation(self):
		information_list=[]
		i=0
		while (i<self.nbRows):
			keepName=self.chechBox_list[i].isChecked ()
			self.grid.endEdit (i,1,1,1)
			name=str(self.grid.text(i,1))
			information_list.append(Element(name,keepName))
			i+=1
		#self.emit(PYSIGNAL('sigCopy'),(-1,information_list,))
		self.emit(PYSIGNAL('sigCopy'),(information_list,))
		self.hide()


# le tablau avec les attribus (lineEdint0 et le les enfants possibles (combobox)
#on n'utilise pas
class TableOfElemAttr(QTable):
	def __init__(self,*args):
		apply(QTable.__init__,(self,)+args)

		self.setNumCols(2)
		self.setColumnStretchable(0,1)
		self.setColumnStretchable(1,1)
		self.setColumnReadOnly(0,1)

		self.horizontalHeader().setLabel ( 0, 'Attrubutes')
		self.horizontalHeader().setLabel ( 1, 'Elements')
		self.verticalHeader().hide()
		self.setLeftMargin(0)

		#self.setFocusPolicy(QWidget.TabFocus)

		self.key2action = {Qt.Key_Down: self.__class__.doDown ,
			      Qt.Key_Up:self.__class__.doUp,
			      Qt.Key_Left:self.__class__.doLeft,
			      Qt.Key_Right:self.__class__.doRight,
			      #Qt.Key_Tab:self.__class__.doTab,
			      Qt.Key_Enter:self.__class__.doEnter,
			      Qt.Key_Insert:self.__class__.doInsert}

		self.connect(self,PYSIGNAL('sigChangeCursor'),self.slotChangeCursor)
  		#doubleClicked ( int row, int col, int button, const QPoint & mousePos )
		self.connect(self,SIGNAL('doubleClicked(int,int,int,const QPoint &)'),self.slotDoubleClicked)

	def fillTable (self,listElement,textAttr):
		lst=QStringList()
		for element in listElement :
			lst.append(element)
		#self.nbRowsElements=textAttr.count('\n')
		#self.nbRowsAttr=len(listAttr)
		self.nbRowsAttr=textAttr.count('\n')+1 #une ligne supplemetaire pour un attr vide
		self.lenElements=len(listElement)
		self.setNumRows(self.nbRowsAttr)
		i=0
		while (i<self.nbRowsAttr-1):
			# 1ere colonne -LineEdit
			#editText=listAttr[i]
			index=textAttr.find('\n')
			editText=textAttr[0:index] #recupere une ligne du texte
			self.setText(i,0,editText)
			#self.elements.item(i,0).setEnabled(0)

			# 2eme colonne -ComboBox
			self.setItem(i,1,QComboTableItem(self,lst))

			textAttr=textAttr[index+1:] # changemant du texte
			i+=1
		self.setItem(i,1,QComboTableItem(self,lst))
		self.setText(i,0,'')

	def doLeft(self,row, column):
		if (column==1):
			self.emit(PYSIGNAL('sigChangeCursor'),(row, column-1,))

	def doRight(self,row, column):
		if (column==0):
			self.emit(PYSIGNAL('sigChangeCursor'),(row, column+1,))

	def doUp(self,row, column):
		self.emit(PYSIGNAL('sigChangeCursor'),((row-1)% self.nbRowsAttr, column,))

	def doDown(self,row, column):
		self.emit(PYSIGNAL('sigChangeCursor'),((row+1)% self.nbRowsAttr, column,))

	def doTab(self,row, column):
		self.setCurrentCell (0,0)
		#print'ok tab elements'
		#self.releaseKeyboard()
		#self.clearFocus ()
		self.emit(PYSIGNAL('sigChangeWindow'),(1,))

	def doEnter(self,row, column):
		if (column==1):
			index= self.item(row,column).currentItem()
			self.item(row,column).setCurrentItem((index+1) % self.lenElements)

	def doInsert(self,row, column):
		key=str(self.text(row,0))
		tag=str(self.item (row,1).currentText())
		self.emit(PYSIGNAL('sigInsertHelp'),(key,tag,))


	def keyPressEvent (self,event):
		row=self.currentRow()
		column=self.currentColumn()
		cod=event.key()
		#print cod,Qt.Key_Tab,Qt.Key_Backtab
		if( self.key2action.has_key(cod) ):
				action = self.key2action[cod]
				apply( action ,(self,)+(row, column))


	def activateNextCell(self):
		row=self.currentRow()
		column=self.currentColumn()
		if (column==1):
			index= self.item(row,column).currentItem()
			self.item(row,column).setCurrentItem((index+1) % self.lenElements)


#----------------Slots de TableOfElemAttr
	def slotChangeCursor(self,newRow, newColumn):
		self.setCurrentCell ( newRow, newColumn)

	def slotSetCurrentPosition(self):
		self.setCurrentCell (0,0)

	def slotDoubleClicked(self,row, column,button,mousPos):
		self.doInsert(row, column)

#le tableau dans la fenetre Elements pour la liste des anfants et les commemtaires
class TableOfElem(QTable):
	def __init__(self,*args):
		apply(QTable.__init__,(self,)+args)
		self.help=QWhatsThis(self)

		self.setNumCols(2)
		self.setColumnStretchable(0,1)
		self.setColumnStretchable(1,1)
		self.setColumnReadOnly(0,1)
		self.setColumnReadOnly(1,1)

		self.horizontalHeader().setLabel ( 0, 'Elements')
		self.horizontalHeader().setLabel ( 1, 'Info')
		self.verticalHeader().hide()
		self.setLeftMargin(0)

		self.key2action = {Qt.Key_Insert: self.__class__.doInsert,
				   Qt.Key_Down: self.__class__.doDown ,
			      	   Qt.Key_Up:self.__class__.doUp,
			      	   Qt.Key_Left:self.__class__.doLeft,
			      	   Qt.Key_Right:self.__class__.doRight,}
		self.connect(self,SIGNAL('doubleClicked(int,int,int,const QPoint &)'),self.slotDoubleClicked)
		self.connect(self,PYSIGNAL('sigChangeCursor'),self.slotChangeCursor)

	def fillTable (self,listElement,listInfo):
		#self.nbRowsElements=textAttr.count('\n')
		#self.nbRowsAttr=len(listAttr)
		self.nbElements=len(listElement)
		self.setNumRows(self.nbElements)
		i=0
		while (i<self.nbElements):
			# 1ere colonne -LineEdit
			editText=listElement[i]
			infoText=listInfo[i]
			self.setText(i,0,editText)
			# 2eme colonne -Line edit
			self.setText(i,1,infoText)
			#self.item(i,1).setWordWrap (1)

			i+=1

	def doLeft(self,row, column):
		if (column==1):
			self.emit(PYSIGNAL('sigChangeCursor'),(row, column-1,))

	def doRight(self,row, column):
		if (column==0):
			self.emit(PYSIGNAL('sigChangeCursor'),(row, column+1,))

	def doUp(self,row, column):
		self.emit(PYSIGNAL('sigChangeCursor'),((row-1)% self.nbElements, column,))

	def doDown(self,row, column):
		self.emit(PYSIGNAL('sigChangeCursor'),((row+1)% self.nbElements, column,))

	def doInsert(self,row,column):
		tag=str(self.text(row,0))
		self.emit(PYSIGNAL('sigInsertHelp'),(tag,''))


	def keyPressEvent (self,event):
		row=self.currentRow()
		column=self.currentColumn()
		cod=event.key()
		#print cod,Qt.Key_Tab,Qt.Key_Backtab
		if( self.key2action.has_key(cod) ):
				action = self.key2action[cod]
				apply( action ,(self,)+(row, column))

	def ShowWhatsThis(self):
		row=self.currentRow()
		text=self.text(row,1)
		posCursor=self.mapToGlobal(QPoint ( self.currentColumn()*50,self.currentRow()*22-self.contentsY()))
		#posCursor=self.mapFromGlobal(QCursor.pos())
		#posCursor=QPoint ( self.curentPosition,self.curentLine*20)
		self.help.display (text,posCursor)

#------------SLOTs of TableOfElem
	def slotDoubleClicked(self,row, column,button,mousPos):
		self.doInsert(row,column)

	def slotChangeCursor(self,newRow, newColumn):
		self.setCurrentCell ( newRow, newColumn)

# c'est Lineedit  dans la fenetre Elements pour organiser le recherche rapide
class LnEditOfElem(QLineEdit):
	def __init__(self,*args):
		apply(QLineEdit.__init__,(self,)+args)
		self.key2action = {Qt.Key_Insert: self.__class__.doInsert}

	def doInsert(self):
		self.emit(PYSIGNAL('sigDoInsert'),())

	def keyPressEvent (self,event):
		cod=event.key()
		#print cod,Qt.Key_Tab,Qt.Key_Backtab
		if( self.key2action.has_key(cod) ):
				action = self.key2action[cod]
				apply( action ,(self,))
		apply( self.__class__.__bases__[0].keyPressEvent, (self,event))

# le tableau pour la groupe Edit Element
class TableForEdit(QTable):
	def __init__(self,*args):
		apply(QTable.__init__,(self,)+args)
		self.doSignal=1
		self.doSetText=1

		self.setNumCols(1)
		self.setColumnStretchable(0,1)
		self.setNumRows(7)

		self.rowType=0
		self.verticalHeader().setLabel ( self.rowType, 'Type')
		#self.setRowReadOnly(self.rowType,1)

		self.rowPointer=1
		self.verticalHeader().setLabel ( self.rowPointer, 'Reference')

		self.rowName=2
		self.verticalHeader().setLabel ( self.rowName, 'Name')

		self.rowAttrVal1=3# les lignes pour les attrubuts possibles
		self.rowAttrVal2=4

		self.rowValue=5 # avec une valeur pour <s>
		self.verticalHeader().setLabel ( self.rowValue, 'Value')
		self.rowValueTab=6 # deuxieme variant pour value (avec 3 valeures) pour <f>
		self.verticalHeader().setLabel ( self.rowValueTab, 'Value')


		self.horizontalHeader().hide()
		self.setTopMargin(0)
		self.setLeftMargin(120)

		#pour la ligne "Pointer" -creation de la list pour combobox
		self.lstPointer=QStringList()
		self.lstPointer.append('false')
		self.lstPointer.append('true')


		#la creation de LineEdit pour le champ Name
		self.lnName=QLineEdit(self)
		self.setCellWidget(self.rowName,0,self.lnName)

		#la ligne avec 3 valeures
		self.creatTableForValue()
		self.setCellWidget(self.rowValueTab,0,self.tbOfValue)
		self.hideRow(self.rowValueTab)
		self.hideRow(self.rowValue)
		#self.tbOfValue.hideRow(0)
		self.tbOfValue.hide ()

		self.connect(self,SIGNAL('valueChanged ( int,int)'),self.slotValueChanged)
		self.connect(self.lnName,SIGNAL('textChanged(const QString &)'),self.slotValueChangedName)
		self.connect(self,SIGNAL('clicked (int,int,int, const QPoint &) '),self.slotChangeRow)
		self.connect(self,SIGNAL('currentChanged (int, int)'),self.slotChangeRow)
		self.connect(self.tbOfValue,SIGNAL('clicked ( int, int, int, const QPoint &)'),self.slotClickedVal)

	def clearAll(self):
		i=0
		while(i< self.numRows()-1):
			if(i!=self.rowName):
				self.setText(i,0,'')
			i+=1
		i=0
		while(i< self.tbOfValue.numCols()):
			self.tbOfValue.setText(0,i,'')
			i+=1
		self.tbOfValue.hide()

	def setName(self,text):
		oldText=str(self.lnName.text())
		text=oldText+text
		self.lnName.setText(text)
		#self.lnName.setFocus()

	def creatTableForValue(self):
		self.tbOfValue=QTable(1,3)
		self.tbOfValue.horizontalHeader().hide()
		self.tbOfValue.setTopMargin(0)
		self.tbOfValue.verticalHeader().hide()
		self.tbOfValue.setLeftMargin(0)
		self.tbOfValue.setMinimumHeight (25)
		i=0
		while(i<self.tbOfValue.numCols()):
			self.tbOfValue.setColumnStretchable (i,1)
			i+=1
		self.connect(self.tbOfValue,SIGNAL('valueChanged ( int,int)'),self.slotValueChangedOfTb)

	def fillEdit(self,dictEdit):
		self.doSignal=0 # controle emission du signal TextChange
		self.clearAll()
		#remplissage du champ Type
		self.setText(self.rowType,0,dictEdit['tag'])
		#remplissage du champ Reference
		self.setItem(self.rowPointer,0,QComboTableItem(self,self.lstPointer))
		self.item(self.rowPointer,0).setCurrentItem(dictEdit['pointer'])
		#remplissage du champ Name
		if (self.doSetText):
			self.lnName.setText(dictEdit['name']) # ne doit pas provoquer le signal TextChange
		lenAttr=len(dictEdit['attrValue'])
		#remplissage du champ des Valeurs des attributs possibles
		lenMax=2
		i=0
		while(i<lenAttr):
			self.showRow(self.rowAttrVal1+i)#value
			self.verticalHeader().setLabel ( self.rowAttrVal1+i, dictEdit['attrKey'][i])
			self.setText(self.rowAttrVal1+i,0,str(dictEdit['attrValue'][i]))
			i+=1
		while(i<lenMax):
			self.hideRow(self.rowAttrVal1+i)#key
			i+=1
		if(dictEdit.has_key('valDefault')):
			self.valDefaut=dictEdit['valDefault']
		#remplissage du champ Value
		if (dictEdit.has_key('valueS')): #le cas des element terminal
			self.hideRow(self.rowValueTab)
			self.tbOfValue.hide ()
			self.showRow(self.rowValue)
			if (len(dictEdit['valueS'])!=0):
				self.setText(self.rowValue,0,dictEdit['valueS'][0])
		elif(dictEdit.has_key('value')):
			self.hideRow(self.rowValue)
			self.showRow(self.rowValueTab)
			self.tbOfValue.show()
			i=0
			values=dictEdit['value']
			for val in values:
				self.tbOfValue.setText(0,i,val)
				i+=1
		else:
			self.hideRow(self.rowValue)
			self.hideRow(self.rowValueTab)
			self.tbOfValue.hide()
		self.doSignal=1

	def getValue(self):
		value=''
		position=0
		row=self.currentRow()
		if (row==self.rowValue ):
			value=str(self.text(self.rowValue,0))
		elif (row==self.rowValueTab):
			position=self.tbOfValue.currentColumn()
			value=str(self.tbOfValue.text(0,position))
		return value,position

	def keyPressEvent (self,event):
		cod=event.key()
		row=self.currentRow()
		if (cod==Qt.Key_F4 and (row==self.rowValue or row==self.rowValueTab)):
			res=self.getValue()
			currentValue=res[0]
			position=res[1]
			self.emit(PYSIGNAL('sigShowBigText'),(currentValue,position,))
		else:
			apply( self.__class__.__bases__[0].keyPressEvent, (self,event))


# SLOTS----------------------------------
	def slotValueChanged(self, row,column):
		if (row==self.rowType): # le changement de Type
			newType=str(self.text(self.rowType,0))
			self.emit(PYSIGNAL('sigTypeChanged'),(newType,))
		elif (row==self.rowPointer):# le changement de Reference
			ind=self.item(self.rowPointer,0).currentItem()
			self.emit(PYSIGNAL('sigPointerChanged'),(ind,))
		elif(row==self.rowValue):# le changement de  Valeur
			newVal=str(self.text(self.rowValue,0))
			self.emit(PYSIGNAL('sigValueChanged'),(newVal,0,))
		elif(row==self.rowAttrVal1 or row==self.rowAttrVal2):# le changement de valeurs des attributs
			newAttrVal=str(self.text(row,0))
			attrKey=str(self.verticalHeader().label(row))
			valDefault=self.valDefaut[attrKey]
			self.emit(PYSIGNAL('sigAttrValueChanged'),(newAttrVal,attrKey,valDefault))

	def slotValueChangedName(self,text):
		# pour que se signal ne passe pas dans le boucle infini on cotrole son emission
		self.setCurrentCell (self.rowName,0)
		self.doSetText=0
		if (self.doSignal):
		#print 'change name'
			self.emit(PYSIGNAL('sigNameChanged'),(str(text),))
		self.doSetText=1

	def slotValueChangedOfTb(self,row,column):
		newVal=str(self.tbOfValue.text(0,column))
		newVal=newVal.replace(' ','')
		self.emit(PYSIGNAL('sigValueChanged'),(newVal,column,))

	def slotChangeRow(self,row,column,botton=None,pos=None):
		#print row, column
		self.setCurrentCell (row,column)
		if (row==self.rowType):
			self.emit(PYSIGNAL('sigDoChangeType'),())
		if(row==self.rowValue or row==self.rowValueTab):
			strMessage='Press F4 to edit value in big window'
			self.emit(PYSIGNAL('sigShowMessageWarning'),(strMessage,0,))
		else:
			self.emit(PYSIGNAL('sigShowMessageWarning'),('',0,))


	def slotClickedVal(self,row, column,button,pos):
		self.setCurrentCell(self.rowValueTab,0)
		strMessage='Press F4 to edit value in big window'
		self.emit(PYSIGNAL('sigShowMessageWarning'),(strMessage,0,))


#class pour modifier et ajouter les commentaire dans la fenetre Edit an element
class TextForComment(QTextEdit):
	def __init__(self,*args):
		apply(QLineEdit.__init__,(self,)+args)
		self.setTextFormat(self.PlainText)
		self.setFont(QFont("Courier",11))
		#self.setWordWrap (QTextEdit.FixedColumnWidth )
		#self.currentLine=0
		#self.currentColumn=0
		#self.connect(self,SIGNAL('textChanged()'),self.slotTextChange)
		#self.connect(self,SIGNAL('clicked(int,int)'),self.slotClicked)

		'''self.key2action = {Qt.Key_Down: self.__class__.doDown ,
			      Qt.Key_Up:self.__class__.doUp,
			      Qt.Key_Left:self.__class__.doLeft,
			      Qt.Key_Right:self.__class__.doRight}
			      #Qt.Key_Enter:self.__class__.doEnter}'''

	def getComment(self):
		return str(self.text())

	def fillComment(self,text):
		#self.doSignal=0
		self.setText(text)
		#self.doSignal=1

	'''def getCurrentPosition(self):
		return self.curentLine, self.curentPosition

	def ChangeCursor(self,newLine,newColumn):
		self.currentLine=newLine
		self.currentColumn=newColumn
		self.setCursorPosition(newLine,newColumn)

	def doUp(self,line, pos):
		self.ChangeCursor(line-1,pos)

	def doDown(self,line, pos):
		self.ChangeCursor(line+1,pos)

	def doRight(self,line, pos):
		self.ChangeCursor(line,pos+1)

	def doLeft(self,line,pos):
		if(pos!=0):
			self.ChangeCursor(line,pos-1)

	def doEnter(self,line,pos,event):
		apply( self.__class__.__bases__[0].keyPressEvent, (self,event))
		self.ChangeCursor(line+1,0)

	def keyPressEvent (self,event ):
		res=self.getCursorPosition()
		line=res[0]
		pos=res[1]
		cod=event.key()
		if (cod==Qt.Key_Enter):
			self.doEnter(line,pos,event)
		#si c'est le simple touche
		if( self.key2action.has_key(cod) ):
			action = self.key2action[cod]
			apply( action ,(self,)+(line, pos))
		else:apply( self.__class__.__bases__[0].keyPressEvent, (self,event))

	def slotTextChange (self):
		if(self.doSignal):
			newText=str(self.text())
			self.emit(PYSIGNAL('sigDoChangeComment'),(newText,))
			self.ChangeCursor(self.currentLine,self.currentColumn+1)

	def slotClicked(self,line,coursor):
		self.ChangeCursor(line,coursor)'''



# class pour line edit pour le tableau des enfants avec attrib
class LnOfChildren(QLineEdit):
	def __init__(self,index,*args):
		apply(QLineEdit.__init__,(self,)+args)
		self.index=index
		self.connect(self,SIGNAL('textChanged ( const QString & )'),self.slotTextChange)

	def slotTextChange(self,text):
		self.emit(PYSIGNAL('sigTextChanged'),(text,self.index,)) # a connecter dans TableForchildren

#le tableua pour la groupe Add children with attributes
class TableForchildren(QTable):
	def __init__(self,*args):
		apply(QTable.__init__,(self,)+args)
		self.setNumCols(3)
		self.setColumnStretchable(0,1)
		self.setColumnStretchable(1,1)
		self.setColumnWidth (2,40)
		self.setColumnReadOnly(0,1)
		#self.setFocusPolicy( QWidget.NoFocus );


		self.horizontalHeader().setLabel ( 0, 'Atributes')
		self.horizontalHeader().setLabel ( 1, 'Type')
		self.horizontalHeader().setLabel ( 2, 'Add')
		self.verticalHeader().hide()
		self.setLeftMargin(0)

		self.maxRows=15 # c'est pas definit!!!!!!!

		self.leList=[]
		self.setNumRows(self.maxRows)
		i=0
		while (i<self.maxRows):
			self.leList.append(LnOfChildren (i,'',self))
			self.setCellWidget(i,1,self.leList[-1])
			self.connect(self.leList[-1],PYSIGNAL('sigTextChanged'),self.slotTextChange)
			i+=1

	def fillChildren(self,listAttrVal,listTypePossible):
		self.doSignal=0
		self.numRows=len(listAttrVal)
		self.listAttrVal=listAttrVal
		self.listTypePossible=listTypePossible
		#self.setNumRows(self.numRows)
		i=0
		while (i<self.numRows):
			self.showRow (i)
			#la premiere colonne
			self.setText(i,0,listAttrVal[i])
			#la deuxieme ligne
			self.leList[i].show()
			self.leList[i].setText(listTypePossible[i][0])
			#la troisieme colonne
			self.setItem ( i, 2, QCheckTableItem(self,''))
			self.item(i,2).setChecked(1)
			i+=1
		while (i<self.maxRows):
			self.hideRow ( i )
			self.leList[i].hide()
			i+=1
		self.doSignal=1
	'''
	def activateNextCell(self):
		row=self.currentRow()
		column=self.currentColumn()
		if (column==1):
			apply( self.__class__.__bases__[0].activateNextCell, (self,))
	'''

#--------------SLOTS of TableForchildren

	def slotGetChildrenChecked(self):
		i=0
		listKeyChecked=[]
		listTypeChecked=[]
		listIndice=[]
		allTypeGood=1
		while (i<self.numRows and allTypeGood):
			if(self.item(i,2).isChecked()):
				key=str(self.text(i,0))
				tag=str(self.leList[i].text())
				if (not (tag in self.listTypePossible[i])):
					val=key
					allTypeGood=0
				listKeyChecked.append(key)
				listIndice.append(i)
				listTypeChecked.append(tag)
			i+=1
		self.setCurrentCell (0,0)
		if(allTypeGood):
			self.emit(PYSIGNAL('sigTakeChildrenChecked'),(listKeyChecked,listTypeChecked,listIndice))
		else:
			strError='The type of element for the value '+ val+' is not correct'
			self.emit(PYSIGNAL('sigMessageError'),(strError,))



	def slotTextChange(self,text,index):
		#row=self.currentRow()
		if (self.doSignal):
			self.emit(PYSIGNAL('sigTextChanged'),(text,self.leList[index],self.listTypePossible[index],))


	#le slot de clique sur bouton "Ccoisir tout"
	def slotCooseAll(self):
		i=0
		while (i<self.numRows):
			self.item(i,2).setChecked(1)
			i+=1

	def slotNoCoice(self):
		i=0
		while (i<self.numRows):
			self.item(i,2).setChecked(0)
			i+=1

	def slotContCoice(self):
		i=0
		while (i<self.numRows):
			checked=self.item(i,2).isChecked()
			self.item(i,2).setChecked(not checked)
			i+=1


#-------------classe for Style de View------
class SyntaxOfView(QSyntaxHighlighter):
	def __init__(self,*args):
		apply(QSyntaxHighlighter.__init__,(self,)+args)
		self.font=QFont("Courier",12)
		self.fontComment=QFont("Courier",12,QFont.Normal ,1)
		self.font.setBold(1)

		self.colorTag=QColor (170,0,170)
		self.colorSign=QColor (0,0,255)
		self.colorAttr=QColor (0,0,200)


	def highlightParagraph(self,textOfParagraph,endStateOfLastPara):
		indStart=[]
		indEnd=[]
		text=str(textOfParagraph)
		# le traitement du tag d'ouverture
		nb=text.count('<')
		i=0
		start=0
		while(i<nb):
			ind=text.find('<',start)
			self.setFormat ( ind, 1,self.font, self.colorTag)
			start=ind+1
			indStart.append(start)
			i+=1

		# le traitement du bar de fermeture
		nb=text.count('>')
		i=0
		start=0
		while(i<nb):
			ind=text.find('>',start)
			self.setFormat ( ind, 1,self.font, self.colorTag)
			start=ind+1
			indEnd.append(ind)
			i+=1

		# le traitement du minus
		if ('-' in text):
			ind=int(text.find('-'))
			self.setFormat ( ind,1, self.colorSign)

		# le traitement du plus
		if ('+' in text):
			ind=int(text.find('+'))
			self.setFormat ( ind,1, self.colorSign)


		# le traitement de type du tag
		if(len(indEnd)==len(indStart)):
			i=0
			while (i<len(indEnd)):
				# tag
				listOfWord=text[indStart[i]:indEnd[i]].split()# ???? ou indEnd[i]+1
				tag=''
				if (len(listOfWord)!=0): tag=listOfWord[0]
				self.setFormat(indStart[i],len(tag),self.font)
				# les attributs
				lenAttr=indEnd[i]-indStart[i]-len(tag)
				if (lenAttr>0):
					self.setFormat(indStart[i]+len(tag),lenAttr,self.colorAttr)
				i+=1

		# le traitement des attr
		if ('"' in text):
			start=text.find('"')
			end=text.rfind('"')
			self.setFormat(start,end-start+1,self.colorAttr)

		# le traitement du bar de fermeture
		if ('/' in text):
			ind=text.rfind('/')
			self.setFormat ( ind,1,self.font, self.colorTag)

		#traitemnet des commentaire
		if ('<!--' in text):
			ind=text.find('<!--')
			self.setFormat(ind,len(text),self.fontComment)

		if ('-->' in text):
			ind=text.find('-->')
			self.setFormat(0,len(text),self.fontComment)

		if not(('>' in text)and('>' in text)):
			self.setFormat(0,len(text),self.fontComment)

		return 0

#----------Window pour recherch des variables------
class WindowForFind(QMainWindow):
	def __init__(self,*args):
		apply(QMainWindow.__init__,(self,)+args)
		self.setCaption(' Find variables ')
		#self.setMaximumSize(QSize (300,300))
		#self.setMinimumSize(QSize (100,100))
		self.setFixedSize (QSize ( 300, 150 ))

		self.mainWidget=QWidget(self)
		self.mainLayout=QVBoxLayout(self.mainWidget,5,1)

		self.grRadionBut=QVButtonGroup('Choise of the variant',self.mainWidget)
		self.rbAllVariables=QRadioButton( 'All variables', self.grRadionBut)
		self.rbAllVariables.setOn(1)
		self.rbOneVariable=QRadioButton( 'One variable', self.grRadionBut)

		self.mainLayout.addWidget(self.grRadionBut)
		'''self.grRadionBut.insert ( self.rbAllVariables, 0)
		self.grRadionBut.insert ( self.rbOneVariable, 1)'''

		#self.mainLayout.addWidget(self.mainWidget)
		self.nameLayout=QHBoxLayout()
		self.name=QLineEdit(self.mainWidget)
		self.nameTitle=QLabel('Name ',self.mainWidget)
		self.nameLayout.addWidget(self.nameTitle)
		self.nameLayout.addWidget(self.name)
		self.mainLayout.addLayout(self.nameLayout)
		self.name.hide()
		self.nameTitle.hide()

		self.southLayout=QHBoxLayout()
		self.btOk=QPushButton('Ok',self.mainWidget)
		self.btOk.setMaximumSize(QSize (50,25))
		self.warning=QLabel(self.mainWidget)
		self.warning.setPaletteForegroundColor(QColor(250,0,0))
		self.southLayout.addWidget(self.btOk)
		self.southLayout.addWidget(self.warning)

		self.mainLayout.addLayout(self.southLayout)

		self.setCentralWidget(self.mainWidget)

		self.connect(self.rbOneVariable,SIGNAL('toggled ( bool)'),self.slotToggledOne)
		self.connect(self.rbAllVariables,SIGNAL('toggled ( bool)'),self.slotToggledAll)

		self.connect(self.btOk,SIGNAL('clicked()'),self.slotClicked)

	def slotToggledOne(self,isOn):
		if isOn :
			self.name.show()
			self.nameTitle.show()

	def slotToggledAll(self,isOn):
		if isOn :
			self.name.hide()
			self.nameTitle.hide()
			self.warning.setText ('')

	def slotClicked(self):
		varToFind=''
		canBeClosed=1
		if (self.rbOneVariable.isOn()):
			varToFind=str(self.name.text())
			if(len(varToFind)==0):
				#il faut donner la faute
				self.warning.setText('Give the name !!!')
				canBeClosed=0
		if canBeClosed:
			self.emit(PYSIGNAL('sigFind'),(varToFind,))
			self.hide()
