'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: lsearch.n,v 1.1.1.3 2000/04/24 08:06:27 wdelano Exp $
'\" 
.so man.macros
.TH lsearch n 7.0 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
lsearch \- See if a list contains a particular element
.SH SYNOPSIS
\fBlsearch \fR?\fImode\fR? \fIlist pattern\fR
.BE

.SH DESCRIPTION
.PP
This command searches the elements of \fIlist\fR to see if one
of them matches \fIpattern\fR.
If so, the command returns the index of the first matching
element.
If not, the command returns \fB\-1\fR.
The \fImode\fR argument indicates how the elements of the list are to
be matched against \fIpattern\fR and it must have one of the following
values:
.TP
\fB\-exact\fR
The list element must contain exactly the same string as \fIpattern\fR.
.TP
\fB\-glob\fR
\fIPattern\fR is a glob-style pattern which is matched against each list
element using the same rules as the \fBstring match\fR command.
.TP
\fB\-regexp\fR
\fIPattern\fR is treated as a regular expression and matched against
each list element using the same rules as the \fBregexp\fR command.
.PP
If \fImode\fR is omitted then it defaults to \fB\-glob\fR.

.SH KEYWORDS
list, match, pattern, regular expression, search, string
