#!/usr/bin/env python
# To use:
#       python setup.py install
#
import os, sys, string, re
from glob import glob

# Check for an advanced enough Distutils.
try:
    import distutils
except ImportError:
    raise SystemExit, "Please see README: Distutils-0.9 or later required."

v=re.match('([0-9]+)\\.([0-9]+)\\.([0-9]+)', distutils.__version__)
vs = map(string.atoi, v.groups())
if vs[0] < 1 and vs[1] < 9:
    raise SystemExit, "Please see README: Distutils-0.9 or later required."

from distutils.command.install import install
from distutils.core import setup, Extension
from distutils.sysconfig import get_python_inc

headers = glob (os.path.join ("Include","*.h"))

# The version is set in Lib/version.py
execfile(os.path.join('Lib','version.py'))
print "Numeric Version", version

setup (name = "Numeric",
       version = version,
       maintainer = "Numerical Python Developers",
       maintainer_email = "numpy-developers@lists.sourceforge.net",
       description = "Numerical Extension to Python",
       url = "http://numpy.sourceforge.net",

       packages = [''],
       package_dir = {'': 'Lib'},
       extra_path = 'Numeric',
       include_dirs = ['Include'],
       headers = headers,
       ext_modules = [Extension('_numpy',
                                ['Src/_numpymodule.c',
                                 'Src/arrayobject.c',
                                 'Src/ufuncobject.c']),
                      Extension('multiarray', ['Src/multiarraymodule.c']),
                      Extension('umath', ['Src/umathmodule.c']),
                      Extension('arrayfns',
                                ['Src/arrayfnsmodule.c'])
                     ]
       )


