#!/usr/bin/env python
# To use:
#       python setup.py install
#
import os, sys, string, re
from glob import glob

# Check for an advanced enough Distutils.
try:
    import distutils
except ImportError:
    raise SystemExit, "Please see README: Distutils-0.9 or later required."

v=re.match('([0-9]+)\\.([0-9]+)\\.([0-9]+)', distutils.__version__)
vs = map(string.atoi, v.groups())
if vs[0] < 1 and vs[1] < 9:
    raise SystemExit, "Please see README: Distutils-0.9 or later required."

from distutils.command.install import install
from distutils.core import setup, Extension

headers = glob (os.path.join ("Include","*.h"))

# delete all but the first one in this list if using your own LAPACK/BLAS
sourcelist = ['Src/lapack_litemodule.c',
              'Src/blas_lite.c', 'Src/f2c_lite.c', 'Src/zlapack_lite.c',
              'Src/dlapack_lite.c'
             ]
# set these to use your own BLAS
library_dirs_list = []
libraries_list = []

setup (name = "Numeric",
       packages = [''],
       package_dir = {'': 'Lib'},
       extra_path = 'Numeric',
       include_dirs = ['Include'],
       headers = headers,
       ext_modules = [ Extension('lapack_lite', sourcelist,
                           library_dirs=library_dirs_list,
                           libraries = libraries_list) 
                     ]
       )


