#!/usr/bin/env python

# Setup script for building the RNG extension to Python.

# To use:
#       python setup.py build
#     or this to build and install it
#       python setup.py install

import string,re

# Check for an advanced enough Distutils.
try:
    import distutils
except ImportError:
    raise SystemExit, "Please see README: Distutils-0.9 or later required."
v=re.match('([0-9]+)\\.([0-9]+)\\.([0-9]+)', distutils.__version__)
vs = map(string.atoi, v.groups())
if vs[0] < 1 and vs[1] < 9:
    raise SystemExit, "Please see README: Distutils-0.9 or later required."

from distutils.core import setup, Extension

setup (name = "RNG",
       version = "3.0",
       maintainer = "Paul Dubois",
       maintainer_email = "dubois@users.sourceforge.net",
       description = "Cray-like Random number package.",

       packages = ['RNG'],
       package_dir = {'RNG': 'Lib'},
       include_dirs=['Include'],
       ext_modules=[Extension('RNG.RNG',
                       ['Src/RNGmodule.c',
                        'Src/ranf.c',
                        'Src/pmath_rng.c'],
                             )
                   ]
       )
