import os, sys, string, re
from glob import glob

# Check for an advanced enough Distutils.
try:
    import distutils
except ImportError:
    raise SystemExit, "Please see README: Distutils-0.9 or later required."
v=re.match('([0-9]+)\\.([0-9]+)\\.([0-9]+)', distutils.__version__)
vs = map(string.atoi, v.groups())
if vs[0] < 1 and vs[1] < 9:
    raise SystemExit, "Please see README: Distutils-0.9 or later required."

from distutils.core import setup, Extension

setup (name = "FFTPACK",
       version = "1.0",
       maintainer = "Numerical Python Developers",
       maintainer_email = "numpy-discussion@lists.sourceforge.net",
       description = "Fast Fourier Transforms",
       url = "http://numpy.sourceforge.net",

       packages = ['FFT'],
       package_dir = {'FFT': 'Lib'},
       include_dirs = ['Include'],
       ext_modules = [ Extension('FFT.fftpack',
                                ['Src/fftpackmodule.c',
                                 'Src/fftpack.c']),
                     ]
       )
