'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\" Copyright (c) 1998 by Scriptics Corporation.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: bind.n,v 1.1.1.3 2000/04/24 08:06:16 wdelano Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1.1.3 2000/04/24 08:06:17 wdelano Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH bind n 8.0 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
bind \- Arrange for X events to invoke Tcl scripts
.SH SYNOPSIS
\fBbind\fI tag\fR
.sp
\fBbind\fI tag sequence\fR
.sp
\fBbind\fI tag sequence script\fR
.sp
\fBbind\fI tag sequence \fB+\fIscript\fR
.BE

.SH INTRODUCTION
.PP
The \fBbind\fR command associates Tcl scripts with X events.
If all three arguments are specified, \fBbind\fR will
arrange for \fIscript\fR (a Tcl script) to be evaluated whenever
the event(s) given by \fIsequence\fR occur in the window(s)
identified by \fItag\fR.
If \fIscript\fR is prefixed with a ``+'', then it is appended to
any existing binding for \fIsequence\fR;  otherwise \fIscript\fR replaces
any existing binding.
If \fIscript\fR is an empty string then the current binding for
\fIsequence\fR is destroyed, leaving \fIsequence\fR unbound.
In all of the cases where a \fIscript\fR argument is provided,
\fBbind\fR returns an empty string.
.PP
If \fIsequence\fR is specified without a \fIscript\fR, then the
script currently bound to \fIsequence\fR is returned, or
an empty string is returned if there is no binding for \fIsequence\fR.
If neither \fIsequence\fR nor \fIscript\fR is specified, then the
return value is a list whose elements are all the sequences
for which there exist bindings for \fItag\fR.
.PP
The \fItag\fR argument determines which window(s) the binding applies to.
If \fItag\fR begins with a dot, as in \fB.a.b.c\fR, then it must
be the path name for a window; otherwise it may be an arbitrary
string.
Each window has an associated list of tags, and a binding applies
to a particular window if its tag is among those specified for
the window.
Although the \fBbindtags\fR command may be used to assign an
arbitrary set of binding tags to a window, the default binding
tags provide the following behavior:
.IP
If a tag is the name of an internal window the binding applies
to that window.
.IP
If the tag is the name of a toplevel window the binding applies
to the toplevel window and all its internal windows.
.IP
If the tag is the name of a class of widgets, such as \fBButton\fR,
the binding applies to all widgets in that class;
.IP
If \fItag\fR has the value \fBall\fR,
the binding applies to all windows in the application.

.SH "EVENT PATTERNS"
.PP
The \fIsequence\fR argument specifies a sequence of one or more
event patterns, with optional white space between the patterns.  Each
.VS
event pattern may
take one of three forms.  In the simplest case it is a single
.VE
printing ASCII character, such as \fBa\fR or \fB[\fR.  The character
may not be a space character or the character \fB<\fR.  This form of
pattern matches a \fBKeyPress\fR event for the particular
character.  The second form of pattern is longer but more general.
It has the following syntax:
.CS
\fB<\fImodifier-modifier-type-detail\fB>\fR
.CE
The entire event pattern is surrounded by angle brackets.
Inside the angle brackets are zero or more modifiers, an event
type, and an extra piece of information (\fIdetail\fR) identifying
a particular button or keysym.  Any of the fields may be omitted,
as long as at least one of \fItype\fR and \fIdetail\fR is present.
The fields must be separated by white space or dashes.
.VS
.PP
The third form of pattern is used to specify a user-defined, named virtual
event.  It has the following syntax:
.CS
\fB<<\fIname\fB>>\fR
.CE
The entire virtual event pattern is surrounded by double angle brackets.
Inside the angle brackets is the user-defined name of the virtual event.
Modifiers, such as \fBShift\fR or \fBControl\fR, may not be combined with a
virtual event to modify it.  Bindings on a virtual event may be created
before the virtual event is defined, and if the definition of a virtual
event changes dynamically, all windows bound to that virtual event will
respond immediately to the new definition.  
.VE
.SH "MODIFIERS"
.PP
Modifiers consist of any of the following values:
.DS
.ta 6c
\fBControl\fR	\fBMod2, M2\fR
\fBShift\fR	\fBMod3, M3\fR	
\fBLock\fR	\fBMod4, M4\fR
\fBButton1, B1\fR	\fBMod5, M5\fR	
\fBButton2, B2\fR	\fBMeta, M\fR
\fBButton3, B3\fR	\fBAlt\fR
\fBButton4, B4\fR	\fBDouble\fR
\fBButton5, B5\fR	\fBTriple\fR
\fBMod1, M1\fR
.DE
Where more than one value is listed, separated by commas, the values
are equivalent.
Most of the modifiers have the obvious X meanings.
For example, \fBButton1\fR requires that
button 1 be depressed when the event occurs.
For a binding to match a given event, the modifiers in the event
must include all of those specified in the event pattern.
An event may also contain additional modifiers not specified in
the binding.
For example, if button 1 is pressed while the shift and control keys
are down, the pattern \fB<Control-Button-1>\fR will match
the event, but \fB<Mod1-Button-1>\fR will not.
If no modifiers are specified, then any combination of modifiers may
be present in the event.
.PP
\fBMeta\fR and \fBM\fR refer to whichever of the
\fBM1\fR through \fBM5\fR modifiers is associated with the meta
key(s) on the keyboard (keysyms \fBMeta_R\fR and \fBMeta_L\fR).
If there are no meta keys, or if they are not associated with any
modifiers, then \fBMeta\fR and \fBM\fR will not match any events.
Similarly, the \fBAlt\fR modifier refers to whichever modifier
is associated with the alt key(s) on the keyboard (keysyms
\fBAlt_L\fR and \fBAlt_R\fR).
.PP
The \fBDouble\fR and \fBTriple\fR modifiers are a convenience
for specifying double mouse clicks and other repeated
events. They cause a particular event pattern to be
repeated 2 or 3 times, and also place a time and space requirement
on the sequence:  for a sequence of events to match a \fBDouble\fR
or \fBTriple\fR pattern, all of the events must occur close together
in time and without substantial mouse motion in between.
For example, \fB<Double-Button-1>\fR
is equivalent to \fB<Button-1><Button-1>\fR with the extra
time and space requirement.

.SH "EVENT TYPES"
.PP
The \fItype\fR field may be any of the standard X event types, with a
few extra abbreviations.  The \fItype\fR field will also accept a
couple non-standard X event types that were added to better support
the Macintosh and Windows platforms.  Below is a list of all the valid
types; where two names appear together, they are synonyms.
.DS C
.ta 5c 10c
\fBActivate	Enter	Map
ButtonPress, Button	Expose	Motion
.VS
ButtonRelease	FocusIn	MouseWheel	
.VE
Circulate	FocusOut	Property
Colormap	Gravity	Reparent
Configure	KeyPress, Key	Unmap
Deactivate	KeyRelease	Visibility
Destroy	Leave\fR
.DE
.PP
.VS
Most of the above events have the same fields and behaviors as events
in the X Windowing system.  You can find more detailed descriptions of
these events in any X window programming book.  A couple of the events
are extensions to the X event system to support features unique to the
Macintosh and Windows platforms.  We provide a little more detail on
these events here.  These include:
.IP \fBActivate\fR 5
.IP \fBDeactivate\fR 5
These two events are sent to every sub-window of a toplevel when they
change state.  In addition to the focus Window, the Macintosh platform
and Windows platforms have a notion of an active window (which often
has but is not required to have the focus).  On the Macintosh, widgets
in the active window have a different appearance than widgets in
deactive windows.  The \fBActivate\fR event is sent to all the
sub-windows in a toplevel when it changes from being deactive to
active.  Likewise, the \fBDeactive\fR event is sent when the window's
state changes from active to deactive.  There are no useful percent
substitutions you would make when binding to these events.
.IP \fBMouseWheel\fR 5
Some mice on the Windows platform support a mouse wheel which is used
for scrolling documents without using the scrollbars.  By rolling the
wheel, the system will generate \fBMouseWheel\fR events that the
application can use to scroll.  Like \fBKey\fR events the event is
always routed to the window that currently has focus. When the event
is received you can use the \fB%D\fR substitution to get the
\fIdelta\fR field for the event which is a integer value of motion
that the mouse wheel has moved.  The smallest value for which the
system will report is defined by the OS.  On Windows 95 & 98 machines
this value is at least 120 before it is reported.  However, higher
resolution devices may be available in the future.  The sign of the
value determines which direction your widget should scroll.  Positive
values should scroll up and negative values should scroll down.
.VE
.PP
The last part of a long event specification is \fIdetail\fR.  In the
case of a \fBButtonPress\fR or \fBButtonRelease\fR event, it is the
number of a button (1-5).  If a button number is given, then only an
event on that particular button will match;  if no button number is
given, then an event on any button will match.  Note:  giving a
specific button number is different than specifying a button modifier;
in the first case, it refers to a button being pressed or released,
while in the second it refers to some other button that is already
depressed when the matching event occurs.  If a button
number is given then \fItype\fR may be omitted:  if will default
to \fBButtonPress\fR.  For example, the specifier \fB<1>\fR
is equivalent to \fB<ButtonPress-1>\fR.
.PP
If the event type is \fBKeyPress\fR or \fBKeyRelease\fR, then
\fIdetail\fR may be specified in the form of an X keysym.  Keysyms
are textual specifications for particular keys on the keyboard;
they include all the alphanumeric ASCII characters (e.g. ``a'' is
the keysym for the ASCII character ``a''), plus descriptions for
non-alphanumeric characters (``comma'' is the keysym for the comma
character), plus descriptions for all the non-ASCII keys on the
keyboard (``Shift_L'' is the keysm for the left shift key, and
``F1'' is the keysym for the F1 function key, if it exists).  The
complete list of keysyms is not presented here;  it is
available in other X documentation and may vary from system to
system.
If necessary, you can use the \fB%K\fR notation described below
to print out the keysym name for a particular key.
If a keysym \fIdetail\fR is given, then the
\fItype\fR field may be omitted;  it will default to \fBKeyPress\fR.
For example, \fB<Control-comma>\fR is equivalent to
\fB<Control-KeyPress-comma>\fR.

.SH "BINDING SCRIPTS AND SUBSTITUTIONS"
.PP
The \fIscript\fR argument to \fBbind\fR is a Tcl script,
which will be executed whenever the given event sequence occurs.
\fICommand\fR will be executed in the same interpreter that the
\fBbind\fR command was executed in, and it will run at global
level (only global variables will be accessible).
If \fIscript\fR contains
any \fB%\fR characters, then the script will not be
executed directly.  Instead, a new script will be
generated by replacing each \fB%\fR, and the character following
it, with information from the current event.  The replacement
depends on the character following the \fB%\fR, as defined in the
list below.  Unless otherwise indicated, the
replacement string is the decimal value of the given field from
the current event.
Some of the substitutions are only valid for
certain types of events;  if they are used for other types of events
the value substituted is undefined.
.IP \fB%%\fR 5
Replaced with a single percent.
.IP \fB%#\fR 5
The number of the last client request processed by the server
(the \fIserial\fR field from the event).  Valid for all event
types.
.IP \fB%a\fR 5
The \fIabove\fR field from the event,
formatted as a hexadecimal number.
Valid only for \fBConfigure\fR events.
.IP \fB%b\fR 5
The number of the button that was pressed or released.  Valid only
for \fBButtonPress\fR and \fBButtonRelease\fR events.
.IP \fB%c\fR 5
The \fIcount\fR field from the event.  Valid only for \fBExpose\fR events.
.IP \fB%d\fR 5
The \fIdetail\fR field from the event.  The \fB%d\fR is replaced by
a string identifying the detail.  For \fBEnter\fR,
\fBLeave\fR, \fBFocusIn\fR, and \fBFocusOut\fR events,
the string will be one of the following:
.RS
.DS
.ta 6c
\fBNotifyAncestor	NotifyNonlinearVirtual
NotifyDetailNone	NotifyPointer
NotifyInferior	NotifyPointerRoot
NotifyNonlinear	NotifyVirtual\fR
.DE
For events other than these, the substituted string is undefined.
.RE
.IP \fB%f\fR 5
The \fIfocus\fR field from the event (\fB0\fR or \fB1\fR).  Valid only
for \fBEnter\fR and \fBLeave\fR events.
.IP \fB%h\fR 5
.VS
The \fIheight\fR field from the event.  Valid for the \fBConfigure\fR and
\fBExpose\fR events.
.VE
.IP \fB%k\fR 5
The \fIkeycode\fR field from the event.  Valid only for \fBKeyPress\fR
and \fBKeyRelease\fR events.
.IP \fB%m\fR 5
The \fImode\fR field from the event.  The substituted string is one of
\fBNotifyNormal\fR, \fBNotifyGrab\fR, \fBNotifyUngrab\fR, or
.VS
\fBNotifyWhileGrabbed\fR.  Valid only for \fBEnter\fR,
\fBFocusIn\fR, \fBFocusOut\fR, and \fBLeave\fR events.
.VE
.IP \fB%o\fR 5
The \fIoverride_redirect\fR field from the event.  Valid only for
\fBMap\fR, \fBReparent\fR, and \fBConfigure\fR events.
.IP \fB%p\fR 5
The \fIplace\fR field from the event, substituted as one of the
strings \fBPlaceOnTop\fR or \fBPlaceOnBottom\fR.  Valid only
for \fBCirculate\fR events.
.IP \fB%s\fR 5
The \fIstate\fR field from the event.  For \fBButtonPress\fR,
\fBButtonRelease\fR, \fBEnter\fR, \fBKeyPress\fR, \fBKeyRelease\fR,
\fBLeave\fR, and \fBMotion\fR events, a decimal string
is substituted.  For \fBVisibility\fR, one of the strings
\fBVisibilityUnobscured\fR, \fBVisibilityPartiallyObscured\fR,
and \fBVisibilityFullyObscured\fR is substituted.
.IP \fB%t\fR 5
The \fItime\fR field from the event.  Valid only for events that
contain a \fItime\fR field.
.IP \fB%w\fR 5
The \fIwidth\fR field from the event.  Valid only for
.VS
\fBConfigure\fR and \fBExpose\fR events.
.VE
.IP \fB%x\fR 5
The \fIx\fR field from the event.  Valid only for events containing
an \fIx\fR field.
.IP \fB%y\fR 5
The \fIy\fR field from the event.  Valid only for events containing
a \fIy\fR field.
.IP \fB%A\fR 5
Substitutes the ASCII character corresponding to the event, or
the empty string if the event doesn't correspond to an ASCII character
(e.g. the shift key was pressed).  \fBXLookupString\fR does all the
work of translating from the event to an ASCII character.
Valid only for \fBKeyPress\fR and \fBKeyRelease\fR events.
.IP \fB%B\fR 5
The \fIborder_width\fR field from the event.  Valid only for
\fBConfigure\fR events.
.VS
.IP \fB%D\fR 5
This reports the \fIdelta\fR value of a \fBMouseWheel\fR event.  The
\fIdelta\fR value represents the rotation units the mouse wheel has
been moved.  On Windows 95 & 98 systems the smallest value for the
delta is 120.  Future systems may support higher resolution values for
the delta.  The sign of the value represents the direction the mouse
wheel was scrolled.
.VE
.IP \fB%E\fR 5
The \fIsend_event\fR field from the event.  Valid for all event types.
.IP \fB%K\fR 5
The keysym corresponding to the event, substituted as a textual
string.  Valid only for \fBKeyPress\fR and \fBKeyRelease\fR events.
.IP \fB%N\fR 5
The keysym corresponding to the event, substituted as a decimal
number.  Valid only for \fBKeyPress\fR and \fBKeyRelease\fR events.
.IP \fB%R\fR 5
The \fIroot\fR window identifier from the event.  Valid only for
events containing a \fIroot\fR field.
.IP \fB%S\fR 5
The \fIsubwindow\fR window identifier from the event,
formatted as a hexadecimal number.
Valid only for events containing a \fIsubwindow\fR field.
.IP \fB%T\fR 5
The \fItype\fR field from the event.  Valid for all event types.
.IP \fB%W\fR 5
The path name of the window to which the event was reported (the
\fIwindow\fR field from the event).  Valid for all event types.
.IP \fB%X\fR 5
The \fIx_root\fR field from the event.
If a virtual-root window manager is being used then the substituted
value is the corresponding x-coordinate in the virtual root.
Valid only for
\fBButtonPress\fR, \fBButtonRelease\fR, \fBKeyPress\fR, \fBKeyRelease\fR,
and \fBMotion\fR events.
.IP \fB%Y\fR 5
The \fIy_root\fR field from the event.
If a virtual-root window manager is being used then the substituted
value is the corresponding y-coordinate in the virtual root.
Valid only for
\fBButtonPress\fR, \fBButtonRelease\fR, \fBKeyPress\fR, \fBKeyRelease\fR,
and \fBMotion\fR events.
.LP
The replacement string for a %-replacement is formatted as a proper
Tcl list element.
This means that it will be surrounded with braces
if it contains spaces, or special characters such as \fB$\fR and
\fB{\fR may be preceded by backslashes.
This guarantees that the string will be passed through the Tcl
parser when the binding script is evaluated.
Most replacements are numbers or well-defined strings such
as \fBAbove\fR;  for these replacements no special formatting
is ever necessary.
The most common case where reformatting occurs is for the \fB%A\fR
substitution.  For example, if \fIscript\fR is
.CS
\fBinsert\0%A\fR
.CE
and the character typed is an open square bracket, then the script
actually executed will be
.CS
\fBinsert\0\e[\fR
.CE
This will cause the \fBinsert\fR to receive the original replacement
string (open square bracket) as its first argument.
If the extra backslash hadn't been added, Tcl would not have been
able to parse the script correctly.

.SH MULTIPLE MATCHES
.PP
It is possible for several bindings to match a given X event.
If the bindings are associated with different \fItag\fR's,
then each of the bindings will be executed, in order.
By default, a binding for the widget will be executed first, followed
by a class binding, a binding for its toplevel, and
an \fBall\fR binding.
The \fBbindtags\fR command may be used to change this order for
a particular window or to associate additional binding tags with
the window.
.PP
The \fBcontinue\fR and \fBbreak\fR commands may be used inside a
binding script to control the processing of matching scripts.
If \fBcontinue\fR is invoked, then the current binding script
is terminated but Tk will continue processing binding scripts
associated with other \fItag\fR's.
If the \fBbreak\fR command is invoked within a binding script,
then that script terminates and no other scripts will be invoked
for the event.
.VS
.PP
If more than one binding matches a particular event and they
have the same \fItag\fR, then the most specific binding
is chosen and its script is evaluated.
The following tests are applied, in order, to determine which of
several matching sequences is more specific:
(a) an event pattern that specifies a specific button or key is more specific
than one that doesn't;
(b) a longer sequence (in terms of number
of events matched) is more specific than a shorter sequence;
(c) if the modifiers specified in one pattern are a subset of the
modifiers in another pattern, then the pattern with more modifiers
is more specific.
.VS
(d) a virtual event whose physical pattern matches the sequence is less
specific than the same physical pattern that is not associated with a 
virtual event.
(e) given a sequence that matches two or more virtual events, one 
of the virtual events will be chosen, but the order is undefined.
.PP
If the matching sequences contain more than one event, then tests
(c)-(e) are applied in order from the most recent event to the least recent
event in the sequences.  If these tests fail to determine a winner, then the
most recently registered sequence is the winner.
.PP
If there are two (or more) virtual events that are both triggered by the
same sequence, and both of those virtual events are bound to the same window
tag, then only one of the virtual events will be triggered, and it will
be picked at random:  
.CS
event add <<Paste>> <Control-y>
event add <<Paste>> <Button-2>
event add <<Scroll>> <Button-2>
bind Entry <<Paste>> {puts Paste}
bind Entry <<Scroll>> {puts Scroll}
.CE
If the user types Control-y, the \fB<<Paste>>\fR binding
will be invoked, but if the user presses button 2 then one of
either the \fB<<Paste>>\fR or the \fB<<Scroll>>\fR bindings will
be invoked, but exactly which one gets invoked is undefined.
.VE
.PP
If an X event does not match any of the existing bindings, then the
event is ignored.
An unbound event is not considered to be an error.

.SH "MULTI-EVENT SEQUENCES AND IGNORED EVENTS"
.PP
When a \fIsequence\fR specified in a \fBbind\fR command contains
more than one event pattern, then its script is executed whenever
the recent events (leading up to and including the current event)
match the given sequence.  This means, for example, that if button 1 is
clicked repeatedly the sequence \fB<Double-ButtonPress-1>\fR will match
each button press but the first.
If extraneous events that would prevent a match occur in the middle
of an event sequence then the extraneous events are
ignored unless they are \fBKeyPress\fR or \fBButtonPress\fR events.
For example, \fB<Double-ButtonPress-1>\fR will match a sequence of
presses of button 1, even though there will be \fBButtonRelease\fR
events (and possibly \fBMotion\fR events) between the
\fBButtonPress\fR events.
Furthermore, a \fBKeyPress\fR event may be preceded by any number
of other \fBKeyPress\fR events for modifier keys without the
modifier keys preventing a match.
For example, the event sequence \fBaB\fR will match a press of the
\fBa\fR key, a release of the \fBa\fR key, a press of the \fBShift\fR
key, and a press of the \fBb\fR key:  the press of \fBShift\fR is
ignored because it is a modifier key.
Finally, if several \fBMotion\fR events occur in a row, only
the last one is used for purposes of matching binding sequences.

.SH ERRORS
.PP
If an error occurs in executing the script for a binding then the
\fBbgerror\fR mechanism is used to report the error.
The \fBbgerror\fR command will be executed at global level
(outside the context of any Tcl procedure).

.SH "SEE ALSO"
bgerror

.SH KEYWORDS
form, manual
