# This is a rough collection of tests that can not be automated.

import sys
import Test
import Tkinter
import Pmw

def scrolledframeflashing_bug():
    # Script which demonstrates continuous flashing of dynamic scrollbars
    # in Pmw.ScrolledFrame.
    #
    # When this script is run, the two scrollbars will be continuously
    # mapped and unmapped and the window will continuously change size.

    frame = Tkinter.Frame(root)
    frame.pack(fill = 'both', expand = 1)

    sf = Pmw.ScrolledFrame(frame, borderframe = 0)
    sf.pack(fill = 'both', expand = 1)

    inner = Tkinter.Frame(sf.interior(),
            width = 401,
            height = 300,
            borderwidth = 0,
            highlightthickness = 0,
    )
    inner.pack(fill = 'both', expand = 1)

def scrolledlistboxflashing_bug():
    # Script which demonstrates continuous flashing of dynamic scrollbars
    # in Pmw.ScrolledListBox.
    #
    # When this script is run, the two scrollbars will be continuously
    # mapped and unmapped and the window will continuously change size.

    frame = Tkinter.Frame(root)
    frame.pack(fill = 'both', expand = 1)

    sf = Pmw.ScrolledListBox(frame,
            listbox_width = 20,
            listbox_height = 10
    )
    sf.pack(fill = 'both', expand = 1)
    for i in range(11):
        sf.insert('end', '2' * 20)

def scrolledlistboxflashing2_bug():
    # Another script which demonstrates continuous flashing of dynamic
    # scrollbars in Pmw.ScrolledListBox under Pmw.0.8.
    #
    # When this script is run, the two scrollbars will be continuously
    # mapped and unmapped and the window will continuously change size.
    #
    # (This did not display error when tried with Pmw.0.8, 99/8/3)

    def insert():
        sectionList = ['1', '2', '3', '4', '5', '6', '7', '8', '9',
            '123456789012345678901']
        for counter in sectionList: 
          slb.insert('end', counter)
          
    def clear():
        slb.delete(0, 'end')
        
    global slb
    slb = Pmw.ScrolledListBox(root)
    slb.pack()

    root.after(2000,insert)
    root.after(3000,clear) 
    root.after(4000,insert)

    root.geometry('400x400')

def scrolledtextflashing_bug():
    # Script which demonstrates continuous flashing of dynamic scrollbars
    # in Pmw.ScrolledText.
    #
    # When this script is run, the two scrollbars will be continuously
    # mapped and unmapped and the window will continuously change size.

    frame = Tkinter.Frame(root)
    frame.pack(fill = 'both', expand = 1)

    sf = Pmw.ScrolledText(frame,
            text_width = 20,
            text_height = 10,
            text_wrap = 'none',
            borderframe = 0
    )
    sf.pack(fill = 'both', expand = 1)
    for i in range(11):
        sf.insert('end', '2' * 20)
        if i != 10:
            sf.insert('end', '\n')

def scrolledcanvasflashing_bug():
    # Script which demonstrates continuous flashing of dynamic scrollbars
    # in Pmw.ScrolledCanvas.
    #
    # When this script is run, the two scrollbars will be continuously
    # mapped and unmapped and the window will continuously change size.

    frame = Tkinter.Frame(root)
    frame.pack(fill = 'both', expand = 1)

    sf = Pmw.ScrolledCanvas(frame,
            canvas_scrollregion = (0, 0, 301, 200),
            canvas_width=300,
            canvas_height=200,
            borderframe = 0
    )
    sf.pack(fill = 'both', expand = 1)

def scrolledframeflashing2_bug():
    # The two scrollbars will be continuously mapped and unmapped, but
    # the toplevel window will remain the same size.

    root.geometry('550x500')

    frame = Tkinter.Frame()
    frame.pack()

    sf = Pmw.ScrolledFrame(frame, borderframe = 0)
    sf.pack(fill = 'both')

    inner = Tkinter.Frame(sf.interior(),
            width = 401,
            height = 300,
            borderwidth = 0,
            highlightthickness = 0,
    )
    inner.pack()

def reinitialise_bug():
    global text
    text = """
    Demonstrates bug in Pmw.0.8.1 and earlier.
    Click on this button, click on OK in the dialog, then Exit below.
    When this window appears again, clicking on this button gives
    an error:
    TclError: can't invoke "wm" command:  application has been destroyed
    """
    class test:
        def __init__(self):
            root = Tkinter.Tk()
            Pmw.initialise(root)
            self.messagedialog = Pmw.MessageDialog(message_text = 'Testing')
            self.messagedialog.withdraw()
            button = Tkinter.Button(
                    text = text, command = self.messagedialog.activate)
            button.pack(pady = 20)
            exit = Tkinter.Button(text = 'Exit', command = root.destroy)
            exit.pack(pady = 20)
            root.mainloop()

    test()
    test()

def componentgroup_bug():
    global changecolour
    def changecolour():
        b.configure(Button_background = 'yellow')

    def addbutton():
        b.configure(Button_background = 'green')
        b.add('OK')
        b.after(3000, changecolour)

    global b
    b = Pmw.ButtonBox(Button_background = 'red')
    b.pack()

    mb = Pmw.MenuBar(Button_background = 'red')
    mb.configure(Button_background = 'yellow')
    mb.pack()

    mb = Pmw.PanedWidget(Frame_background = 'red')
    mb.configure(Frame_background = 'yellow')
    mb.pack()

    mb = Pmw.RadioSelect(Button_background = 'red')
    mb.configure(Button_background = 'yellow')
    mb.pack()

    b.after(3000, addbutton)

# ----------------------------------------------------------------------

if len(sys.argv) != 2:
    print 'Usage:', sys.argv[0], '<test_num>'
    sys.exit()

if sys.argv[1] == 'reinitialise_bug':
    # Run this by itself, since it calls Tkinter.Tk, mainloop, etc.
    reinitialise_bug()
    sys.exit()

# Use Pmw version in this distribution:
Test.initialise()
root = Test.root
root.deiconify()

# To use a different version of Pmw, comment out the three above lines
# and the "import Test" line and uncomment these three:
#   root = Tkinter.Tk()
#   Pmw.setversion('0.8')
#   Pmw.initialise(root, fontScheme = 'pmw1')

if sys.argv[1] == '1':
    scrolledframeflashing_bug()
elif sys.argv[1] == '2':
    scrolledlistboxflashing_bug()
elif sys.argv[1] == '3':
    scrolledlistboxflashing2_bug()
elif sys.argv[1] == '4':
    scrolledtextflashing_bug()
elif sys.argv[1] == '5':
    scrolledcanvasflashing_bug()
elif sys.argv[1] == '6':
    scrolledframeflashing2_bug()
elif sys.argv[1] == 'componentgroup_bug':
    componentgroup_bug()
else:
    print 'unkown test:', `sys.argv[1]`
    sys.exit()
root.mainloop()
