title = 'Pmw.Dialog demonstration'

# Import Pmw from this directory tree.
import sys
sys.path[:0] = ['../../..']

import Tkinter
import Pmw

class Demo:
    def __init__(self, parent):
	# Create two buttons to launch the dialog.
	w = Tkinter.Button(parent, text = 'Show application modal dialog',
	        command = self.showAppModal)
	w.pack(padx = 8, pady = 8)

	w = Tkinter.Button(parent, text = 'Show global modal dialog',
	        command = self.showGlobalModal)
	w.pack(padx = 8, pady = 8)

	# Create the dialog.
	self.dialog = Pmw.Dialog(parent,
	    buttons = ('OK', 'Apply', 'Cancel', 'Help'),
	    defaultbutton = 'OK',
	    title = 'My dialog',
	    command = self.execute)
	self.dialog.withdraw()

	# Add some contents to the dialog.
	w = Tkinter.Label(self.dialog.interior(),
	    text = 'Pmw Dialog\n(put your widgets here)',
	    background = 'black',
	    foreground = 'white',
	    pady = 20)
	w.pack(expand = 1, fill = 'both', padx = 4, pady = 4)

    def showAppModal(self):
        self.dialog.activate(geometry = 'centerscreenalways')

    def showGlobalModal(self):
        self.dialog.activate(globalMode = 1)

    def execute(self, result):
	print 'You clicked on', result
	if result not in ('Apply', 'Help'):
	    self.dialog.deactivate(result)

######################################################################

# Create demo in root window for testing.
if __name__ == '__main__':
    root = Tkinter.Tk()
    Pmw.initialise(root, fontScheme = 'pmw1')
    root.title(title)

    exitButton = Tkinter.Button(root, text = 'Exit', command = root.destroy)
    exitButton.pack(side = 'bottom')
    widget = Demo(root)
    root.mainloop()
