#!/bin/csh
# 
#---------------------------------------------------------------------
# Build script for making PyMOL External dependencies
#---------------------------------------------------------------------
# (can't do this stuff in a makefile cause we need to define
#  some important environmental variables)
#
#- Paths -------------------------------------------------------------
#
# --- Base
setenv BASE /opt/ESRF_sw/pymol/ext
#
#- Targets -------------------------------------------------------------
# -- Linux with just Tcl/Tk
setenv PYMOL_TARGETS "tcl tk zlib python distutils numpy pmw  glut-linux"
#
# -- Linux with Tcl/Tk and wxPython
# setenv PYMOL_TARGETS tcl tk zlib python distutils numpy pmw png-linux glut-linux glib gtk wxgtk wxpython" 
#
# -- SGI/IRIX with just Tcl/Tk
#setenv PYMOL_TARGETS "tcl tk zlib python distutils numpy pmw png-irix glut-irix" 
#
# -- SGI/IRIX with Tcl/Tk and wxPython
# setenv PYMOL_TARGETS tcl tk zlib python distutils numpy pmw png-irix glut-irix glib gtk wxgtk wxpython" 
#---------------------------------------------------------------------
#
#- For creation of a shared python library --------------------------
# --- Linux
setenv LDALLFLAGS "--whole-archive"
# --- SGI/IRIX
#setenv LDALLFLAGS "-n32 -all"
#---------------------------------------------------------------------
#
#- Misc --------------------------------------------------------------
#
# --- SGI/IRIX
#setenv SGI_ABI -n32
#setenv MAKE gmake
#setenv CXX CC
#
# --- Linux
setenv MAKE make
#
#- Path pre-emption critical for building gtk/wx ---------------------
#
setenv PATH ${BASE}/bin:$PATH
setenv LD_LIBRARY_PATH ${BASE}/lib
#
#- Build --------------------------------------------------------------
$MAKE -f Makefile.in $1
#---
