#########################3
##Disclaimer
##==========
## 
## This  software is provided without warranty of any kind.
## No liability is taken for any loss or damages, direct or
## indirect, that may result through the use of it. No warranty
## is made with respect to this documantation, or the programs
## and functions therein.
## There are no warranties that the programs or their documentation
## are free of error, or that it is consistent with any standard,
## or that it will meet the requirement for a particular application.




## Copyright
## =========
## 
## We have adopted the GNU LIBRARY GENERAL PUBLIC LICENSE to apply to
## the this software.
## For more information on the license terms, see
## http://www.gnu.org/copyleft/lgpl.txt         

## Author : Alessandro MIRONE mirone@esrf.fr 



import  Numeric 
import  LinearAlgebra
import sys
import math
import pickle

from    OP_simmetrie import OP_cella, OP_ComparisonCellRotatedCell, OP_isDifferent, OP_FindSymmetries, OP_TellAbout
import copy


help= (
" --------------------------------------------------------------------\n"
" This program has to be called with an input file name as argument\n"
"Such a file contains information on the cell in this format (example):\n"
"AtomNames=['Z',   'O',  'RR', 'OO' ]\n"
"cellvectors=Numeric.array( \n"
"         [ \n"
"            [4.0  , 0.0     ,  0.0],\n"
"            [0.0   , 4.0    ,  0.0], \n"
"            [0.0   , 0.0     ,  8.0] \n"
"         ] )\n"
"PositionsList=[\n"
"          Numeric.array(\n"
"              [\n"
"              [ 0.0,       0.0,       0.5  ]\n"
"             ]\n"
"          ),\n"
"          Numeric.array(\n"
"              [ [0.5,       0.0,       0.5 ],\n"
"                [0.0,       0.5,       0.5 ],\n"
"              ]\n"
"           ),\n"
"          Numeric.array(\n"
"              [ [0.0,       0.0,       0.0]\n"
"              ]\n"
"           ),\n"
"          Numeric.array(\n"
"              [ [0.5,       0.5,       0.3],\n"
"                [0.5,       0.5,       0.701]\n"
"              ]\n"
"          )\n"
"]\n"
"SeekedTetragon=[('Z',0),('O',0),('RR',0),('OO',0)]\n"
"CellsCoo=[(0,0,0),(0,0,0),(0,0,0),(0,0,0)]  # optional ( default to all zeros  )\n"
"dr_shell=0.05 # optional ( defaults to 0.1  ) \n"
"num_nei=3     # optional default to 2\n"
"\n"
"--------------------------------------------------------------------\n"
"............ Of course ... not verbatim....\n"
" To understand how to fit this input to your needs\n"
" please refer to the comments in the code\n"
" Better documentation is coming soon\n"
"--------------------------------------------------------------------\n"
)
 


if(len(sys.argv)!=2):
     print help
     raise " PROGRAM STOPPED"
file=open(sys.argv[1],"r")
sforexec=file.read()
exec(sforexec)
file.close()


#######################################
# the elements entering the cell
if("AtomNames" not in dir()):
   raise "AtomNames not defined"  


###########################################
# the three axis of the cell
if("cellvectors" not in dir()):
   raise "cellvectors not defined"  


######################################################################################
# for each element a list of vectors, each vector is the position of an atom
# Positions are given in the cell vectos basis
if("PositionsList" not in dir()):
      raise "PositionsList not defined"  


########################################################################
# The tetragons to be looked for simmetries
if("SeekedTetragon" not in dir()):
      raise "SeekedTetragon not defined" 

########################################################################
# The Cells coordinates of tetragon vertexes
if("CellsCoo" not in dir()):
      CellsCoo=[(0,0,0),(0,0,0),(0,0,0),(0,0,0)]

#################################################################################
# dr_shell ; this parameter tells how large is a radial shell
if  ("dr_shell" not in dir()):
      dr_shell=0.1

#################################################################################
# num_nei  ; this parameter tells how many neighbouring shells we consider
if("num_nei" not in dir()):
      num_nei=2

#############################################################"""
#  The positions are given in  the cell vectos basis.
#  Now we transform the position in xyz absolute space.

for k in range(0, len(PositionsList)):
     PositionsList[k]=Numeric.dot(PositionsList[k],  cellvectors   )

#########################################################"
# Constructor of OP_cella.
# Here one passes  the relevant parameter (see default list)

cella=OP_cella(cellvectors=cellvectors, AtomNames=AtomNames, PositionsList=PositionsList)



############################################################
# OP_cella.computeDistances(self, maxdist,N=2)
# It builds up a Big multiple dictionary, namely
#
# self.distances[Aa][Bb][kA][kB][(DX,DY,DZ)]
#
# where Aa and kA are the atom name ( for example "Si",..)
#  and the position in the array of vectors in cell.PositionsList
# starting from 0. Same thing for Bb and kB.
# (DX,DY,DZ) are integer numbers specifying the cell containing (Bb,kB)
# relatively to (Aa,kA).
# DX,DY,DZ run from -N to N 

cella.computeDistances(200.0,N=2)





##################################################################################
# OP_cella. FindTetragons(self, Latoms, CellsCoo=[(0,0,0),(0,0,0),(0,0,0),(0,0,0)])
# This is the key routine to find good candidates to symmetry group.
# Latoms is a list of the kind [  (Aa,kA) ,(Bb,kB)....] 
# ( i.e. couples formed by atom-name and position in the position list.
# Latoms must be formed of four  atoms defining a non-degenerate tetraedron.
# A check is permormed on the non-degeneracy.
# The funtions finds all the possible equivalent tetraedrons (which have the same
# set of distances, and the same atom kinds)
# The function return the list of all these tetraedrons
#
# Every tetraedron is represented by a list of four atoms and a list of cell coordinates.... like
# [     [        [(Aa,kA),(Aa2,kA2),(Aa3,kA3), (Aa4,kA4)],         [(0,0,0),(0,0,0),(0,0,0),(0,0,0)]           ]
#       [  ..............................................                                                      ]
# ]

#LTetra = cella.FindTetragons(
#[('Cu',0),('O',0),('La',2),('O',1)]
#)

LTetra = cella.FindTetragons(SeekedTetragon, CellsCoo)

#########################################################################################
#  OP_cella.FindPositions(self, Latoms, CellsCoo=[(0,0,0),(0,0,0),(0,0,0),(0,0,0)])
#  returns an array of four vectors. 
#  The nth vector gives the position of nth atom of Latoms with the nth  cell-coordinates 
#  of CellsCoo.
#  Here, LTetra[0] which is the first tetraedron of the list, correspond by construction 
#  to  identity 
 
Positions= cella.FindPositions(LTetra[0][0],LTetra[0][1])
Vectors = Positions[1:4]-Positions[0]

##########################################################
# OP_cella.getK(self, N=2)
# Returns an array of 3D vectors, that are spanned by
# integer multiples of cell's Brillouin vectors.
# integers run form -N to N.
# (the vectors are already multiplied by imaginary unit
#  in order to be ready for fourier transforming)

K       = cella.getK()

Fourier = cella.getFourier(K) 




 


##############################################################
# in CellsList we put transformed Cells that superpose
# perfectly to the original one through simmetry operations
# that are looked for in LTetra
# 
CellsList=[]

##############################################################
# in RotList we put rotations for the  transformed Cells that superpose
# perfectly to the original one through simmetry operations
# that are looked for in LTetra
# 
RotList=[]



#################################################"
# Start the loop on candidates to symmetry group
#
print LTetra
for i in range(0, len(LTetra)):
  NewPositions= cella.FindPositions(LTetra[i][0],LTetra[i][1])
  NewVectors = NewPositions[1:4]-NewPositions[0]
  Rot= Numeric.dot(Numeric.transpose(NewVectors),   LinearAlgebra.inverse(Numeric.transpose(Vectors))  )  

  shift=NewPositions[0]-Numeric.dot(Rot,Positions[0])
  if(LinearAlgebra.determinant(Rot)<0):
     Reflection=1
     Rot=-Rot
  else:
     Reflection=0

  newCell=copy.deepcopy(cella)
  if(Reflection):
          newCell.Reflection()
  newCell.TransformByMatrix( Rot ,shift )
  newFourier=newCell.getFourier(K) 
  diffFourier=newFourier-Fourier 
  diffFourier=  (diffFourier* Numeric.conjugate(diffFourier)).real  
  error=Numeric.sum(Numeric.sum(diffFourier))

  if(error<0.00001):
    isnew=1
    for tok in CellsList:
      if ( not OP_isDifferent(tok,newCell) ):
        isnew=0
    if(isnew):
     print "NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN"
     OP_TellAbout(Rot, short="NO")
     print " REFLECTION= ", ["NO","YES"][Reflection]
     print " SHIFT     = ", newCell.shift
     CellsList.append(newCell)
     RotList.append(Rot*(1-2*Reflection))

########################################################
# Now CellsList contains all the symmetric versions
# of the original cells

#######################################""
# Do important operations
# to find out groups and so on

cella.FindEquivalences(CellsList)       
cella.RotList=RotList
cella.computeHistograms(DR=dr_shell)

########################################"
# print something to the screen
#
cella.printEquivalences()
print " DISTANCES "
cella.printHisto(3)


#############################################
# Write the input file template
#
cella.printParametersInput("parinput",n=num_nei)

##################################################################33
# Write object cella to a file for subsequent retrival
#

delattr(cella,"distances")

print " WRITING CELLA TO FILE. TAKES A LONG TIME"    
fd=open("cella","w")
pickle.dump(cella,fd)

 







