import  NumericA
import  Numeric 
import  LinearAlgebra
import arrayfns
import  Minimiser
import  sys
import  math
import  cPickle
import  MLab
import string
from Dabax import * 
from    OP_simmetrie import OP_cella, OP_ComparisonCellRotatedCell, OP_isDifferent, OP_FindSymmetries, OP_TellAbout
import copy
from contributions import contributions

TR=Numeric.transpose


#################################################################
# opens the file where cella, M, Q, evals+evects are stored
#
storeall=open("storeall","r")
cella=cPickle.load(storeall)
ussqM=cPickle.load(storeall)  #1/sqrt(Mass)
Q=cPickle.load(storeall)

print " LENGHT Q=", len(Q)
Sum=0
Nsampling=cPickle.load(storeall)


#######################################
# Reads the definition of Q2I_Foo
#

Q2I_String=cPickle.load(storeall)
print " FUNCTION ", Q2I_String
exec(Q2I_String)  

transformations=cPickle.load(storeall)


#######################################################################33
# specify here the scatterers
#

Table_f0= Dabax_f0_Table("f0_WaasKirf.dat")
Table_f1f2=Dabax_f1f2_Table("f1f2_Windt.dat")

O_f0  = Table_f0.Element("O2-")
O_f1f2 = Table_f1f2.Element("O")

Cu_f0  = Table_f0.Element("Cu1+")
Cu_f1f2 = Table_f1f2.Element("Cu")

Nd_f0  = Table_f0.Element("Nd3+")
Nd_f1f2 = Table_f1f2.Element("Nd")

Copper =   Dabax_Scatterer([Cu_f0], [1.0],   [Cu_f1f2]  ,  [1.0]       )
Oxygen=    Dabax_Scatterer([O_f0 ], [1.0],   [O_f1f2 ]  ,  [1.0]       )
Neodymium =Dabax_Scatterer([Nd_f0], [1.0],   [Nd_f1f2]  ,  [1.0]       )

# Oxygen=Copper
# Neodymium=Copper



###################################################33
# here the objects that you associate to a given entry
# can be whatever object, given that it has a method
# F_Lambda(self,  Lambda, theta=None )
# with lambda in Angstroems and theta in radians
# Theta is the "bragg angle" i.e. : q= 2*sin(theta)*2*PI/lambda
#
 
scatterer_for_type={}
scatterer_for_type["Cu_G0"]=Copper
scatterer_for_type["O_G0"] =Oxygen
scatterer_for_type["O_G1"] =Oxygen
scatterer_for_type["Nd_G0"]=Neodymium
scatterer_for_type["Nd_G1"]=Neodymium

#####################################################################################3
# build up a list whose ith element is the scattering function for the type ( like Nd_G0)
# corresponding to the ith site ( coordinate from 3*i to 3*i+2 in the vectors)
# This list will be used to estabilish the array of scattering factor using dabax
# It is just a commodity list to be used when looping on the contributions

scatterers=[]
for A in cella.atomlist:
   scatterers.append(scatterer_for_type[cella.DGroups[A]] )


###########################################################################
# input here your lambda in Angstroems 
#
Lambda=0.783867
###########################################################################
# input here your Temperature in Kelvin of the SAMPLE
#
Temp = 15.0

##################################
# Planck's constant over two pi in erg*sec
#
hbar=1.054571596e-27

##################################
# Boltzmann constant in erg/Kelvin
Kb=1.38e-16

###########################################################
# the classical radius of the electron (e*e/m/c/c)
# re= 2.817940285(31)X10-15 m 

er0=2.817940285e-13
                                         


####################################################
# The unshifted Q of the phonons given in dispersion is in Angstroems-1
# We put it in cm-1
#
Q=Q*1.0e8

####################################################
# the list of 3D positions in Angstroems in cm
#
Positions= Numeric.array(map(cella.FindPosition,cella.atomlist ))*1.0e-8


##########################################################
# build a matrix by which the q's can be decomposed  on
# the Brillouin vectors basis. 
# Useful to display result in units which are integer on
#  the reciprocal lattice sites, or even more useful
# when we want reduce a big vector in the 000 cell
#

brill=cella.Brillvectors
brill=brill*1.0e8   # it was A-1
brilldecomposition=LinearAlgebra.inverse(TR(brill))

##########################################################################3
# qpoint is the point in the reciprocal lattice
# that we are observing. In this 2-phonons calculation
# qpoint is the sum of two phonon's Q's   
#
qpoint=Numeric.dot([6.6,1.0,0.0], brill )

print " qpoint = "
print qpoint

  


######################################################
# Histogram initialisation
#

Nhisto=200+1
Histogram=Numeric.zeros(Nhisto,'d')
################################################################333
# maximum frequency. About twice the maximum w of phonons
Whisto=40.0e12



########################################################
#  theta ( analogous of Bragg theta )
# 
theta = Numeric.arcsin(Numeric.sqrt(Numeric.sum(TR(qpoint*qpoint)))*Lambda*1.0e-8/2.0/math.pi/2.0)

print " CHECK CHECK CHECK CHECK CHECK CHECK CHECK CHECK CHECK CHECK CHECK CHECK"
print " theta corresponding to qpoint is  " ,theta*180/math.pi


scattering_powers=Numeric.array(map( lambda x, Lambda=Lambda, theta=theta: x.F_Lambda(Lambda,theta),  scatterers))


###############################################################################
# Build a list containing eigenvalues, and a list containing eigenvectors
#

Eval_L =[]
Evec_L =[]

for iq in range(0,len(Q)):
  print iq
  Eval_L.append(  cPickle.load(storeall) )
  # print Eval_L[-1]
  Evec_L.append(  cPickle.load(storeall) )

Eval_L=Numeric.array(Eval_L)

# we donot need to rescale evect because they are normalised to 1

Evec_L=Numeric.array(Evec_L)

# we need sqrt of frequencies

Numeric.sqrt(Eval_L,Eval_L)
Sqrt_Eval_L = Numeric.sqrt(Eval_L)
Sqrt_Eval_L_1d=Numeric.reshape( Sqrt_Eval_L ,[  Numeric.multiply.reduce( Numeric.shape(Sqrt_Eval_L) ) ]   )
MaxSqW =max(Sqrt_Eval_L_1d)

###################################################################################################
#
#    Problems may come from w=0 in the denominator. Sqrt_Eval_L is used only
#    in the denomiator. Put it to infinite when it is too small.
#   No interference with other parts of the programs. Only with denominator
#

Mask=Numeric.less(Sqrt_Eval_L, MaxSqW/100.0)
Sqrt_Eval_L= Sqrt_Eval_L+Mask*1.0e60


###################################################################################################
#  (Sqrt_)Eval_L is now an array of dimension Nq,Nm
#                   where Nq is the number of sampling qs and Nm the number of modes (42 for Matteo)  
#  Evec_L      is now an array of dimension Nq,Nm,Ndf
#                   where Ndf is the number of degrees of freedom that is equal to Nm

#################################################
# occupation numbers
#
espo      = Numeric.minimum(  hbar/(Kb*Temp)*Eval_L  , 80)
expmhw_kt = Numeric.exp(-espo) 
Bose_nwh   =  expmhw_kt/(1-expmhw_kt)                   # this is a vector too






##############################################################################
# We perform now a double loop on the sampled Q space.
# We recompose the Q space in its integrity by a double loop
#  on the simmetry transofmations
#

count_trA=0
if( len(sys.argv)==1):
   start_A=0
   lim_A  =len(transformations)
else:
   start_A= string.atoi(sys.argv[1])
   lim_A  = string.atoi(sys.argv[2])

for count_trA in range (start_A,lim_A):
  trA=transformations[count_trA]
  print " count_trA ", count_trA

  #################################################################################3
  # Instead of transforming the Evec_L and than doing the scalar product with qpoint,
  #   it is more convenient to transform back qpoint and doing the calar product
  #   with the non transformed Evec_Ls
  #

  qpointA =Numeric.dot(TR( trA ) , qpoint)
  # print " qpointA ",  qpointA
  scalA   =TR( Numeric.sum( TR(qpointA*Numeric.reshape(Evec_L,[len(Evec_L), len(Evec_L[0]), len(Evec_L[0][0])/3,3 ]  )) ) )


  #  print Evec_L[0]



  ##############################################################################################
  #  scalA      is now an array of dimension Nq,Nm,Nm/3
  #         the last indices runs over the atomic sites          


  ###################################################################################################################
  # We multiply scalA by the inverse of sqrt(masses) 
  #
  Numeric.multiply(scalA,ussqM[::3],scalA) 

  ################################################################################################3
  # divide by the sqrt of frequencies
  # 
  Numeric.divide(TR(scalA),TR(Sqrt_Eval_L),TR(scalA) ) 
 
  for count_trB in range(0,len(transformations)) :
     print " len tr = ", len(transformations)
     print "    count_trB ", count_trB
     trB = transformations[count_trB]
     qpointB =Numeric.dot(TR( trB ) , qpoint)
     scalB   =TR( Numeric.sum( TR(qpointB*Numeric.reshape(Evec_L,[len(Evec_L), len(Evec_L[0]), len(Evec_L[0][0])/3,3 ]  )) ) )

     Numeric.multiply(scalB,ussqM[::3],scalB) 
     Numeric.divide(TR(scalB),TR(Sqrt_Eval_L),TR(scalB)) 



     ####################################################
     # Now loop on all q of the first zone
     #
     for iFz in range(0, len(Q)):
        q1=Q[iFz]
         
        ###########################################################
        # Find the weigth and check the Q2I_Foo at the same time
        #
        q1_onBrill    = Numeric.dot  (  brilldecomposition,  q1  )
        (iFz_supposed ,weightFz) = Q2I_Foo(q1_onBrill,Nsampling)
        if(iFz_supposed != iFz):
            raise " iFz_supposed != iFz"


        ########################################3
        # transform q1 to what it really is
        # after transformation  trA
        q1=Numeric.dot(  trA  , q1)

        ##################################
        # The vector to reproduce with
        # q2
        Bigq2 = qpoint-q1

        ########################################3
        # reduce Bigq2 in the (0,0,0)  cell
        
        Bigq2_onBrill    = Numeric.dot  (  brilldecomposition, Bigq2 )
        decalage_onBrill = Numeric.floor(  Bigq2_onBrill  +  0.5 )
        decalage         = Numeric.dot  (  decalage_onBrill , brill )
        q2               = Bigq2 - decalage
        #################################################################
        # trace back in the 0 domain
        q2               = Numeric.dot(  TR(trB)  , q2)

        q2_onBrill       = Numeric.dot  (  brilldecomposition, q2 )

        ##################################################################
        # Now find the iSz ( the "i" in the second zone)
        # to which q2 corresponds.
        # The following function test if q2_onBrill lyes in the
        # 0 domain
        
        
        (iSz,weightSz) = Q2I_Foo(q2_onBrill,Nsampling)
       
        if(iSz<0):
           # point outside the domain
           continue
        if(iSz>=len(Q) ):
           # problem with the backmapping
           raise  " PROBLEM : iSz>=len(Q) "
        print weightFz

        ##########################################################################
        # Now the important things that I have are
        #  ----    ScalA[iFz]
        #  ----    ScalB[iSz]
        #  ----    Frequences in A (Eval_L[iFz])
        #  ----               in B (Eval_L[iSz])
        #
        #   
     
        scala=scalA[iFz]
        scalb=scalB[iSz]
        fA   =Eval_L[iFz]/2.0/math.pi
        fB   =Eval_L[iSz]/2.0/math.pi

        #########################################################################
        # we take into account the decalage of BigQ2

        scalb=scalb* Numeric.exp(Numeric.sum(TR(complex(0.0,+1.0)*decalage*Positions)) )

        ###########################################################################
        #  add contributions to the histogram
        #  Uses Outer Product 
        # addcontributionsToHisto(Histogram,Nhisto,Whisto, scala,scalb,fA,fB)                                     


        fXsum =( Numeric.reshape(fA,[len(fA),1]) +
                 Numeric.reshape(fB,[1,len(fB)])  )

        shs=Numeric.shape(scala)

        sXprod =(Numeric.reshape(scala,[shs[0] ,1     , shs[1]]  ) * 
                 Numeric.reshape(scalb,[ 1     ,shs[0], shs[1] ] )     )           

        sXprod=sXprod  *scattering_powers

        sXprod = TR( Numeric.sum(TR(sXprod))  )


        hix = Numeric.floor( ((fXsum * (Nhisto-1))/Whisto)+0.5 ).astype('l')

        shf=Numeric.multiply.reduce( Numeric.shape(fXsum) )
        shi=Numeric.multiply.reduce( Numeric.shape(hix)   )

        ##############################################################
        # Before reshaping to a 1D array we multiply by occupations numbers factors
        #
        # L'ultimo indice(ultimo a destra) viene dalla seconda zona
        # 
        Numeric.multiply( sXprod, (Bose_nwh[iSz]   +1 )   ,sXprod)
        #
        # il primo ( a sinistra) dalla prima
        #
        Numeric.multiply( TR(sXprod), (Bose_nwh[iFz]   +1 )   ,TR(sXprod) )
        #########################################################################

        hix        = Numeric.reshape(hix    ,[shi] )
        sXprod     = Numeric.reshape(sXprod ,[shf] )
         
        
        sXprod = (sXprod*Numeric.conjugate(sXprod)).real
        
        addendum = arrayfns.histogram(hix,sXprod )


        # print " shape addendum ", Numeric.shape(addendum)
        # print " shape Histogram", Numeric.shape(Histogram)
        Ncells=1.0e22  

        Sum=Sum+weightFz*weightSz
        Numeric.add(Histogram[0:len(addendum)]  , addendum*weightFz*weightSz , Histogram[0:len(addendum)])


#####################################################################3
# PUT THE RIGHT FACTORS
#

NsampTot = (2*Nsampling-2)*(2*Nsampling-2)*(2*Nsampling-2)
Ncells=1.0e22

Histogram=er0*er0*hbar*hbar*Ncells *Histogram/(NsampTot*8)

if(len(sys.argv)==1):

  fd=open("doublePh.dat","w")
  for i in range(0,len(Histogram)):
    fd.write("%e %e\n" %(i*Whisto/Nhisto  ,Histogram[i]) )
else:
  fd=open("doublePh%s.dat" % sys.argv[1] ,"w")

  for i in range(0,len(Histogram)):
    fd.write("%e %e\n" %(i*Whisto/Nhisto  ,Histogram[i]) )



 
print " Sum ", Sum










