#########################3
##Disclaimer
##==========
##
## This  software is provided without warranty of any kind.
## No liability is taken for any loss or damages, direct or
## indirect, that may result through the use of it. No warranty
## is made with respect to this documantation, or the programs
## and functions therein.
## There are no warranties that the programs or their documentation
## are free of error, or that it is consistent with any standard,
## or that it will meet the requirement for a particular application.

## Copyright
## =========
##
## We have adopted the GNU LIBRARY GENERAL PUBLIC LICENSE to apply to
## the this software.
## For more information on the license terms, see
## http://www.gnu.org/copyleft/lgpl.txt
import NumericA
import  Numeric 
import  LinearAlgebra
import sys
import math
import pickle
import MLab
import commands

from    OP_simmetrie import OP_cella, OP_ComparisonCellRotatedCell, OP_isDifferent, OP_FindSymmetries, OP_TellAbout
import copy
from contributions import contributions
import contributions

TR=Numeric.transpose
CON=Numeric.conjugate
DOT=Numeric.dot


help=" Execute this program with three arguments : Name of the edited parinput file, Name of the cella file. Name of a file containing something like this:\n"

help_file=("astar=2*math.pi/3.87\n"
"cstar=2*math.pi/9.50\n"
"eps=0.0015\n"
"Q=Numeric.array( [ [0,0,cstar*0.02*i+eps] for i in range(1,50)]           )\n"
"debyerange=[4,4,2]\n"
"debye=astar/8\n"
"SMcellrange=[2,2,2]\n"
"cellrange= [-1,-1,-1]\n"
"Kcellrange=[-1,-1,-1]\n"
"sigmacellrange=[-1,-1,-1]\n"
"sigmacharge=3\n"
"IS_IT_SCREENED=1\n"
"selectors=[(1.0,0.0,0.0]\n"
"USE_DFM=1/0/Optional(Default 0)\n"
"USE_JT =1/0/Optional(Default 0)\n"
"USE_SCREENING_FUNCTION =1/0/Optional(Default 0)\n"
"ScreenKrange = [2,2,2]/Optional(Default [-1,-1,-1])\n"
)

USE_DFM=0
USE_JT =0
USE_SCREENING_FUNCTION = 0
ScreenKrange = [-1,-1,-1]

if(len(sys.argv)!=4):
   print help
   print ""
   print help_file
   raise "STOPPING PROGRAM "

####################################################
# Read parameters for interactions. 

name=sys.argv[1]
fd=open(name,"r")
stringa=fd.read()

#    With this trick, parameters will be accessed
#    like  Parameters.BM_L ..........and so on
#    ;)


class Parameters:
    exec(stringa)
    

print Parameters.Z_
print Parameters.M_

print dir(Parameters)
print (Parameters.Z_)


###################################
# Read object cella from  a file 
#
print " READING  CELLA FROM FILE. TAKES A LONG TIME"    
fd=open(sys.argv[2],"r")
cella=pickle.load(fd)

######################################
# create the array of K vectors

name=sys.argv[3]
fd=open(name,"r")
stringa=fd.read()

exec(stringa)
    


########################################################


F_arrays     = contributions.contributionsArrays(cella, Parameters, Q)

F_analytical  = contributions.contributionsAnalytical(cella, Parameters,Q, cellrange= cellrange)
F_shellModel = contributions.contributionsShellModel(cella, Parameters,Q,SMcellrange=SMcellrange, )

if(IS_IT_SCREENED==0):
    F_coulomb = contributions.contributionsCoulomb(cella, Parameters,Q,  Kcellrange=Kcellrange,  sigmacellrange=sigmacellrange,
                                                   sigmacharge=sigmacharge, fastcalc=1  )
else:
   F_screened  =  contributions.contributionsScreened(cella, Parameters,Q, debye=debye, debyerange=debyerange, fastcalc=1)
    
if(USE_DFM):
  F_dfm= contributions.contributionsDFM(cella, Parameters, Q,SMcellrange=SMcellrange  )
else:
  F_dfm=0    

if(USE_JT):
  F_JT= contributions.contributionsJT(cella, Parameters, Q,SMcellrange=SMcellrange  )
else:
  F_JT=0
  
if(USE_SCREENING_FUNCTION):
     F_SF = contributions.contributionsCoulombScreened(cella, Parameters,Q,  Kcellrange=ScreenKrange,  sigmacharge=sigmacharge,  fastcalc=0  )
else:
     F_SF=0

file=open("disp_res","w")
filesq=open("disp_ressq","w")
    
Z=F_arrays.Za
M=F_arrays.Ma
M=1./Numeric.sqrt(M)
Y=F_arrays.Ya
K=F_arrays.Ka


evectsOld=None


###################################################################################################
# file where everything will be stored ( cella, Q, and for every q  eigenvvalues + eigenvectors
#

storeall=open("storeall","w")
pickle.dump(cella,storeall)
pickle.dump(M,storeall)
pickle.dump(Q,storeall)


for iscan in range(0, len(Q)):
  q=Q[iscan]
  FSR =F_shellModel.SS[iscan]
  FSC =F_shellModel.SC[iscan]
  FCS =F_shellModel.CS[iscan]
  FSS =F_shellModel.SR[iscan]
  FSC0=F_shellModel.SC0[iscan]
  FCS0=F_shellModel.CS0[iscan]

  if(IS_IT_SCREENED==0):
    C=F_coulomb.C[iscan]
    VC0z=F_coulomb.VC0z [iscan]
  else:
    C=F_screened.DebC[iscan]
    VC0z=F_screened.DebVC0 [iscan]
    
  if(USE_SCREENING_FUNCTION):
     C=C+F_SF.C[iscan]
     VC0z= VC0z + F_SF.VC0z [iscan]

  
#  C=F.DebC[i]
#  VC0=F.DebVC0 [i]
 

  ZCZ= TR(Z*TR(C*Z))
  ZCY= TR(Z*TR(C*Y))
  YCZ= Numeric.conjugate(TR(ZCY))
  YCY= TR(Y*TR(C*Y))

  ZVC0z= TR(Z*TR(VC0z))
  YVC0z= TR(Y*TR(VC0z))


  dim=len(ZCZ)
  KM  = MLab.eye(dim,dim)*K
  Muu =     ZCZ+FSR+FSC+FCS+FSS+ZVC0z

  if(USE_DFM):
    # print " S\n",F_dfm.S[iscan]
    Muu = Muu +( F_dfm.P[iscan] -
         DOT(  CON(TR(F_dfm.T[iscan])) , DOT(LinearAlgebra.inverse( MLab.eye(dim,dim)+F_dfm.S[iscan]), F_dfm.T[iscan] ) ) )

  Muw =     ZCY+FSC+FSS+FCS0-FSC0+YVC0z
  Mwu =     YCZ+FCS+FSS+YVC0z
  Mww =     YCY+FSS+FSC0+KM +YVC0z

  if(USE_JT):
    Mww = Mww +( F_JT.JT[iscan] )




  MM  = Muu - Numeric.dot(Muw , Numeric.dot( LinearAlgebra.inverse(Mww), Mwu)   ) 
  MM=TR( M*TR(MM*M))

  (evals, evects) = LinearAlgebra.Heigenvectors(MM)


  ###################################333
  # reordering
  #
  if(evectsOld is not None):
      products = Numeric.array(
                 [ 
                    [ Numeric.sum( Numeric.conjugate(evects[j]) * evectsOld[i] )
                              for j in range(0, len(evects)) 
                    ]
                          for i in    range(0, len(evects)) 
                 ])      
      products=abs(products) 
      placetoread = [ (products[i].tolist()).index( reduce(Numeric.maximum,products[i])) for i in    range(0, len(evects))  ]
      newevects  = Numeric.array([ evects[placetoread[i]] for       i in    range(0, len(evects))  ] )
      newevals   = Numeric.array([ evals [placetoread[i]] for       i in    range(0, len(evects))  ] )    
      evects =     newevects
      evals  =     newevals
  evectsOld = evects
  if("selectors" in dir()):
      if( "selector_result" not in dir()):
          selector_result={}
      for sel_i in range(len(selectors)):
          if( sel_i not in selector_result.keys()):
              selector_result[sel_i]=Numeric.zeros(len(evects),'d')
          versor=selectors[sel_i]
          qe = Numeric.reshape(evects,[len( evects),len( evects)/3,3])*versor
          qe=TR(Numeric.sum(TR(qe)))
          qe=qe*Numeric.conjugate(qe)
          qe=qe.real
          qe=Numeric.sum(TR(qe))
          selector_result[sel_i]+=qe


   
  ######################################
  # dumping evals and evects
  #
  pickle.dump(evals,storeall)
  pickle.dump(evects,storeall)

  ##########################################################
  # build a matrix by which the q's can be decomposed  on
  # the Brillouin vectors basis. 
  # Useful to display result in units which are integer on
  #  the reciprocal lattice sites, or even more useful
  # when we want reduce a big vector in the 000 cell
  #
  
  brill=cella.Brillvectors
  brilldecomposition=LinearAlgebra.inverse(TR(brill))
  
  for eval in evals:
       file.write( ( " %20e " % eval) )
  file.write("\n")
  count=0
  for eval in evals:
     if(count==0):
         qdec=Numeric.dot(brilldecomposition, Q[iscan])
         print qdec
         filesq.write( ( " %20e %20e %20e  " % ( qdec[0],qdec[1],qdec[2])   ) )
#         filesq.write( ( " %20e " % ((Q[iscan,0])*9.50/2.0/math.pi, )   ) )
#    commands.getoutput('gnuplot plotta')

     if(eval>0):
           filesq.write( ( " %20e " % math.sqrt(eval)) )
     else:
           filesq.write( ( " ****  " ) )
     count=count+1

  filesq.write("\n")

filepol=open("polar_res","w")
for sel_i in range(len(selectors)):
   filepol.write("%s %s \n " % ("for selector ", selectors[sel_i]))
   sortedqe=Numeric.sort(selector_result[sel_i])
   qelist= selector_result[sel_i].tolist()
   for tot in sortedqe:
       filepol.write(  " %s %20e \n" % (qelist.index(tot), tot))
   filepol.write("\n")










