/*
 * Alessandro MIRONE
 * June the 7th 2001, 
 * ESRF
 */

#include"Python.h"
#include "structmember.h"
#include<stdio.h>
#include<iostream.h>
#include<string.h>

#include "Numeric/arrayobject.h"
#include <math.h>
#include<complex.h>

#define DEBUG(a) printf(a); printf("\n");

/*
 * The error object to expose 
 */

static PyObject *ErrorObject;
#define onError(message)\
  { PyErr_SetString(ErrorObject, message); return NULL;}


static char OP_fastGsum_doc[] = "
/*  11  arguments are taken by the function :
 * KcrX , PyInteger. Scann for the x-coordinate of the cell-loop will go from -KcrX to + KcrX
 * KcrY , idem for Y
 * KcrZ , idem for Z
 * 
 * BrillX Array3: brillouin vectors
 * BrillY
 * BrillZ
 * Q      Array NX3, the wavenumbers of the scan  
 * DR     Array3. the distance from the fixed atom to the looping one
 *
 * sigma           float, sigma charge
 *
 * TermtoaddtoInsect    has to be dimensioned to Complex64 len(Q)X3X3
 * Cself                has to be dimensioned to Complex64 3X3
 *
 * RETURN VALUE
 *    None
 *    Result are in  TermtoaddtoInsect and Cself
 *    Cself has to be dimensioned to Complex64 3X3
 *    TermtoaddtoInsect  has to be dimensioned to Complex64 len(Q)X3X3
 */
";



static PyObject *
OP_fastGsum(PyObject *self, PyObject *args)
{
  PyArrayObject *BrillX,*BrillY,*BrillZ,*Q,*DR,*TermtoaddtoInsect,*Cself,*Qshift;
  double  sigma;
  int KcrX,KcrY,KcrZ;



  if(!PyArg_ParseTuple(args,"iiiOOOOOdOOO:OP_fastGsum_doc",  &KcrX, &KcrY, &KcrZ,
                        &BrillX, &BrillY, &BrillZ,
                         &Q, &DR,
                         &sigma,  &TermtoaddtoInsect, &Cself,&Qshift)
     )
    return NULL;

  /* check the Objects */
  if(!PyArray_Check((PyObject *)BrillX ))    onError("not a PyArray, argument 4");
  if(!PyArray_Check((PyObject *)BrillY))     onError("not a PyArray, argument 5");
  if(!PyArray_Check((PyObject *)BrillZ))    onError("not a PyArray, argument 6");
  if(!PyArray_Check((PyObject *)Q))         onError("not a PyArray, argument 7");
  if(!PyArray_Check((PyObject *)DR))       onError("not a PyArray, argument 8");
  if(!PyArray_Check((PyObject *)TermtoaddtoInsect))        onError("not a PyArray, argument 10");
  if(!PyArray_Check((PyObject *)Cself))        onError("not a PyArray, argument 11");

  /* check the types */
  if( BrillX->descr->type_num != PyArray_DOUBLE ) onError(" arg 4 is not double " ) ;
  if( BrillY->descr->type_num != PyArray_DOUBLE ) onError(" arg 5  is not double " ) ;
  if( BrillZ->descr->type_num != PyArray_DOUBLE ) onError(" arg 6 is not double " ) ;

  if( Q->descr->type_num != PyArray_DOUBLE ) onError(" arg 7 is not double " ) ;
  if( DR->descr->type_num != PyArray_DOUBLE ) onError("  arg 9  is not double " ) ;
  if( TermtoaddtoInsect->descr->type_num != PyArray_CDOUBLE ) onError("  arg 10  is not cdouble " ) ;
  if( Cself->descr->type_num != PyArray_CDOUBLE ) onError("  arg 11  is not cdouble " ) ;

  if( Qshift->descr->type_num != PyArray_DOUBLE ) onError("  arg 12  is not double " ) ;


  /* check the dimensions */
  if( BrillX->nd != 1 )
    onError("The BrillX (arg. 4) has not the right number of dimensions");
  if( BrillY->nd != 1 )
    onError("The BrillY (arg. 5) has not the right number of dimensions");
  if( BrillZ->nd != 1 )
    onError("The BrillZ (arg. 6) has not the right number of dimensions");

  if( Q->nd != 2 )
    onError("The Q (arg. 7) has not the right number of dimensions");
  if( DR->nd != 1 )
    onError("The DR (arg. 8) has not the right number of dimensions");

  if(TermtoaddtoInsect ->nd != 3 )
    onError("The TermtoaddtoInsect (arg. 10) has not the right number of dimensions");

  if( Cself->nd != 2 )
    onError("The Cself (arg. 11) has not the right number of dimensions");



  
  int numQ;
  numQ=Q->dimensions[0];

  if(TermtoaddtoInsect->dimensions[0] != numQ )
    onError("The TermtoaddtoInsect  array (arg. 10  has not the right  dimension");
  if(TermtoaddtoInsect->dimensions[1] != 3 )
    onError("The TermtoaddtoInsect  array (arg. 10  has not the right  dimension");
  if(TermtoaddtoInsect->dimensions[2] != 3 )
    onError("The TermtoaddtoInsect  array (arg. 10  has not the right  dimension");

  if(Cself->dimensions[0] != 3 )
    onError("The Cself  array (arg. 11  has not the right  dimension");
  if(Cself->dimensions[1] != 3 )
    onError("The Cself  array (arg. 11  has not the right  dimension");


  if(BrillX->dimensions[0] != 3 )
    onError("The  BrillX array (arg. 4  has not the right  dimension");
  if(BrillY->dimensions[0] != 3 )
    onError("The BrillY  array (arg. 5  has not the right  dimension");
  if(BrillZ->dimensions[0] != 3 )
    onError("The BrillZ  array (arg. 6  has not the right  dimension");
  if(Q->dimensions[1] != 3 )
    onError("The Q  array (arg.  7  has not the right  dimension");
  if(DR->dimensions[0] != 3 )
    onError("The DR  array (arg.  8  has not the right  dimension");


  /* check for contiguity */

  PyArrayObject *toverify[]={BrillX,BrillY,BrillZ,DR,TermtoaddtoInsect,Cself,NULL};
  PyArrayObject **ptr;
  ptr=toverify;
  while(*ptr) {
    if((*ptr)->flags %2 == 0) onError(" All arrays have to be contiguous");
    ptr++;
  }


  /* After having verified everything we can finally do fast calculations */


  double *qshift =   (double*) Qshift->data;  
  double *q =   (double*) Q->data;  
  double *brillX =   (double*) BrillX->data;  
  double *brillY =   (double*) BrillY->data;  
  double *brillZ =   (double*) BrillZ->data;  
  double *dr =   (double*) DR->data;  

  complex<double> *toadd =   (complex<double>*) TermtoaddtoInsect->data;  
  complex<double> *cself =   (complex<double>*) Cself->data;  


  double k0,k1,k2,dk2, gdr,g0,g1,g2, espo, G2;
  double p;
  complex<double>  fatt;
  p=1.0/(2.0*sigma*sigma);  
  for( int nscan=0; nscan<numQ; nscan++) {
    for(int ix=-KcrX; ix<=KcrX; ix++) 
      for(int iy=-KcrY; iy<=KcrY; iy++) 
	for(int iz=-KcrZ; iz<=KcrZ; iz++) {
	  k0=q[0]+ix*brillX[0]+iy*brillY[0]+iz*brillZ[0];
	  k1=q[1]+ix*brillX[1]+iy*brillY[1]+iz*brillZ[1];
	  k2=q[2]+ix*brillX[2]+iy*brillY[2]+iz*brillZ[2];
	  g0=k0-q[0];
	  g1=k1-q[1];
	  g2=k2-q[2];


          dk2=k0*k0+k1*k1+k2*k2;

	  gdr= (g0-qshift[0])*dr[0]+(g1-qshift[1])*dr[1]+(g2-qshift[2])*dr[2]; 
	  espo=dk2/4.0/p;
          if(espo>80) espo=80;
	  
          fatt= exp(complex<double>(-espo, -gdr) )/dk2;

	  toadd[ 0* 3 + 0 ] += fatt*k0 * k0 ;
	  toadd[ 0* 3 + 1 ] += fatt*k0 * k1 ;
	  toadd[ 0* 3 + 2 ] += fatt*k0 * k2 ;
	  toadd[ 1* 3 + 1 ] += fatt*k1 * k1 ;
	  toadd[ 1* 3 + 2 ] += fatt*k1 * k2 ;
	  toadd[ 2* 3 + 2 ] += fatt*k2 * k2 ;

          G2 =g0*g0+g1*g1+g2*g2;
          if( nscan==0 && G2>0.0 ) {
	    espo= G2/4.0/p;
	    if(espo>50) espo=50;
	     
	    gdr= (g0)*dr[0]+(g1)*dr[1]+(g2)*dr[2]; 
	    fatt= exp(complex<double>(-espo, -gdr) )/G2;


	    
	    cself[ 0* 3 + 0 ] += fatt*g0 * g0 ;
	    cself[ 0* 3 + 1 ] += fatt*g0 * g1 ;
	    cself[ 0* 3 + 2 ] += fatt*g0 * g2 ;
	    cself[ 1* 3 + 1 ] += fatt*g1 * g1 ;
	    cself[ 1* 3 + 2 ] += fatt*g1 * g2 ;
	    cself[ 2* 3 + 2 ] += fatt*g2 * g2 ;
	  }
          
	  
	} 
    toadd[ 1* 3 + 0 ] =toadd[ 0* 3 + 1 ];
    toadd[ 2* 3 + 0 ] =toadd[ 0* 3 + 2 ];
    toadd[ 2* 3 + 1 ] =toadd[ 1* 3 + 2 ];

    toadd+= 9;
    q    +=3;
  }
  cself[ 1* 3 + 0 ] =cself[ 0* 3 + 1 ];
  cself[ 2* 3 + 0 ] =cself[ 0* 3 + 2 ];
  cself[ 2* 3 + 1 ] =cself[ 1* 3 + 2 ];
 

  Py_INCREF(Py_None);
  return Py_None;
}





static PyMethodDef OP_fastGsum_functions[] = {
  {"OP_fastGsum", OP_fastGsum, METH_VARARGS ,OP_fastGsum_doc },
  { NULL, NULL}
};


extern "C" {
void 
initOP_fastGsum();
}

void 
initOP_fastGsum()
{
  PyObject *m, *d;
  m = Py_InitModule("OP_fastGsum", OP_fastGsum_functions);
  d = PyModule_GetDict(m);
  ErrorObject = Py_BuildValue("s","OP_fastGsum.error");
  PyDict_SetItemString(d,"error", ErrorObject);
  if(PyErr_Occurred())
    Py_FatalError("can't initialize module OP_fastGsum ");

#ifdef import_array
  import_array();
#endif
}

































