import beans
import beansgui
import sys
from beans import *
from Dabax import *



class BEAN_AtomicProperties(      instruction_base):

  help="I can tell you about %s  \n call function  getProperty with two args: atom name and property name" %( string.join(AtomicPropertiesList()) ) 

  type="AtomicProperties"
  supertype="Optical Tables"

  generatedtype="numeric_f"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Element",
                                  type         ="string", 
                                  value="None" ,             
                                  argument_key="None",
				  help="Name of the Element. Dont forget the \" \" around the filename.",
                                  default="pippo"
                                ),
                                self 
                               )
                             )

    plist_=AtomicPropertiesList()
    plist=[]
    for tok in plist_:
      plist.append( '"'+tok+'"'    )
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Property",
                                  type         ="notipe", 
                                  additionaloptions=plist,
                                  value="None" ,             
                                  argument_key="None",
				  help="Lot of choices... open the menu... ",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="AtomicProperties"

  


class BEAN_ScanReader(      instruction_base):
  help="object  of the class of type instruction ScanReader"
  type="ScanReader"
  supertype="Readers"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="filename",
                                  type         ="string", 
                                  value="None" ,             
                                  argument_key="None",
				  help="Name of the file to read. Dont forget the \" \" around the filename. Leave it equal to NonDont write anything if you want to sythetize a scan",
                                  default="pippo"
                                ),
                                self 
                               )
                             )
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Npoints",
                                  type         ="notipe", 
                                  additionaloptions=["\"first line\"", "\"automatic\""],
                                  value="None" ,             
                                  argument_key="Np",
				  help="Number of points in the scan to read. Either input an integer, or ""first line"" or ""automatic""  ",
                                  default="None"
                                ),
                                self 
                               )
                             )
    for name_col in ["wavelenghts_col","angles_col","refle_col","weight_col"]:
      self.properties_list_fixed.append(
                               property_container(
                                property(property_name=name_col,
                                  type         =("numeric_f","numeric_i"), 
                                  value="None" ,             
                                  argument_key=name_col,
				  help=("An integer to tell the columns number (1,2,3..), or a float to tell a fixed value."+
                                        " if you want to sythetise it write a list like [min,max,stride] "),
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="angle_factor",
                                  type         ="numeric_f", 
                                  value="1.0" ,             
                                  argument_key="angle_factor",
				  help="The angle column migth need to be rescaled. Input here the factor to convert it in radians from the surface",
                                  default="1.0"
                                ),
                                self 
                               )
                             )

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="ScanReader"



class BEAN_Dabax_f0_Table(      instruction_base):
  help="object  of the class of type  Dabax_f0_Table"
  type="Dabax_f0_Table"
  supertype="Optical Tables"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="filename",
                                  type         ="string", 
                                  additionaloptions=("\"f0_WaasKirf.dat\"",),
                                  value="\"f0_WaasKirf.dat\"" ,             
                                  argument_key="None",
				  help="Name of the file to read.  ",
                                  default="pippo"
                                ),
                                self 
                               )
                             )
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="Dabax_f0_Table"









class BEAN_Dabax_f1f2_Table(      instruction_base):
  help="object  of the class of type  Dabax_f1f2_Table"
  type="Dabax_f1f2_Table"
  supertype="Optical Tables"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="filename",
                                  type         ="string", 
                                  additionaloptions=("\"f1f2_Henke.dat\"","\"f1f2_Sasaki.dat\"","\"f1f2_Windt.dat\"",),
                                  value="\"f1f2_Henke.dat\"" ,             
                                  argument_key="None",
				  help="Name of the file to read.  ",
                                  default="pippo"
                                ),
                                self 
                               )
                             )
    
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="Dabax_f1f2_Table"


class BEAN_IndexFromTable(  ListLike_instruction):
  help="Create an optical  material from tables"
  type="IndexFromTable"
  supertype="Create an optical  material from tables"


  def __init__(self):
    beans.ListLike_instruction.__init__(self)
    self.associated_variable="None"

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Table F0",
                                  type         ="Dabax_f0_Table", 
                                  value="None" ,             
                                  argument_key="None",
				  help="Table to use for f0 ",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Table F1F2",
                                  type         ="Dabax_f1f2_Table", 
                                  value="None" ,             
                                  argument_key="None",
				  help="Table to use for f12 ",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.groupedproperties=[
      ["Name of the element","string", [], "Name of the element. Remeber the \"'s around the name" ],
      ["Density",["numeric_f","Variable"],[],"Density"  ]
      ]

##     self.properties_list_fixed.append(
##                                property_container(
##                                 property(property_name="Name of the element",
##                                   type         ="string", 
##                                   value="None" ,             
##                                   argument_key="None",
## 				  help="Name of the element",
##                                   default="None"
##                                 ),
##                                 self 
##                                )
##                              )

##     self.properties_list_fixed.append(
##                                property_container(
##                                 property(property_name="Density",
##                                   type         =["numeric_f","Variable"], 
##                                   value="None" ,             
##                                   argument_key="None",
## 				  help="Density",
##                                   default="None"
##                                 ),
##                                 self 
##                                )
##                              )




    self.variable_is_active=1
    self.properties_list=[]	
    self.option=0
    self.option_dic={}
    for i in range(10):
       self.option_dic[i]= "%s elements"%i
    self.constructor="IndexFromTable"






class BEAN_PPM_SimpleLayer(      instruction_base):
  help="object  of the class of type PPM_SimpleLayer "
  type="PPM_SimpleLayer"
  supertype="Layers"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.generatedtype="Layer"
   
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Thickness",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="thickness",
				  help="Thickenss in Angstroems ",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Roughness",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="roughness",
				  help="Roughness in Angstroems ",
                                  default="None"
                                ),
                                self 
                               )
                             )
    
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Material",
                                  type         ="IndexFromTable", 
                                  value="None" ,             
                                  argument_key="material",
				  help="Optical Material",
                                  default="None"
                                ),
                                self 
                               )
                             )

    
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="PPM_SimpleLayer"





class BEAN_SumThings(   ListLike_instruction):
  help="Sum layers and stacks"
  type="SumThings"
  supertype="Layers"
  

  def __init__(self):
    beans.ListLike_instruction.__init__(self)
    self.associated_variable="None"

    self.generatedtype="Layers"


    self.groupedproperties=[
      ["Layer or Stack",["Layer","Layers"], [], "Layer or stack to sum" ],
      ]

    self.variable_is_active=1
    self.properties_list=[]	
    self.option=0
    self.option_dic={}
    for i in range(10):
       self.option_dic[i]= "%s things"%i
    self.constructor="SumThings"












class BEAN_MultiplyAThing(      instruction_base):
  help="To repeat a stack "
  type="MultiplyAThing"
  supertype="Layers"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.generatedtype = "Layer"
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.generatedtype="Layers"
   
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="N. of repeats",
                                  type         ="numeric_i", 
                                  value="None" ,             
                                  argument_key="None",
				  help="N. of repeats",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Stack to repeat",
                                  type         =["Layer","Layers"], 
                                  value="None" ,             
                                  argument_key="None",
				  help="Stack to repeat",
                                  default="None"
                                ),
                                self 
                               )
                             )
    

    
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="MultiplyAThing"


class BEAN_PPM_ComparisonTheoryExperiment(      instruction_base):
  help="Create an object specifing a stack  ad a list of scan to fit"
  type="Comparison"
  supertype="Fits"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.generatedtype="Fit"
   
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Stack model",
                                  type         ="Layers", 
                                  value="None" ,             
                                  argument_key="None",
				  help="Stack model",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="List of scans",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="None",
				  help="List of scans",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="List of weights",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="None",
				  help="List of weight",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="List of norms",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="normlist",
				  help="List of norms",
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="List of noises",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="noise",
				  help="List of noises",
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="width",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="width",
				  help="width for the convolution",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="print partial",
                                  type         ="List",
                                  additionaloptions=("0","1"),
                                  value="None" ,             
                                  argument_key="printpartial",
				  help="if you want to save partial resulta to files choose 1",
                                  default="None"
                                ),
                                self 
                               )
                             )



    
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="PPM_ComparisonTheoryExperiment"
    














class BEAN_Minimise(      instruction_base):
  help="Optimise a comparision model/experiment"
  type="Minimiser"
  supertype="Fits"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.generatedtype="None"
   
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Fit",
                                  type         ="Comparison", 
                                  value="None" ,             
                                  argument_key="fit",
				  help="Fit to optimise",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="variables",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="list_of_variables",
				  help="List of variables that can be optimized",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="tolerance",
                                  type         ="Numeric_f", 
                                  value="None" ,             
                                  argument_key="tol",
				  help="Tolerance specifies when to stop the fit",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Temp function",
                                  type         ="string", 
                                  value="\".05*exp(-0.2*x)\"" ,             
                                  argument_key="temperature",
				  help="The function of temperature versus number of evaluation",
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="max_refusedcount",
                                  type         ="Numeric_i", 
                                  value="100" ,             
                                  argument_key="max_refusedcount",
				  help="max_refusedcount",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="max_isthesame",
                                  type         ="Numeric_i", 
                                  value="10" ,             
                                  argument_key="max_isthesame",
				  help="max_isthesame",
                                  default="None"
                                ),
                                self 
                               )
                             )





    
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="Minimise"

beans.register_instruction(BEAN_AtomicProperties)
beans.register_instruction(BEAN_Duplicator)
beans.register_instruction(BEAN_Minimise)

beans.register_instruction(BEAN_PPM_ComparisonTheoryExperiment)

beans.register_instruction(BEAN_MultiplyAThing)


beans.register_instruction(BEAN_SumThings)


beans.register_instruction(BEAN_PPM_SimpleLayer)

beans.register_instruction(BEAN_IndexFromTable)

beans.register_instruction(beans.List_instruction)

beans.register_instruction( BEAN_Dabax_f0_Table )
beans.register_instruction( BEAN_Dabax_f1f2_Table )
beans.register_instruction( BEAN_Variable )
beans.register_instruction( BEAN_DependentVariable )
beans.register_instruction( BEAN_ScanReader )
beans.register_instruction( Insertion_instruction )
beans.headers =(
"import  NumericA\n"
"from Numeric import *\n"
"from  PPM import *\n"
"from Dabax import *\n"
"from Minimiser import *\n"
"import string\n"
"List=list"
)

if __name__=="__main__":
  print "###############LANCIO LANCIO LANCUI "
  beansgui.lanciagui( beans , sys.argv)
