import sys

import NumericA
import Numeric

import beans
import beansgui
import sys
from beans import *


class BEAN_ScanReader(      instruction_base):
  help="object  of the class of type instruction ScanReader"
  type="ScanReader"
  supertype="Readers"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="filename",
                                  type         ="string", 
                                  value="None" ,             
                                  argument_key="None",
				  help="Name of the file to read. Dont forget the \" \" around the filename. Set it to None if you dont use an experimental file ( see instruction for ranges in the angle, energy and wavelenght entries) ",
                                  default="pippo"
                                ),
                                self 
                               )
                             )
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Npoints",
                                  type         ="notipe", 
                                  additionaloptions=["\"first line\"", "\"automatic\""],
                                  value="None" ,             
                                  argument_key="Np",
				  help="Number of points in the scan to read. Either input an integer, or ""first line"" or ""automatic""  ",
                                  default="None"
                                ),
                                self 
                               )
                             )
    for name_col in ["energy_col","wavelenghts_col","angles_col","refle_col","weight_col"]:
      extracomment=""
      if(name_col in ["energy_col","wavelenghts_col", "angles_col"] ):
        extracomment={"energy_col":"leave it empty if you use wavelenghts. You can also specify a range",
		      "wavelenghts_col":"leave it empty if you use energy. You can also specify a range",
                      "angles_col":".You could also specify a range [min,max, step], in this case the angles are not read but an array is created according to the specified range. If you specify the TwoTheta angle, the value input in this filed is take as the energy corresponding to the twotheta value in a Qper constant scan.  "  }[name_col]
      self.properties_list_fixed.append(
                               property_container(
                                property(property_name=name_col,
                                  type         =("numeric_f","numeric_i"), 
                                  value="None" ,             
                                  argument_key=name_col,
				  help="An integer to tell the columns number (1,2,3..), or a float to tell a fixed value.%s"%extracomment,
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="angle_factor",
                                  type         ="numeric_f", 
                                  value="1.0" ,             
                                  argument_key="angle_factor",
				  help="The angle column migth need to be rescaled. Input here the factor to convert it in radians from the surface",
                                  default="1.0"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="TwoTheta",
                                  type         ="numeric_f", 
                                  value="None" ,             
                                  argument_key="TwoTheta",
				  help="By Specifying a number in this entry, the angles array is set so that Qperp is contant.",
                                  default="None"
                                ),
                                self 
                               )
                             )






    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="ScanReader"



class BEAN_Dabax_f0_Table(      instruction_base):
  help="object  of the class of type  Dabax_f0_Table"
  type="Dabax_f0_Table"
  supertype="Optical Tables"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="filename",
                                  type         ="string", 
                                  additionaloptions=("\"f0_WaasKirf.dat\"",),
                                  value="\"f0_WaasKirf.dat\"" ,             
                                  argument_key="None",
				  help="Name of the file to read.  ",
                                  default="pippo"
                                ),
                                self 
                               )
                             )
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="Dabax_f0_Table"









class BEAN_Dabax_f1f2_Table(      instruction_base):
  help="object  of the class of type  Dabax_f1f2_Table"
  type="Dabax_f1f2_Table"
  supertype="Optical Tables"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="filename",
                                  type         ="string", 
                                  additionaloptions=("\"f1f2_Henke.dat\"","\"f1f2_Sasaki.dat\"","\"f1f2_Windt.dat\"",),
                                  value="\"f1f2_Henke.dat\"" ,             
                                  argument_key="None",
				  help="Name of the file to read.  ",
                                  default="pippo"
                                ),
                                self 
                               )
                             )
    
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="Dabax_f1f2_Table"


class BEAN_ScattererFromTable(   instruction_base  ):
  help="Create a Scattere from tables"
  type="ScattererFromTable"
  supertype="Optical Tables"


  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Table F0",
                                  type         ="Dabax_f0_Table", 
                                  value="None" ,             
                                  argument_key="None",
				  help="Table to use for f0 ",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Table F1F2",
                                  type         ="Dabax_f1f2_Table", 
                                  value="None" ,             
                                  argument_key="None",
				  help="Table to use for f12 ",
                                  default="None"
                                ),
                                self 
                               )
                             )
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Name of the element" ,
                                  type         ="string", 
                                  value="None" ,             
                                  argument_key="None",
				  help="Name of the element" ,
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Sigma de DW" ,
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="DWsigma",	
				  help="Sigma de DW en Angstroems" ,
                                  default="None"	
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Convention" ,
                                  type         ="string", 
				  additionaloptions=("\"-iKx\"","\"+iKx\""),
                                  value="\"-iKx\"" ,             
                                  argument_key="convention",	
				  help="Convention +iKx is the usual one, but in PyFullerton it is -iKx" ,
                                  default="None"	
                                ),
                                self 
                               )
                             )


    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="ScattererFromTable"




# Or_Plane  = Fuller_ElementalPlane(Element=Or,  InPlaneDensity=1*0.139)

class BEAN_Fuller_ElementalPlane(      instruction_base):
  help="Elemental Plane"
  type="ElementalPlane"
  supertype="Planes"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Element",
                                  type         ="ScattererFromTable", 
                                  value="None" ,             
                                  argument_key="Element",
				  help="Scaterer entering the plane",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="InPlaneDensity",
                                  type         =["numeric_f","Variable"], 
                                  value="1." ,             
                                  argument_key="InPlaneDensity",
				  help="InPlaneDensity",
                                  default="1.0"
                                ),
                                self 
                               )
                             )

    self.properties_list={}
    self.properties_list[1]=[]	
    self.option=1
    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="Fuller_ElementalPlane"



#Or_Layer  = Fuller_LayerM_I(Plane=Or_Plane, PlaneD = Or_PlaneD ,  Nplanes= Or_Nplanes , SigmaNplanes=Or_SigmaNplanes,
#                              PlaneDD1=0, PlaneDD2= 0, PlaneDDAlpha=0.5)
    




class BEAN_Fuller_LayerM_I(      instruction_base):
  help="Fuller_LayerM_I"
  type="Fuller_LayerM_I"
  supertype="Planes"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"Superlattice",2:"Amorphous"}

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Plane",
                                  type         ="ElementalPlane", 
                                  value="None" ,             
                                  argument_key="Plane",
				  help="Plane",
                                  default="None"
                                ),
                                self 
                               )
                             )


    lattice_op=[]    

    lattice_op.append(	  property_container(
                        	  property(property_name="PlaneD",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="PlaneD",
				  help="Planes interspacing in Angstroem",
                                  default="None"
                                ),
                                self 
                               )
                             )
    
    lattice_op.append(	  property_container(
                        	  property(property_name="Nplanes",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="Nplanes",
				  help="Averaged number of planes",
                                  default="None"
                                ),
                                self 
                               )
                             )
    
    lattice_op.append(	  property_container(
                        	  property(property_name="SigmaNplanes",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="SigmaNplanes",
				  help="Sigma of the  number of planes",
                                  default="None"
                                ),
                                self 
                               )
                             )


    lattice_op.append(	  property_container(
                        	  property(property_name="PlaneDD2",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="PlaneDD2",
				  help="Difference betwen the upper interspacing and the nominale one PlaneD",
                                  default="None"
                                ),
                                self 
                               )
                             )

    lattice_op.append(	  property_container(
                        	  property(property_name="PlaneDD1",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="PlaneDD1",
				  help="Difference betwen the lower interspacing and the nominal one PlaneD",
                                  default="None"
                                ),
                                self 
                               )
                             )


    lattice_op.append(	  property_container(
                        	  property(property_name="PlaneDDAlpha",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="PlaneDDAlpha",
				  help="Decay constant of the stress going from interface to the layer interior",
                                  default="None"
                                ),
                                self 
                               )
                             )

    amor_op = []

    amor_op.append(	  property_container(
                        	  property(property_name="Thickness",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="Thickness",
				  help="thickness of the whole amorphous layer. Angstroems",
                                  default="None"
                                ),
                                self 
                               )
                             )


    amor_op.append(	  property_container(
                        	  property(property_name="SigmaThickness",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="SigmaThickness",
				  help="The sigma of the thickness of the whole amorphous layer. ",
                                  default="None"
                                ),
                                self 
                               )
                             )

    amor_op.append(	  property_container(
                        	  property(property_name="Density",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="Density",
				  help="The density of the material composing the layer. Arbitraty units. This factor plays the same role as inplanedensity of the planes",
                                  default="None"
                                ),
                                self 
                               )
                             )


    


    self.properties_list={}
    self.properties_list[1]=lattice_op
    self.properties_list[2]=amor_op	
    self.option=1
    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="Fuller_LayerM_I"
    self.constructor[2]="Fuller_LayerM_I"





class BEAN_Free_Strain_Diffusion(      instruction_base):
  help=( "Contains For array of numbers/parameters. Two for the spacing deformation (Top and Bottom).\n"
	       " Two for interdiffusion (Top and Bottom).\n"
	       " The deformation are given as modifications to the lattice spacings, in Angstroems, and starting\n"
               " from the interfaces. Same thing for the interdiffusion\n"
              )
 
  type="Free_Strain_Diffusion"
  supertype="Planes"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"No options"}

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="TopSpacingsD",   type="List"     , value="None" , 
                                argument_key="TopSpacingsD",help= "Starting from the top, an arbitrary number of lattice spacing deformations",  default="None"
                                ),  self 
                               )
                             )
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="BottomSpacingsD",   type="List"     , value="None" , 
                                argument_key="BottomSpacingsD",help="Starting from the bottom, an arbitrary number of lattice spacing deformations",  default="None"
                                ),  self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="TopInterdiffusion",   type="List"     , value="None" , 
                                argument_key="TopInterdiffusion",help="Starting from the top, an arbitrary number of interdiffusion coefficients",  default="None"
                                ),  self 
                               )
                             )
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="BottomInterdiffusion",   type="List"     , value="None" , 
                                argument_key="BottomInterdiffusion",help= "Starting from the bottom, an arbitrary number of interdiffusion coefficients",  default="None"
                                ),  self 
                               )
                             )


    self.properties_list={}
    self.properties_list[1]=[]
    self.option=1
    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="Free_Strain_Diffusion"





class BEAN_Fuller_Interface(      instruction_base):
  help="Fuller_Interface"
  type="Fuller_Interface"
  supertype="Planes"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"Exponential Diffusion",2:"Stearn Diffusion",3:"Free diffusion+strain"}


    self.properties_list_fixed.append(
                               property_container(
         property(property_name="Separation",type=["numeric_f","Variable"],value="None" ,             
                  argument_key="Separation", help="Separation between two layers, Angstroems",default="None"
                                ),self  ) )


    self.properties_list_fixed.append(
                               property_container(
         property(property_name="SigmaSeparation",type=["numeric_f","Variable"],value="None" ,             
                  argument_key="SigmaSeparation", help="Sigma of the Separation between two layers, Angstroems",
		  default="None"),self  ) )


    exp_diff_op= []
    
    exp_diff_op.append(           property_container(
         property(property_name="Interdiffusion",type=["numeric_f","Variable"],value="None" ,             
                  argument_key="Interdiffusion", help="Interdiffusion of the outermost layer",
		  default="None"),self  ) )

    
    exp_diff_op.append(           property_container(
         property(property_name="InterdiffusionExponent",type=["numeric_f","Variable"],value="None" ,             
                  argument_key="InterdiffusionExponent", help="Interdiffusion Exponent",
		  default="None"),self  ) )


    stearn_op = []
    
    stearn_op.append(         property_container(
      property(property_name="StearnsWidth",type=["numeric_f","Variable"],value="None" ,             
               argument_key="StearnsWidth", help="StearnsWidth. Total number of layers on one side and the other.",
               default="None"),self  )  ) 
    
    ev_free_op = []
    
    ev_free_op.append( property_container(
      property(property_name="I_Planes",type=["Free_Strain_Diffusion"],value="None" ,             
               argument_key="I_Planes", help="I_Planes. An object of type Free_Strain_Diffusion",
               default="None"),self  )  ) 	
    
    
    
    
    self.properties_list={}
    self.properties_list[1]= exp_diff_op
    self.properties_list[2]= stearn_op
    self.properties_list[3]= ev_free_op
    self.option=1
    self.variable_is_active=1
    self.constructor={}
    self.constructor[3]=self.constructor[2]=self.constructor[1]="Fuller_Interface"
    
    

class BEAN_SumThings(   ListLike_instruction):
  help="Sum layers and stacks"
  type="SumThings"
  supertype="Planes"
  
  def __init__(self):
    beans.ListLike_instruction.__init__(self)
    self.associated_variable="None"
    
    self.generatedtype="Period"
    
    
    self.groupedproperties=[ ["Layer or Stack",["Fuller_LayerM_XXI" ,"Fuller_LayerM_I" ,"Fuller_Interface"] , [], "Layer or stack to sum" ],
    ]
    
    self.variable_is_active=1
    self.properties_list=[]	
    self.option=0
    self.option_dic={}
    for i in range(10):
      self.option_dic[i]= "%s things"%i
      self.constructor="SumThings"






class BEAN_Fuller_ComparisonTheoryExperiment(      instruction_base):
  help="Create an object specifing a stack, a list of scan to fit,plus some parameters for the Fullerton calculation."
  type="Comparison"
  supertype="Fits"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.generatedtype="Fit"
   
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Stack model",
                                  type         ="Period", 
                                  value="None" ,             
                                  argument_key="None",
				  help="Stack model",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="List of scans",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="None",
				  help="List of scans",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="List of weights",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="None",
				  help="List of weight",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="List of norms",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="normlist",
				  help="List of norms",
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="List of noises",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="noise",
				  help="List of noises",
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="M",
                                  type         ="numeric_i", 
                                  value="None" ,             
                                  argument_key="M",
				  help="Number of repetions ",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="L",
                                  type         ="numeric_i", 
                                  value="None" ,             
                                  argument_key="L",
				  help="Number of averaged lateral zones ",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Ds",
                                  type         =[ "numeric_f","Variable"], 
                                  value="0" ,             
                                  argument_key="Ds",
				  help="Spacing of the substrate Planes",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="SubPlane",
                                  type         ="ElementalPlane", 
                                  value="None" ,             
                                  argument_key="SubPlane",
				  help="Substrate Plane",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="sigmatheta",
                                  type         =[ "numeric_f","Variable"], 
                                  value="0" ,             
                                  argument_key="sigmatheta",
				  help="Sigma Theta",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="pol",
                                  type         = "string" , 
				  additionaloptions=("\"Nothing\"","\"S\"","\"P\"","\"M\"",) ,
                                  value="Nothing" ,             
                                  argument_key="pol",
				  help="Polarisation",
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="CRough",
                                  type         =["numeric_f","Variable"], 
                                  value="0" ,             
                                  argument_key="CRough",
				  help="CRough",
                                  default="None"
                                ),
                                self 
                               )
                             )


    
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="Fuller_ComparisonTheoryExperiment"






class BEAN_Minimise(      instruction_base):
  help="Optimise a comparision model/experiment"
  type="Minimiser"
  supertype="Fits"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.generatedtype="None"
   
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Fit",
                                  type         ="Comparison", 
                                  value="None" ,             
                                  argument_key="fit",
				  help="Fit to optimise",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="variables",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="list_of_variables",
				  help="List of variables that can be optimized",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="tolerance",
                                  type         ="Numeric_f", 
                                  value="None" ,             
                                  argument_key="tol",
				  help="Tolerance specifies when to stop the fit",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Temp function",
                                  type         ="string", 
                                  value="\".05*exp(-0.2*x)\"" ,             
                                  argument_key="temperature",
				  help="The function of temperature versus number of evaluation",
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="max_refusedcount",
                                  type         ="Numeric_i", 
                                  value="100" ,             
                                  argument_key="max_refusedcount",
				  help="max_refusedcount",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="max_isthesame",
                                  type         ="Numeric_i", 
                                  value="10" ,             
                                  argument_key="max_isthesame",
				  help="max_isthesame",
                                  default="None"
                                ),
                                self 
                               )
                             )





    
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="Minimise"
    



class BEAN_Fuller_PerovskitePlane(      instruction_base):
  help="PerovskitePlane Plane"
  type="PerovskitePlane"
  supertype="Planes"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Oxygen",
                                  type         ="ScattererFromTable", 
                                  value="None" ,             
                                  argument_key="Oxygen",
				  help="Scaterrer at the oxygen position",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="External",
                                  type         ="ScattererFromTable", 
                                  value="None" ,             
                                  argument_key="External",
				  help="Scatterer at the corners positions",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Internal",
                                  type         ="ScattererFromTable", 
                                  value="None" ,             
                                  argument_key="Internal",
				  help="Scatterer in the internal  position",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Spacing",
                                  type         =["numeric_f","Variable"], 
                                  value="1." ,             
                                  argument_key="Spacing",
				  help="Spacing of the whole cell",
                                  default="4.0"
                                ),
                                self 
                               )
                             )


    self.properties_list={}
    self.properties_list[1]=[]	
    self.option=1
    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="Fuller_PerovskitePlane"

class BEAN_Fuller_LayerM_XXI(      instruction_base):
  help="Fuller_LayerM_XXI"
  type="Fuller_LayerM_XXI"
  supertype="Planes"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Plane",
                                  type         =["PerovskitePlane"], 
                                  value="None" ,             
                                  argument_key="Plane",
				  help="Plane",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(	  property_container(
                        	  property(property_name="Nplanes",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="Nplanes",
				  help="Averaged number of planes",
                                  default="None"
                                ),
                                self 
                               )
                             )
    
    self.properties_list_fixed.append(	  property_container(
                        	  property(property_name="SigmaNplanes",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="SigmaNplanes",
				  help="Sigma of the  number of planes",
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.properties_list={}
    self.properties_list[1]=[]
    self.option=1
    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="Fuller_LayerM_XXI"


beans.register_instruction(BEAN_Fuller_PerovskitePlane)
beans.register_instruction(BEAN_Fuller_LayerM_XXI)
beans.register_instruction(BEAN_Minimise)


beans.register_instruction(BEAN_Duplicator)


beans.register_instruction(BEAN_SumThings)

beans.register_instruction(BEAN_Fuller_ComparisonTheoryExperiment)

beans.register_instruction(BEAN_Free_Strain_Diffusion)
beans.register_instruction(BEAN_Fuller_Interface)
beans.register_instruction(BEAN_ScattererFromTable)

beans.register_instruction(beans.List_instruction)

beans.register_instruction( BEAN_Dabax_f0_Table )
beans.register_instruction( BEAN_Dabax_f1f2_Table )
beans.register_instruction( BEAN_Variable )
beans.register_instruction( BEAN_DependentVariable )
beans.register_instruction( BEAN_ScanReader )
beans.register_instruction( BEAN_Fuller_ElementalPlane )
beans.register_instruction( BEAN_Fuller_LayerM_I )



beans.headers =(
"import  NumericA\n"
"from Numeric import *\n"
"from  PyFullerton import *\n"
"from Dabax import *\n"
"from Minimiser import *\n"
"import string\n"
"List=list"
)



if __name__=="__main__":
  print "###############LANCIO LANCIO LANCUI "
  beansgui.lanciagui( beans , sys.argv)










