############################################################
# Alessandro Mirone
# April 2001
# ESRF

import NumericA
from Numeric import *
import random
import os
import glob
import re



def update( var, x):
     var.value=(   (1-tanh(x))*var.min+(1+tanh(x))*var.max)/2.0

def getx( var):
     x=( 2*var.value -var.min - var.max)/(var.max-var.min)
     print "x ", x
     if (x==1): return 40
     if(x==-1): return -40
     x=0.5*log(   (1+x) /(1-x)  )
     return x

def generateverticesNormal(X,dx):
     pointlist=[array(X)]
     for i in range(0,len(X)):
        nX=array(X)

        nX[i]=nX[i]+dx
        pointlist.append(nX)
     return array(pointlist) 

def generateverticesRandomNormal(X,dx, centershiftFact=0):
     pointlist=[array(X)]
     centershift=centershiftFact*dx*array([ (-0.5+random.random()) for i in range(0, len(X)) ]     )
     
     for   i in range(0,len(X)):
         pointlist[0][i]+=dx[i]*(-0.5+random.random())+centershift[i]
     for i in range(0,len(X)):
        nX=array(X)

        nX[i]=nX[i]+dx[i]*(-0.5+random.random())+centershift[i]
        pointlist.append(nX)
     return array(pointlist) 


class minimiser:
  extrapotfactor=10.0
  stoppa=[0,0]      #  emergency stop, delayed stop
  history=[]
  def __init__(self, EcartObject, VariableList):
    self.EcartObject=EcartObject
    self.VariableList=VariableList
    minimiser.history=[]

  def calculateerror(self, x):
     for i in range (0, len(self.VariableList)):
         update( self.VariableList[i], x[i])
     extrapot=0.0
     limit=3.0
     for i in range (0, len(self.VariableList)):
        print x[i]
        if(abs(x[i])>limit):
           extrapot=extrapot+(exp(abs(x[i]))-exp(limit))
     # print " EXTRAPOT__ " , extrapot*self.extrapotfactor
     error = self.EcartObject.error()
     # print " error ", error

     return error +extrapot*self.extrapotfactor

  
    
  def amoeba(self, ftol, arret=None):
    X=[]
    for var in self.VariableList:
      X.append(getx(var) )
    x=array(X)
    p=generateverticesNormal(X, 0.1)
    y=map(self.calculateerror,p)
    return self.amoebaspecial(ftol,p,y, arret=arret)


  
    
  def amoebaAnnealed(self, ftol, temperature_fn, max_refusedcount=100,
                     centershiftFact=0.0,
                     arret=None,
                     max_isthesame=10,
                     expandby_if_isthesame=3.0,
                     shrinkby_if_accepted =0.7,
                     triggerby_if_accepted=1,
                     proportionality_whenlower=2.5,
                     maxium_ratio_max_min_whenlower=33.33,
                     
                     ):
    count=0

    minimiser.history=[]
    history=self.history
    ###############################################
    # If EcartObject has the method setitercounter
    # then set it
    if(hasattr(self.EcartObject, 'setitercounter' ) ):
        self.EcartObject.setitercounter(0)

    ###############################################
    #  initialization of x variable.
    #  x maps [-inf,+inf] to the limited interval
    #  that has been assigne to the given variable
    #  X contains the x for every variable.
    #
    self.history.append(map(par,self.VariableList))
    X=[]
    for var in self.VariableList:
      X.append(getx(var) )
    p=generateverticesNormal(X, 0.1)
    y=map(self.calculateerror,p)
    self.history[-1].extend([" ERROR ", y[0] ])
    fperformance=open("performances","a")
    fperformance.write("At ITERATION %d, ERROR %e \n" % (0, y[0] ))
    fperformance.close()
    res=self.amoebaspecial(ftol,p,y, arret=arret)



    X=res[0]
    Y=res[1]   
    Yold=Y

    Xmin=X
    Ymin=res[1]
    lower=1
    
    Dpar=ones(len(X))*0.1    
    refusedcount=0
    isthesamecount=0

    while(refusedcount<max_refusedcount  and  isthesamecount<max_isthesame
                  and self.stoppa[0]==0  and self.stoppa[1]==0
          ) :
       count=count+1
       if(lower ):
         if( count > 1):
            Dpar=proportionality_whenlower*abs(res[0]-Xold)
            Dpar=Dpar+max(Dpar)/maxium_ratio_max_min_whenlower
       else:
          if(isthesame):
             Dpar*=expandby_if_isthesame
          else:
             mask=less(Dpar,triggerby_if_accepted)
             Dpar=Dpar*mask+(1-mask)*triggerby_if_accepted
             Dpar*=shrinkby_if_accepted
       Xold=X*1.0
       mask=less(Dpar,10.0)
       Dpar=Dpar*mask+(1-mask)*10

       print " X " , X
       print " Xold " , Xold


       p=generateverticesRandomNormal(X, Dpar, centershiftFact)
       print p
       y=map(self.calculateerror,p)



       res=self.amoebaspecial(ftol,p,y, arret=arret)
    
       self.history.append(map(par,self.VariableList))
       self.history[-1].extend([" ERROR ", res[1] ])


       ###############################################
       # If EcartObject has the method getitercounter
       # then use it getitercounter
       if(hasattr(self.EcartObject,'getitercounter') ):
         fperformance=open("performances","a")
         fperformance.write("At ITERATION %d, ERROR %e \n" % (self.EcartObject.getitercounter(), res[1] ))
         fperformance.close()

       print "********************************************"
       print " newY = ", res[1]
       print "    Y = ", Y

       print " Ymin= ", Ymin
       if(abs(res[1]-Y)/abs(res[1]+Y)<4*ftol):
         isthesame=1
         isthesamecount=isthesamecount+1
         accepted=0
         lower=0
         X=res[0]*1
         Y=res[1]
       else:
         isthesame=0
         if(res[1]<Y):
            Y=res[1]
            lower=1
            accepted=1
            isthesamecount=0
            if(Y<Ymin):
               Ymin=Y
               Xmin=res[0]*1
         else:
            lower=0
            espo=(res[1]-Y)/temperature_fn(count)
            if(espo>30):
              accepted = 0
            prob=exp(-espo)
            if(random.random()<prob):
              isthesamecount=0
              accepted=1
            else:
              accepted=0
         if(accepted):
            X=res[0]*1
            Y=res[1]
            refusedcount=0
         else:
            refusedcount+=1
       print " accepted = ", accepted
       print " refusedcount = ", refusedcount
       print " TEMP = ",  temperature_fn(count)
       print " count = " , count
       print " isthesame ", isthesame
       print " isthesamecount ", isthesamecount
       print " lower = ", lower
       print "Dpar = ", Dpar
       if(arret != None and Ymin<arret):
          print " mi fermo " , Ymin, " " , Y
          break
    for i in range (0, len(self.VariableList)):
     update( self.VariableList[i], Xmin[i])
         





  #########################################################3
  # run an amoeba minimisation taking as initial simplex p
  # with initial values given by y.
  # It stops when either 
  # 2*abs(y[ihighest]-y[ilowest])/(abs(y[ihighest])+abs(y[ilowest]))<ftol
  #
  # or  y[ilowest]< arret if arret!=None
  #
  def amoebaspecial(self, ftol,p,y, arret=None):
    ndim = len(y)-1   

    iter=0
    maxiter=10000
    while(1):
      ilowest=ihighest=isecondhighest=0
      for i in range(0, len(p)):
         if( y[i]>y[ihighest]):
                isecondhighest=ihighest
                ihighest=i
         elif(y[i]>y[isecondhighest]):
                isecondhighest=i
         if( y[i]<y[ilowest] ):
                ilowest=i
      center= (sum(p)-p[ihighest])/ndim

      rtol=2*abs(y[ihighest]-y[ilowest])/(abs(y[ihighest])+abs(y[ilowest]))
      if(rtol<ftol): break
      print dir()
      if (  self.stoppa[0] ): break

      
      if(arret!=None and arret>y[ilowest]): break
      iter=iter+1
      if(iter>maxiter):
         return (p[ilowest]*1.0,y[ilowest])

      ptry= 2*center- p[ihighest]
      ytry=self.calculateerror(ptry)

      if(ytry< y[ilowest]):
          ptry2= 2*ptry-center 
          ytry2= self.calculateerror(ptry2)
          if(ytry2 < y[ilowest] ):
              p[ihighest]=ptry2
              y[ihighest]=ytry2
          else:
              p[ihighest]=ptry
              y[ihighest]=ytry
      elif( ytry>=y[isecondhighest]):
          if(ytry<y[ihighest]):
             p[ihighest]=ptry
             y[ihighest]=ytry
          ptry=0.5*p[ihighest]+0.5*center
          ytry=self.calculateerror(ptry)
          if(ytry<y[ihighest]):
             y[ihighest]=ytry
             p[ihighest]=ptry
          else:
            for i in range(0,ndim+1):
               p[i]=0.5*(p[i]+p[ilowest])
      else:
          p[ihighest]=ptry
          y[ihighest]=ytry
    return (p[ilowest]*1.0,y[ilowest])






class Variable:
     def getvalue(self):
        return self.value

     def __init__(self, value,min,max):
        self.value=value*1.0
        self.max=max*1.0
        self.min=min*1.0
        self.getvalue=self.getvalue

     def setrandom(self):
         self.value=self.min+(self.max-self.min)*random.random()


     def __repr__(self):
         res="Variable(%e,%e,%e)"%(self.value, self.min,self.max)
         return res

 



class DependentVariable:
     def getvalue(self):
        command="res="+self.formula
        exec(command)
        return res

     def __init__(self,stringa , dictio={}):

        for key in dictio.keys():
            res=re.search("par *\( *%s *\)"%key, stringa  )
            if(res is not None):
                stringa=stringa[0:res.start()]+"par(self.%s)"%key + stringa[res.end():]
                setattr(self,key,dictio[key])
        self.getvalue=self.getvalue
        self.formula=stringa

     def __repr__(self):
         res="DependentVariable ->getvalue() = %e"% self.getvalue()
         return res


def par(a):
    if( hasattr(a,'getvalue' )):
          return a.getvalue()
    else:
          return a      


def par(a):
    if( hasattr(a,'getvalue' )):
          return a.getvalue()
    else:
          return a      



if __name__=='__main__':




  class scarto:
    def __init__(self, a,b,c):
       self.a=a
       self.b=b
       self.c=c
    def error(self):
      print par(self.a)
      print dir(self.a)
      res= 1+par(self.a)*par(self.a)+par(self.b)*par(self.b)+par(self.c)*par(self.c)
      # print "error=", res
      return res


  a=Variable(2.,5.,-6.)
  b=Variable(7.,9.,-10.)
  c=Variable(7.,10.,-11.)

  ecob=scarto(a,b,c)

  miniob=minimiser(ecob,[a,b,c])

  (p,y)=miniob.amoeba(0.000000001)  

  print p
  print y



  class scartoF2:
    def __init__(self, a,b):
       self.a=a
       self.b=b
    def error(self):
      x1=par(self.a)
      x2=par(self.b)
      a=x2-x1*x1
      res= 100*a*a + (1-x1)*(1-x1)
      print "error=", res, " itc= ", self.itc
      self.itc=self.itc+1
      return res
    def setitercounter(self, n):
      self.itc=n
    def getitercounter(self):
      return self.itc


  for ini in [ (1001,1001), (1001,-999),  (-999,-999),    (-999,1001),
                 (1443,1), (1,1443),(1.2,1)]   :

    a=Variable(ini[0],-2000.048,2000.048)
    b=Variable(ini[1],-2000.048,2000.048)

    tominimise=scartoF2(a,b)

    miniob=minimiser(tominimise,[a,b])

    os.system("rm performances")
    
    miniob.amoebaAnnealed( 0.001, lambda x: 1000.0/(1.0+x*0.3), 100,
    arret=1.0e-12) 
    
    s=open("performances","r").read()
    x1=par(a)
    x2=par(b)
    dist=(x1-1)*(x1-1)+(x2-1)*(x2-1)
    dist=sqrt(dist)

    open("resocontoRosF2d","a").write( "##### ini=(%f %f)\n%s// finale= %e   x1= %e x2=%e dist=%e\n" %
      ( ini[0],ini[1], s, tominimise.error(), x1,x2,dist) )








