############################################
#  Alessandro MIRONE
#  2001
#  ESRF
import string 
import Numeric 
import arrayfns             
import sys 
import copy
import specfile
import math
import os
import math

LAMBDAEV=12398.52
AVOGADRO=6.0221367e23


if(os.getenv("DABAX_DIR")!=None):
  dabaxpath=os.getenv("DABAX_DIR")
else:
#  dabaxpath=__TOBECHANGED_WITH_PATH__
#  dabaxpath="/usr/local/DABAX"
  dabaxpath="/sware/exp/xop-2.0/data/dabax"

######################################################################
#  
#  class to manipulate f0/f12 objects

class Dabax_Scatterer:
# DWsigma, Debye Waller is the sigma of the atom vibration

   is_a_tensor = 0

   def __init__(self, f0list=None,f0weights=None, f1f2list=None,f1f2weights=None,
                convention="+iKx" , DWsigma=None ):
      self.DWsigma=DWsigma
      if(f0list!=None):
          self.f0list      = f0list
      else:
          self.f0list      = []

      if(f1f2list is not None):
          self.f1f2list    = f1f2list
      else:
          self.f1f2list      = []

      if(f0weights is not None):
          self.f0weights   = f0weights
      else:
           self.f0weights     = []


      if(f1f2weights is not None):
          self.f1f2weights = f1f2weights
      else:
          self.f1f2weights      = []

      self.classe="Scatterer"
      self.convention= convention

      self.recorder = {}

   def __repr__(self):

     for key in dir(self):
       if(key not in ['self', ]): print "            ",  key, "=", getattr(self,key)
     return ''

   def __add__(self, other):
      if("classe" not in dir(self) or self.classe!= "Scatterer"):
         print " summing wrong class to Scatterer"
         sys.exit(1)
      
      newf0list= self.f0list +other.f0list
      newf0weights= Numeric.array(list(self.f0weights)+list(other.f0weights))

      newf1f2list= self.f1f2list+other.f1f2list
      newf1f2weights= Numeric.array(list(self.f1f2weights) +list(other.f1f2weights))

      self.recorder = {}

      return Dabax_Scatterer(newf0list,newf0weights,newf1f2list,newf1f2weights)


   def __rmul__(self, fact):

      self.recorder = {}

      return self.__mul__(fact)

   def __mul__(self, fact):
      newf0list  = (self.f0list)
      newf1f2list= (self.f1f2list)

      newf0weights   = fact*self.f0weights
      newf1f2weights = fact*self.f1f2weights

      self.recorder = {}
  
      return Dabax_Scatterer(newf0list,newf0weights,newf1f2list,newf1f2weights)

      
   def F_Lambda(self,  Lambda, theta=None ): 
      return self.  F_Energy(  LAMBDAEV/Lambda, theta )


   def F_Energy(self,  En, theta=None ):   


      if( isinstance(En,Numeric.ArrayType)  ):
        if(theta is None):
           theta=Numeric.ones( len(En)     )*0*math.pi/180.0

        key = En.tostring() + theta.tostring()

      else:
        if(theta is None):
           theta=0*math.pi/180.0
        key = (En, theta)


      if(key not in self.recorder.keys() ):

        res=complex(0,0)

        for i  in range(0,len(self.f0list) ):
            res=res+self.f0weights[i]*self.f0list[i].f0Energy(  En, theta)

        for i  in range(0,len(self.f1f2list) ):
            res=res+self.f1f2weights[i]*self.f1f2list[i].f1f2Energy(  En)

        if(self.DWsigma!=None):
            q=2*Numeric.sin(theta)*LAMBDAEV/En
            res=res*Numeric.exp(- (2*math.pi*math.pi*self.DWsigma*self.DWsigma)* q*q      )

        self.recorder[key]= res
      else:
        res= self.recorder[key]


      if(self.convention=="+iKx"): 
         return Numeric.conjugate(res)
      else:
         return res
 

#
#############################################################################################
class Dabax_f0_Table:

  def __init__(self, Name=None):
#    self.path="/home/alessandro/data/f0"
    self.path=dabaxpath

    self.dataprocessors   ={   "f0_WaasKirf.dat": self.process_WaasKirf,
                             "f0_CromerMann.dat": self.process_WaasKirf
                           }
    self.elementretrievers={  "f0_WaasKirf.dat":   self.Element_WaasKirf ,
                            "f0_CromerMann.dat":   self.Element_WaasKirf  }
    if(Name!=None):
      self.load(Name)    


  def getDataBaseNames(self):
    return self.elementretrievers.keys()

  def load(self, location):
     self.Location=self.path+"/"+ location
     self.fileType=location
     self.data=specfile.Specfile(self.Location)
     
     print "Opened file %s. It is of the  %s type" %(
                          self.Location,self.fileType)


     if( (self.fileType in self.dataprocessors.keys()) and
         (self.fileType in self.elementretrievers.keys()) ):

        self.Element= self.elementretrievers[self.fileType]
        self.dataprocessors[self.fileType]()

     else:
        print " I can't process a file of the type %s", self.fileType
        print " Possible types are ", self.fileType in dataprocessors.keys
        exit(1)

  def process_WaasKirf(self):

     self.elementlist=[]
     for scan in self.data:
       self.elementlist.append( string.split(scan.command()) [-1])

  def Element_WaasKirf(self,name):
      index=self.elementlist.index(name)
      if(index==-1):
         print "%s not found in %s", name, self.Location
         exit(1)
      lista=self.data[index].dataline(1)
      res= f0_WaasKirf( lista[5],lista[0:5], lista[6:11]   )
      res.element=name
      return res


###############################################
#
#  class to get the f0 from WaasKirf (internal use only)

class f0_WaasKirf:
  def __init__(self, c,a,b):
    self.a_array=Numeric.array(a)
    self.b_array=(Numeric.array(b))
    self.c=c
    self.classe="class to get the f0 from WaasKirf (internal use only)"

  def __repr__(self):
     for key in dir(self):
       if(key not in ['self','a_array','b_array','c' ]): print "            ",  key, "=", getattr(self,key)
     return ''

  def f0Lambda(self, Lambda, theta=None):
      if( isinstance(Lambda,Numeric.ArrayType)  ):
        if(theta is None):
           theta=Numeric.ones( len(En)     )*0*math.pi/180.0
        k=  Numeric.sin(theta) / Lambda
        k=-k*k
        return (self.c+Numeric.sum( Numeric.swapaxes(self.a_array* Numeric.exp(  Numeric.reshape(k,[len(k),1])* self.b_array),0,1)   ) )
      else:
        if(theta is None):
           theta=0*math.pi/180.0
        k=  Numeric.sin(theta) / Lambda
        k=-k*k
        return (self.c+ Numeric.sum(self.a_array*Numeric.exp( self.b_array*k) ) )


  def f0Energy(self,  Energy, theta=None):
      return self.f0Lambda(LAMBDAEV /Energy, theta)


#########################################################################################
#
#  f12  tables

class Dabax_f1f2_Table:

  def __init__(self, Name=None):
#    self.path="/home/alessandro/data/f12"
    self.path=dabaxpath
    self.dataprocessors   ={"f1f2_Windt.dat": self.process_Windt,"f1f2_Sasaki.dat":self.process_Sasaki}
    self.elementretrievers={"f1f2_Windt.dat": self.Element_Windt,"f1f2_Sasaki.dat":self.Element_Windt }
    if(Name!=None):
      self.load(Name)    

  def getDataBaseNames(self):
    return self.elementretrievers.keys()

  def load(self, location):
     self.Location=self.path+"/"+ location
     self.fileType=location
     self.data=specfile.Specfile(self.Location)

     print "Opened file %s. It is of the  %s type" %(
                          self.Location,self.fileType)


     if( (self.fileType in self.dataprocessors.keys()) and
         (self.fileType in self.elementretrievers.keys()) ):

        self.Element= self.elementretrievers[self.fileType]
        self.dataprocessors[self.fileType]()

     else:
        print " I can't process a file of the type %s", self.fileType
        print " Possible types are ", self.fileType in dataprocessors.keys
        exit(1)


  def  process_Windt(self): 
     self.elementlist=[]
     for scan in self.data: 
       self.elementlist.append( string.split(scan.command()) [-1])

  def  process_Sasaki(self): 
     self.elementlist=[]
     for scan in self.data: 
       self.elementlist.append( string.split(scan.command()) [-1])

  def Element_Windt(self,name):
      index=self.elementlist.index(name)
      if(index==-1):
         print "%s not found in %s", name, self.Location
         exit(1)
      ene=self.data[index].datacol('PhotonEnergy[eV]')
      f1 =self.data[index].datacol('f1')
      f2 =self.data[index].datacol('f2')
 
      hea=self.data[index].header("")
      head=""
      for tok in hea: head=head+tok
      if(string.find(head, "1ADD 0.0")>0):
         f1=f1-f1[-1]

      res= Ef1f2_Interpolated(ene, f1,  f2  )
      res.element=name
      return res

#
#########################################################################################




###############################################
#
#  class to get f1f2 (internal use only)

class Ef1f2_Interpolated:
  def __init__(self, ene,f1,f2):
    self.ene=ene
    self.f1=f1
    self.f2=f2
    self.classe="Ef1f2_Interpolated class to get f1f2 (internal use only) "

  def __repr__(self):
     for key in dir(self):
       if(key not in ['self','ene','f1','f2' ]): print "            ",  key, "=", getattr(self,key)
     return ''

  def f1f2Lambda(self, Lambda):

    energy= LAMBDAEV/Lambda
    return self.f1f2Energy(energy)

  def f1f2Energy(self, energy):
    if(isinstance(energy,Numeric.ArrayType)):
      return arrayfns.interp(self.f1,self.ene, energy )+complex(0,1)*arrayfns.interp(self.f2,self.ene, energy ) 
    else:
      return complex(arrayfns.interp(self.f1,self.ene,(energy,))[0],arrayfns.interp(self.f2,self.ene,(energy,))[0])




class _AtomicProperties:
  databaseA=specfile.Specfile("%s/AtomicConstants.dat" % dabaxpath  )
  databaseB=specfile.Specfile("%s/AtomicDensities.dat" % dabaxpath  )


  elementlistA=[]
  for scan in databaseA: 
     elementlistA.append( string.split(scan.command()) [-1])
  elementlistB=[]
  for scan in databaseB: 
     elementlistB.append( string.split(scan.command()) [-1])
  propA=string.split(databaseA[0].header('L')[0]  )[1:]
  propB=string.split(databaseA[0].header('L')[0]  )[1:]
  __doc__="I can tell you about %s  %s\n call function  getProperty with two args: atom name and property name" %( string.join(propA), string.join(propB)) 
    
def AtomicPropertiesList():
	return _AtomicProperties.propA+_AtomicProperties.propB
  
def AtomicProperties(atom, property):
     if(property in _AtomicProperties.propA and atom in _AtomicProperties.elementlistA):
          return _AtomicProperties.databaseA[_AtomicProperties.elementlistA.index(atom)].datacol(property)   [0]
     elif(property in _AtomicProperties.propB and atom in _AtomicProperties.elementlistB):
          return _AtomicProperties.databaseB[_AtomicProperties.elementlistB.index(atom)].datacol(property)   [0]
     else:
       print _AtomicProperties.elementlistA
       print _AtomicProperties.elementlistB
       print " property %s not found " % property
       exit(0)
  
AtomicProperties.__doc__="I can tell you about %s  %s\n call function  getProperty with two args: atom name and property name" %( string.join(_AtomicProperties.propA), string.join(_AtomicProperties.propB)) 



#######################################################
# ESEMPI DI UTILIZZAZIONE
#
if (__name__=="__main__"):


  Table_f0= Dabax_f0_Table("f0_WaasKirf.dat")

  Table_f1f2=Dabax_f1f2_Table("f1f2_Windt.dat")


  Bef0  = Table_f0.Element("O2-")
  Bef1f2= Table_f1f2.Element("Be")

  print Bef0.f0Energy(1000.0)
  print Bef1f2.f1f2Energy(1000.0)


  Be=Dabax_Scatterer((Bef0,),(1,), (  Bef1f2,),(1,)       )

  print Be.F_Energy(1000)

  print "#######################"



  Wf0  = Table_f0.Element("W")
  Wf1f2= Table_f1f2.Element("W")

  print Wf0  .f0Energy(1000.0,0)
  print Wf1f2.f1f2Energy(1000.0)


  W=Dabax_Scatterer((Wf0,),(1,), (  Wf1f2,),(1,)       )

  print W.F_Energy(1000)

  print "#######################"

  print (1*W+Be*1).F_Energy( 2000  )         
  print (1*W+Be*1).F_Energy( Numeric.array((1000,2000,80000))         )
#
#
#######################################################




















