/***************************************************************************
                          Sparsa.h  -  description
                             -------------------
    begin                : Tue Feb 1 2000
    copyright            : (C) 2000 by Alessandro MIRONE
    email                : mirone@lure.u-psud.fr
 ***************************************************************************/
#ifndef _SPARSAH_
#define _SPARSAH_
class MatriceSparsa {
public:
	MatriceSparsa() {threads=0;};
	virtual void preparathreads(int t) {};
	virtual ~MatriceSparsa();
	virtual void Moltiplica(double *ris, double *vect  );
	virtual void solveCGSym( double *x, double *b, double tol, int MAXIT, double *initial=0);	
	virtual void trasforma(double fattore, double addendo);
	virtual void copiasu( MatriceSparsa * &m);
  int dim;
  int threads;
};

class LanczosSteps;


class LanczosSteps{
public:
	LanczosSteps();
	inline void setMatrice(MatriceSparsa *m, int  ns ) { matrice=m; inizializza(); assicuramemoria(matrice->dim, ns); };
	inline void setInversione(double t, int m) { inversione=1; tol=t; maxit=m;};
	inline void setDiretto      () { inversione=0;};
	void GramSchmidt(double* z, int n ) ;
	void passeggia(int k, int m,  double * iniziale, int continued=0   );
	void inizializza();
	~LanczosSteps(	);

    friend class Lanczos;
    void setNoOldDiags() { olddiags=0;};
    void diagonalizza(int k, int m);
    int convergeds(int m, double tole=2.0e-16);
    void ricipolla(int k, int m);
    int lineaestnulla(int k, double tole);
public :
	void liberamemoria();
	void assicuramemoria(int d, int ns);
	MatriceSparsa * matrice;
	int dim;
	int nsteps;
	
	double **q;
	double *alpha;
	double *oldalpha;
	int olddiags;
	double * beta;
	
	double *p;
	double **omega;

	int inversione;
	double tol;
	int        maxit;
	
	uMatrix<double> A;
	uMatrix<double> eval;
	uMatrix<double>  evect;
};

class Lanczos{
public:
	Lanczos();
	inline void setMatrice(MatriceSparsa *m, int inversione=0, double t=1.0e-16 , int max=40000)
	 {
	 		matrice=m;
	 		if(inversione==1) {
	 			steps.setInversione(t,max);
	 		} else  {
	 			steps.setDiretto();
	 		}	 		
	 };
  ~Lanczos(	);
	int cerca(int nd, double shift=0.0, double tol=2.0e-16);
	double * & geteigenvector(int n) { return steps.q[n];}
	double    &geteigenvalue(int n)  { return steps.eval(n,n); };
	LanczosSteps  steps;
private :
	// void liberamemoria();
	// void assicuramemoria(int d, int ns);
	
	MatriceSparsa * matrice;
	MatriceSparsa * shiftata;
	int nd;
	int nsteps;
	
	int inversione;
	double shift;
	double tol;
	int        maxit;
};



class SparsaS;

class Sparsa3A : public  MatriceSparsa {

 public:
  Sparsa3A();
  Sparsa3A(int N, double *c, int *i, int *j);
   ~Sparsa3A();
  void inizializza(char *file, double fact=1);
  void somma(char *file , double f=1 ) ;
  void sommaFast(char *file , double f=1 ) ;

  void inizializza( Sparsa3A &a ) ;
  void inizializza( Sparsa3A &a , double fact) ;

  void somma    ( Sparsa3A &a, double f=1 ) ;

  void pulisci();
  void Moltiplica(double *ris, double *vect  );

  void aggiungiElemento    (double a, int i, int j);
  void aggiungiElementoFast(double a, int i, int j);

  void riordina();
  void trim();
  void solveCGSym( double *x, double *b, double tol, int MAXIT, double *initial=0);
  void solveCGSym( double *x,double *y,double *b, double *d, double tol, int MAXIT, double *initial=0);
  void solveCGSym2menoImag( double *x, double *b, double imag, double tol, int MAXIT, double *initial=0);
  void trasforma(double fattore, double addendo) ;	
  void copiasu( MatriceSparsa * & m);
  void scrivi(char *file) ;
  void scrivi() ;
  void transpose() { int *dum; dum=col; col=row; row=dum; };
  void raddoppia(double imag) ;
  void preparathreads(int t);
  void Moltiplica(double *ris, double *vect , int start, int end );

  int * intervallithreads;
  friend class SparsaS;

  void   gohersch   ();
  double goherschMin();
  double goherschMax();

  double getelement(int i,int j);

	void solveBCG( double *x,double *b, double tol, int itmax,int & iter,double &err);

	void ottieniuM(uMatrix<double> &a);

 private:

  void reqmrpbCG( double *r, double *b);
  void aggiungimemoria();
	double dAd(double *d, double *dum );
	double dA2menoImag(double *d, double *dum , double imag, double * preco);
	complex<double>  dAd(double *d0, double *di0, double *d, double *dum , double *dumi);

  int n;
  int nsize;

  double *coeff  ;
  int    *col   ;
  int    *row   ;

  double *Gmin, *Gmax;
  int nG;
};


class SparsaS : public  MatriceSparsa  {

 public:
  
  SparsaS();
 SparsaS( double *x, double *b, double tol, int MAXIT, double *initial=0);
 virtual ~SparsaS();

  void inizializza(Sparsa3A &s);
  void inizializza(SparsaS   &s);

  void Moltiplica(double *ris, double *vect  );

  void copiasu( MatriceSparsa * & m);

  friend class Sparsa3A;
 private:

  void resize(int np, int nhorsp );
  int n;
  int nhors;
  double *coeff  ;
  int    *ncol   ;
};



class Sparsa_Resolver {
public:
  void resize(int n);
  void azzera();
  void sommaH(int  i,int j, double add);
  void diagonalizzaH ( double Dene, uMatrix<double>& eVect, uMatrix<double>& eVal , int maxNevals=-1, double tole=2.0e-15,
                        int minDim=5, double distFromPole=0.001 );
  double prodottoscalare(  uMatrix<double>& a , uMatrix<double>&    b    );
  inline void stampa(){ 
    matricione.scrivi();
   }
  void salvasufile(char *nome);
  void addizionadafile(char *nome, double f);
 inline void somma(Sparsa_Resolver & a, double f=1) { matricione.somma(a.matricione,f); }
 void inizializza(Sparsa3A & m);
private:
  Sparsa3A   matricione;
};







double scalare(double * , double *, int);
void normalizza(double * , double , int);
void somma      (double * ,    double * ,    double , int);
#endif

