%define pref /usr
%define ver 2.2.1
%define rpmver 0

Summary: Cross platform GUI toolkit for use with the Python language.
Name: wxPython
Version: %{ver}
Release: %{rpmver}
Copyright: wxWindows License
Group: Development/Languages/Python
Source: wxPython-%{ver}.tar.gz
Packager: Robin Dunn <robin@alldunn.com>
URL:http://alldunn.com/wxPython/index.html
Vendor: Total Control Software
Requires: python >= 1.5.2
##BuildRoot: /tmp/wxPython-build
##Prefix: /usr/lib/python1.5/site-packages

Prefix: %{pref}

%description
wxPython is a GUI toolkit for Python that is a wrapper around the
wxWindows C++ GUI library.  wxPython provides a large variety of
window types and controls, all imlemented with a native look and
feel (and runtime speed) on the platforms it is supported on.


%package gl
Summary: Cross platform GUI toolkit for use with the Python language, OpenGL addon.
Group: Development/Languages/Python
Requires: wxPython

%description gl
OpenGL add on for wxPython.

#----------------------------------------------------------------------

%prep

%setup

%build
NOSWIG=1
export NOSWIG
cd src
python ../distrib/build.py -b WXPSRCDIR=$PWD USE_SONAME=1
cd ../contrib/ogl
python ../../distrib/build.py -b WXPSRCDIR=../../src USE_SONAME=1
cd ../stc
python ../../distrib/build.py -b WXPSRCDIR=../../src USE_SONAME=1
if [ -z $NOGLCANVAS ]; then
    cd ../glcanvas
    python ../../distrib/build.py -b WXPSRCDIR=../../src USE_SONAME=1
fi

#----------------------------------------------------------------------

%install
NOSWIG=1
export NOSWIG
cd src
python ../distrib/build.py -i
cd ../contrib/ogl
python ../../distrib/build.py -i
cd ../stc
python ../../distrib/build.py -i
if [ -z $NOGLCANVAS ]; then
    cd ../glcanvas
    python ../../distrib/build.py -i
fi

#----------------------------------------------------------------------

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

#----------------------------------------------------------------------

%files
%doc BUILD.txt CHANGES.txt README.txt gpl.txt lgpl.txt licence.txt licendoc.txt preamble.txt
%{pref}/lib/libwxPyHelpers*
%{pref}/lib/python1.5/site-packages/wxPython/*.py
%{pref}/lib/python1.5/site-packages/wxPython/*.py?
%{pref}/lib/python1.5/site-packages/wxPython/lib
%{pref}/lib/python1.5/site-packages/wxPython/demo
%{pref}/lib/python1.5/site-packages/wxPython/wxcmodule.so
%{pref}/lib/python1.5/site-packages/wxPython/oglcmodule.so
%{pref}/lib/python1.5/site-packages/wxPython/stc_cmodule.so

%files gl
%{pref}/lib/python1.5/site-packages/wxPython/glcanvascmodule.so







