#########################3
##Disclaimer
##==========
##
## This  software is provided without warranty of any kind.
## No liability is taken for any loss or damages, direct or
## indirect, that may result through the use of it. No warranty
## is made with respect to this documantation, or the programs
## and functions therein.
## There are no warranties that the programs or their documentation
## are free of error, or that it is consistent with any standard,
## or that it will meet the requirement for a particular application.



## Copyright
## =========
##
## We have adopted the GNU LIBRARY GENERAL PUBLIC LICENSE to apply to
## the this software.
## For more information on the license terms, see
## http://www.gnu.org/copyleft/lgpl.txt

import  Numeric 
import  LinearAlgebra
import sys
import math
import pickle
import MLab

Einstein= 0
normal=0

from    OP_simmetrie import OP_cella, OP_ComparisonCellRotatedCell, OP_isDifferent, OP_FindSymmetries, OP_TellAbout
import copy
from contributions import contributions
import contributions

TR=Numeric.transpose


help=" Execute this program with three arguments : Name of the edited parinput file, Name of the cella file. Name of a file containing something like this:\n"

helpfile=( 'IS_IT_SCREENED=1\nKcellrange=[-1,-1,-1]\nsigmacellrange=[-1,-1,-1]\ncellrange= [-1,-1,-1]\ndebyerange=[4,4,2]\nSMcellrange=[2,2,2]\nastar=2*math.pi/3.874\nkdebye=astar/8\n\neps=0.001\n\n\nNsampling=6\n\nQall=Numeric.array( [ Numeric.array([0.00001,0,0]) +"\
" qx*cella.Brillvectors[0]*0.5/(Nsampling-1)\n                      + qy*cella.Brillvectors[1]*0.5/(Nsampling-1) + qz*cella.Brillvectors[2]*0.5/(Nsampling-1)\n\
              for  qx in range(0,Nsampling)\n                      for  qy in range(0 , Nsampling)\n                      for  qz in range(0,Nsampling)\n\
         ] )\n\n\n# thetasym=22.5\nthetasym=45\n\nbdx=math.cos(thetasym*math.pi/180.)\nbdy=math.sin(thetasym*math.pi/180.)\n\nbasedomain=Numeric.array([ bdx, bdy   ,1])\ndomains=Numeric.array( [\n                           [ bdx, bdy   ,1],\n#                            [ bdy, bdx   ,1],\n                            [ bdx, bdy  ,-1],\n#                            [ bdy, bdx  ,-1],\n\n                           [ bdx, -bdy   ,1],\n#                            [ bdy, -bdx   ,1],\n"\
"             [ bdx, -bdy  ,-1],\n#                            [ bdy, -bdx  ,-1],\n\n                           [ -bdx, -bdy   ,1],\n#                            [ -bdy, -bdx   ,1],\n                            [ -bdx, -bdy  ,-1],\n#                            [ -bdy, -bdx  ,-1],\n\n\n\n                           [ -bdx, bdy   ,1],\n#                            [ -bdy, bdx   ,1],\n                            [ -bdx, bdy   ,-1],\n#                            [ -bdy, bdx   ,-1]\n\
        ]\n                       )\n\n\nQ2I_String_sym1 =("def Q2I_Foo(a,N):\\n"\n"   (x,y,z)=Numeric.floor( (a/0.5)*(N-1) +0.5)\\n"\n"#   print \\" AAA \\", (x,y,z)\\n"\n"   if( x >=N  or y >= N  or  z >=N ):\\n"\n"      raise \\" fuori limiti \\"     \\n"\n"      return (-1,0)\\n"\n"   if(x==-(N-1)): x=-x \\n"\n"   if(y==-(N-1)): y=-y \\n"\n"   if(z==-(N-1)): z=-z \\n"\n"   if (x<0 or  y< 0 or z<0 ):\\n"\n"      return (-1,0)\\n"\n"   if (y>x):\\n"\n"      return (-1,0)\\n"\n"   res = z+(y+(x*(x+1))/2)*N\\n"\n"   weight=1.0\\n"\n"   if(x==0 ): weight*=0.5\\n"\n"   if(y==0 ): weight*=0.5\\n"\n"   if(z==0 ): weight*=0.5\\n"\n"   if(x==y ): weight*=0.5\\n"\n"   if(x==(N-1)): weight*=0.5\\n"\n"   if(y==(N-1)): weight*=0.5\\n"\n"   if(z==(N-1)): weight*=0.5\\n"\n"\\n"\n"#   print  \\" AAAAA \\", ( int(round(res)) , weight )            \\n"\n"   return ( int(round(res)) , weight )\\n"\n""\n) \n\nQ2I_String_sym2 =("def Q2I_Foo(a,N):\\n"\n"   (x,y,z)=Numeric.floor( (a/0.5)*(N-1) +0.5)\\n"\n"#   print \\" AAA \\", (x,y,z)\\n"\n"   if( x >=N  or y >= N  or  z >=N ):\\n"\n"      raise \\" fuori dai  limiti %e %e %e\\" %(x,y,z)     \\n"\n"      return (-1,0)\\n"\n"   if(x==-(N-1)): x=-x \\n"\n"   if(y==-(N-1)): y=-y \\n"\n"   if(z==-(N-1)): z=-z \\n"\n"   if (x<0 or  y< 0 or z<0  ):\\n"\n"      return (-1,0)\\n"\n"\
"  print x, \\" \\",y,\\" \\",z \\n"\n"   res = (z)+(y+ x*(N)  )*(N)\\n"\n"   weight=1.0\\n"\n"   if(x==0 ): weight*=0.5\\n"\n"   if(y==0 ): weight*=0.5\\n"\n"   if(z==0 ): weight*=0.5\\n"\n"   if(x==(N-1)): weight*=0.5\\n"\n"   if(y==(N-1)): weight*=0.5\\n"\n"   if(z==(N-1)): weight*=0.5\\n"\n"\\n"\n"#   print  \\" AAAAA \\", ( int(round(res)) , weight )            \\n"\n"   return ( int(round(res)) , weight )\\n"\n""\n) \nQ2I_String =Q2I_String_sym2')


if(len(sys.argv) !=4):
    print help
    print ""
    print helpfile
    raise " PROGRAMSTOPS"

####################################################
# Read parameters for interactions. 

name=sys.argv[1]
fd=open(name,"r")
stringa=fd.read()

#    With this trick, parameters will be accessed
#    like  Parameters.BM_L ..........and so on
#    ;)
print stringa

class Parameters:
    exec(stringa)
    

print Parameters.Z_
print Parameters.M_

print dir(Parameters)
print (Parameters.Z_)


###################################
# Read object cella from  a file 
#
print " READING  CELLA FROM FILE. TAKES A LONG TIME"    
fd=open(sys.argv[2],"r")
cella=pickle.load(fd)



######################################
# create the array of K vectors
print dir(cella)
print cella.Brillvectors

######################################################"
# read and execute the file of scan  parameters

name=sys.argv[3]
fd=open(name,"r")
stringa=fd.read()
exec(stringa)

###################################################################################################
# file where everything will be stored ( cella, Q, and for every q  eigenvvalues + eigenvectors
#

storeall=open("storeall","w")

pickle.dump(cella,storeall)

F_arrays     = contributions.contributionsArrays(cella, Parameters, Qall)
M=F_arrays.Ma
if(Einstein==1):
  M=M*0+M[0]


pickle.dump(1/Numeric.sqrt(M),storeall)

pickle.dump(Qall,storeall)

if(normal==0):
  pickle.dump(Nsampling,storeall)


if(normal==0):
 pickle.dump( Q2I_String , storeall)


RotList=cella.RotList

print RotList

transformations=[]
transformed=Numeric.dot(RotList, basedomain)
for rt in RotList:
  print rt
  print " XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX "
for domain in domains:
     differences=domain-transformed
     differences=Numeric.sum(Numeric.transpose( differences*differences))
     differences=Numeric.less(differences,0.000001)
     if( 1 not in differences.tolist() ):
           print " transformation not found "
     index=differences.tolist().index(1)
     print " index= ", index
     transformations.append(RotList[index])
   


if(normal==0):
 pickle.dump(transformations, storeall)

for i in range (0, len(domains)):
  print " domains ", domains[i]
  print " transformations ", transformations[i]
exit




pezzetti=range(0,len(Qall),200) +[len(Qall)]
print Qall 
print pezzetti
print len(Qall)

file=open("dirp_res","w")
filesq=open("disp_ressq","w")


for k in range(0,len(pezzetti)-1):
  Q=Qall[pezzetti[k]:pezzetti[k+1]]


  if(Einstein==0):
   F_arrays     = contributions.contributionsArrays(cella, Parameters, Q)
   if(IS_IT_SCREENED):
       F_screened  =  contributions.contributionsScreened(cella, Parameters,Q, debye=kdebye, debyerange=debyerange, fastcalc=1)
   else:
       F_coulomb = contributions.contributionsCoulomb(cella, Parameters,Q,  Kcellrange=Kcellrange,  sigmacellrange=sigmacellrange,
                                                      sigmacharge=sigmacharge, fastcalc=1  )
       
   F_analytical  = contributions.contributionsAnalytical(cella, Parameters,Q, cellrange=cellrange)
   F_shellModel = contributions.contributionsShellModel(cella, Parameters,Q,SMcellrange=SMcellrange, )



  Z=F_arrays.Za
  M=F_arrays.Ma
  ussqM=1./Numeric.sqrt(M)
  Y=F_arrays.Ya
  K=F_arrays.Ka


  # evectsOld=None





  for iscan in range(0, len(Q)):

    q      = Q[iscan]

    if(Einstein==0):
      FSR =F_shellModel.SS[iscan]
      FSC =F_shellModel.SC[iscan]
      FCS =F_shellModel.CS[iscan]
      FSS =F_shellModel.SR[iscan]
      FSC0=F_shellModel.SC0[iscan]
      FCS0=F_shellModel.CS0[iscan]

      if(0):
        C=F_coulomb.C[iscan]
        VC0z=F_coulomb.VC0z [iscan]
      else:
        C=F_screened.DebC[iscan]
        VC0z=F_screened.DebVC0 [iscan]

  
#  C=F.DebC[i]
#  VC0=F.DebVC0 [i]
 

      ZCZ= TR(Z*TR(C*Z))
      ZCY= TR(Z*TR(C*Y))
      YCZ= Numeric.conjugate(TR(ZCY))
      YCY= TR(Y*TR(C*Y))

      ZVC0z= TR(Z*TR(VC0z))
      YVC0z= TR(Y*TR(VC0z))


      dim=len(ZCZ)
      KM  = MLab.eye(dim,dim)*K
      Muu =     ZCZ+FSR+FSC+FCS+FSS+ZVC0z
      Muw =     ZCY+FSC+FSS+FCS0-FSC0+YVC0z
      Mwu =     YCZ+FCS+FSS+YVC0z
      Mww =     YCY+FSS+FSC0+KM +YVC0z
      MM  = Muu - Numeric.dot(Muw , Numeric.dot( LinearAlgebra.inverse(Mww), Mwu)   ) 
      MM=TR( ussqM*TR(MM*ussqM))
    else:
      dim=len(ussqM)
      MM=MLab.eye(dim,dim)*5.0e+27

    (evals, evects) = LinearAlgebra.Heigenvectors(MM)


    #######################################################
    # reordering
    #
    # if(evectsOld is not None):
    #    products = Numeric.array(
    #               [ 
    #                  [ Numeric.sum( Numeric.conjugate(evects[j]) * evectsOld[i] )
    #                            for j in range(0, len(evects)) 
    #                  ]
    #                        for i in    range(0, len(evects)) 
    ##               ])      
    #    products=abs(products) 
    #    placetoread = [ (products[i].tolist()).index( reduce(Numeric.maximum,products[i])) for i in    range(0, len(evects))  ]
    #    newevects  = Numeric.array([ evects[placetoread[i]] for       i in    range(0, len(evects))  ] )
    #    newevals   = Numeric.array([ evals [placetoread[i]] for       i in    range(0, len(evects))  ] )    
    #    evects =     newevects
    #    evals  =     newevals
    # evectsOld = evects
   
    ######################################
    # dumping evals and evects
    #
    pickle.dump(evals,storeall)
    pickle.dump(evects,storeall)

    ##########################################################
    # build a matrix by which the q's can be decomposed  on
    # the Brillouin vectors basis. 
    # Useful to display result in units which are integer on
    #  the reciprocal lattice sites, or even more useful
    # when we want reduce a big vector in the 000 cell
    #
    
    brill=cella.Brillvectors
    brill=brill
    brilldecomposition=LinearAlgebra.inverse(TR(brill))
    
    for eval in evals:
        file.write( ( " %20e " % eval) )
    file.write("\n")
    count=0
    for eval in evals:
       if(count==0):
             qdec=Numeric.dot(brilldecomposition, Q[iscan])
             print qdec
             filesq.write( ( " %20e %20e %20e  " % ( qdec[0],qdec[1],qdec[2])   ) )
       if(eval>0):
             filesq.write( ( " %20e " % math.sqrt(eval)) )
       else:
             filesq.write( ( " ****  " ) )
       count=count+1
    filesq.write("\n")


storeall.close()










