#########################3
##Disclaimer
##==========
##
## This  software is provided without warranty of any kind.
## No liability is taken for any loss or damages, direct or
## indirect, that may result through the use of it. No warranty
## is made with respect to this documantation, or the programs
## and functions therein.
## There are no warranties that the programs or their documentation
## are free of error, or that it is consistent with any standard,
## or that it will meet the requirement for a particular application.
   
# Copyright
## =========
##
## We have adopted the GNU LIBRARY GENERAL PUBLIC LICENSE to apply to
## the this software.
## For more information on the license terms, see
## http://www.gnu.org/copyleft/lgpl.txt
    
## Author : Alessandro MIRONE mirone@esrf.fr
                                                        





import  Numeric 
import  LinearAlgebra
import sys
import math
import pickle
import MLab

from    OP_simmetrie import OP_cella, OP_ComparisonCellRotatedCell, OP_isDifferent, OP_FindSymmetries, OP_TellAbout
import copy
from contributions import contributions

TR=Numeric.transpose

####################################################
# Read parameters for interactions. 

name="parinputedited"
fd=open(name,"r")
stringa=fd.read()

#    With this trick, parameters will be accessed
#    like  Parameters.BM_L ..........and so on
#    ;)


class Parameters:
    exec(stringa)
    

print Parameters.Z_
print Parameters.M_

print dir(Parameters)
print (Parameters.Z_)


###################################
# Read object cella from  a file 
#
print " READING  CELLA FROM FILE. TAKES A LONG TIME"    
fd=open("cella","r")
cella=pickle.load(fd)



######################################
# create the array of K vectors
astar=2*math.pi/3.95
cstar=2*math.pi/12.06556
eps=0.001
Q=Numeric.array( [ [0*astar+astar*0.5*i+eps,0,0] for i in range(1,2)]           )

########################################################



F=contributions(cella, Parameters,Q, sigmacharge=3.0, Kcellrange=[2,2,4],  sigmacellrange=[5,5,2],
                SMcellrange=[2,2,2], cellrange=[-1,-1,-1], debye=0.0, fastcalc=1) 

file=open("vagito","w")
filesq=open("vagitosq","w")

Z=F.Za
M=F.Ma
ussqM=1./Numeric.sqrt(M)
Y=F.Ya
K=F.Ka


evectsOld=None


###################################################################################################
# file where everything will be stored ( cella, Q, and for every q  eigenvvalues + eigenvectors
#

storeall=open("storeall","w")
pickle.dump(cella,storeall)
pickle.dump(ussqM,storeall)
pickle.dump(Q,storeall)


for iscan in range(0, len(F.C)):
  q=Q[iscan]
  C=F.C[iscan]
  FSR=F.SS[iscan]
  FSC=F.SC[iscan]
  FCS=F.CS[iscan]
  FSS=F.SR[iscan]
  FSC0=F.SC0[iscan]
  FCS0=F.CS0[iscan]
  VC0z=F.VC0z [iscan]
  VC0y=F.VC0y [iscan]
  
#  C=F.DebC[i]
#  VC0=F.DebVC0 [i]
 

  ZCZ= TR(Z*TR(C*Z))
  ZCY= TR(Z*TR(C*Y))
  YCZ= Numeric.conjugate(TR(ZCY))
  YCY= TR(Y*TR(C*Y))

  ZVC0z= TR(Z*TR(VC0z))
  YVC0z= TR(Y*TR(VC0z))
  ZVC0y= TR(Z*TR(VC0y))
  YVC0y= TR(Y*TR(VC0y))


  dim=len(ZCZ)
  KM  = MLab.eye(dim,dim)*K
  Muu =     ZCZ+FSR+FSC+FCS+FSS+ZVC0z
  Muw =     ZCY+FSC+FSS+FCS0-FSC0+YVC0z
  Mwu =     YCZ+FCS+FSS+YVC0z
  Mww =     YCY+FSS+FSC0+KM +YVC0z
  MM  = Muu - Numeric.dot(Muw , Numeric.dot( LinearAlgebra.inverse(Mww), Mwu)   ) 
  MM=TR( ussqM*TR(MM*ussqM))

  (evals, evects) = LinearAlgebra.Heigenvectors(MM)


  ###################################333
  # reordering
  #
  if(evectsOld!=None):
      products = Numeric.array(
                 [ 
                    [ Numeric.sum( Numeric.conjugate(evects[j]) * evectsOld[i] )
                              for j in range(0, len(evects)) 
                    ]
                          for i in    range(0, len(evects)) 
                 ])      
      products=abs(products) 
      placetoread = [ (products[i].tolist()).index( reduce(Numeric.maximum,products[i])) for i in    range(0, len(evects))  ]
      newevects  = Numeric.array([ evects[placetoread[i]] for       i in    range(0, len(evects))  ] )
      newevals   = Numeric.array([ evals [placetoread[i]] for       i in    range(0, len(evects))  ] )    
      evects =     newevects
      evals  =     newevals
  evectsOld = evects
   
  ######################################
  # dumping evals and evects
  #
  pickle.dump(evals,storeall)
  pickle.dump(evects,storeall)
   
  for eval in evals:
       file.write( ( " %20e " % eval) )
  file.write("\n")
  count=0
  for eval in evals:
     if(count==0):
           print Q[iscan][0]
           filesq.write( ( " %20e " % (4+(Q[iscan,0])*3.95/2.0/math.pi, )   ) )
     if(eval>0):
           filesq.write( ( " %20e " % math.sqrt(eval)) )
     else:
           filesq.write( ( " ****  " ) )
     count=count+1
  filesq.write("\n")
  













