import    NumericA
import  Numeric 
import  LinearAlgebra
import  Minimiser
import sys
import math
import pickle

from    OP_simmetrie import OP_cella



#################################################################################3


def contributionsCoulombMadelung(cella, Z, Impurity,  cellrange=[2,2,2]
	 ):

  #########################################################3
  # find the dimensions ( How many sites in the cell )
  N=Numeric.sum(map(len, cella.PositionsList))


  ##########################################
  # initialise the result
  result=0.0


  SUM=Numeric.sum


  for i1 in [Impurity] :

     A1= cella.atomlist[i1]
     P1=cella.FindPosition( A1, CellCoo=(0,0,0))

     Z1       =Z[i1]


     for i2 in range(0,len(cella.atomlist)):
        if(i2==Impurity): continue

        #####################################################"
        # this factor for diagonal terms is 0.5 because
        # each matrix will be symmetrized later, so diagonal 3X3 blocks are
        # counted twice
        if(i1!=i2):
            fattdiag=1
        else:
            fattdiag=1

        A2= cella.atomlist[i2]
        Z2       =Z [i2]

        for lx in range(-cellrange[0], cellrange[0]+1) :
         for ly in range(-cellrange[1], cellrange[1]+1) :
          for lz in range(-cellrange[2], cellrange[2]+1) :

            if(A1==A2 and lx==0 and ly==0 and lz==0): continue

            P2=cella.FindPosition( A2, CellCoo=(lx,ly,lz))

            

            R=P2-P1

            # print "i1=", i1, " i2=", i2
            # print R

            d=math.sqrt(Numeric.sum(R*R) )

            result=result +Z1*Z2/d
              
  return result




import copy

#######################################
# the elements entering the cell
AtomNames=['Cu',   'O',  'Nd' ]


###########################################
# the three axis of the cell
cellvectors=Numeric.array( 
         [ 
           [3.95  , 0.0     ,  0.0],
           [0.0   , 3.95    ,  0.0], 
           [0.0   , 0.0     ,  12.06556] 
         ] )


######################################################################################
# for each element a list ov vector, each vector is the position of an atom
# Positions are given in the cell vectos basis
PositionsList=[
          Numeric.array(  
              [ [0.0,       0.0,       0.0  ],
                [0.5,       0.5,       0.5  ]
              ]    
          ),


          Numeric.array(
              [ [0.5,       0.5,       0.352  ], # impurity
                [0.5,       0.0,       0.0  ],
                [0.0,       0.5,       0.0  ],
                [0.5,       0.0,       0.25 ],
                [0.0,       0.5,       0.25 ],
                [1.0,       0.5,       0.5  ],
                [0.5,       1.0,       0.5  ],
                [1.0,       0.5,       0.75],
                [0.5,       1.0,       0.75],            
              ]
           ),
           Numeric.array(
              [ [0.0,       0.0,       0.352],
                [0.5,       0.5,       0.148],
                [0.5,       0.5,       0.852],
                [1.0,       1.0,       0.648]        
              ]
           )
]

#############################################################"""
#  The positions are given in  the cell vectos basis.
#  Now we transform the position in xyz absolute space.

for k in range(0, len(PositionsList)):
     PositionsList[k]=Numeric.dot(PositionsList[k],  cellvectors   )

#########################################################"
# Constructor of OP_cella.
# Here one passes  the relevant parameter (see default list)

cella=OP_cella(cellvectors=cellvectors, AtomNames=AtomNames, PositionsList=PositionsList)
 
Z=[ 1.64, 1.64, 
   -1.56,-1.56,-1.56,-1.56,
   -1.56,-1.56,-1.56,-1.56, -1.56,
   2.3,2.3,2.3,2.3
  ]

Z =[ 2,2, 
    -2,-2,-2,-2, -2,
    -2,-2,-2,-2,
    3,3,3,3
   ]

for i in [1,2,3,4,5,6,8,10]:
 print i, " ", contributionsCoulombMadelung(cella, Z, 2,  cellrange=[i,i,i] )















