import    NumericA
import  Numeric 
import  LinearAlgebra
import  Minimiser
import sys
import math
import pickle

from    OP_simmetrie import OP_cella, OP_ComparisonCellRotatedCell, OP_isDifferent, OP_FindSymmetries, OP_TellAbout
import copy

#######################################
# the elements entering the cell
AtomNames=['Cu',   'O',  'Nd' ]


###########################################
# the three axis of the cell
cellvectors=Numeric.array( 
         [ 
           [3.95  , 0.0     ,  0.0],
           [0.0   , 3.95    ,  0.0], 
           [0.0   , 0.0     ,  12.06556] 
         ] )


######################################################################################
# for each element a list ov vector, each vector is the position of an atom
# Positions are given in the cell vectos basis
PositionsList=[
          Numeric.array(  
              [ [0.0,       0.0,       0.0  ],
                [0.5,       0.5,       0.5  ]
              ]    
          ),
          Numeric.array(
              [ [0.5,       0.0,       0.0  ],
                [0.0,       0.5,       0.0  ],
                [0.5,       0.0,       0.25 ],
                [0.0,       0.5,       0.25 ],
                [1.0,       0.5,       0.5  ],
                [0.5,       1.0,       0.5  ],
                [1.0,       0.5,       0.75],
                [0.5,       1.0,       0.75],            
              ]
           ),
           Numeric.array(
              [ [0.0,       0.0,       0.352],
                [0.5,       0.5,       0.148],
                [0.5,       0.5,       0.852],
                [1.0,       1.0,       0.648]        
              ]
           )
]

#############################################################"""
#  The positions are given in  the cell vectos basis.
#  Now we transform the position in xyz absolute space.

for k in range(0, len(PositionsList)):
     PositionsList[k]=Numeric.dot(PositionsList[k],  cellvectors   )

#########################################################"
# Constructor of OP_cella.
# Here one passes  the relevant parameter (see default list)

cella=OP_cella(cellvectors=cellvectors, AtomNames=AtomNames, PositionsList=PositionsList)



############################################################
# OP_cella.computeDistances(self, maxdist,N=2)
# It builds up a Big multiple dictionary, namely
#
# self.distances[Aa][Bb][kA][kB][(DX,DY,DZ)]
#
# where Aa and kA are the atom name ( for example "Si",..)
#  and the position in the array of vectors in cell.PositionsList
# starting from 0. Same thing for Bb and kB.
# (DX,DY,DZ) are integer numbers specifying the cell containing (Bb,kB)
# relatively to (Aa,kA).
# DX,DY,DZ run from -N to N 

cella.computeDistances(200.0,N=2)





##################################################################################
# OP_cella. FindTetragons(self, Latoms, CellsCoo=[(0,0,0),(0,0,0),(0,0,0),(0,0,0)])
# This is the key routine to find good candidates to symmetry group.
# Latoms is a list of the kind [  (Aa,kA) ,(Bb,kB)....] 
# ( i.e. couples formed by atom-name and position in the position list.
# Latoms must be formed of four  atoms defining a non-degenerate tetraedron.
# A check is permormed on the non-degeneracy.
# The funtions finds all the possible equivalent tetraedrons (which have the same
# set of distances, and the same atom kinds)
# The function return the list of all these tetraedrons
#
# Every tetraedron is represented by a list of four atoms and a list of cell coordinates.... like
# [     [        [(Aa,kA),(Aa2,kA2),(Aa3,kA3), (Aa4,kA4)],         [(0,0,0),(0,0,0),(0,0,0),(0,0,0)]           ]
#       [  ..............................................                                                      ]
# ]

LTetra = cella.FindTetragons([('Cu',0),('O',1),('Nd',0),('Nd',2)])

#########################################################################################
#  OP_cella.FindPositions(self, Latoms, CellsCoo=[(0,0,0),(0,0,0),(0,0,0),(0,0,0)])
#  returns an array of four vectors. 
#  The nth vector gives the position of nth atom of Latoms with the nth  cell-coordinates 
#  of CellsCoo.
#  Here, LTetra[0] which is the first tetraedron of the list, correspond by construction 
#  to  identity 
 
Positions= cella.FindPositions(LTetra[0][0],LTetra[0][1])
Vectors = Positions[1:4]-Positions[0]

##########################################################
# OP_cella.getK(self, N=2)
# Returns an array of 3D vectors, that are spanned by
# integer multiples of cell's Brillouin vectors.
# integers run form -N to N.
# (the vectors are already multiplied by imaginary unit
#  in order to be ready for fourier transforming)

K       = cella.getK()

Fourier = cella.getFourier(K) 




 


##############################################################
# in CellsList we put transformed Cells that superpose
# perfectly to the original one through simmetry operations
# that are looked for in LTetra
# 
CellsList=[]


#################################################"
# Start the loop on candidates to symmetry group
#
print LTetra
for i in range(0, len(LTetra)):
  NewPositions= cella.FindPositions(LTetra[i][0],LTetra[i][1])
  NewVectors = NewPositions[1:4]-NewPositions[0]
  Rot= Numeric.dot(Numeric.transpose(NewVectors),   LinearAlgebra.inverse(Numeric.transpose(Vectors))  )  

  shift=NewPositions[0]-Numeric.dot(Rot,Positions[0])
  if(LinearAlgebra.determinant(Rot)<0):
     Reflection=1
     Rot=-Rot
  else:
     Reflection=0

  newCell=copy.deepcopy(cella)
  if(Reflection):
          newCell.Reflection()
  newCell.TransformByMatrix( Rot ,shift )
  newFourier=newCell.getFourier(K) 
  diffFourier=newFourier-Fourier 
  diffFourier=  (diffFourier* Numeric.conjugate(diffFourier)).real  
  error=Numeric.sum(Numeric.sum(diffFourier))

  if(error<0.00001):
    isnew=1
    for tok in CellsList:
      if ( not OP_isDifferent(tok,newCell) ):
        isnew=0
    if(isnew):
     print "NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN"
     OP_TellAbout(Rot, short="YES")
     print " REFLECTION= ", ["NO","YES"][Reflection]
     print " SHIFT     = ", newCell.shift
     CellsList.append(newCell)

########################################################
# Now CellsList contains all the symmetric versions
# of the original cells

#######################################""
# Do important operations
# to find out groups and so on

cella.FindEquivalences(CellsList)       
cella.computeHistograms()

########################################"
# print something to the screen
#
cella.printEquivalences()
print " DISTANCES "
cella.printHisto(3)


#############################################
# Write the input file template
#
cella.printParametersInput("parinput")

##################################################################33
# Write object cella to a file for subsequent retrival
#
print " WRITING CELLA TO FILE. TAKES A LONG TIME"    
fd=open("cella","w")
delattr(cella,'distances')
pickle.dump(cella,fd)

 







