#########################3
##Disclaimer
##==========
##
## This  software is provided without warranty of any kind.
## No liability is taken for any loss or damages, direct or
## indirect, that may result through the use of it. No warranty
## is made with respect to this documantation, or the programs
## and functions therein.
## There are no warranties that the programs or their documentation
## are free of error, or that it is consistent with any standard,
## or that it will meet the requirement for a particular application.
 
  
   
## Copyright
## =========
##
## We have adopted the GNU LIBRARY GENERAL PUBLIC LICENSE to apply to
## the this software.
## For more information on the license terms, see
## http://www.gnu.org/copyleft/lgpl.txt
    
## Author : Alessandro MIRONE mirone@esrf.fr  


import  Numeric 
import  LinearAlgebra
import  umathextra
Numeric.erf=umathextra.erf
import sys
import math
import pickle
from OP_fastGsum import  OP_fastGsum
from OP_fastRsum import  OP_fastRsum
from OP_fastRsumDebye import  OP_fastRsumDebye
from OP_fastRsumDebye_c import  OP_fastRsumDebye_c

import MLab

from    OP_simmetrie import OP_cella, OP_ComparisonCellRotatedCell, OP_isDifferent, OP_FindSymmetries, OP_TellAbout
import copy

TR=Numeric.transpose

def findinhisto(histo, r):
 res= map( lambda x, r=r: (r>=x[0]-1.0e-6 and r<x[1]+1.0e-6) , histo)
 return res.index(1)

def contributions(cella, Parameters,Q, cellrange=[2,2,2], Kcellrange=[2,2,2],  sigmacellrange=[2,2,2],
	SMcellrange=[2,2,2], sigmacharge=2.0, debye=0.3, debyerange=[2,2,2], fastcalc=0):

  #########################################################3
  # find the dimensions ( How many sites in the cell )
  N=Numeric.sum(map(len, cella.PositionsList))

  #############################################################
  # create the result for "easy interactions"
  res=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )

  ##########################################
  # create the Matrix for Coulomb interactios
  C=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  VC0z=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  VC0y=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  DebC=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  DebVC0=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )

  ##########################################
  # create an array containing Z
  Zarray =Numeric.zeros( [  3*N ]  , Numeric.Float64 )

  ##########################################
  # create an array containing Masses
  Marray =Numeric.zeros( [  3*N ]  , Numeric.Float64 )

  ##########################################
  # create an array containing shell charges Y
  Yarray =Numeric.zeros( [  3*N ]  , Numeric.Float64 )

  ###################################################
  # create an array containing force constants K
  Karray =Numeric.zeros( [  3*N ]  , Numeric.Float64 )
 
  ##########################################
  # create the Matrices  for Shells model
  SR=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  SC=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  CS=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  SS=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  SC0=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  CS0=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )




  ##################################3333
  # an useful matrix : identity
  identity = Numeric.array([[1.0,0.0,0.0],[0.0,1.0,0.0],[0.0,0.0,1.0]])

  #######################################333
  # universal constants
  #
  VW_V0= Parameters.VW_V0
  LJ_V0= Parameters.LJ_V0
  BM_V0= Parameters.BM_V0

  for i1 in range(0,len(cella.atomlist)):
     A1= cella.atomlist[i1]
     print A1
     print cella.DGroups
     g1=cella.DGroups[A1]
     P1=cella.FindPosition( A1, CellCoo=(0,0,0))
     BMsigma1=Parameters.BMs_[g1]
     LJsigma1=Parameters.LJs_[g1]
     VWsigma1=Parameters.VWs_[g1]
     Z1       =Parameters.Z_  [g1]
     M1       =Parameters.M_  [g1]
     Y1       =Parameters.Y_  [g1]
     K1       =Parameters.K_  [g1]
     Zarray[i1*3:i1*3+3 ]=Z1
     print Z1
     print Zarray
     Marray[i1*3:i1*3+3 ]=M1
     Yarray[i1*3:i1*3+3 ]=Y1
     Karray[i1*3:i1*3+3 ]=K1

     for i2 in range(i1,len(cella.atomlist)):
        #####################################################"
        # this factor for diagonal terms is 0.5 because
        # each matrix will be symmetrized later, so diagonal 3X3 blocks are
        # counted twice

        if(i1!=i2):
            fattdiag=1
        else:
            fattdiag=0.5

        A2= cella.atomlist[i2]
        g2=cella.DGroups[A2]
        BMsigma2=Parameters.BMs_[g2]
        LJsigma2=Parameters.BMs_[g2]
        VWsigma2=Parameters.BMs_[g2]
        Z2       =Parameters.Z_  [g2]
        Y2       =Parameters.Y_  [g2]
       
        # Insertion for Coulomb
        Insect = C[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]

        TR=Numeric.transpose
        SUM=Numeric.sum
        conj=Numeric.conjugate
        P2=cella.FindPosition( A2, CellCoo=(0,0,0))
        
        DR=P2-P1
        #################################################################
        # ADD COULOMB FROM SMEARED CHARGES
        #
        Cself=Numeric.zeros([3,3],Numeric.Complex64)
        print " ADD COULOMB FROM SMEARED CHARGES "

        #####################################################
        # p is is the factor in the gaussian exponent :
        #  charge density is written as Z*(p/pi)**1.5*exp(-p*r**2)
        #
        p=1.0/(2*sigmacharge*sigmacharge)

        brilldecompose=LinearAlgebra.inverse(TR(cella.Brillvectors))
        shiftzero=Numeric.dot(brilldecompose, Q[0])
        intzero  =MLab.floor(shiftzero)
        Qshift   =Numeric.dot(intzero, cella.Brillvectors)

        Q=Q-Qshift
        #######################################################
        # loop over the vectors of the reciprocal lattice
        #
        if(not fastcalc):
         for kx in range(-Kcellrange[0], Kcellrange[0]+1)  :
          for ky in range(-Kcellrange[1], Kcellrange[1]+1) :
           for kz in range(-Kcellrange[2], Kcellrange[2]+1) :
             G=Numeric.dot( Numeric.array([kx,ky,kz]) , cella.Brillvectors)
             QpG=Q+G
             ########################################################
             # outer product by using reshape : ask the guru
             #
             T3X3= Numeric.reshape(QpG,[len(Q),3,1]) * Numeric.reshape(QpG,[len(Q),1,3])
             #################################
             # squared modulus of G+Q
             #
             QpG2 = Numeric.sum( TR( QpG * QpG))

             #############################################
             # fourier transform of a gaussian is a gaussian
             # espo is its exponent
             #
             espo =  QpG2/(4.0*p)
             Numeric.putmask(espo, Numeric.greater(espo,40.0), 40.0)

             Numeric.add(Insect, TR(   TR(T3X3) / TR(QpG2) * 
                               TR( Numeric.exp(-espo  +
                                         complex(0.0,-1.0)*Numeric.sum((G-Qshift)*DR)
                                      )
                                 )
                              ) *(4*math.pi/cella.volume)    * fattdiag
                         , Insect)


             ########################################
             # add contributions for the self term
             # Diskard G=0 case that would give a floatinf point error
             # and that is in any case   a flat contribution with null  derivative
             #
             if( kx!=0 or ky!=0 or kz!=0):
               T3X3=Numeric.outerproduct(G,G)
               G2  =Numeric.sum(G*G)
               espo = G2/(4.0*p)
               if(espo>40): espo=40.0

               ###############################################
               # self term 
               #
               Cself=Cself+    ( T3X3 / G2 * 
                                Numeric.exp(-espo  +
                                         complex(0.0,-1.0)*Numeric.sum(G*DR)
                                      )
                               
                         ) *(4*math.pi/cella.volume)

        ################################################################################3
        # The above loop can be substituted by a C++ function taking as argument
        # Kcellrange[0], Kcellrange[1], Kcellrange[3], cella.Brillvectors[0,1,2],Q,
        #  DR, sigmacharge, TermtoaddtoInsect, Cself)
        #
        else:
          TermtoaddtoInsect= Numeric.zeros([len(Q), 3, 3 ]  , Numeric.Complex64 )
          addtoCself= Numeric.zeros([ 3, 3 ]  , Numeric.Complex64 )
          OP_fastGsum(  Kcellrange[0], Kcellrange[1], Kcellrange[2], cella.Brillvectors[0],
                        cella.Brillvectors[1],cella.Brillvectors[2], Q,
                        DR,  sigmacharge , TermtoaddtoInsect, addtoCself,Qshift)

          TermtoaddtoInsect=TermtoaddtoInsect*(4*math.pi/cella.volume) * fattdiag
          Cself=Cself+ addtoCself*(4*math.pi/cella.volume) 

          Numeric.add(Insect,  TermtoaddtoInsect , Insect) 
              
        Q=Q+Qshift      
        #######################################################################
        # the Fourier transform terms are obtained by summing over a whole
        # lattice. That include also the contribution of a site on the same site itself :( :
        #  we have to remove it 
        # NOTA BENE:
        #   that would be unnecessary in the case of rigid Ion because
        #   the spurious contributions to insect and to Cself would elide
        #   each other. But as we consider polarizable shells, Cself
        #   and Insect have a life of their own
        if(i1==i2):
           sq=math.sqrt(p/math.pi)
           ###################################################"
           # the field at the center of the sphere has a simple
           # linear dependance on the radius, proportional to
           # the charge density
           #
           add= identity*(4.0*math.pi/3.0 *sq*sq*sq)
           Numeric.add(Insect, -add*0.5  , Insect) # removes the undue self term
           Cself=Cself -add

        #########################################################
        # subtract  the 3X3 self term to the VC0 self term matrix
        # 
        InsectA = VC0z[:,  i1*3 : 3+i1*3, i1*3 : i1*3+3  ]
        Numeric.add(InsectA, -Cself*Z2 , InsectA)
        if(i1!=i2):
          InsectA = VC0z[:,  i2*3 : 3+i2*3, i2*3 : i2*3+3  ]
          Numeric.add(InsectA, -conj(TR(Cself)*Z1) , InsectA)

        InsectA = VC0y[:,  i1*3 : 3+i1*3, i1*3 : i1*3+3  ]
        Numeric.add(InsectA, -Cself*Y2 , InsectA)
        if(i1!=i2):
          InsectA = VC0y[:,  i2*3 : 3+i2*3, i2*3 : i2*3+3  ]
          Numeric.add(InsectA, -conj(TR(Cself))*Y1 , InsectA)
        
        ##############################################################33
        #  ADD THE MISSED PART OF THE SMEARED CHARGE
        #    the part of the gaussian distribution exceeding 
        #    in radius the interacting atom distance
        #
        Cself=Numeric.zeros([3,3],Numeric.Float64)
        print " ADD THE MISSED PART OF THE SMEARED CHARGE "
        if(not fastcalc):
         for lx in range(-sigmacellrange[0], sigmacellrange[0]+1) :
          for ly in range(-sigmacellrange[1], sigmacellrange[1]+1) :
           for lz in range(-sigmacellrange[2], sigmacellrange[2]+1) :
            if(A1==A2 and lx==0 and ly==0 and lz==0): continue
            P2=cella.FindPosition( A2, CellCoo=(lx,ly,lz))
            R=P2-P1
            d=math.sqrt(Numeric.sum(R*R) )

            LmT_fact0 = Numeric.outerproduct(R,R)/(d*d)
            T_fact0   = identity

            expi = Numeric.reshape( Numeric.exp(complex(0.0,1.0)*SUM(TR(Q*R))), [len(Q),1,1])

            LmT_fact = expi  *  LmT_fact0
            T_fact   = expi  *  T_fact0  

            ####################################################################"
            #  We are adding the potential of the outer charge as if it were
            # at the site center, minus the actual contribution of the gaussian
            # tail going from r to infinity
            # 

            p= 1.0/(2.0*sigmacharge*sigmacharge)
            esp = math.exp(-p*d*d)
            integral = math.sqrt(math.pi/4.0/p)*(1-Numeric.erf(math.sqrt(p) * d ))
            Der1=-1.0/d*(integral/d + esp  )
            Der2=2*( 1.0/d/d*(integral/d + esp ) + p*esp)
            fact=2*math.sqrt(p/math.pi)
            L= fact*Der2
            T= fact*Der1/d

            Numeric.add(Insect, (- (L-T)*LmT_fact - T * T_fact) * fattdiag, Insect)

            ###############################################
            # 
            # 
            #

            Cself=Cself+(-(L-T)*LmT_fact0 - T * T_fact0)

        ################################################################################3
        # The above loop can be substituted by a C++ function taking as argument
        # sigmacellrange[0], sigmacellrange[1], sigmacellrange[3], cella.cellvectors[0,1,2],Q,
        #  DR, sigmacharge, TermtoaddtoInsect, Cself)
        #
        else:

          TermtoaddtoInsect= Numeric.zeros([len(Q), 3, 3 ]  , Numeric.Complex64 )
          addtoCself= Numeric.zeros([ 3, 3 ]  , Numeric.Complex64 )

          OP_fastRsum(  sigmacellrange[0], sigmacellrange[1], sigmacellrange[2], cella.cellvectors[0],
                        cella.cellvectors[1],cella.cellvectors[2], Q,
                        DR,  sigmacharge , TermtoaddtoInsect, addtoCself)

          TermtoaddtoInsect=TermtoaddtoInsect * fattdiag

          Cself=Cself+ addtoCself
          Numeric.add(Insect,  TermtoaddtoInsect , Insect) 


        #########################################################
        # subtract  the 3X3 self term to the VC0 self term matrix
        # 
        InsectA = VC0z[:,  i1*3 : 3+i1*3, i1*3 : i1*3+3  ]
        Numeric.add(InsectA, -Cself*Z2 , InsectA)
        if(i1!=i2):
          InsectA = VC0z[:,  i2*3 : 3+i2*3, i2*3 : i2*3+3  ]
          Numeric.add(InsectA, -conj(TR(Cself)*Z1) , InsectA)

        InsectA = VC0y[:,  i1*3 : 3+i1*3, i1*3 : i1*3+3  ]
        Numeric.add(InsectA, -Cself*Y2 , InsectA)
        if(i1!=i2):
          InsectA = VC0y[:,  i2*3 : 3+i2*3, i2*3 : i2*3+3  ]
          Numeric.add(InsectA, -conj(TR(Cself))*Y1 , InsectA)
         
        ###################################################################
        #  ADD THE SHELL MODEL
        #
        SRself=Numeric.zeros([3,3],Numeric.Float64)
        SSself=Numeric.zeros([3,3],Numeric.Float64)
        SCself=Numeric.zeros([3,3],Numeric.Float64)
        CSself=Numeric.zeros([3,3],Numeric.Float64)
        if ( len(Parameters.BK_L[g1][g2])!=0 ):
           print "ADD THE SHELL MODEL"

           ####################################################"
           # a sorted list of possible  radius for  A1-A2 interactions
           distList=cella.histo[g1][g2]

           #################################################################
           # retrieve lists of springs strenghts
           #
           bk_lL= Parameters.BK_L[g1][g2]
           ss_lL= Parameters.SM_L[g1][g2]['SS']
           sc_lL= Parameters.SM_L[g1][g2]['SC']
           cs_lL= Parameters.SM_L[g1][g2]['CS']

           bk_tL= Parameters.BK_T[g1][g2]
           ss_tL= Parameters.SM_T[g1][g2]['SS']
           sc_tL= Parameters.SM_T[g1][g2]['SC']
           cs_tL= Parameters.SM_T[g1][g2]['CS']

           if (map(len , [bk_lL,ss_lL,sc_lL,cs_lL, bk_tL,ss_tL,sc_tL,cs_tL])!= [len(bk_lL)]*8 ):
              print " I am sorry but all the bk_lL,ss_lL,sc_lL,cs_lL, bk_tL,ss_tL,sc_tL,cs_tL "
              print " iteraction strenght list have to be the same lenght for a given couple  "
              print " of atom types."
              print " In the case of type %s with type %s your input is not valid " %(g1,g2)
              print " Now exiting "
              os.exit() 

           ######################################################
           # Insertions 
           # Where calculation for this loop result will be put
           SRInsect = SR[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]
           SCInsect = SC[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]
           CSInsect = CS[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]
           SSInsect = SS[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]


           for lx in range(-SMcellrange[0],SMcellrange[0]+1) :
            for ly in range(-SMcellrange[1], SMcellrange[1]+1) :
             for lz in range(-SMcellrange[2], SMcellrange[2]+1) :
               if(A1==A2 and lx==0 and ly==0 and lz==0): continue
               P2=cella.FindPosition( A2, CellCoo=(lx,ly,lz))
               R=P2-P1
               d=math.sqrt(Numeric.sum(R*R) )
               ns = findinhisto(distList,d)
               if(ns<0):
                  print " did not find distance %f in histo for %s and %s " %(d,g1,g2)          
                  os.exit()
               if(not ns < len(bk_lL)):
                  continue

               ######################################
               # retrieve spring strenght from the lists
               #
               bk_l=bk_lL[ns]
               ss_l=ss_lL[ns]
               sc_l=sc_lL[ns]
               cs_l=cs_lL[ns]

               bk_t=bk_tL[ns]
               ss_t=ss_tL[ns]
               sc_t=sc_tL[ns]
               cs_t=cs_tL[ns]

               LmT_fact0 = Numeric.outerproduct(R,R)/(d*d)
               print LmT_fact0
               T_fact0  = identity

               expi = Numeric.reshape( Numeric.exp(complex(0.0,1.0)*SUM(TR(Q*R))), [len(Q),1,1])

               LmT_fact = expi  *  LmT_fact0
               T_fact   = expi  *  T_fact0  


               Numeric.add( SRInsect, ( - (bk_l-bk_t)*LmT_fact - bk_t * T_fact)* fattdiag,  SRInsect)

               Numeric.add(SSInsect, (- (ss_l-ss_t)*LmT_fact - ss_t * T_fact)* fattdiag, SSInsect)
               Numeric.add(SCInsect, (- (sc_l-sc_t)*LmT_fact - sc_t * T_fact)* fattdiag, SCInsect)
               Numeric.add(CSInsect, (- (cs_l-cs_t)*LmT_fact - cs_t * T_fact)* fattdiag, CSInsect)


               SRself=SRself - (bk_l-bk_t)*LmT_fact0 - bk_t * T_fact0
               SSself=SSself - (ss_l-ss_t)*LmT_fact0 - ss_t * T_fact0
               SCself=SCself - (sc_l-sc_t)*LmT_fact0 - sc_t * T_fact0
               CSself=CSself - (cs_l-cs_t)*LmT_fact0 - cs_t * T_fact0


        for selfterm, matrix,sf2 in [ ( SRself, SR, SRself    ), 
                                      ( SSself, SS, SSself    ),
                                      ( 2*SCself, SC0, 2*CSself    ),
                                      ( 2*CSself, CS0, 2*SCself    )  
                                    ]:
           if (len(Numeric.shape(selfterm))==0): continue
           InsectA = matrix[:,  i1*3 : 3+i1*3, i1*3 : i1*3+3  ]
           Numeric.add(InsectA, -selfterm*0.5 , InsectA)
           if(i1!=i2):
             InsectA =matrix[:,  i2*3 : 3+i2*3, i2*3 : i2*3+3  ]
             Numeric.add(InsectA, -conj(TR(sf2)*0.5) , InsectA)


        #################################################################3
        # ADD THE OTHER INTERACTIONS
        # Insertion

        BMself=Numeric.zeros([3,3],Numeric.Float64)
        LJself=Numeric.zeros([3,3],Numeric.Float64)
        VWself=Numeric.zeros([3,3],Numeric.Float64)

        print "  ADD THE OTHER INTERACTIONS "
        Insect = res[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]

        for lx in range(-cellrange[0], cellrange[0]+1) :
         for ly in range(-cellrange[1], cellrange[1]+1) :
          for lz in range(-cellrange[2], cellrange[2]+1) :

            if(A1==A2 and lx==0 and ly==0 and lz==0): continue

            P2=cella.FindPosition( A2, CellCoo=(lx,ly,lz))

            R=P2-P1
            d=math.sqrt(Numeric.sum(R*R) )

            LmT_fact0 = Numeric.outerproduct(R,R)/(d*d)
            T_fact0   = identity

            expi = Numeric.reshape( Numeric.exp(complex(0.0,1.0)*SUM(TR(Q*R))), [len(Q),1,1])

            LmT_fact = expi  *  LmT_fact0
            T_fact   = expi  *  T_fact0  

            # BORN MAYER
            sigma=(BMsigma1+BMsigma2)*1.0
            dum= BM_V0*math.exp(-d/sigma)/sigma
            L= dum/sigma
            T=-dum/d
            # Insertion

            Numeric.add(Insect, (- (L-T)*LmT_fact - T * T_fact)* fattdiag, Insect)
            BMself=BMself - (L-T)*LmT_fact0 - T * T_fact0

            # LENNARD-JONES
            sigma=(LJsigma1+LJsigma2)*1.0/d
            dum1= math.exp(12.0*math.log(sigma )) 
            dum2= math.exp( 6.0*math.log(sigma ))
            L= LJ_V0*6.0/d/d*(26*dum1-7*dum1)
            T=-LJ_V0*6.0/d/d*( 2*dum1-  dum1)
            # Insertion

            Numeric.add(Insect, (- (L-T)*LmT_fact - T * T_fact)* fattdiag, Insect)
            LJself=LJself - (L-T)*LmT_fact0 - T * T_fact0

            # van der WAALS
            sigma=(VWsigma1+VWsigma2)*1.0/d
            dum= math.exp( 6.0*math.log(sigma ))
            L= -42*VW_V0/d/d*dum
            T=   6*VW_V0/d/d*dum
            # Insertion

            Numeric.add(Insect, (- (L-T)*LmT_fact - T * T_fact)* fattdiag, Insect)
            VWself=VWself - (L-T)*LmT_fact0 - T * T_fact0

        for selfterm, matrix in [ (BMself,res ), ( LJself, res  ), (VWself, res)  ]:

           InsectA = matrix[:,  i1*3 : 3+i1*3, i1*3 : i1*3+3  ]
           Numeric.add(InsectA, -selfterm*0.5 , InsectA)
           if(i1!=i2):
             InsectA =matrix[:,  i2*3 : 3+i2*3, i2*3 : i2*3+3  ]
             Numeric.add(InsectA, -conj(TR(selfterm))*0.5 , InsectA)


        #################################################################3
        # ADD SCREENED COULOMB
        # Insertion

        Debself=Numeric.zeros([3,3],Numeric.Float64)

        print " ADD SCREENED COULOMB  "
        Insect = DebC[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]
        if(not fastcalc):
         for lx in range(-debyerange[0], debyerange[0]+1) :
          for ly in range(-debyerange[1], debyerange[1]+1) :
           for lz in range(-debyerange[2], debyerange[2]+1) :

            if(A1==A2 and lx==0 and ly==0 and lz==0): continue

            P2=cella.FindPosition( A2, CellCoo=(lx,ly,lz))

            R=P2-P1
            d=math.sqrt(Numeric.sum(R*R) )

            LmT_fact0 = Numeric.outerproduct(R,R)/(d*d)
            T_fact0   = identity

            expi = Numeric.reshape( Numeric.exp(complex(0.0,1.0)*SUM(TR(Q*R))), [len(Q),1,1])

            LmT_fact = expi  *  LmT_fact0
            T_fact   = expi  *  T_fact0  

            # SCREENED COULOMB

            L  = 2*math.exp( -debye*d ) * ( 1/d/d/d  +debye/d/d +0.5*debye*debye/d   )
            T  = (- math.exp( -debye*d ) * ( 1/d/d    +debye/d) )/d

 
            # Insertion

            Numeric.add(Insect, (- (L-T)*LmT_fact - T * T_fact)* fattdiag, Insect)

            Debself=Debself +(- (L-T)*LmT_fact0 - T * T_fact0)
        ################################################################################3
        # The above loop can be substituted by a C++ function taking as argument
        # sigmacellrange[0], sigmacellrange[1], sigmacellrange[3], cella.cellvectors[0,1,2],Q,
        #  DR, sigmacharge, TermtoaddtoInsect, Cself)
        #
        else:

          TermtoaddtoInsect= Numeric.zeros([len(Q), 3, 3 ]  , Numeric.Complex64 )
          addtoCself= Numeric.zeros([ 3, 3 ]  , Numeric.Complex64 )

          OP_fastRsumDebye(  debyerange[0], debyerange[1], debyerange[2], cella.cellvectors[0],
                        cella.cellvectors[1],cella.cellvectors[2], Q,
                        DR,  debye , TermtoaddtoInsect, addtoCself)

          TermtoaddtoInsect=TermtoaddtoInsect * fattdiag

          Debself=Debself+ addtoCself
          Numeric.add(Insect,  TermtoaddtoInsect , Insect) 


        InsectA = DebVC0[:,  i1*3 : 3+i1*3, i1*3 : i1*3+3  ]
        Numeric.add(InsectA, -Debself*Z2 , InsectA)
        if(i1!=i2):
          InsectA =DebVC0[:,  i2*3 : 3+i2*3, i2*3 : i2*3+3  ]
          Numeric.add(InsectA, -conj(TR(Debself*Z1)) , InsectA)


  ################################################3
  # simmetrising
  print "simmetrising"


  C=C+ Numeric.conjugate(Numeric.swapaxes(C, 1,2 )  )
  DebC=DebC+ Numeric.conjugate(Numeric.swapaxes(DebC, 1,2 )  )
  SR=SR+Numeric.conjugate(Numeric.swapaxes(SR, 1,2 )  )
  SCnew=SC  +Numeric.conjugate(Numeric.swapaxes(CS   , 1,2 )  )
  CSnew=CS  +Numeric.conjugate(Numeric.swapaxes(SC   , 1,2 )  )
  SS=SS  +Numeric.conjugate(Numeric.swapaxes(SS   , 1,2 )  )

  res=res  +Numeric.conjugate(Numeric.swapaxes(res   , 1,2 )  )

  SC=SCnew+SC0
  CS=CSnew+CS0

  ################################################3
  # Prepares the result
  class result:
    pass
  result.others=res
  result.Za=Zarray
  result.Ma=Marray
  result.Ya=Yarray
  result.Ka=Karray
  result.C=C
  result.SR=SR
  result.SC=SC
  result.CS=CS
  result.SS=SS
  result.SC0=SC0
  result.CS0=CS0
  print 'Zarray ', Zarray
  result.VC0z=VC0z
  result.VC0y=VC0y

  result.DebC=DebC
  result.DebVC0=DebVC0
  # result.DebVC0=Numeric.swapaxes(Numeric.swapaxes(DebVC0,1,2)/Zarray,1,2)

  return result

            



def contributionsCoulomb(cella, Parameters,Q,  Kcellrange=[2,2,2],  sigmacellrange=[2,2,2],
	 sigmacharge=2.0, fastcalc=0):



  TR=Numeric.transpose
  SUM=Numeric.sum


  #########################################################3
  # find the dimensions ( How many sites in the cell )
  N=Numeric.sum(map(len, cella.PositionsList))


  ##########################################
  # create the Matrix for Coulomb interactios
  C=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  VC0z=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )

  ##########################################
  # create an array containing Z
  Zarray =Numeric.zeros( [  3*N ]  , Numeric.Float64 )


 
 


  ##################################3333
  # an useful matrix : identity
  identity = Numeric.array([[1.0,0.0,0.0],[0.0,1.0,0.0],[0.0,0.0,1.0]])



  #####################################################
  # p is is the factor in the gaussian exponent :
  #  charge density is written as Z*(p/pi)**1.5*exp(-p*r**2)
  #
  p=1.0/(2*sigmacharge*sigmacharge)

  brilldecompose=LinearAlgebra.inverse(TR(cella.Brillvectors))
  shiftzero=Numeric.dot(brilldecompose, Q[0])
  intzero  =MLab.floor(shiftzero)
  Qshift   =Numeric.dot(intzero, cella.Brillvectors)

  TR=Numeric.transpose
  SUM=Numeric.sum


  for i1 in range(0,len(cella.atomlist)):
     A1= cella.atomlist[i1]
     g1=cella.DGroups[A1]
     P1=cella.FindPosition( A1, CellCoo=(0,0,0))

     Z1       =Parameters.Z_  [g1]

     Zarray[i1*3:i1*3+3 ]=Z1


     for i2 in range(i1,len(cella.atomlist)):
        #####################################################"
        # this factor for diagonal terms is 0.5 because
        # each matrix will be symmetrized later, so diagonal 3X3 blocks are
        # counted twice

        if(i1!=i2):
            fattdiag=1
        else:
            fattdiag=0.5

        A2= cella.atomlist[i2]
        g2=cella.DGroups[A2]

        Z2       =Parameters.Z_  [g2]
       
        # Insertion for Coulomb
        Insect = C[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]

        conj=Numeric.conjugate
        P2=cella.FindPosition( A2, CellCoo=(0,0,0))
        
        DR=P2-P1
        #################################################################
        # ADD COULOMB FROM SMEARED CHARGES
        #
        Cself=Numeric.zeros([3,3],Numeric.Complex64)
        print " ADD COULOMB FROM SMEARED CHARGES "


        Q=Q-Qshift # to be reversed later

        #######################################################
        # loop over the vectors of the reciprocal lattice
        #
        if(not fastcalc):
         for kx in range(-Kcellrange[0], Kcellrange[0]+1)  :
          for ky in range(-Kcellrange[1], Kcellrange[1]+1) :
           for kz in range(-Kcellrange[2], Kcellrange[2]+1) :
             G=Numeric.dot( Numeric.array([kx,ky,kz]) , cella.Brillvectors)
             QpG=Q+G
             ########################################################
             # outer product by using reshape : ask the guru
             #
             T3X3= Numeric.reshape(QpG,[len(Q),3,1]) * Numeric.reshape(QpG,[len(Q),1,3])
             #################################
             # squared modulus of G+Q
             #
             QpG2 = Numeric.sum( TR( QpG * QpG))

             #############################################
             # fourier transform of a gaussian is a gaussian
             # espo is its exponent
             #
             espo =  QpG2/(4.0*p)
             Numeric.putmask(espo, Numeric.greater(espo,40.0), 40.0)

             Numeric.add(Insect, TR(   TR(T3X3) / TR(QpG2) * 
                               TR( Numeric.exp(-espo  +
                                         complex(0.0,-1.0)*Numeric.sum((G-Qshift)*DR)
                                      )
                                 )
                              ) *(4*math.pi/cella.volume)    * fattdiag
                         , Insect)


             ########################################
             # add contributions for the self term
             # Diskard G=0 case that would give a floatinf point error
             # and that is in any case   a flat contribution with null  derivative
             #
             if( kx!=0 or ky!=0 or kz!=0):
               T3X3=Numeric.outerproduct(G,G)
               G2  =Numeric.sum(G*G)
               espo = G2/(4.0*p)
               if(espo>40): espo=40.0

               ###############################################
               # self term 
               #
               Cself=Cself+    ( T3X3 / G2 * 
                                Numeric.exp(-espo  +
                                         complex(0.0,-1.0)*Numeric.sum(G*DR)
                                      )
                               
                         ) *(4*math.pi/cella.volume)

        ################################################################################3
        # The above loop can be substituted by a C++ function taking as argument
        # Kcellrange[0], Kcellrange[1], Kcellrange[3], cella.Brillvectors[0,1,2],Q,
        #  DR, sigmacharge, TermtoaddtoInsect, Cself)
        #
        else:
          TermtoaddtoInsect= Numeric.zeros([len(Q), 3, 3 ]  , Numeric.Complex64 )
          addtoCself= Numeric.zeros([ 3, 3 ]  , Numeric.Complex64 )
          OP_fastGsum(  Kcellrange[0], Kcellrange[1], Kcellrange[2], cella.Brillvectors[0],
                        cella.Brillvectors[1],cella.Brillvectors[2], Q,
                        DR,  sigmacharge , TermtoaddtoInsect, addtoCself,Qshift)

          TermtoaddtoInsect=TermtoaddtoInsect*(4*math.pi/cella.volume) * fattdiag
          Cself=Cself+ addtoCself*(4*math.pi/cella.volume) 

          Numeric.add(Insect,  TermtoaddtoInsect , Insect) 
              
        Q=Q+Qshift      
        #######################################################################
        # the Fourier transform terms are obtained by summing over a whole
        # lattice. That include also the conbtribution of a site on the same site itself :( :
        #  we have to remove it 
        # NOTA BENE:
        #   that would be unnecessary in the case of rigid Ion because
        #   the spurious contributions to insect and to Cself would elide
        #   each other. But as we consider polarizable shells, Cself
        #   and Insect have a life of their own
        #
        if(i1==i2):
           sq=math.sqrt(p/math.pi)
           ###################################################"
           # the field at the center of the sphere has a simple
           # linear dependance on the radius, proportional to
           # the charge density
           #
           add= identity*(4.0*math.pi/3.0 *sq*sq*sq)
           Numeric.add(Insect, -add*0.5  , Insect) # removes the undue self term
           Cself=Cself -add

        #########################################################
        # subtract  the 3X3 self term to the VC0 self term matrix
        # 
        InsectA = VC0z[:,  i1*3 : 3+i1*3, i1*3 : i1*3+3  ]
        Numeric.add(InsectA, -Cself*Z2 , InsectA)
        if(i1!=i2):
          InsectA = VC0z[:,  i2*3 : 3+i2*3, i2*3 : i2*3+3  ]
          Numeric.add(InsectA, -conj(TR(Cself)*Z1) , InsectA)

        
        ##############################################################33
        #  ADD THE MISSED PART OF THE SMEARED CHARGE
        #    the part of the gaussian distribution exceeding 
        #    in radius the interacting atom distance
        #
        Cself=Numeric.zeros([3,3],Numeric.Float64)
        print " ADD THE MISSED PART OF THE SMEARED CHARGE "
        if(not fastcalc):
         for lx in range(-sigmacellrange[0], sigmacellrange[0]+1) :
          for ly in range(-sigmacellrange[1], sigmacellrange[1]+1) :
           for lz in range(-sigmacellrange[2], sigmacellrange[2]+1) :
            if(A1==A2 and lx==0 and ly==0 and lz==0): continue
            P2=cella.FindPosition( A2, CellCoo=(lx,ly,lz))
            R=P2-P1
            d=math.sqrt(Numeric.sum(R*R) )

            LmT_fact0 = Numeric.outerproduct(R,R)/(d*d)
            T_fact0   = identity

            expi = Numeric.reshape( Numeric.exp(complex(0.0,1.0)*SUM(TR(Q*R))), [len(Q),1,1])

            LmT_fact = expi  *  LmT_fact0
            T_fact   = expi  *  T_fact0  

            ####################################################################"
            #  We are adding the potential of the outer charge as if it were
            # at the site center, minus the actual contribution of the gaussian
            # tail going from r to infinity
            # 

            p= 1.0/(2.0*sigmacharge*sigmacharge)
            esp = math.exp(-p*d*d)
            integral = math.sqrt(math.pi/4.0/p)*(1-Numeric.erf(math.sqrt(p) * d ))
            Der1=-1.0/d*(integral/d + esp  )
            Der2=2*( 1.0/d/d*(integral/d + esp ) + p*esp)
            fact=2*math.sqrt(p/math.pi)
            L= fact*Der2
            T= fact*Der1/d

            Numeric.add(Insect, (- (L-T)*LmT_fact - T * T_fact) * fattdiag, Insect)

            ###############################################
            # 
            # 
            #

            Cself=Cself+(-(L-T)*LmT_fact0 - T * T_fact0)

        ################################################################################3
        # The above loop can be substituted by a C++ function taking as argument
        # sigmacellrange[0], sigmacellrange[1], sigmacellrange[3], cella.cellvectors[0,1,2],Q,
        #  DR, sigmacharge, TermtoaddtoInsect, Cself)
        #
        else:

          TermtoaddtoInsect= Numeric.zeros([len(Q), 3, 3 ]  , Numeric.Complex64 )
          addtoCself= Numeric.zeros([ 3, 3 ]  , Numeric.Complex64 )

          OP_fastRsum(  sigmacellrange[0], sigmacellrange[1], sigmacellrange[2], cella.cellvectors[0],
                        cella.cellvectors[1],cella.cellvectors[2], Q,
                        DR,  sigmacharge , TermtoaddtoInsect, addtoCself)

          TermtoaddtoInsect=TermtoaddtoInsect * fattdiag

          Cself=Cself+ addtoCself
          Numeric.add(Insect,  TermtoaddtoInsect , Insect) 


        #########################################################
        # subtract  the 3X3 self term to the VC0 self term matrix
        # 
        InsectA = VC0z[:,  i1*3 : 3+i1*3, i1*3 : i1*3+3  ]
        Numeric.add(InsectA, -Cself*Z2 , InsectA)
        if(i1!=i2):
          InsectA = VC0z[:,  i2*3 : 3+i2*3, i2*3 : i2*3+3  ]
          Numeric.add(InsectA, -conj(TR(Cself)*Z1) , InsectA)



  ################################################3
  # simmetrising
  print "simmetrising"


  C=C+ Numeric.conjugate(Numeric.swapaxes(C, 1,2 )  )


  ################################################3
  # Prepares the result
  class result:
    pass
  result.Za=Zarray
  result.C=C
  result.VC0z=VC0z

  return result








def contributionsCoulombScreened(cella, Parameters,Q,  Kcellrange=[2,2,2], sigmacharge=0.5, fastcalc=0):

  TR=Numeric.transpose
  SUM=Numeric.sum


  #########################################################3
  # find the dimensions ( How many sites in the cell )
  N=Numeric.sum(map(len, cella.PositionsList))


  ##########################################
  # create the Matrix for Coulomb interactios
  C=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  VC0z=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )

  ##########################################
  # create an array containing Z
  Zarray =Numeric.zeros( [  3*N ]  , Numeric.Float64 )

  ##################################3333
  # an useful matrix : identity
  identity = Numeric.array([[1.0,0.0,0.0],[0.0,1.0,0.0],[0.0,0.0,1.0]])



  #####################################################
  # p is is the factor in the gaussian exponent :
  #  charge density is written as Z*(p/pi)**1.5*exp(-p*r**2)
  #
  # sigmacharge=0.001 # point charge
  p=1.0/(2*sigmacharge*sigmacharge)

  brilldecompose=LinearAlgebra.inverse(TR(cella.Brillvectors))
  shiftzero=Numeric.dot(brilldecompose, Q[0])
  intzero  =MLab.floor(shiftzero)
  Qshift   =Numeric.dot(intzero, cella.Brillvectors)

  TR=Numeric.transpose
  SUM=Numeric.sum
  SCREENING_FUNCTION = Parameters.SCREENING_FUNCTION

  for i1 in range(0,len(cella.atomlist)):
     print i1, "  of ", len(cella.atomlist)

     A1= cella.atomlist[i1]
     g1=cella.DGroups[A1]
     P1=cella.FindPosition( A1, CellCoo=(0,0,0))

     Z1       =Parameters.Z_  [g1]

     Zarray[i1*3:i1*3+3 ]=Z1


     for i2 in range(i1,len(cella.atomlist)):
        print i2, "  of ",i1," to ",  len(cella.atomlist)
        #####################################################"
        # this factor for diagonal terms is 0.5 because
        # each matrix will be symmetrized later, so diagonal 3X3 blocks are
        # counted twice

        if(i1!=i2):
            fattdiag=1
        else:
            fattdiag=0.5

        A2= cella.atomlist[i2]
        g2=cella.DGroups[A2]

        Z2       =Parameters.Z_  [g2]
       
        # Insertion for Coulomb
        Insect = C[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]

        conj=Numeric.conjugate
        P2=cella.FindPosition( A2, CellCoo=(0,0,0))
        
        DR=P2-P1
        #################################################################
        # ADD COULOMB WITH A SMEARING FUNCTION
        #
        Cself=Numeric.zeros([3,3],Numeric.Complex64)
        print " ADD COULOMB WITH A SCREENING FUNCTION"


        Q=Q-Qshift # to be reversed later

        #######################################################
        # loop over the vectors of the reciprocal lattice
        #
        if(not fastcalc):
         for kx in range(-Kcellrange[0], Kcellrange[0]+1)  :
          for ky in range(-Kcellrange[1], Kcellrange[1]+1) :
           for kz in range(-Kcellrange[2], Kcellrange[2]+1) :
             G=Numeric.dot( Numeric.array([kx,ky,kz]) , cella.Brillvectors)
             QpG=Q+G
             ########################################################
             # outer product by using reshape : ask the guru
             #
             T3X3= Numeric.reshape(QpG,[len(Q),3,1]) * Numeric.reshape(QpG,[len(Q),1,3])
             SFF = Parameters().SCREENING_FUNCTION(QpG)
             T3X3 = TR(TR(T3X3)*TR(SFF))
             #################################
             # squared modulus of G+Q
             #
             QpG2 = Numeric.sum( TR( QpG * QpG))

             #############################################
             # fourier transform of a gaussian is a gaussian
             # espo is its exponent
             #
             espo =  QpG2/(4.0*p)
             Numeric.putmask(espo, Numeric.greater(espo,40.0), 40.0)

             Numeric.add(Insect, TR(   TR(T3X3) / TR(QpG2) * 
                               TR( Numeric.exp(-espo  +
                                         complex(0.0,-1.0)*Numeric.sum((G-Qshift)*DR)
                                      )
                                 )
                              ) *(4*math.pi/cella.volume)    * fattdiag
                         , Insect)


             ########################################
             # add contributions for the self term
             # Diskard G=0 case that would give a floatinf point error
             # and that is in any case   a flat contribution with null  derivative
             #
             if( kx!=0 or ky!=0 or kz!=0):

               T3X3=Numeric.outerproduct(G,G)
               SFF = Parameters().SCREENING_FUNCTION(G)
               T3X3 = T3X3*SFF
               
               G2  =Numeric.sum(G*G)
               espo = G2/(4.0*p)
               if(espo>40): espo=40.0

               ###############################################
               # self term 
               #
               Cself=Cself+    ( T3X3 / G2 * 
                                Numeric.exp(-espo  +
                                         complex(0.0,-1.0)*Numeric.sum(G*DR)
                                      )
                               
                         ) *(4*math.pi/cella.volume)

        ################################################################################3
        # The above loop can be substituted by a C++ function taking as argument
        # Kcellrange[0], Kcellrange[1], Kcellrange[3], cella.Brillvectors[0,1,2],Q,
        #  DR, sigmacharge, TermtoaddtoInsect, Cself)
        #
        else:
            raise " fastcalc not active yet in routine contributionsCoulombScreened "
#          TermtoaddtoInsect= Numeric.zeros([len(Q), 3, 3 ]  , Numeric.Complex64 )
#           addtoCself= Numeric.zeros([ 3, 3 ]  , Numeric.Complex64 )
#           OP_fastGsumScreened(  Kcellrange[0], Kcellrange[1], Kcellrange[2], cella.Brillvectors[0],
#                         cella.Brillvectors[1],cella.Brillvectors[2], Q,
#                         DR,  sigmacharge , TermtoaddtoInsect, addtoCself,Qshift)

#           TermtoaddtoInsect=TermtoaddtoInsect*(4*math.pi/cella.volume) * fattdiag
#           Cself=Cself+ addtoCself*(4*math.pi/cella.volume) 

#           Numeric.add(Insect,  TermtoaddtoInsect , Insect) 
              
        Q=Q+Qshift      
        #######################################################################
        # the Fourier transform terms are obtained by summing over a whole
        # lattice. That include also the conbtribution of a site on the same site itself :( :
        #  we have to remove it 
        # NOTA BENE:
        #   that would be unnecessary in the case of rigid Ion because
        #   the spurious contributions to insect and to Cself would elide
        #   each other. But as we consider polarizable shells, Cself
        #   and Insect have a life of their own
        if(i1==i2):
           sq=math.sqrt(p/math.pi)
           ###################################################"
           # the field at the center of the sphere has a simple
           # linear dependance on the radius, proportional to
           # the charge density
           #
           add= identity*(4.0*math.pi/3.0 *sq*sq*sq)
           Numeric.add(Insect, -add*0.5  , Insect) # removes the undue self term
           Cself=Cself -add

        #########################################################
        # subtract  the 3X3 self term to the VC0 self term matrix
        # 
        InsectA = VC0z[:,  i1*3 : 3+i1*3, i1*3 : i1*3+3  ]
        Numeric.add(InsectA, -Cself*Z2 , InsectA)
        if(i1!=i2):
          InsectA = VC0z[:,  i2*3 : 3+i2*3, i2*3 : i2*3+3  ]
          Numeric.add(InsectA, -conj(TR(Cself)*Z1) , InsectA)

 
  ################################################3
  # simmetrising
  print "simmetrising"


  C=C+ Numeric.conjugate(Numeric.swapaxes(C, 1,2 )  )


  ################################################3
  # Prepares the result
  class result:
    pass
  result.Za=Zarray
  result.C=C
  result.VC0z=VC0z

  return result







def contributionsShellModel(cella, Parameters,Q, 
	SMcellrange=[2,2,2], ):

  #########################################################3
  # find the dimensions ( How many sites in the cell )
  N=Numeric.sum(map(len, cella.PositionsList))

  #############################################################
  # create the result for "easy interactions"
  res=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )

  ##########################################
  # create an array containing shell charges Y
  Yarray =Numeric.zeros( [  3*N ]  , Numeric.Float64 )

  ###################################################
  # create an array containing force constants K
  Karray =Numeric.zeros( [  3*N ]  , Numeric.Float64 )
 
  ##########################################
  # create the Matrices  for Shells model
  SR=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  SC=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  CS=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  SS=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  SC0=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  CS0=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )


  ##################################3333
  # an useful matrix : identity
  identity = Numeric.array([[1.0,0.0,0.0],[0.0,1.0,0.0],[0.0,0.0,1.0]])

  TR=Numeric.transpose
  SUM=Numeric.sum
  conj=Numeric.conjugate

  for i1 in range(0,len(cella.atomlist)):
     A1= cella.atomlist[i1]
     print A1
     print cella.DGroups
     g1=cella.DGroups[A1]
     P1=cella.FindPosition( A1, CellCoo=(0,0,0))

     Y1       =Parameters.Y_  [g1]
     K1       =Parameters.K_  [g1]

     Yarray[i1*3:i1*3+3 ]=Y1
     Karray[i1*3:i1*3+3 ]=K1

     for i2 in range(i1,len(cella.atomlist)):
        #####################################################"
        # this factor for diagonal terms is 0.5 because
        # each matrix will be symmetrized later, so diagonal 3X3 blocks are
        # counted twice

        if(i1!=i2):
            fattdiag=1
        else:
            fattdiag=0.5

        A2= cella.atomlist[i2]
        g2=cella.DGroups[A2]
        Y2       =Parameters.Y_  [g2]
       

        P2=cella.FindPosition( A2, CellCoo=(0,0,0))
        
        DR=P2-P1
         
        ###################################################################
        #  ADD THE SHELL MODEL
        #
        SRself=Numeric.zeros([3,3],Numeric.Float64)
        SSself=Numeric.zeros([3,3],Numeric.Float64)
        SCself=Numeric.zeros([3,3],Numeric.Float64)
        CSself=Numeric.zeros([3,3],Numeric.Float64)

        if ( len(Parameters.BK_L[g1][g2])!=0 ):
           print "ADD THE SHELL MODEL"

           ####################################################"
           # a sorted list of possible  radius for  A1-A2 interactions
           distList=cella.histo[g1][g2]

           #################################################################
           # retrieve lists of springs strenghts
           #
           bk_lL= Parameters.BK_L[g1][g2]
           ss_lL= Parameters.SM_L[g1][g2]['SS']
           sc_lL= Parameters.SM_L[g1][g2]['SC']
           cs_lL= Parameters.SM_L[g1][g2]['CS']

           bk_tL= Parameters.BK_T[g1][g2]
           ss_tL= Parameters.SM_T[g1][g2]['SS']
           sc_tL= Parameters.SM_T[g1][g2]['SC']
           cs_tL= Parameters.SM_T[g1][g2]['CS']

           if (map(len , [bk_lL,ss_lL,sc_lL,cs_lL, bk_tL,ss_tL,sc_tL,cs_tL])!= [len(bk_lL)]*8 ):
              print " I am sorry but all the bk_lL,ss_lL,sc_lL,cs_lL, bk_tL,ss_tL,sc_tL,cs_tL "
              print " iteraction strenght list have to be the same lenght for a given couple  "
              print " of atom types."
              print " In the case of type %s with type %s your input is not valid " %(g1,g2)
              print " Now exiting "
              os.exit() 

           ######################################################
           # Insertions 
           # Where calculation for this loop result will be put

           SRInsect = SR[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]
           SCInsect = SC[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]
           CSInsect = CS[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]
           SSInsect = SS[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]


           for lx in range(-SMcellrange[0],SMcellrange[0]+1) :
            for ly in range(-SMcellrange[1], SMcellrange[1]+1) :
             for lz in range(-SMcellrange[2], SMcellrange[2]+1) :
               if(A1==A2 and lx==0 and ly==0 and lz==0): continue
               P2=cella.FindPosition( A2, CellCoo=(lx,ly,lz))
               R=P2-P1
               d=math.sqrt(Numeric.sum(R*R) )
               ns = findinhisto(distList,d)
               if(ns<0):
                  print " did not find distance %f in histo for %s and %s " %(d,g1,g2)          
                  os.exit()
               if(not ns < len(bk_lL)):
                  continue

               ######################################
               # retrieve spring strenght from the lists
               #
               bk_l=bk_lL[ns]
               ss_l=ss_lL[ns]
               sc_l=sc_lL[ns]
               cs_l=cs_lL[ns]

               bk_t=bk_tL[ns]
               ss_t=ss_tL[ns]
               sc_t=sc_tL[ns]
               cs_t=cs_tL[ns]

               LmT_fact0 = Numeric.outerproduct(R,R)/(d*d)
               print LmT_fact0
               T_fact0  = identity

               expi = Numeric.reshape( Numeric.exp(complex(0.0,1.0)*SUM(TR(Q*R))), [len(Q),1,1])

               LmT_fact = expi  *  LmT_fact0
               T_fact   = expi  *  T_fact0  


               Numeric.add( SRInsect, ( - (bk_l-bk_t)*LmT_fact - bk_t * T_fact)* fattdiag,  SRInsect)

               Numeric.add(SSInsect, (- (ss_l-ss_t)*LmT_fact - ss_t * T_fact)* fattdiag, SSInsect)
               Numeric.add(SCInsect, (- (sc_l-sc_t)*LmT_fact - sc_t * T_fact)* fattdiag, SCInsect)
               Numeric.add(CSInsect, (- (cs_l-cs_t)*LmT_fact - cs_t * T_fact)* fattdiag, CSInsect)


               SRself=SRself - (bk_l-bk_t)*LmT_fact0 - bk_t * T_fact0
               SSself=SSself - (ss_l-ss_t)*LmT_fact0 - ss_t * T_fact0
               SCself=SCself - (sc_l-sc_t)*LmT_fact0 - sc_t * T_fact0
               CSself=CSself - (cs_l-cs_t)*LmT_fact0 - cs_t * T_fact0


        for selfterm, matrix,sf2 in [ ( SRself, SR, SRself    ), 
                                      ( SSself, SS, SSself    ),
                                      ( 2*SCself, SC0, 2*CSself    ),
                                      ( 2*CSself, CS0, 2*SCself    )  
                                    ]:
           if (len(Numeric.shape(selfterm))==0): continue
           InsectA = matrix[:,  i1*3 : 3+i1*3, i1*3 : i1*3+3  ]
           Numeric.add(InsectA, -selfterm*0.5 , InsectA)
           if(i1!=i2):
             InsectA =matrix[:,  i2*3 : 3+i2*3, i2*3 : i2*3+3  ]
             Numeric.add(InsectA, -conj(TR(sf2)*0.5) , InsectA)


  ################################################3
  # simmetrising
  print "simmetrising"


  SR=SR+Numeric.conjugate(Numeric.swapaxes(SR, 1,2 )  )
  SCnew=SC  +Numeric.conjugate(Numeric.swapaxes(CS   , 1,2 )  )
  CSnew=CS  +Numeric.conjugate(Numeric.swapaxes(SC   , 1,2 )  )
  SS=SS  +Numeric.conjugate(Numeric.swapaxes(SS   , 1,2 )  )


  SC=SCnew+SC0
  CS=CSnew+CS0

  ################################################3
  # Prepares the result
  class result:
    pass

  result.Ya=Yarray
  result.Ka=Karray

  result.SR=SR
  result.SC=SC
  result.CS=CS
  result.SS=SS
  result.SC0=SC0
  result.CS0=CS0

  return result

            
def contributionsJT (cella, Parameters,Q, 	SMcellrange=[2,2,2], ):

  print " ADDINF JT INTERACTIONS "
  JT = contributionsDFM_PTS(cella, Parameters.Tens_JT,Q, SMcellrange )

  factors = 1

  ################################################3
  # Prepares the result
  #

  class result:
    pass

  result.JT = TR(TR(JT) * factors)

  return result


def contributionsDFM(cella, Parameters,Q, 	SMcellrange=[2,2,2], ):

  P = contributionsDFM_PTS(cella, Parameters.Tens_P,Q, 	SMcellrange )
  T = contributionsDFM_PTS(cella, Parameters.Tens_T,Q, 	SMcellrange )
  S = contributionsDFM_PTS(cella, Parameters.Tens_S,Q, 	SMcellrange )

  ################################################3
  # Prepares the result
  #
  class result:
    pass

  result.P = P
  result.T = T
  result.S = S

  return result

def contributionsDFM_PTS(cella, Tens_dictio,Q, 	SMcellrange=[2,2,2], ):

  #########################################################3
  # find the dimensions ( How many sites in the cell )
  N=Numeric.sum(map(len, cella.PositionsList))

  #############################################################
  # create the result f
  res=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )


  ##################################
  # an useful matrix : identity
  identity = Numeric.array([[1.0,0.0,0.0],[0.0,1.0,0.0],[0.0,0.0,1.0]])



  ################################################
  # array of simmetry rotations
  rotlist=Numeric.array(cella.RotList)
  rot_invlist=Numeric.array( map( LinearAlgebra.inverse, rotlist )         )


  TR=Numeric.transpose
  SUM=Numeric.sum
  conj=Numeric.conjugate
  DOT=Numeric.dot

  for i1 in range(0,len(cella.atomlist)):
     A1= cella.atomlist[i1]
     print A1
     print cella.DGroups
     g1=cella.DGroups[A1]
     P1=cella.FindPosition( A1, CellCoo=(0,0,0))

     for i2 in range(i1,len(cella.atomlist)):
        #####################################################"
        # this factor for diagonal terms is 0.5 because
        # each matrix will be symmetrized later, so diagonal 3X3 blocks are
        # counted twice

        if(i1!=i2):
            fattdiag=1
        else:
            fattdiag=0.5

        A2= cella.atomlist[i2]
        g2=cella.DGroups[A2]
       

        P2=cella.FindPosition( A2, CellCoo=(0,0,0))
        
        DR=P2-P1
         
        ###################################################################
        #  ADD 
        #
        Tself=Numeric.zeros([3,3],Numeric.Float64)
        if( g1  not in Tens_dictio.keys() or  g2 not in Tens_dictio[g1].keys()): continue 
	tensself=Numeric.zeros([3,3],Numeric.Float64)
        if( len(Tens_dictio[g1][g2])!=0 ):
           print "ADD THE TENSORIAL MODEL"

           ####################################################"
           # a sorted list of possible  radius for  A1-A2 interactions
           distList=cella.histo[g1][g2]

           #################################################################
           # retrieve lists of  strenghts
           #
           tens_list = Tens_dictio[g1][g2]


           ######################################################
           # Insertions 
           # Where calculation for this loop result will be put

           resInsect = res[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]




           for lx in range(-SMcellrange[0],SMcellrange[0]+1) :
            for ly in range(-SMcellrange[1], SMcellrange[1]+1) :
             for lz in range(-SMcellrange[2], SMcellrange[2]+1) :
               if(A1==A2 and lx==0 and ly==0 and lz==0): continue
               P2=cella.FindPosition( A2, CellCoo=(lx,ly,lz))
               R=P2-P1

               print " P1 ", P1
               print " P2 ", P2

               d=math.sqrt(Numeric.sum(R*R) )
               print " DISTANZA=",d

               ns = findinhisto(distList,d)
               if(ns<0):
                  raise " did not find distance %f in histo for %s and %s " %(d,g1,g2)
                  print " did not find distance %f in histo for %s and %s " %(d,g1,g2)          
                  os.exit()
               if(not ns < len(  tens_list       )):
                  continue

               print " RAGGIO TIPO ", tens_list[ns][0]

               ######################################
               # retrieve spring strenght from the lists
               #
 

               tens_r=tens_list[ns][0]
               tens_t=tens_list[ns][1]

               ##################################################
               # rotate the tensor

               trials = Numeric.dot(rotlist, tens_r)
               trials= trials - R
               trials=Numeric.sum(TR(trials*trials))

               print " R \n", R
               # print " RotList \n", rotlist

               trials = Numeric.less(trials,1.0e-8)
               nones=Numeric.sum(trials)
               if(nones<1):
                  print rotlist
                  print trials
                  raise " PROBLEM WITH ROTATIONS IN TENSORIAL FORCES ROUTINE"
               rot = rotlist[  trials.tolist().index(1)  ]
               rot_inv = rot_invlist[  trials.tolist().index(1)  ]

               tens_0 = DOT( rot,  DOT(tens_t   , rot_inv )        )

               
               # check if JT vectors are specified
               if(len(tens_list[ns])==4):
                 vec_a=DOT( rot, tens_list[ns][2])
                 vec_b=DOT( rot, tens_list[ns][3])
	         scal_a = Numeric.sin(SUM(TR(vec_a*Q)))
	         scal_b = Numeric.sin(SUM(TR(vec_b*Q)))
               else:
                 scal_a=1
                 scal_b=1                 


               # I have to put a sign minus because of the  sign convention 
               # of  N. Wakabayashi, R. H. Scherm, and H. G. Smith , 
               # \textit{Phys. Rev. B} \textbf{25} (1982)  5122-5132.
               #
               # it is because the double derivation giving the tensorial forces 
               # is done once respect to an atom's coordinates
               # an another time respecto to the other atom coordinates, 

               tens_0 = -1*tens_0

               expi = Numeric.reshape( scal_a*scal_b*Numeric.exp(complex(0.0,1.0)*SUM(TR(Q*R))), [len(Q),1,1])





               tens  = expi  *  tens_0

               Numeric.add( resInsect, tens* fattdiag,  resInsect)


               tensself=tensself +tens_0


        for selfterm, matrix,sf2 in [ ( tensself, res, tensself    ), 
                                   ]:
           if (len(Numeric.shape(selfterm))==0): continue
           InsectA = matrix[:,  i1*3 : 3+i1*3, i1*3 : i1*3+3  ]
           Numeric.add(InsectA, -selfterm*0.5 , InsectA)
           if(i1!=i2):
             InsectA =matrix[:,  i2*3 : 3+i2*3, i2*3 : i2*3+3  ]
             Numeric.add(InsectA, -conj(TR(sf2)*0.5) , InsectA)

  ################################################3
  # simmetrising
  #
  print "simmetrising"

  res=res+Numeric.conjugate(Numeric.swapaxes(res, 1,2 )  )


  return res

            
def contributionsAngleBonds(cella, Angle_dictio,   Q, 	AB_cellrange=[2,2,2], ):




  ######################################################
  # make sure that dictio is symmetric in the last two keys
  new_dict = {}
  for k1 in  Angle_dictio.keys():
      new_dict[k1]={}
      for k2 in Angle_dictio[k1].keys():
          new_dict[k1][k2]={}
          for k3 in Angle_dictio[k1][k2].keys():
              new_dict[k1][k3]={}
              
      for k2 in Angle_dictio[k1].keys():
          for k3 in Angle_dictio[k1][k2].keys():
              new_dict[k1][k2][k3]=Angle_dictio[k1][k2][k3]
              new_dict[k1][k3][k2]=Angle_dictio[k1][k2][k3]

  Angle_dictio=new_dict







  #########################################################3
  # find the dimensions ( How many sites in the cell )
  N=Numeric.sum(map(len, cella.PositionsList))

  #############################################################
  # create the result f
  res=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )


  ##################################
  # an useful matrix : identity
  identity = Numeric.array([[1.0,0.0,0.0],[0.0,1.0,0.0],[0.0,0.0,1.0]])



  ################################################
  # array of simmetry rotations
  rotlist=Numeric.array(cella.RotList)


  TR=Numeric.transpose
  SUM=Numeric.sum
  conj=Numeric.conjugate
  DOT=Numeric.dot


  for i1 in range(0,len(cella.atomlist)):
     # vertex bond 
     A1= cella.atomlist[i1]
     print cella.DGroups
     g1=cella.DGroups[A1]
     if( g1  not in Angle_dictio.keys() ): continue 
     P1=cella.FindPosition( A1, CellCoo=(0,0,0))


     for i2 in range(0,len(cella.atomlist)):

         A2= cella.atomlist[i2]
         g2=cella.DGroups[A2]
         if( g2  not in Angle_dictio[g1].keys() ): continue 
         
         
         for i3 in range(i2,len(cella.atomlist)):


             A3= cella.atomlist[i3]
             g3=cella.DGroups[A3]
             if( g3  not in Angle_dictio[g1][g2].keys() ): continue 
             
             # ##################################################################
             #  ADD 
             #
             Tself=Numeric.zeros([3,3],Numeric.Float64)
             tensself=Numeric.zeros([3,3],Numeric.Float64)


             if( len(Angle_dictio[g1][g2][g3])!=0 ):
                 print "ADD ANGLE BONDS"

                 # ###################################################"
                 # a sorted list of possible  radius for  A1-A2 interactions
                 # distList=cella.histo[g1][g2]

                 # ################################################################
                 # retrieve lists of  strenghts
                 #
                 angle_list = Angle_dictio[g1][g2][g3]


                 # #####################################################
                 # Insertions 
                 # Where calculation for this loop result will be put
                 
                 # resInsect = res[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]
		 print "-"
                 countA =  0
                 for angle_bond in angle_list:
		     countA=countA+1
                     dist1 =  angle_bond[0]
                     tol_dist1 =  angle_bond[1]
                     dist2 =  angle_bond[2]
                     tol_dist2 =  angle_bond[3]
                     
                     distmod1 = Numeric.sqrt(Numeric.sum(dist1*dist1))
                     distmod2 = Numeric.sqrt(Numeric.sum(dist2*dist2))
                     
                                             
                     rotatedtrials1 = Numeric.dot(rotlist, dist1 )
                     rotatedtrials2 = Numeric.dot(rotlist, dist2 )

                     count2 = 0
                     for lx2 in range(-AB_cellrange[0],AB_cellrange[0]+1) :
                         for ly2 in range(-AB_cellrange[1], AB_cellrange[1]+1) :
                             for lz2 in range(-AB_cellrange[2], AB_cellrange[2]+1) :

                                 count2=count2+1
                                 P2=cella.FindPosition( A2, CellCoo=(lx2,ly2,lz2))
                                 R2=P2-P1
                                 
                                 d=math.sqrt(Numeric.sum(R2*R2) )
                                 if( abs(d-distmod1)>tol_dist1): continue
 				 print " trovato un ", countA

                                 count3 = 0
                                 for lx3 in range(-AB_cellrange[0],AB_cellrange[0]+1) :
                                     for ly3 in range(-AB_cellrange[1], AB_cellrange[1]+1) :
                                         for lz3 in range(-AB_cellrange[2], AB_cellrange[2]+1) :

                                             count3=count3+1
                                             if(i2==i3 and count3<count2):
                                                 print " EVITO IL DOPPIO COUNTING "
                                                 continue


                                             P3=cella.FindPosition( A3, CellCoo=(lx3,ly3,lz3))
                                             R3=P3-P1
                                             
                                             d=math.sqrt(Numeric.sum(R3*R3) )
                                             if( abs(d-distmod2)>tol_dist2): continue

                                             # #################################################
                                             # rotate and search for superposition
                                             
                                             trials1= rotatedtrials1 - R2
                                             trials1=Numeric.sum(TR(trials1*trials1))

                                             trials2= rotatedtrials2 - R3
                                             trials2=Numeric.sum(TR(trials2*trials2))

                                             trials1 = Numeric.less(trials1,tol_dist1)
                                             
                                             trials2 = Numeric.less(trials2,tol_dist2)

                                             trials=trials1*trials2

                                             nones=Numeric.sum(trials)
                                             if(nones<1): continue

                                             strenght =2* angle_bond[4]

                                             
                                             modR2 = Numeric.sqrt(Numeric.sum(R2*R2))
                                             modR3 = Numeric.sqrt(Numeric.sum(R3*R3))
                                             v2 = R2/modR2
                                             v3 = R3/modR3
                                             c23=Numeric.sum(v2*v3)
                                             s23=Numeric.sqrt( 1.0-c23*c23  )

                                             dt2 = -1.0/s23/modR2 *( v3 - v2*c23  )
                                             dt3 = -1.0/s23/modR3 *( v2 - v3*c23  )
                                             dt1 = -dt2 -dt3


                                             # ##################################################
                                             #  TERMINE 1-2
                                             
                                             expi = Numeric.exp(complex(0.0,1.0)*SUM(TR(Q*R2)))

                                             resInsect = res[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]

                                             termToAdd = (dt1[:,None]*dt2) *expi[:,None,None] * strenght
                                             if(i1==i2):    # to compensate simmetrysation
                                                 termToAdd=termToAdd*0.5
                                             Numeric.add( resInsect,termToAdd, resInsect )

                                             
                                             # ##################################################
                                             #  TERMINE 1-3
                                             
                                             expi = Numeric.exp(complex(0.0,1.0)*SUM(TR(Q*R3)))

                                             resInsect = res[:,  i1*3 : 3+i1*3, i3*3 : i3*3+3  ]

                                             termToAdd = (dt1[:,None]*dt3) *expi[:,None,None] * strenght
                                             if(i1==i3): # to compensate symmetrisation
                                                 termToAdd=termToAdd*0.5
                                             Numeric.add( resInsect,termToAdd, resInsect )



                                             
                                             # ##################################################
                                             #  TERMINE 2-3
                                             
                                             expi = Numeric.exp(complex(0.0,1.0)*SUM(TR(Q*(R3-R2))))

                                             resInsect = res[:,  i2*3 : 3+i2*3, i3*3 : i3*3+3  ]

                                             termToAdd =( dt2[:,None]*dt3) *expi[:,None,None] * strenght
                                             if(i2==i3): # to compensate symmetrisation
                                                 termToAdd=termToAdd*0.5
                                             Numeric.add( resInsect,termToAdd, resInsect )

                                             # ##################################################
                                             #  TERMINE 1-1

                                             resInsect = res[:,  i1*3 : 3+i1*3, i1*3 : i1*3+3  ]

                                             termToAdd = dt1[:,None]*dt1  * strenght*0.5
                                             Numeric.add( resInsect,termToAdd, resInsect )
                                             
                                             # ##################################################
                                             #  TERMINE 3-3

                                             resInsect = res[:,  i3*3 : 3+i3*3, i3*3 : i3*3+3  ]

                                             termToAdd = dt3[:,None]*dt3 * strenght*0.5
                                             Numeric.add( resInsect,termToAdd, resInsect )
                                             
                                             # ##################################################
                                             #  TERMINE 2-2

                                             resInsect = res[:,  i2*3 : 3+i2*3, i2*3 : i2*3+3  ]

                                             termToAdd = dt2[:,None]*dt2*strenght*0.5
                                             Numeric.add( resInsect,termToAdd, resInsect )





                                             
  ################################################3
  # simmetrising
  #
  print "simmetrising"

  res=res+Numeric.conjugate(Numeric.swapaxes(res, 1,2 )  )

  
  return res

            


































def contributionsAnalytical(cella, Parameters,Q, cellrange=[2,2,2] ):

  #########################################################3
  # find the dimensions ( How many sites in the cell )
  N=Numeric.sum(map(len, cella.PositionsList))

  #############################################################
  # create the result for "easy interactions"
  res=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )

  ##################################3333
  # an useful matrix : identity
  identity = Numeric.array([[1.0,0.0,0.0],[0.0,1.0,0.0],[0.0,0.0,1.0]])

  #######################################333
  # universal constants
  #
  VW_V0= Parameters.VW_V0
  LJ_V0= Parameters.LJ_V0
  BM_V0= Parameters.BM_V0

  TR=Numeric.transpose
  SUM=Numeric.sum

  for i1 in range(0,len(cella.atomlist)):
     A1= cella.atomlist[i1]
     g1=cella.DGroups[A1]
     P1=cella.FindPosition( A1, CellCoo=(0,0,0))
     BMsigma1=Parameters.BMs_[g1]
     LJsigma1=Parameters.LJs_[g1]
     VWsigma1=Parameters.VWs_[g1]

     for i2 in range(i1,len(cella.atomlist)):
        #####################################################"
        # this factor for diagonal terms is 0.5 because
        # each matrix will be symmetrized later, so diagonal 3X3 blocks are
        # counted twice

        if(i1!=i2):
            fattdiag=1
        else:
            fattdiag=0.5

        A2= cella.atomlist[i2]
        g2=cella.DGroups[A2]
        BMsigma2=Parameters.BMs_[g2]
        LJsigma2=Parameters.BMs_[g2]
        VWsigma2=Parameters.BMs_[g2]
       

        conj=Numeric.conjugate
        P2=cella.FindPosition( A2, CellCoo=(0,0,0))
        
        DR=P2-P1

        #################################################################3
        # ADD THE OTHER INTERACTIONS
        # Insertion

        BMself=Numeric.zeros([3,3],Numeric.Float64)
        LJself=Numeric.zeros([3,3],Numeric.Float64)
        VWself=Numeric.zeros([3,3],Numeric.Float64)

        print "  ADD THE OTHER INTERACTIONS "
        Insect = res[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]

        for lx in range(-cellrange[0], cellrange[0]+1) :
         for ly in range(-cellrange[1], cellrange[1]+1) :
          for lz in range(-cellrange[2], cellrange[2]+1) :

            if(A1==A2 and lx==0 and ly==0 and lz==0): continue

            P2=cella.FindPosition( A2, CellCoo=(lx,ly,lz))

            R=P2-P1
            d=math.sqrt(Numeric.sum(R*R) )

            LmT_fact0 = Numeric.outerproduct(R,R)/(d*d)
            T_fact0   = identity

            expi = Numeric.reshape( Numeric.exp(complex(0.0,1.0)*SUM(TR(Q*R))), [len(Q),1,1])

            LmT_fact = expi  *  LmT_fact0
            T_fact   = expi  *  T_fact0  

            # BORN MAYER
            sigma=(BMsigma1+BMsigma2)*1.0
            dum= BM_V0*math.exp(-d/sigma)/sigma
            L= dum/sigma
            T=-dum/d
            # Insertion

            Numeric.add(Insect, (- (L-T)*LmT_fact - T * T_fact)* fattdiag, Insect)
            BMself=BMself - (L-T)*LmT_fact0 - T * T_fact0

            # LENNARD-JONES
            sigma=(LJsigma1+LJsigma2)*1.0/d
            dum1= math.exp(12.0*math.log(sigma )) 
            dum2= math.exp( 6.0*math.log(sigma ))
            L= LJ_V0*6.0/d/d*(26*dum1-7*dum1)
            T=-LJ_V0*6.0/d/d*( 2*dum1-  dum1)
            # Insertion

            Numeric.add(Insect, (- (L-T)*LmT_fact - T * T_fact)* fattdiag, Insect)
            LJself=LJself - (L-T)*LmT_fact0 - T * T_fact0

            # van der WAALS
            sigma=(VWsigma1+VWsigma2)*1.0/d
            dum= math.exp( 6.0*math.log(sigma ))
            L= -42*VW_V0/d/d*dum
            T=   6*VW_V0/d/d*dum
            # Insertion

            Numeric.add(Insect, (- (L-T)*LmT_fact - T * T_fact)* fattdiag, Insect)
            VWself=VWself - (L-T)*LmT_fact0 - T * T_fact0

        for selfterm, matrix in [ (BMself,res ), ( LJself, res  ), (VWself, res)  ]:

           InsectA = matrix[:,  i1*3 : 3+i1*3, i1*3 : i1*3+3  ]
           Numeric.add(InsectA, -selfterm*0.5 , InsectA)
           if(i1!=i2):
             InsectA =matrix[:,  i2*3 : 3+i2*3, i2*3 : i2*3+3  ]
             Numeric.add(InsectA, -conj(TR(selfterm))*0.5 , InsectA)



  ################################################3
  # simmetrising
  print "simmetrising"




  res=res  +Numeric.conjugate(Numeric.swapaxes(res   , 1,2 )  )


  ################################################3
  # Prepares the result
  class result:
    pass
  result.others=res

  return result

            






def contributionsScreened(cella, Parameters,Q, 
	debye=0.3, debyerange=[2,2,2], fastcalc=0):

  #########################################################3
  # find the dimensions ( How many sites in the cell )
  N=Numeric.sum(map(len, cella.PositionsList))


  ##########################################
  # create the Matrix for Coulomb interactios
  DebC=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  DebVC0=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )

  ##########################################
  # create an array containing Z
  Zarray =Numeric.zeros( [  3*N ]  , Numeric.Float64 )




  ##################################3333
  # an useful matrix : identity
  identity = Numeric.array([[1.0,0.0,0.0],[0.0,1.0,0.0],[0.0,0.0,1.0]])


  TR=Numeric.transpose
  SUM=Numeric.sum
  conj=Numeric.conjugate

  for i1 in range(0,len(cella.atomlist)):
     A1= cella.atomlist[i1]
     print A1
     print cella.DGroups
     g1=cella.DGroups[A1]
     P1=cella.FindPosition( A1, CellCoo=(0,0,0))
     Z1       =Parameters.Z_  [g1]

     for i2 in range(i1,len(cella.atomlist)):
        #####################################################"
        # this factor for diagonal terms is 0.5 because
        # each matrix will be symmetrized later, so diagonal 3X3 blocks are
        # counted twice

        if(i1!=i2):
            fattdiag=1
        else:
            fattdiag=0.5

        A2= cella.atomlist[i2]
        g2=cella.DGroups[A2]
        Z2       =Parameters.Z_  [g2]
       

        P2=cella.FindPosition( A2, CellCoo=(0,0,0))
        

        #################################################################3
        # ADD SCREENED COULOMB
        # Insertion

        Debself=Numeric.zeros([3,3],Numeric.Float64)

        print " ADD SCREENED COULOMB  "
        Insect = DebC[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]
        if(not fastcalc):
         for lx in range(-debyerange[0], debyerange[0]+1) :
          for ly in range(-debyerange[1], debyerange[1]+1) :
           for lz in range(-debyerange[2], debyerange[2]+1) :

            if(A1==A2 and lx==0 and ly==0 and lz==0): continue

            P2=cella.FindPosition( A2, CellCoo=(lx,ly,lz))

            R=P2-P1
            d=math.sqrt(Numeric.sum(R*R) )

            LmT_fact0 = Numeric.outerproduct(R,R)/(d*d)
            T_fact0   = identity

            expi = Numeric.reshape( Numeric.exp(complex(0.0,1.0)*SUM(TR(Q*R))), [len(Q),1,1])

            LmT_fact = expi  *  LmT_fact0
            T_fact   = expi  *  T_fact0  

            # SCREENED COULOMB

            L  = 2*math.exp( -debye*d ) * ( 1/d/d/d  +debye/d/d +0.5*debye*debye/d   )
            T  = (- math.exp( -debye*d ) * ( 1/d/d    +debye/d) )/d

 
            # Insertion

            Numeric.add(Insect, (- (L-T)*LmT_fact - T * T_fact)* fattdiag, Insect)

            Debself=Debself +(- (L-T)*LmT_fact0 - T * T_fact0)
        ################################################################################3
        # The above loop can be substituted by a C++ function taking as argument
        # sigmacellrange[0], sigmacellrange[1], sigmacellrange[3], cella.cellvectors[0,1,2],Q,
        #  DR, sigmacharge, TermtoaddtoInsect, Cself)
        #
        else:
          P2=cella.FindPosition( A2, CellCoo=(0,0,0))
          DR=P2-P1
          TermtoaddtoInsect= Numeric.zeros([len(Q), 3, 3 ]  , Numeric.Complex64 )
          addtoCself= Numeric.zeros([ 3, 3 ]  , Numeric.Complex64 )

          if( debyerange[0]>=0 and debyerange[1]>=0 and debyerange[2]>=0):
            OP_fastRsumDebye(  debyerange[0], debyerange[1], debyerange[2], cella.cellvectors[0],
                        cella.cellvectors[1],cella.cellvectors[2], Q,
                        DR,  debye , TermtoaddtoInsect, addtoCself)

          TermtoaddtoInsect=TermtoaddtoInsect * fattdiag

          Debself=Debself+ addtoCself
          Numeric.add(Insect,  TermtoaddtoInsect , Insect) 


        InsectA = DebVC0[:,  i1*3 : 3+i1*3, i1*3 : i1*3+3  ]
        Numeric.add(InsectA, -Debself*Z2 , InsectA)
        if(i1!=i2):
          InsectA =DebVC0[:,  i2*3 : 3+i2*3, i2*3 : i2*3+3  ]
          Numeric.add(InsectA, -conj(TR(Debself*Z1)) , InsectA)


  ################################################3
  # simmetrising
  print "simmetrising"


  DebC=DebC+ Numeric.conjugate(Numeric.swapaxes(DebC, 1,2 )  )


  ################################################3
  # Prepares the result
  class result:
    pass

  result.DebC=DebC
  result.DebVC0=DebVC0

  return result

            





def contributionsArrays(cella, Parameters, Q):

  #########################################################3
  # find the dimensions ( How many sites in the cell )
  N=Numeric.sum(map(len, cella.PositionsList))

  #############################################################
  # create the result for "easy interactions"
  res=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )



  ##########################################
  # create an array containing Z
  Zarray =Numeric.zeros( [  3*N ]  , Numeric.Float64 )

  ##########################################
  # create an array containing Masses
  Marray =Numeric.zeros( [  3*N ]  , Numeric.Float64 )

  ##########################################
  # create an array containing shell charges Y
  Yarray =Numeric.zeros( [  3*N ]  , Numeric.Float64 )

  ###################################################
  # create an array containing force constants K
  Karray =Numeric.zeros( [  3*N ]  , Numeric.Float64 )
 


  for i1 in range(0,len(cella.atomlist)):
     A1= cella.atomlist[i1]
     g1=cella.DGroups[A1]

     Z1       =Parameters.Z_  [g1]
     M1       =Parameters.M_  [g1]
     Y1       =Parameters.Y_  [g1]
     K1       =Parameters.K_  [g1]

     Zarray[i1*3:i1*3+3 ]=Z1
     Marray[i1*3:i1*3+3 ]=M1
     Yarray[i1*3:i1*3+3 ]=Y1
     Karray[i1*3:i1*3+3 ]=K1


  ################################################3
  # Prepares the result
  class result:
    pass
  result.Za=Zarray
  result.Ma=Marray
  result.Ya=Yarray
  result.Ka=Karray


  return result

            



def contributionsScreenedCos( cella, Parameters,Q, 
	                      debye=0.3, debyerange=[2,2,2], fastcalc=0):

  #########################################################3
  # find the dimensions ( How many sites in the cell )
  N=Numeric.sum(map(len, cella.PositionsList))


  ##########################################
  # create the Matrix for Coulomb interactios
  DebC=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )
  DebVC0=Numeric.zeros( [len(Q), 3*N, 3*N ]  , Numeric.Complex64 )

  ##########################################
  # create an array containing Z
  Zarray =Numeric.zeros( [  3*N ]  , Numeric.Float64 )




  ##################################3333
  # an useful matrix : identity
  identity = Numeric.array([[1.0,0.0,0.0],[0.0,1.0,0.0],[0.0,0.0,1.0]])


  TR=Numeric.transpose
  SUM=Numeric.sum
  conj=Numeric.conjugate

  for i1 in range(0,len(cella.atomlist)):
     A1= cella.atomlist[i1]
     print A1
     print cella.DGroups
     g1=cella.DGroups[A1]
     P1=cella.FindPosition( A1, CellCoo=(0,0,0))
     Z1       =Parameters.Z_  [g1]

     for i2 in range(i1,len(cella.atomlist)):
        #####################################################"
        # this factor for diagonal terms is 0.5 because
        # each matrix will be symmetrized later, so diagonal 3X3 blocks are
        # counted twice

        if(i1!=i2):
            fattdiag=1
        else:
            fattdiag=0.5

        A2= cella.atomlist[i2]
        g2=cella.DGroups[A2]
        Z2       =Parameters.Z_  [g2]
       

        P2=cella.FindPosition( A2, CellCoo=(0,0,0))
        

        #################################################################3
        # ADD SCREENED COULOMB
        # Insertion

        Debself=Numeric.zeros([3,3],Numeric.Float64)

        print " ADD SCREENED COULOMB  "
        Insect = DebC[:,  i1*3 : 3+i1*3, i2*3 : i2*3+3  ]
        if(not fastcalc):
         for lx in range(-debyerange[0], debyerange[0]+1) :
          for ly in range(-debyerange[1], debyerange[1]+1) :
           for lz in range(-debyerange[2], debyerange[2]+1) :

            if(A1==A2 and lx==0 and ly==0 and lz==0): continue

            P2=cella.FindPosition( A2, CellCoo=(lx,ly,lz))

            R=P2-P1
            d=math.sqrt(Numeric.sum(R*R) )
            cosinus=math.sqrt(Numeric.sum( (R*R)[0:2] ) )   /d
            debye_c=debye*cosinus
            LmT_fact0 = Numeric.outerproduct(R,R)/(d*d)
            T_fact0   = identity

            expi = Numeric.reshape( Numeric.exp(complex(0.0,1.0)*SUM(TR(Q*R))), [len(Q),1,1])

            LmT_fact = expi  *  LmT_fact0
            T_fact   = expi  *  T_fact0  

            # SCREENED COULOMB

            L  = 2*math.exp( -debye_c*d ) * ( 1/d/d/d  +debye_c/d/d +0.5*debye_c*debye_c/d   )
            T  = (- math.exp( -debye_c*d ) * ( 1/d/d    +debye_c/d) )/d

 
            # Insertion

            Numeric.add(Insect, (- (L-T)*LmT_fact - T * T_fact)* fattdiag, Insect)

            Debself=Debself +(- (L-T)*LmT_fact0 - T * T_fact0)
        ################################################################################3
        # The above loop can be substituted by a C++ function taking as argument
        # sigmacellrange[0], sigmacellrange[1], sigmacellrange[3], cella.cellvectors[0,1,2],Q,
        #  DR, sigmacharge, TermtoaddtoInsect, Cself)
        #
        else:
          P2=cella.FindPosition( A2, CellCoo=(0,0,0))
          DR=P2-P1
          TermtoaddtoInsect= Numeric.zeros([len(Q), 3, 3 ]  , Numeric.Complex64 )
          addtoCself= Numeric.zeros([ 3, 3 ]  , Numeric.Complex64 )

          OP_fastRsumDebye_c(  debyerange[0], debyerange[1], debyerange[2], cella.cellvectors[0],
                        cella.cellvectors[1],cella.cellvectors[2], Q,
                        DR,  debye , TermtoaddtoInsect, addtoCself)

          TermtoaddtoInsect=TermtoaddtoInsect * fattdiag

          Debself=Debself+ addtoCself
          Numeric.add(Insect,  TermtoaddtoInsect , Insect) 


        InsectA = DebVC0[:,  i1*3 : 3+i1*3, i1*3 : i1*3+3  ]
        Numeric.add(InsectA, -Debself*Z2 , InsectA)
        if(i1!=i2):
          InsectA =DebVC0[:,  i2*3 : 3+i2*3, i2*3 : i2*3+3  ]
          Numeric.add(InsectA, -conj(TR(Debself*Z1)) , InsectA)


  ################################################3
  # simmetrising
  print "simmetrising"


  DebC=DebC+ Numeric.conjugate(Numeric.swapaxes(DebC, 1,2 )  )


  ################################################3
  # Prepares the result
  class result:
    pass

  result.DebC=DebC
  result.DebVC0=DebVC0

  return result

            






#################################################################################3


def contributionsCoulombMadelung(cella, Z, Impurity,  cellrange=[2,2,2]
	 ):

  #########################################################3
  # find the dimensions ( How many sites in the cell )
  N=Numeric.sum(map(len, cella.PositionsList))


  ##########################################
  # initialise the result
  result=0.0


  SUM=Numeric.sum


  for i1 in [Impurity] :

     A1= cella.atomlist[i1]
     P1=cella.FindPosition( A1, CellCoo=(0,0,0))

     Z1       =Z[i1]


     for i2 in range(0,len(cella.atomlist)):
        if(i2==Impurity): continue

        #####################################################"
        # this factor for diagonal terms is 0.5 because
        # each matrix will be symmetrized later, so diagonal 3X3 blocks are
        # counted twice
        if(i1!=i2):
            fattdiag=1
        else:
            fattdiag=1

        A2= cella.atomlist[i2]
        Z2       =Z [i2]

        for lx in range(-cellrange[0], cellrange[0]+1) :
         for ly in range(-cellrange[1], cellrange[1]+1) :
          for lz in range(-cellrange[2], cellrange[2]+1) :

            if(A1==A2 and lx==0 and ly==0 and lz==0): continue

            P2=cella.FindPosition( A2, CellCoo=(lx,ly,lz))

            

            R=P2-P1

            # print "i1=", i1, " i2=", i2
            # print R

            d=math.sqrt(Numeric.sum(R*R) )

            result=result +Z1*Z2/d
              
  return result











