

from sys import *
from copy import *
from Numeric import *
from  arrayfns  import *            
#
from umathextra import *

from dabax import *
import dabax 
from PyFullerton  import *

class convenient:
  def f1f2Lambda(self, Lambda):
          return self.value12*ones(len(Lambda))

  def f1f2Energy(self, Lambda):
      return self.value12*ones(len(Lambda))
  def f0Lambda(self, Lambda, theta=None):
      return self.value12*ones(len(Lambda))
  def f0Energy(self, Lambda, theta=None):
      return self.value0*ones(len(Lambda))


if(__name__=='__main__'):



  con1=convenient()
  con1.value0=0.01
  con1.value12=complex(0.0,0.01)
  Mocon=Dabax_Scatterer([con1], [2],[con1],[2])
  Nicon=Dabax_Scatterer([con1], [2],[con1],[1])
  Subcon=Dabax_Scatterer([con1], [2],[con1],[1])

######################################################333
#
#  Compose the elements
#


######################################################
#
#  define  the layers
#


  Mo_Plane  = Fuller_ElementalPlane(Element=Mocon,  InPlaneDensity=1)
  Ni_Plane  = Fuller_ElementalPlane(Element=Nicon,  InPlaneDensity=1)
  Sub_Plane  = Fuller_ElementalPlane(Element=Subcon,  InPlaneDensity=1)



  Mo_Layer  = Fuller_LayerM_I(Plane=Mo_Plane, PlaneD = 2.,  Nplanes=7.0    , SigmaNplanes=0.003,
                              PlaneDD1=0.5, PlaneDD2= 0.0, PlaneDDAlpha=0.5)

  Ni_Layer  = Fuller_LayerM_I(Plane=Ni_Plane, PlaneD = 2.,  Nplanes=7.00   , SigmaNplanes=0.003 ,
                              PlaneDD1= 0.0, PlaneDD2= 0.2, PlaneDDAlpha=0.5)



  period    = (Fuller_Interface(Separation=2, SigmaSeparation=0.) +Mo_Layer+
                Fuller_Interface(Separation=2, SigmaSeparation=0.)  +Ni_Layer)


  period .SetupCalculations()

  thetalist=array([ theta for theta in arrayrange(5,25,0.0133)*math.pi/180.0 ])
  lambdalist=1.546*ones(len(thetalist) ) 

  res=(period .DoCalculation( lambdalist , thetalist , 1  , L=4, SigmaNs=2, Ds=2.3, SubPlane= Sub_Plane , sigmatheta=0.0,
                              pol='M', CRough=0 , SubSep=2.4))

  thetalist=thetalist*2.0

  f=open("curva","w")
  for i in range (0,len(thetalist)):
    f.write("%e %e\n"% (thetalist[i]*180.0/math.pi,res[i]  ))

  print "finished  calculations"
