#include "Python.h"
#include "Numeric/arrayobject.h"
#include "Numeric/ufuncobject.h"
#include <math.h>

static PyUFuncGenericFunction erf_functions[] = { NULL,  NULL,  NULL,  };

static void * erf_data[] = { (void *)erf,  (void *)erf,  (void *)"erf",  };

static char erf_signatures[] = { PyArray_FLOAT,  PyArray_FLOAT,  PyArray_DOUBLE,  PyArray_DOUBLE,  PyArray_OBJECT,  PyArray_OBJECT,  };




static void InitOperators(PyObject *dictionary) {
	PyObject *f;

	

	erf_functions[0] = PyUFunc_f_f_As_d_d;
	erf_functions[1] = PyUFunc_d_d;
	erf_functions[2] = PyUFunc_O_O_method;



	f = PyUFunc_FromFuncAndData(erf_functions, erf_data, erf_signatures, 
				    3, 1, 1, PyUFunc_None, "erf", 
          "erf. Like erf in C", 1);
	PyDict_SetItemString(dictionary, "erf", f);
	Py_DECREF(f);
}


/* Initialization function for the module (*must* be called initArray) */

static struct PyMethodDef methods[] = {
  {NULL,		NULL, 0}		/* sentinel */
};

void initumathextra() {
  PyObject *m, *d, *s;
  
  /* Create the module and add the functions */
  m = Py_InitModule("umathextra", methods); 

  /* Import the array and ufunc objects */
  import_array();
  import_ufunc();

  /* Add some symbolic constants to the module */
  d = PyModule_GetDict(m);

  s = PyString_FromString("1.0");
  PyDict_SetItemString(d, "__version__", s);
  Py_DECREF(s);

  /* Load the ufunc operators into the array module's namespace */
  InitOperators(d); 


  /* Setup the array object's numerical structures */
  /* PyArray_SetNumericOps(d); */ 
  
  /* Check for errors */
  if (PyErr_Occurred())
    Py_FatalError("can't initialize module umathextra");
}

