##################################################################
# Alessandro MIRONE 2001
# ESRF
##################################################################
#########################
##Disclaimer
##==========
##
## This  software is provided without warranty of any kind.
## No liability is taken for any loss or damages, direct or
## indirect, that may result through the use of it. No warranty
## is made with respect to this documentation, or the programs
## and functions therein.
## There are no warranties that the programs or their documentation
## are free of error, or that it is consistent with any standard,
## or that it will meet the requirement for a particular application.
## Copyright
## =========
##
## We have adopted the GNU LIBRARY GENERAL PUBLIC LICENSE to apply to
## the this software.
## For more information on the license terms, see
## http://www.gnu.org/copyleft/lgpl.txt


import beans
import beansgui
import sys
from beans import *
from Dabax import *

from Dabax.dabax_gui import *

__version__="15/11/2002"
 


class BEAN_PPM_SimpleLayer(      instruction_base):
  help="object  of the class of type PPM_SimpleLayer "
  type="PPM_SimpleLayer"
  supertype="Layers"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.generatedtype="Layer"
   
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Thickness",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="thickness",
				  help="Thickenss in Angstroems ",
                                  default="None"
                                ),
                                self 
                               )
                             )





    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Roughness",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="roughness",
				  help="Roughness in Angstroems ",
                                  default="None"
                                ),
                                self 
                               )
                             )
    
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Material",
                                  type         =["IndexFromTable","KK","ComposedIndex", "IndexFromFile"], 
                                  value="None" ,             
                                  argument_key="material",
				  help="Optical Material",
                                  default="None"
                                ),
                                self 
                               )
                             )

    
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="PPM_SimpleLayer"





class BEAN_SumThings(   ListLike_instruction):
  help="Sum layers and stacks"
  type="SumThings"
  supertype="Layers"
  

  def __init__(self):
    beans.ListLike_instruction.__init__(self)
    self.associated_variable="None"

    self.generatedtype="Layers"


    self.groupedproperties=[
      ["Layer or Stack",["Layer","Layers"], [], "Layer or stack to sum" ],
      ]

    self.variable_is_active=1
    self.properties_list=[]	
    self.option=0
    self.option_dic={}
    for i in range(10):
       self.option_dic[i]= "%s things"%i
    self.constructor="SumThings"












class BEAN_MultiplyAThing(      instruction_base):
  help="To repeat a stack "
  type="MultiplyAThing"
  supertype="Layers"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.generatedtype = "Layer"
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.generatedtype="Layers"
   
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="N. of repeats",
                                  type         ="numeric_i", 
                                  value="None" ,             
                                  argument_key="None",
				  help="N. of repeats",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Stack to repeat",
                                  type         =["Layer","Layers"], 
                                  value="None" ,             
                                  argument_key="None",
				  help="Stack to repeat",
                                  default="None"
                                ),
                                self 
                               )
                             )
    

    
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="MultiplyAThing"



class BEAN_ScanReader(      instruction_base):
  help="object  of the class of type instruction ScanReader"
  type="ScanReader"
  supertype="Readers"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="filename",
                                  type         ="string", 
                                  value="None" ,             
                                  argument_key="None",
				  help="Name of the file to read. Dont forget the \" \" around the filename. Leave it equal to NonDont write anything if you want to sythetize a scan",
                                  default="pippo"
                                ),
                                self 
                               )
                             )
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Npoints",
                                  type         ="notipe", 
                                  additionaloptions=["\"first line\"", "\"automatic\""],
                                  value="None" ,             
                                  argument_key="Np",
				  help="Number of points in the scan to read. Either input an integer, or ""first line"" or ""automatic""  ",
                                  default="None"
                                ),
                                self 
                               )
                             )
    for name_col in ["wavelenghts_col","angles_col","refle_col","weight_col"]:
      self.properties_list_fixed.append(
                               property_container(
                                property(property_name=name_col,
                                  type         =("numeric_f","numeric_i"), 
                                  value="None" ,             
                                  argument_key=name_col,
				  help=("An integer to tell the columns number (1,2,3..), or a float to tell a fixed value."+
                                        " if you want to sythetise it write a list like [min,max,stride] "),
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="angle_factor",
                                  type         ="numeric_f", 
                                  value="1.0" ,             
                                  argument_key="angle_factor",
				  help="The angle column migth need to be rescaled. Input here the factor to convert it in radians from the surface",
                                  default="1.0"
                                ),
                                self 
                               )
                             )

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="ScanReader"



class BEAN_PPM_ComparisonTheoryExperiment(      instruction_base):
  help="Create an object specifing a stack  ad a list of scan to fit"
  type="Comparison"
  supertype="Fits"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.generatedtype="Fit"
   
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Stack model",
                                  type         ="Layers", 
                                  value="None" ,             
                                  argument_key="None",
				  help="Stack model",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="List of scans",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="None",
				  help="List of scans",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="List of weights",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="None",
				  help="List of weight",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="List of norms",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="normlist",
				  help="List of norms",
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="List of noises",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="noise",
				  help="List of noises. Noise is added the calculated scan ( before multiplication by norm ) ",
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="width",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="width",
				  help="width for the convolution",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="print partial",
                                  type         ="List",
                                  additionaloptions=("0","1"),
                                  value="None" ,             
                                  argument_key="printpartial",
				  help="if you want to save partial resulta to files choose 1",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(  
      property_container(
      property(property_name="shiftlist",
               type         ="List", 
               value="None" ,             
               argument_key="shiftlist",
               help="""a list of energy shift (eV) for each scan.
               let it equal to None if no shift. You are shifting Calculation energies, not
               experimental energies, beware""",
               default="None"
               ),
      self 
      )
      )
    
    
    
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="PPM_ComparisonTheoryExperiment"
    














class BEAN_Minimise(      instruction_base):
  help="Optimise a comparision model/experiment"
  type="Minimiser"
  supertype="Fits"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.generatedtype="None"
   
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Fit",
                                  type         ="Comparison", 
                                  value="None" ,             
                                  argument_key="fit",
				  help="Fit to optimise",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="variables",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="list_of_variables",
				  help="List of variables that can be optimized",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="tolerance",
                                  type         ="Numeric_f", 
                                  value="None" ,             
                                  argument_key="tol",
				  help="Tolerance specifies when to stop the fit",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Temp function",
                                  type         ="string", 
                                  value="\".05*exp(-0.2*x)\"" ,             
                                  argument_key="temperature",
				  help="The function of temperature versus number of evaluation",
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="max_refusedcount",
                                  type         ="Numeric_i", 
                                  value="100" ,             
                                  argument_key="max_refusedcount",
				  help="max_refusedcount",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="max_isthesame",
                                  type         ="Numeric_i", 
                                  value="10" ,             
                                  argument_key="max_isthesame",
				  help="max_isthesame",
                                  default="None"
                                ),
                                self 
                               )
                             )





    
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="Minimise"

beans.register_instruction(BEAN_AtomicProperties)
beans.register_instruction(BEAN_Duplicator)
beans.register_instruction(BEAN_Minimise)

beans.register_instruction(BEAN_PPM_ComparisonTheoryExperiment)

beans.register_instruction(BEAN_KK_ForPlot)

beans.register_instruction(BEAN_MultiplyAThing)


beans.register_instruction(BEAN_SumThings)


beans.register_instruction(BEAN_PPM_SimpleLayer)

beans.register_instruction(BEAN_IndexFromTable)
beans.register_instruction(BEAN_IndexFromFile)
beans.register_instruction(BEAN_ComposedIndex)

beans.register_instruction(BEAN_KK)


beans.register_instruction(beans.List_instruction)

beans.register_instruction( BEAN_Dabax_f0_Table )
beans.register_instruction( BEAN_Dabax_f1f2_Table )
beans.register_instruction( BEAN_Variable )
beans.register_instruction( BEAN_DependentVariable )
beans.register_instruction( BEAN_ScanReader )
beans.register_instruction( Insertion_instruction )

beans.register_instruction(BEAN_BetaManipulator_ScanReader)
beans.register_instruction(BEAN_BetaManipulator_BetaJoin)
beans.register_instruction(BEAN_BetaManipulator_ContributionsFromFile)
beans.register_instruction(BEAN_BetaManipulator_SumOfContributions)
beans.register_instruction(BEAN_BetaManipulator_Comparison)
beans.register_instruction(BEAN_BetaManipulator_ContributionsFromContinuum)
beans.register_instruction(BEAN_BetaManipulator_ContributionsFromLorentz)

beans.register_instruction(BEAN_CreateVariableArray )
beans.register_instruction(BEAN_BetaManipulator_ContributionsFromInterpolation)

beans.register_instruction(BEAN_IndexFromObject)

beans.headers =(
"from Numeric import *\n"
"from  PPMlayerclass import *\n"
"from Dabax import *\n"
"from Minimiser import *\n"
"import string\n"
"List=list"
)

if __name__=="__main__":
  print "###############LANCIO LANCIO LANCUI "
  beansgui.lanciagui( beans , sys.argv)
