from sys import *
from copy import *
import NumericA
from Numeric import *
from  arrayfns  import *            

from umathextra import *

from Dabax import *
import Dabax 
from PyFullerton import *

class convenient:
  def f1f2Lambda(self, Lambda):
      return self.value12
  def f1f2Energy(self, Lambda):
      return self.value12
  def f0Lambda(self, Lambda, theta=None):
      return self.value12
  def f0Energy(self, Lambda, theta=None):
      return self.value0


if(__name__=='__main__'):



  con1=convenient()
  con1.value0=0.01
  con1.value12=complex(0.0,0.01)
  Mocon=Dabax_Scatterer([con1], [1],[con1],[1])
  Nicon=Dabax_Scatterer([con1], [2],[con1],[1])

######################################################
#
#  Compose the elements
#


######################################################
#
#  define  the layers
#


  Mo_Plane  = Fuller_ElementalPlane(Element=Mocon,  InPlaneDensity=1)
  Ni_Plane  = Fuller_ElementalPlane(Element=Nicon,  InPlaneDensity=1)



  Mo_Layer  = Fuller_LayerM_I(Plane=Mo_Plane, Amorphous=1, Density=1, Thickness= 14, SigmaThickness=0.1,
                              PlaneD=2.)




  Ni_Layer  = Fuller_LayerM_I(Plane=Ni_Plane, PlaneD = 2.,  Nplanes=7.5   , SigmaNplanes=0.3,
                              PlaneDD1= 0.0, PlaneDD2= 0.0, PlaneDDAlpha=0.5)

  period    = Mo_Layer+Fuller_Interface(Separation=0)+Ni_Layer


  period .SetupCalculations()

  thetalist=array([ theta for theta in arrayrange(5,25,0.0033)*math.pi/180.0 ])
  lambdalist=1.546*ones(len(thetalist) ) 

  res=(period .DoCalculation( lambdalist , thetalist , 60  , L=None, SigmaNs=0, Ds=0, SubPlane=None , sigmatheta=0.0,
                              pol='M', CRough=0 ))

  thetalist=thetalist*2.0

  f=open("curva","w")
  for i in range (0,len(thetalist)):
    f.write("%e %e\n"% (thetalist[i]*180.0/math.pi,res[i]  ))

  print "finished  calculations"
