
import Tkinter as Tk, tkMessageBox


class MyDialog(Tk.Toplevel):
  def __init__(self, master, title = None,
		     oktext = 'Ok', canceltext = 'Dismiss',
		     btwidth = 6, padx = 15, pady = 8,
		     bd = 3, bdrelief = Tk.RIDGE):

    Tk.Toplevel.__init__(self, master)
    self.transient(master)
    self.master = master
    
    coords = (master.winfo_rootx() + 10, master.winfo_rooty() + 10)
    self.geometry("+%d+%d" % coords)
 
    if title:
      self.title(title)

    self.oktext = oktext
    self.canceltext = canceltext
    self.btwidth = btwidth
    self.padx = padx
    self.pady = pady
    self.bd = bd
    self.bdrelief = bdrelief
    self.lastmcframe = None

    self.result = None
    self.init_focus = None
    self.validate_func = []

    self.init_focus = self.body() or self
    self.buttonbox()


  def do_modal(self):
    self.protocol('WM_DELETE_WINDOW', self.cancel)
    self.init_focus.focus_set()
    self.resizable(0, 0)
    self.wait_visibility()
    self.grab_set()

    self.wait_window(self)
    return self.result

  def get_frame(self, frameside = Tk.TOP, bodyside = Tk.LEFT,
                multicolumn = 0):
    if multicolumn:
      if not self.lastmcframe:
        self.lastmcframe = Tk.Frame(self)
        self.lastmcframe.pack(side = frameside, fill = Tk.X,
                              expand = 1)
      
      master = self.lastmcframe
      side = Tk.LEFT
      fill = Tk.BOTH
    else:
      self.lastmcframe = None
      master = self
      side = frameside
      fill = Tk.X

    fm1 = Tk.Frame(master, bd = self.bd, relief = self.bdrelief)
    fm1.pack(side = side, fill = fill, expand = 1)

    if bodyside == Tk.CENTER:
      fm2 = fm1
    else:
      fm2 = Tk.Frame(fm1)
      fm2.pack(side = bodyside)

    fm3 = Tk.Frame(fm2)
    fm3.grid(row = 0, column = 0, padx = self.padx, pady = self.pady)

    return fm3

  def body(self):
    pass
      
  def buttonbox(self):
    bb = self.get_frame(bodyside = Tk.CENTER)

    b1 = Tk.Button(bb, width = self.btwidth, text = self.oktext, 
                        command = self.ok, default = Tk.ACTIVE)
    b1.grid(row = 0, column = 0, padx = self.padx)

    if self.canceltext:
      b2 = Tk.Button(bb, width = self.btwidth, text = self.canceltext, 
                          command = self.cancel)
      b2.grid(row = 0, column = 1, padx = self.padx)

    self.bind('<Return>', self.ok)
    self.bind('<Escape>', self.cancel)


  def add_validate(self, func):
    self.validate_func.append(func)

  def validate(self):
    return 1

  def apply(self):
    pass
	
  def ok(self, event = None, retcode = 1):
    for func in self.validate_func:
      if not func():
        return

    if not self.validate():
      self.init_focus.focus_set()
      return

    self.withdraw()
    self.apply()

    self.result = retcode
    self.end_modal()

  def cancel(self, event = None):
    self.result = 0
    self.end_modal()

  def end_modal(self):
    self.master.focus_set()
    self.grab_release()
    self.destroy()


class NumEntry:

  def __init__(self, double = 0, val = 0, format = None, callback = None,
               owndlg = None, range = None):
    self.double = double
    if double:
      self.var = Tk.DoubleVar()
      self.format = format or '%f'
    else:
      self.var = Tk.IntVar()
      self.format = format or '%d'

    self.str = Tk.StringVar()
    self.entry = None

    self.set(val)
    self.cback = callback
    self.dlg = owndlg
    self.range = range

  def get(self):
    return self.var.get()

  def set(self, val):
    self.var.set(val)
    self.update_entry()

  def set_range(self, range):
    self.range = range
   
  def update_entry(self, *args):
    self.str.set(self.format % self.var.get())
    
  def create_entry(self, master, **args):
    if self.entry:
      return

    args = args.copy()
    args['textvariable'] = self.str
    self.entry = apply(Tk.Entry, (master,), args)
    self.entry.bind('<FocusOut>', self.validate)
    self.entry.bind('<Return>', self.validate)

    if self.dlg:
      self.dlg.add_validate(self.validate)
    else:
      dlg = self.entry.winfo_toplevel()
      try:
        dlg.add_validate(self.validate)
      except:
        pass

  def validate(self, event = None):
    cfunct = 0

    try:
      if self.double:
        val = float(self.str.get())
      else:
        val = int(self.str.get())

      if self.range:
        if (val < self.range[0]) or (val > self.range[1]):
          raise    

      cfunct = (val != self.var.get())
      self.var.set(val)

    except:
      self.entry.unbind('<FocusOut>')
      tkMessageBox.showinfo('NumEntry', 'Invalid numeric data. '
                            'Please enter a valid number')
      self.update_entry()
      self.entry.focus_set()
      self.entry.bind('<FocusOut>', self.validate)

      if event:
        return "break"
      else:
        return 0

    self.update_entry()
    if self.cback and cfunct:
      apply(self.cback)

    return 1


