import sys
from Tkinter import *
import string
import ScrollFrame

DEBUG=0

class McaTable(ScrollFrame.ScrollFrame):
    def __init__(self, *args,**kw):
        apply(ScrollFrame.ScrollFrame.__init__, (self, ) + args)
        self.labels=['Parameter','Estimation','Fit Value','Sigma',
                     'Restrains','Min/Parame','Max/Factor/Delta/']
        self.code_options=["FREE","POSITIVE","QUOTED",
                 "FIXED","FACTOR","DELTA","SUM","IGNORE","ADD","SHOW"]

        i=0
        if kw.has_key('labels'):
            self.labels=[]
            for label in kw['labels']:
                self.labels.append(label)
        else:
            self.labels=['Position','Area','Sigma','Fwhm','Chisq',
                         'Region','XBegin','XEnd']
        
        for label in self.labels:
            title=Label(self,text=label,width=15,relief='groove')
            title.grid(row=0,column=i,sticky='ew')
            i=i+1
                
        self.regionlist=[]
        self.regiondict={}
        
    def fillfrommca(self,mcaresult):
        line0=0
        region=0
        for result in mcaresult:
            region=region+1
            if result['chisq'] is not None:
                chisq="%6.2f" % (result['chisq'])
                xbegin="%6g" % (result['xbegin'])
                xend="%6g" % (result['xend'])
                for (pos,area,sigma,fwhm) in result['mca_areas']:
                    line0=line0+1
                    #nlines=self.numRows()
                    #if (line0 > nlines):
                    #    self.setNumRows(line0)
                    line=line0
                    #pos=QString(str(pos))
                    #area=QString(str(area))
                    #sigma=QString(str(sigma))
                    #fwhm=QString(str(fwhm))
                    tregion=str(region)
                    pos="%6g" % (pos)
                    area="%6g" % (area)
                    sigma="%6.3g" % (sigma)
                    fwhm="%6g" % (fwhm)
                    tregion="%6g" % (region)
                    fields=[pos,area,sigma,fwhm,chisq,tregion,xbegin,xend]
                    col=0
                    for field in fields:
                        label=Label(self,text=field,
                                    width=15,bg='white',fg='black',
                                    bd=1,relief='ridge')
                        label.grid(row=line,column=col,sticky='ew')
                        col=col+1
