""" This module defines basic exception classes. """
# mcb April, 2001 (see ODAK.py mcb Oct, 1999)
__author__ = 'Manfred Burghammer'




#
# Proposed Baseclass for all exception classes
#
class BaseExcp:
	""" Proposed Base class for all exception classes.

	example:
	raise InfernalDisasterFatalException (\"coffeeLevel is low\", coffeeLevel)
	"""


	def __init__(self, comment = '', value = None, vbscmt = ''):
		self.comment = comment
		self.value = value
		self.verboseComment = vbscmt


	def __str__(self):
		if not self.comment:
			theString = '\ncomment: (uncommented)'
		else:
			theString = '\ncomment: ' + self.comment
		if self.value:
			theString = theString + '  value: '+ `self.value`
		if self.verboseComment:
			theString = theString + '\nverbose:\n' + self.verboseComment
		return theString
