/* file: bina.c
 * author: mcb (Seyssins, Sat May 26 01:03:40 MEST 2001)
 * type: C source
 * what it is:
 */
#include <stdio.h>
#include <stdlib.h>
#include "mcb.h"
#include "binio.h"
#include "bina.h"
#include "binb.h"

/* basic video scaling */
error_t RampScale_sint32(void *vd, void *vg, size_t n, int_t photo,
                         sint32_t data_lowlevel, sint32_t data_highlevel,
                         sint32_t grey_lowlevel, sint32_t grey_highlevel)
{
  error_t result = NO_ERROR;
	size_t i;
	sint32_t *d, *g, grey_range, data_range;

	d = (sint32_t *)vd;
	g = (sint32_t *)vg;
	grey_range = grey_highlevel - grey_lowlevel;
	data_range = data_highlevel - data_lowlevel;

	/*
	printf("dll, dhl, gll, gll, dr, gr, photo = \n%ld %ld\n%ld %ld\n%ld %ld\n%d\n",     data_lowlevel,
	       data_highlevel,
	       grey_lowlevel,
	       grey_highlevel,
	       data_range,
	       grey_range,
	       photo);
	*/
	if(photo) {
		for(i=0; i<n; i++) {
			if (*d < data_lowlevel) {
				*g = 0;
			} else if(*d > data_highlevel) {
				*g = grey_highlevel;
			} else {
				*g = grey_lowlevel + (grey_range*(*d - data_lowlevel))/data_range;
			}
			d++;g++;
		}
	} else {
		for(i=0; i<n; i++) {
			if (*d < data_lowlevel)
				*g = grey_highlevel;
			else if(*d > data_highlevel) 
				*g = 0;
			else {
				*g = grey_highlevel - (grey_range*(*d - data_lowlevel))/data_range;
			}
			d++;g++;
		}
	}
	return result;
}

/* basic video scaling */
error_t RampScaleZoom_sint32(void *vd, void *vg, size_t n1, size_t n2,
                         int_t photo,
                         sint32_t data_lowlevel, sint32_t data_highlevel,
                         sint32_t grey_lowlevel, sint32_t grey_highlevel,
                         int_t zoom)
{
  error_t result = NO_ERROR;
	size_t i, j, k, l, zn1, zn1_v;
	sint32_t *d, *g, gr, grey_range, data_range;

	printf("Hi!\n");
	d = (sint32_t *)vd;
	g = (sint32_t *)vg;
	grey_range = grey_highlevel - grey_lowlevel;
	data_range = data_highlevel - data_lowlevel;

	/*
	printf("dll, dhl, gll, gll, dr, gr, photo = \n%ld %ld\n%ld %ld\n%ld %ld\n%d\n",     data_lowlevel,
	       data_highlevel,
	       grey_lowlevel,
	       grey_highlevel,
	       data_range,
	       grey_range,
	       photo);
	*/
	printf("n1 = %ld, n2 = %ld\n", n1, n2);
	zn1 = (size_t)n1*zoom;
	zn1_v = zn1*sizeof(sint32_t);
	if(photo) {
		for(j=0; j<n2; j++) {
			for(i=0; i<n1; i++) {
				if (*d < data_lowlevel) {
					gr = 0;
				} else if(*d > data_highlevel) {
					gr = grey_highlevel;
				} else {
					gr = grey_lowlevel + (grey_range*(*d - data_lowlevel))/data_range;
				}
				d++;
				for(k=0; k<zoom; k++) {
					*g = gr;
					g++;
				}
			}
			for(l=0; l<zoom-1; l++) {
				memcpy((void *)g, (void *)(g - zn1), zn1_v);
				g += zn1;
			}
		}
	} else {
		for(j=0; j<n2; j++) {
			for(i=0; i<n1; i++) {
				if (*d < data_lowlevel) {
					gr = grey_highlevel;
				} else if(*d > data_highlevel) {
					gr = 0;
				} else {
					gr = grey_highlevel - (grey_range*(*d - data_lowlevel))/data_range;
				}
				d++;
				for(k=0; k<zoom; k++) {
					*g = gr;
					g++;
				}
			}
			for(l=0; l<zoom-1; l++) {
				printf("new memcpy %ld %ld g-base = %ld\n", j, l, g - (sint32_t *)vg);
				memcpy((void *)g, (void *)(g - zn1), zn1_v);
				/*
				*/
				g += zn1;
			}
		}
	}
/*
	i = 0;
	g = (sint32_t *)vg;
	while(1) {
		printf("%ld : %ld\n", i, *g);
		if(!(i%100)) {
			if('e' == getchar())
				break;
		}
		i = i+1;
	}
*/
	return result;
}
