from PyDisWindow import *
from PyDVT.View import View
import EdfFile

__version__=  '1.0.0'
__author__ =  'Alexandre Gobbo (gobbo@esrf.fr)'



class PyDisSaveEdf(Plugin):
    ########################################################
    ### Virtuals
    ########################################################
    def OnStartInit (self):
        return 1

    def OnFileSave (self,window,filename,format_string):
        try:            
            arr=window.View.GetSource()[0].GetOutput()["data"]
            output=EdfFile.EdfFile(filename)
            output.WriteImage({},arr,0)
            return 1
        except: return 0

    def GetSaveFormatList(self,window):
        try:
            if window.View.GetSource() is not (): return ["EDF files (*.edf)"]
            else: return []
        except: return []
        
    def GetInfoString(self):
        return "v"+__version__


plugin=PyDisSaveEdf()