from PyDisWindow import *
import PyDVT
import sys
import sps
import qt

__version__=  '1.0.0'
__author__ =  'EP - GB'


class PyDisImageMarker(Plugin):

  def OnStartInit(self):
    self.select= {}
    self.eraseMarker= {}
    self.moveMarker= {}
    return 1

  def OnFinishInit(self, app_window):
    self.app_window= app_window

  def GetInfoString(self):
    return "v. "+__version__
  
  def OnInitWindowPopupMenu(self, window):
    if isinstance(window.View, PyDVT.ImageView.ImageView) and \
      hasattr(window, "Data") and isinstance(window.Data, PyDVT.SPSData.SPSData):
      view= window.View

      view.AddMenuSeparator()

      self.moveMarker[view]= view.AddMenuPopupItem("Set marker",
       Command.Command(self.CreateViewSelect, window), "checkbutton")
      view.MenuPopup.CheckItem(self.moveMarker[view], 0)

      self.eraseMarker[view]= view.AddMenuPopupItem("Erase marker",
       Command.Command(self.EraseMarker, window), "command")

  def CreateViewSelect(self, window):
    view= window.View
    pointChecked= view.MenuPopup.IsItemChecked(self.moveMarker[view])

    if pointChecked :
      view.MenuPopup.CheckItem(self.moveMarker[view],0)
      self.select[view].Disable()
    else :
      if not self.select.has_key(view):
        self.select[view]= PyDVT.ImageViewSelect.ImageViewSelectPoint(window.Data,
           self._ViewSelectPoint)
#        self.select[view]= ImageViewSelectMarker(window.Data,
#           self._ViewSelectPoint)
        self.select[view].ConnectView(view)
      self.select[view].Enable()
      view.MenuPopup.CheckItem(self.moveMarker[view], 1)

  def EraseMarker(self, window) :
    view = window.View
    if self.select.has_key(view) :
      self.select[view].Destroy()      
      del self.select[view]

    pointChecked= view.MenuPopup.IsItemChecked(self.moveMarker[view])
    if pointChecked :
      self.select[view]= PyDVT.ImageViewSelect.ImageViewSelectPoint(window.Data,
           self._ViewSelectPoint)
      self.select[view]= ImageViewSelectMarker(window.Data,
           self._ViewSelectPoint)
      self.select[view].ConnectView(view)
      self.select[view].Enable()
      
    
  def _ViewSelectPoint(self, select):
    pass

#class ImageViewSelectMarker(PyDVT.ImageViewSelect.ImageViewSelectPoint):
#  def DrawSelection(self,view):

#    """
#    Virtual: See ViewSelectDefault

#    """

#    
#    print self.Pen(0)
#    #self.Pen=Pen((255,0,0),2,"solid")
#    
#    self.EraseTemp(view)

#    pos=self.Selection["BoundingRect"][0]
#    start=view.DataCoord2ImageCoord(pos)
#    end=(start[0]+1,start[1]+1)

#    
#    crossLength=3*(end[1]-start[1])
#    crossWidth=end[0]-start[0]
#    
#    upCrossStart=(start[0],start[1]-crossWidth-crossLength)
#    upCrossEnd=(start[0]+crossWidth,start[1]-crossWidth)
#    leftCrossStart=(start[0]-crossWidth-crossLength,start[1])
#    leftCrossEnd=(start[0]-crossWidth,start[1]+crossWidth)
#    bottomCrossStart=(start[0],start[1]+2*crossWidth)
#    bottomCrossEnd=(start[0]+crossWidth,start[1]+2*crossWidth+crossLength)
#    rightCrossStart=(start[0]+2*crossWidth,start[1])
#    rightCrossEnd=(start[0]+2*crossWidth+crossLength,start[1]+crossWidth)
#
#    if "SelectDraw" not in self.ViewList[view].keys():

#        self.ViewList[view]["CrossUp"]=view.Drawable.PutRectangle(upCrossStart[0], upCrossStart[1], upCrossEnd[0], upCrossEnd[1],self.Pen,self.Brush)
#        self.ViewList[view]["CrossLeft"]=view.Drawable.PutRectangle(leftCrossStart[0], leftCrossStart[1], leftCrossEnd[0], leftCrossEnd[1],self.Pen,self.Brush)
#        self.ViewList[view]["CrossBottom"]=view.Drawable.PutRectangle(bottomCrossStart[0], bottomCrossStart[1], bottomCrossEnd[0], bottomCrossEnd[1],self.Pen,self.Brush)
#        self.ViewList[view]["CrossRight"]=view.Drawable.PutRectangle(rightCrossStart[0], rightCrossStart[1], rightCrossEnd[0], rightCrossEnd[1],self.Pen,self.Brush)
#    else:     
#        view.Drawable.SetObjectCoords(self.ViewList[view]["CrossUp"],upCrossStart[0], upCrossStart[1], upCrossEnd[0], upCrossEnd[1])
#        view.Drawable.SetObjectCoords(self.ViewList[view]["CrossLeft"],leftCrossStart[0], leftCrossStart[1], leftCrossEnd[0], leftCrossEnd[1])
#        view.Drawable.SetObjectCoords(self.ViewList[view]["CrossBottom"],bottomCrossStart[0], bottomCrossStart[1], bottomCrossEnd[0], bottomCrossEnd[1])
#        view.Drawable.SetObjectCoords(self.ViewList[view]["CrossRight"],rightCrossStart[0], rightCrossStart[1], rightCrossEnd[0], rightCrossEnd[1])
#

#
#  def DrawTemp(self,view,mouse_position):

#    """
#    Virtual: See ViewSelectDefault

#    """

#    self.Pen=Pen((255,0,0),2,"solid")
#
#    start=view.DataCoord2ImageCoord(mouse_position)

#    end=(start[0]+1,start[1]+1)

#    
#    
#    crossLength=3*(end[1]-start[1])
#    crossWidth=end[0]-start[0]
#    
#    upCrossStart=(start[0],start[1]-crossWidth-crossLength)
#    upCrossEnd=(start[0]+crossWidth,start[1]-crossWidth)
#    leftCrossStart=(start[0]-crossWidth-crossLength,start[1])
#    leftCrossEnd=(start[0]-crossWidth,start[1]+crossWidth)
#    bottomCrossStart=(start[0],start[1]+2*crossWidth)
#    bottomCrossEnd=(start[0]+crossWidth,start[1]+2*crossWidth+crossLength)
#    rightCrossStart=(start[0]+2*crossWidth,start[1])
#    rightCrossEnd=(start[0]+2*crossWidth+crossLength,start[1]+crossWidth)
#    
#    if "TempDraw" not in self.ViewList[view].keys():

#        self.ViewList[view]["TempDraw"]=view.Drawable.PutRectangle( start[0], start[1], end[0], end[1],self.Pen,self.Brush)
#        self.ViewList[view]["TempCrossUp"]=view.Drawable.PutRectangle(upCrossStart[0], upCrossStart[1], upCrossEnd[0], upCrossEnd[1],self.Pen,self.Brush)
#        self.ViewList[view]["TempCrossLeft"]=view.Drawable.PutRectangle(leftCrossStart[0], leftCrossStart[1], leftCrossEnd[0], leftCrossEnd[1],self.Pen,self.Brush)
#        self.ViewList[view]["TempCrossBottom"]=view.Drawable.PutRectangle(bottomCrossStart[0], bottomCrossStart[1], bottomCrossEnd[0], bottomCrossEnd[1],self.Pen,self.Brush)
#        self.ViewList[view]["TempCrossRight"]=view.Drawable.PutRectangle(rightCrossStart[0], rightCrossStart[1], rightCrossEnd[0], rightCrossEnd[1],self.Pen,self.Brush)
#    else:

#        view.Drawable.SetObjectCoords(self.ViewList[view]["TempDraw"], start[0], start[1], end[0], end[1])
#        view.Drawable.SetObjectCoords(self.ViewList[view]["TempCrossUp"],upCrossStart[0], upCrossStart[1], upCrossEnd[0], upCrossEnd[1])
#        view.Drawable.SetObjectCoords(self.ViewList[view]["TempCrossLeft"],leftCrossStart[0], leftCrossStart[1], leftCrossEnd[0], leftCrossEnd[1])
#        view.Drawable.SetObjectCoords(self.ViewList[view]["TempCrossBottom"],bottomCrossStart[0], bottomCrossStart[1], bottomCrossEnd[0], bottomCrossEnd[1])
#        view.Drawable.SetObjectCoords(self.ViewList[view]["TempCrossRight"],rightCrossStart[0], rightCrossStart[1], rightCrossEnd[0], rightCrossEnd[1])

plugin=PyDisImageMarker()

