"""
    Py4datPyMLabPlugin.py
"""
import qt, Command, string,os,time, sys
from PyDVT.Binding import *
from PyDisWindow import Plugin
try:
 import ReadEdfFile
except:
 pass
# import AzimInt
print "-----------------------------------------------------------------------------"

from PyDisWindow import *
import PyDVT.DataSelection as DataSelection
import PyDVT.ExtendedImageView as ExtendedImageView
import PyDVT.ImageView as ImageView
import PyDVT.GraphView as GraphView



from PyDVT.View import    View



__version__=  '1.0.0'
__author__ =  'Alessandro Mirone'



###################################################
####  LOAD MLab Modules

local_dir=os.path.dirname(__file__)
if local_dir=="": local_dir="."
sys.path.append(local_dir+"/../MLabModules/")

import GraphViewCmdl
import AsciiMatrix
####################################################

DEBUG=0
_DataSelection=DataSelection
class  MLabClass:
	""" this is the interface with Py4DAT/PyDIS widgets
	and data formats.
	To get Help call the Help() metyhod
	"""
	additionalHelps={
	"HOWTOPLOT_1d": " Look newWindow_1d or the shortcut provided by Plot_1d",
	"HOWTOPLOT_2d": " Look newWindow ",
	}
	def PrintMenu(self):
		print " HELP IS AVAILABLE ON THE FOLLOWING METHODS ( MLab.Help(\"method\" ) )\n "
		for tok in dir(self) :
                        if( tok in [ "PrintHelp",    "PrintMenu",   "__init__",    "appw" ]):
                           continue
			meth=getattr(self, tok)
			if(hasattr(meth, "__doc__")  ):
				print tok , " ",
		print "\n "
		print " HELP IS AVAILABLE ALSO ON THE FOLLOWING SUBJETS ( MLab.Help(\"subjet\" ) ) \n "
		for tok in self.additionalHelps.keys():
			print tok , " ",
                print ""

	def PrintHelp(self, subj):
                tok = getattr(self,subj)
		print 		getattr( tok , "__doc__")
		if( hasattr(tok, "__init__")):
			print " The following help is extracted from __init__ method "
			print 		getattr( getattr(tok,"__init__")  , "__doc__")

	def Help(self,subj=""):
		if (subj ==""):
			self.PrintMenu()
 		else:
			if( (subj in dir(self) and hasattr( getattr(self,subj), "__doc__"))   ):
				self.PrintHelp(subj)
			elif( subj in self.additionalHelps.keys() ):
				print self.additionalHelps[subj]+"\n"
			else:
				print " No help available. Help is available for "
				self.PrintMenu()

        def __init__(self):
              self.AsciiReader = AsciiMatrix.AsciiMatrixReader
              self.AsciiWriter = AsciiMatrix.AsciiMatrixWriter
	      import MLabData
	      self.MLabData=MLabData.MLabData
        def ReadTomo(self, name, nslice, sizefloat):
         """ReadTomo(self, name, nslice)
              return slice number nslice slice
              info file must be present
         """
         info= name+".info"
         sinfo = open(info, "r"  ).read()
 
         s = treat_par_file(sinfo)
         exec(s, locals(), locals())
         print locals()
         slice_size = NUM_X * NUM_Y * sizefloat
 
         fimages = open(name,"r")
 
         if nslice> NUM_Z :
            raise " nslice too big "
 
         for i in range(nslice-1) :
            fimages.seek( slice_size  , 1)
         s = fimages.read(slice_size )
 
         if( sizefloat == 4) :
           data= Numeric.fromstring(s,"f")
         else:
           data= Numeric.fromstring(s,"d")
         if sys.byteorder=="big":
               byteorder  = "HIGHBYTEFIRST"
         else:
               byteorder  =  "LOWBYTEFIRST"
           
         if(byteorder != BYTEORDER):
             data=data.byteswapped()
         data=Numeric.reshape(data, [NUM_Y  , NUM_X ]  )
         return data
 

 	def ShowTomoSlices(self, name, nslices, sizefloat=4):
           """ReadTomo(self, name, nslices)
              shows slices specified by nslices
              nslices may be either an integer or a list of integers
           """
 
           if( type(nslices)==type(1)):
                nslices=[nslices]
           mldata=self.MLabData(SourceName=name)
           for i in nslices:
                a= self.ReadTomo(name, i, sizefloat)
                mldata.LoadSource(array=a, append=1)
           w=self.newWindow(mldata)
           return w


	def Data_for_Graph(self, *args, **argc):
                """  Data_for_Graph(source)
		     where source is a data derived class.

		     Gives an output that is ready to be plotted by a GraphView
		     widget

		     See Help for function newWindow_1d to 
		     see a practical example on how plotting a graph

		     More advanced use of Data_for_Graph requires that you pass arguments in this format:
                     
			Data_for_Graph(name=None,source=None,synchronized=1,
					buffer_input=0,yscale=0,xdata=None,
					pen=Pen((0,0,0),2,"solid"),symbol="none"
				  )

		     the function Data_for_Graph return  from GraphFilter
		     This help extracted from PyDVT GraphFilter
                     ( print GraphView.GraphFilter.__init__.__doc__ )
                     will be useful for you

		""" 
		import copy
		dictio=copy.copy(argc)
		if(len(args)==1 and len(argc)==0):
	 		graphdata=DataSelection.DataSelection(args[0])
		elif(len(args)>=2):
			graphdata=DataSelection.DataSelection(args[1])
			dictio["name"]=args[0]
		else:
			graphdata=DataSelection.DataSelection(argc["source"])

		dictio["source"]=graphdata

		graphdata=GraphView.GraphFilter(**dictio)
		return graphdata

        Data_for_Graph.__doc__=Data_for_Graph.__doc__+ GraphView.GraphFilter.__init__.__doc__


	def newWindow_1d(self, name=""):
                
                """ newWindow_1d(self, name="") :
		returns a window where you can plot 1D graphs.
		The plotting is then done calling 

                    w.SetSource((g1,g2,... ) )

		where w is the newWindow_1d return value (  PyDis\'s ViewWindow instance)
                where  g1, g2...gn are instance of GraphFilter derived classes.
                MLab provides a shortcut to create Such class with the function
                MLab.Data_for_Graph.... see corresponding documentation
                
		EXAMPLES FOR DISPLAYING A GRAPH: 
                w= MLab.newWindow_1d()

import Numeric

a=Numeric.sin(Numeric.arrayrange(0.0,12,0.1))
c=Numeric.cos(Numeric.arrayrange(0.0,12,0.1))

a_data=MLab.MLabData(a)
c_data=MLab.MLabData(c)

g2= MLab.Data_for_Graph(a_data)
g1= MLab.Data_for_Graph(c_data)

w.View.SetSource((g1,g2))		
			

		For a more advanced use of Data_for_Graph refer to MLab.Help("Data_for_Graph")
	        You\'ll find there a complete list of options
		"""

                print len(locals().keys())
                print len(globals().keys())
                print "MLab" in globals().keys()
                print globals().keys()
		return ViewWindow (self.appw.mdi,GraphViewCmdl.GraphViewCmdl,
			name,
			{"AddCursorSelect":1,"AddStyleSelect":1,"ScrollMode":"ON","AddStatus":1,"AutoHideStatus":1,}
			)



	def newWindow(self, data, Name="", DataSelection=None):
		"""
		-- newWindow(data, Name="") create a new window displaying 2D data
	   	The window reference is returned

		EXAMPLE :

import Numeric
a=Numeric.sin( Numeric.arrayrange(0,12.0,0.1 ))
A=a[:,None]*a
mldata=MLab.MLabData(A)
w=MLab.newWindow(mldata)
 


		"""	
		if Name=="":
			Name=data.SourceName
		
                window=ViewWindow (self.appw.mdi,
				   ExtendedImageView.ExtendedImageView,
				   Name,
				   {"AddSelection":0,
				    "SelectionCallback":self.appw.EventSelection,
				    "UseColormapWidget":1,
				    "AddReduc":1}
				   )
                window.shortName=Name
                window.fileName="NONCIVUOLE1"
                window.Data=data

		if(DataSelection is None):
			window.DataSelection=_DataSelection.RectSelection(window.Data)
		else:
	                window.DataSelection=DataSelection
			
                window.Filter=ImageView.ColormapFilter(None,window.DataSelection)

                window.View.SetSource(window.Filter)
                info=window.Data.GetSourceInfo()
                window.NumImages=info["Size"]
                MLab_Set2DArrayViewMenu(self.appw, window)
                self.appw.PageSelect(window,0)

		return window
	




	def Plot_1d( self, *argv):
	  """
	    This function is meant to provide a very easy interface to plotting utilities
            Input is in the form :
                Function_name( (y1,x1   ), (y2,x2), (y3), .....              )

	    Where the y's and the x's are Numpy arrays. 
            The obtained widget plots the y's versus the x's.
            When x is not provided an integer array ranging from
            0 to len(y)-1 is used.

            The return value is a dictionary containing the
            following keywords/ values : ( Example )

       {'graphs': [
                     {'y_data': <MLabData.MLabData instance at 0x8539ce4>, 
                      'y_graph': <PyDVT.GraphView.GraphFilter instance at 0x853adc4>}
                  ],
                'w': <PyDisWindow.ViewWindow instance at 0x851adb4>
       }

           To the keyword "graphs" correspond a list of couple ( MLabData.MLabData , PyDVT.GraphView.GraphFilter).
           One such couple for each (y,x) couple that you provided as argument.

           The 'w' key point to the widget objet. You can add labels and titles by manipulation
           of the object w.View.

           EXAMPLE

           x=Numeric.arrayrange(0.0,12.0,0.1)
           y=Numeric.sin(x)
           w=MLab.Plot_1d((y,x))



	  """
	  res=Dictio_1d()
	  w=self.newWindow_1d()
	  res["w"]=w
	  graphs=[]
	  toplot=[]
	  for tok in argv:
	     ng={}
	     if len(tok)==1:
	       x=range(len(tok[0]))
	     else:
	       x=tok[1]
	     y = tok[0]
	     y_data = self.MLabData( y )
	     y_graph = self.Data_for_Graph(source=y_data, xdata=x)
	     ng["y_data"]=y_data
	     ng["y_graph"]=y_graph
	     graphs.append(ng)
	     toplot.append(y_graph)
	  w.View.SetSource(toplot)
	  res["graphs"]=  graphs
	  return res








def MLab_Set2DArrayViewMenu(appw,window):
        window.View.AddMenuSeparator()
        cascademenu=Menu(window.View.GetPopupMenu())
        cascademenu.AddCommand("Horizontal",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectHLine),"radiobutton")
        cascademenu.AddCommand("Vertical",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectVLine),"radiobutton")
        cascademenu.AddCommand("Line",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectLine),"radiobutton")
        cascademenu.AddCommand("Rectangle",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectRect),"radiobutton")
        cascademenu.AddSeparator()
	print " NumImages  ", window.NumImages 
        if window.NumImages > 1:
            cascademenu.AddCommand("Depth Point",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectPoint,callback=appw.EventDepthSelection),"radiobutton")        
            cascademenu.AddCommand("Depth Horizontal",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectHLine,callback=appw.EventDepthSelection),"radiobutton")
            cascademenu.AddCommand("Depth Vertical",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectVLine,callback=appw.EventDepthSelection),"radiobutton")
            cascademenu.AddSeparator()
        cascademenu.AddCommand("Clear Selection",window.View.ClearViewSelect,"radiobutton")
        cascademenu.SetCheckedRadio("Clear Selection")
        window.View.AddMenuPopupCascade("Selection",cascademenu)
        appw.Set2DViewMenu(window)
        window.View.AddMenuSeparator()
        if window.NumImages > 1:
            window.image_selection_menu=Menu(window.View.GetPopupMenu())
            for i in range(window.NumImages): window.image_selection_menu.AddCommand(str(i+1),Command.Command(appw.PageSelect,window,i),"radiobutton")
            window.image_selection_menu.SetCheckedRadio("1")
            window.View.AddMenuPopupCascade("Select Image",window.image_selection_menu)
            appw.AddImageSlider(window,appw.onImageSelectionSliderChanged)


	
class cmdln_QTextEdit(qt.QTextEdit):
	def __init__(self,*args,**keys):
		qt.QTextEdit.__init__(self,*args,**keys)
                self.masterWindow=args[0]
                self.setAcceptDrops(1)
                self.viewport().setAcceptDrops(1)
                self.tag_count=0
                self.dictiotags={}


        def keyPressEvent( self,  e ):
		tx=  e.ascii()
		sta = e.state()
		if( sta ==qt.Qt.ShiftButton  and tx==13):
			s=str(self.selectedText())
			if(str(s)==""):
				(para,inde)=self.getCursorPosition()
				s=str(self.text(para))
                        print " ho trovato il testo ", str(s)+"##"
                        while( s[-1]==" "): s=s[:-1]
                        s=self.TagExpand(str(s))
			self.emit(qt.PYSIGNAL("cmdln_QTextEdit_execute_sgnl()"),(s,))
		else:
			qt.QTextEdit.keyPressEvent(self,e)


	def contentsDragEnterEvent(self, de):
            source= de.source()
            print " ENTER "
            print source.__class__
            if( hasattr(source,"GetSource")):
                de.accept(1)

	def contentsDragMoveEvent(self, de):
		source= de.source()
                print " MOVE "
                print source.__class__
                if( hasattr(source,"GetSource")):
                    de.accept(1)


        def contentsMouseDoubleClickEvent(self, de):
            print " SONO in contentsMouseDoubleClickEvent "
            print de
            a,b=self.getCursorPosition()
            s=str(self.text(a))
            if (len(s)<10): return
            print s[:10]
            if( s[:10] not in [ "# END CCCC" , "# END WWWW" , "# WWWWWWWW", "# CCCCCCCC"]):
                self.emit(qt.PYSIGNAL("cmdln_QTextEdit_execute_sgnl()"),(s, ))
                return 
            if( s[:10]=="# END CCCC" or s[:10]=="# END WWWW"):
                a=a-1
                while(a>=0):
                    s=str(self.text(a))
                    print s[:10]
                    if(s[:10]=="# CCCCCCCC" or s[:10]=="# WWWWWWWW"):
                        break
                    a=a-1
            if(s[:10]=="# CCCCCCCC" or s[:10]=="# WWWWWWWW"):
                print s[:10]
                tag=s[-8:-1]
                print " devo cercar /",tag,"/"
                print " dentro " , self.dictiotags.keys()
                if( tag[:3]=="tag"):
                    if( tag not in self.dictiotags.keys()):
                        return
                    print " devo inserire " , self.dictiotags[tag]
                    newtext=s[:-8]+"\n"
                    newtext=newtext + self.dictiotags[tag]+"\n"
                    del    self.dictiotags[tag]
                    self.setSelection ( a, 0, a, 100000000, 1 )
                    self.removeSelectedText(1)
                    # rimuovo se c'e' il cqrriqge
                    self.setSelection ( a, 0, a+1, 0, 1 )
                    self.removeSelectedText(1)
                    self.insertAt(newtext ,a,0)
                    
                else:
                    tosearch = s[:2]+"END "+s[2:10]
                    found=-1
                    for il in range(a+1, self.lines()):
                        l = str(self.text(il))
                        if ( tosearch == l[:len(tosearch)] ):
                            found = il
                            break
                    if(found==-1): return
                    self.setSelection ( a+1, 0, il, 1000000, 0 )
                    texttotag = str(self.selectedText())
                    print " preso ", texttotag
                    self.removeSelectedText(0)
                    
                    # rimuovo il carriage return se c'e'
                    self.setSelection ( a, 10000000, a+1, 0, 0 )
                    self.removeSelectedText(0)

                    
                    tagtext = string.replace("tag%4d" %self.tag_count ," ", "0")
                    self.tag_count=self.tag_count+1
                    self.insertAt(tagtext ,a,10000000)
                    self.dictiotags[tagtext]=texttotag
                    print " preso ", self.dictiotags
                    
                

            
	def contentsDropEvent(self, de):
                print de
		source= de.source()
                if( hasattr(source,"GetSource")):
                    print " provo con l esecuzione di "
                    s=self.selectedText()
                    if(str(s)==""):
                        self.placeCursor(de.pos())
                        (para,inde)=self.getCursorPosition()
                        s=self.text(para)
                        print s
                    print " LA SORGENTE EST ", source
                    a,b=self.getCursorPosition()
                    ix=b
                    while( s[ix] not in ["=","(" ]):
                        ix=ix-1
                        if(ix==0):
                            return
                    import time
                    lt=time.localtime()
                    idstr=" that you dropped on %d/%d/%d %d:%d %ds " %(lt[2],lt[1],lt[0], lt[3],lt[4],lt[5])
                    self.setSelection ( a, ix+1, a, 100000, 1 )
                    self.removeSelectedText(1)
                    if(s[ix]=="="):
                        self.insertAt( str(source)+idstr,a,ix+1)
                    else:
                        self.insertAt( str(source)+idstr+")",a,ix+1)
                    self.emit(qt.PYSIGNAL("cmdln_QTextEdit_execute_sgnl()"),(s[:ix+1],source))



        def GetText(self):
            s=str(self.text())
            news=self.TagExpand(s)
            return news
        def TagExpand(self,s, savelet=0):
            news=""
            sl=string.split(s,"\n")
            for  s in sl :
                istagged=0
                if (len(s)>=10):
                    if(s[:10]=="# CCCCCCCC" or s[:10]=="# WWWWWWWW"):
                        tag=s[-7:]
                        if( tag[:3]=="tag"):
                            istagged=1
                            if( tag  in self.dictiotags.keys()):
                                if(savelet):
                                    news=news+s[:-7]+"\n"+self.dictiotags[tag]
                                else:
                                    news=news+self.dictiotags[tag]
                if(not istagged):
                    news=news+"\n"+s
            # if(news[-1]!="\n"): news=news+"\n"
            return news
        
def function_bidon():
  pass

class Py4datPyMLabPlugin(Plugin):
    	########################################################
    	### Virtuals
    	########################################################
    	def OnStartInit (self):
		if DEBUG: print 'Py4datPyMLabPlugin.OnStartInit'
		self.displayMlab=1
		self.inputFiles=[]
                self.CurPathCodelet='.'
		return 1

    	def OnInitMenuBar (self,menu_bar):
            pass
        
        def onInitPluginsMenu(self, PluginsMenu):
            mlabmenu=qt.QPopupMenu(PluginsMenu)
            PluginsMenu.insertItem('&MLab',mlabmenu)
            mlabmenu.insertItem('&Info',self.PluginInfo)
            mlabmenu.insertItem('Show Mlab',self.ShowMlab)
            mlabmenu.insertItem('Hide Mlab',self.HideMlab)
            mlabmenu.insertItem('Load Codelet',self.Loadlet)
            mlabmenu.insertItem('Save Selection as Codelet',self.Savelet)
            self.PluginsMenu=PluginsMenu
            self.mlabmenu=mlabmenu
            
        def desactivatePlugin(self):
            self.HideMlab()
            
        def reactivatePlugin(self):
            pass

        def processArguments(self, arguments):
            import types
            for arg in arguments:
                if( type(arg) is types.StringType ):
                    if( arg[-4:]==".pml" ):
                        self.LoadMLab(arg)
                        return

        def GetOpenFormatList(self):
            return ["MLab Files (*.pml)"]
        def GetSaveFormatList(self, window):
            if( window == self.app_window.mlab_input):
                return ["MLab Files (*.pml)"]
            else:
                return []
        
        def OnFileOpen (self, filename,format_string):
            self.LoadMLab(filename)
            self.ShowMlab()
            
        def OnFileSave (self,window,filename,format_string):
            if( window == self.app_window.mlab_input):
                print " FINESTRA SBAGLIATA !!!!! OnFileOpen (self,window, filename,format_string) ", __file__
            self.DumpMLab(filename)

        def Clear(self):
            """"  Cleans memory space of MLab
            Cleans text area of MLab
            """
            self.variables= {"MLab": self.variables["MLab"]  }
            self.app_window.mlab_input.setText("")
            self.app_window.mlab_log.setText("")
            self.import_instructions=[]
            
            


            
        def PluginInfo(self):
                if DEBUG: print 'In PyMLabPlugin.PluginInfo...'
		new_window=ViewWindow (self.app_window.mdi,TextView)        
		new_window.show()
		new_window.SetTitle("Plugin Info")
		str="PyMLabPlugin\n-File: "+__file__+"\n"
		str=str+"-VERSION " + __version__+"\n"+"-AUTHOR " + __author__+"\n"
		new_window.View.SetSource(str)
	

        def DumpMLab(self, name=None):
                """ Serialise on a file the variables created in the MLab plugin """
                import pickle
		import copy
                variables = copy.copy(  self.variables)

                del variables["MLab"]
	        l=copy.deepcopy(variables.keys())
                functions = {}
                for key in l:
                  if( type( variables[key]) == type(function_bidon)):
                      functions[key]= variables[key].func_code 
                      del variables[key]
		  else:
                    try:
	              # f=open("/tmp/cucu12345","w")
                      pickle.dumps(variables[key])
                    except:
                      print key , " fallito "
                      if( type( variables[key]) == type(function_bidon)):
                          functions[key]= variables[key].func_code 
                      del variables[key]


                f=open(name,"w")
                pickle.dump(self.import_instructions, f);

                import marshal
                marshal.dump(functions , f);
	 	

                pickle.dump( variables,f)
                pickle.dump( str(self. app_window.mlab_input.GetText()), f) # GetText invec di text per convertire i codelets
                pickle.dump( str(self. app_window.mlab_log.text()), f)
	        f.close()

        def LoadMLab(self, name=None):
                """ Read from  a file the variables saved from another session of the  MLab plugin """
                import pickle
                f=open(name,"r")

	        self.import_instructions= pickle.load( f)
	        for line in self.import_instructions:
		  self.Execute(line, append_import=0)


		import marshal
		import new
		functions= marshal.load( f )
                for key in functions.keys():
                   print key
                   self.variables[key] = new.function( functions[key],self.variables , key )  

                variables = pickle.load( f)
                for key in variables.keys():
                   self.variables[key]=variables[key]

                it = pickle.load ( f)
	        self. app_window.mlab_input.setText( str(self. app_window.mlab_input.text()) +it )
                ot = pickle.load ( f)
	        self. app_window.mlab_log.setText( str(self. app_window.mlab_log.text()) +it )

        

    	def OnFinishInit (self,app_window):
                if(hasattr(self,"app_window")): return 
		self.app_window=app_window
		Mlab_instance =MLabClass()
	        Mlab_instance.LoadMLab=self.LoadMLab
	        Mlab_instance.DumpMLab=self.DumpMLab
	        Mlab_instance.Clear   =self.Clear

		Mlab_instance.appw = self.app_window
		self.variables={"MLab": Mlab_instance }
	        self.import_instructions=[]
		self.app_window.Command=''

		self.splitter=qt.QSplitter(qt.Qt.Vertical,self.app_window)
		# print qt.version
		self.app_window.mdi.reparent(self.splitter,qt.QPoint(0,0))
		self.app_window.setCentralWidget (self.splitter)


		self.app_window.mlab_input=cmdln_QTextEdit(self.app_window.mdi, "PyMLab_input")
		self.app_window.mlab_input.setCaption("PyMLab Window")
		self.app_window.mlab_input.setText("# "+"W"*20 +"""\n# write in this window
#  Use python syntax, <Shift>+ <Enter> executes the line the curson is in, if no selection is active
# if a selection is active, <Shift>+ <Enter> execute the selection
# to get Help :  \nMLab.Help()   # now click your mouse here and type   <Shift>+ <Enter> 
"""+"# END " +"W"*20)
	
		# self.app_window.mlab_input.raise()
		self.app_window.mlab_input.resize(800,400)
		self.app_window.connect(self.app_window.mlab_input,
					qt.PYSIGNAL("cmdln_QTextEdit_execute_sgnl()"),
					self.Execute)

		self.app_window.mlab_log=cmdln_QTextEdit(self.app_window.mdi , "PyMLab_log")
		self.app_window.mlab_log.setCaption("PyMLab LOG Window")
		self.app_window.mlab_log.setMinimumSize(qt.QSize(self.app_window.mlab_log.x(),25))
		self.app_window.mlab_log.setText("DO NOT WRITE HERE. IT'S JUST A LOG WINDOW")

		self.app_window.mlab_input.setBold(0)
		self.app_window.mlab_input.setItalic(0)

		self.app_window.mlab_input.setBold(0)
		self.app_window.mlab_input.setItalic(0)

		self.app_window.mlab_input.setMinimumSize(qt.QSize(self.app_window.mlab_input.x(),25))

                self.mlab_input = self.app_window.mlab_input

		self.HideMlab()
	              
    	def GetInfoString(self):
        	if DEBUG: print 'Py4datPyMLabPlugin.GetInfoString'
		return "v. "+__version__+",  Author:"+__author__

    	########################################################
    	### Private methods
    	########################################################

	def ShowMlab(self):
		if DEBUG: print 'Py4datPyMLabPlugin.ShowMlab'
		if self.displayMlab==0:
			self.app_window.mlab_log.show()
			self.app_window.mlab_input.show()
 			self.displayMlab=1

		
	def HideMlab(self):
		if self.displayMlab==1:
                    print " NASCONDO "
                    self.app_window.mlab_input.hide()
                    self.app_window.mlab_log.hide()
                    self.displayMlab=0

        def Loadlet(self):
            filter="Codelet  Files (*.clt)" +";;" +" any file (*)"+";;"
            if qt.qVersion()>="3.0.0":
                selected=qt.QString()
                fn = qt.QFileDialog.getOpenFileName(self.CurPathCodelet,filter,self.app_window.mlab_input,None,qt.QString.null,selected)
            else:
                dlg=qt.QFileDialog(self.CurPath,filter,self.app_window.mlab_input,None,1)
                dlg.setCaption("Open")
                dlg.show()
                fn=dlg.selectedFile()
                selected=dlg.selectedFilter()
            if fn.isEmpty(): return
            filename = str(fn)
            format_str=str(selected)
            self.CurPathCodelet=os.path.dirname(filename)
            s=open(filename,"r").read()

            sl=string.split(s,"\n")
            news=""
            isl=0
            while( isl< len(sl) ):
                line=sl[isl]
                if(line[:10]=="# CCCCCCCC" or line[:10]=="# WWWWWWWW"):
                    tosearch = line[:2]+"END "+line[2:10]
                    found=-1
                    for il in range(isl+1, len(sl)):
                        l = str( sl[il])
                        if ( tosearch == l[:len(tosearch)] ):
                            found = il
                            break
                    if(found==-1):
                        print " ERROR IN LOADING CODELET "
                        print line, " has not been closed "
                        raise " STOP "
                    else:
                        seltext = ""
                        for j in range(isl +1 ,found+1): seltext =seltext+sl[j]+"\n"
                        tagtext = string.replace("tag%4d" %self.mlab_input.tag_count ," ", "0")
                        self.mlab_input.dictiotags[tagtext]=seltext[:-1]
                        self.mlab_input.tag_count=self.mlab_input.tag_count+1
                        news=news+sl[isl]+tagtext+"\n"
                        isl=found+1
                        
                else:
                    news=news+line+"\n"
                    isl=isl+1



            
            qtexed=self.app_window.mlab_input
            a,b=qtexed.getCursorPosition()
            qtexed.insertAt(news ,a,b)

        def Savelet(self):
            filter="Codelet  Files (*.clt)" +";;"+" any file (*)"+";;"
            if qt.qVersion()>="3.0.0":
                selected=qt.QString()
                fn = qt.QFileDialog.getSaveFileName(self.CurPathCodelet,filter,self.app_window.mlab_input,None,qt.QString.null,selected)
            else:
                dlg=qt.QFileDialog(self.CurPath,filter,self.app_window.mlab_input,None,1)
                dlg.setCaption("Save")
                dlg.show()
                fn=dlg.selectedFile()
                selected=dlg.selectedFilter()
            if fn.isEmpty(): return
            filename = str(fn)
            format_str=str(selected)
            self.CurPathCodelet=os.path.dirname(filename)
            f=open(filename,"w")
            qtexed=self.app_window.mlab_input
            s=str(qtexed.selectedText())
            news=qtexed.TagExpand(s,1)

            f.write(news)
            f.close()

		
	def Execute(self,command,extra_object=None , append_import=1):
		if DEBUG: print 'Py4datPyMLabPlugin.Execute'
		command=str(command)
		if(command == ""): return
		COMMAND = str(command)
		if(command[-1]!="\n"): COMMAND=COMMAND+"\n"

		globs= globals()

		#######################################################
		# OLD WAY
                # problems : sometimes one has to double execute
                # is something getting defined in variables
                # has to be accessed as global ( for example
                #      from inside a function )
                #
		# globs.update(self.variables)
		# exec( COMMAND , globals(), self.variables)
		#####################################################

                if( extra_object is not None):
                    self.variables["tmp_variable_162738271827"]=extra_object
                    COMMAND=COMMAND[:-1]
                    if COMMAND[-1]=="(":
                        extra=")\n"
                    else:
                        extra="\n"
                    COMMAND=COMMAND+"tmp_variable_162738271827"+extra
                    
		self.app_window.mlab_log.append(COMMAND)

                ####################################################### 
                # NEW WAY
                for key in globs.keys():
                   if ( key not in self.variables.keys() ):
                      self.variables[key] = globs[key]
                exec( COMMAND ,self.variables ,self.variables )
               
##                 for key in globs.keys():
##                     if( key in self.variables.keys()) :
##                      if( globs[key] == self.variables[key]):
##                        del self.variables[key]
                ###########################################################


		lines = string.split( COMMAND,"\n")
                if(append_import):
                 for line in lines:
                  if( (line[:len("import")]=="import" and line[len("import")]  in string.whitespace )
                   	or ( line[:len("from")]=="from" and line[len("from")]  in string.whitespace )
		    ):
 			self.import_instructions.append(line)	





 
 
                                                                 
 

 

   
def add_quotes(s):
     pos=string.find(s,"=")
     if(pos==-1): return s
     pos=pos+1
     new_s=s[:pos+1]
     toggle=0
     while(pos<len(s) and s[pos]==" "):
         pos=pos+1
     if(pos==len(s)):
         return s
     new_s=new_s+"\""
     while(pos<len(s) and s[pos]!=" "):
         new_s=new_s+s[pos]
         pos=pos+1
     new_s=new_s+"\""
     return new_s
     
def treat_par_file(s):
 
     s=string.replace(s,"!","#")
     lines=string.split(s,"\n")
     new_lines=""
     for line in lines:
         if( string.find(line,"BYTEORDER")>=0 ):
             line=add_quotes(line)
         new_lines=new_lines+"\n"+line
     return new_lines
 
 


 


class TextView(View):
    def CreateDrawable(self):
        if DEBUG: print 'In TextView.CreateDrawable...'
	self.Drawable= qt.QTextBrowser(self)
        self.Drawable.show()
    def SetSource(self,source):
        if DEBUG: print 'In TextView.SetSource...'
	import types
        if type(source)is types.StringType: self.Drawable.setText(source)
        else: self.Drawable.setSource(source)
        self.Refresh()
    def Save(self,filename):
        if DEBUG: print 'In TextView.Save...'
	open(filename,"w+").write(str(self.Drawable.text()))




class Dictio_1d(dict):
   def Update(self,graphs=None, Pens=None):
	   if graphs is None:
		   graphs = range(len(self['graphs']))
	   elif type(graphs)==type(1):
		   graphs=[graphs]
		   
	   for ng in graphs:
		   g = self['graphs'][ng]['y_graph']
		   if Pens is not None:
			   g.pen=Pens[ng]
		   g.Refresh()



plugin=Py4datPyMLabPlugin()

