from PyDisWindow import *
import PyDVT

__version__=  '1.0.0'
__author__ =  'Alexandre Gobbo (gobbo@esrf.fr)'


class PyDisDefaultFitToScreen2D(Plugin):
    ########################################################
    ### Virtuals
    ########################################################            

    def OnInitWindowPopupMenu (self,window):
        if isinstance(window.View,PyDVT.ImageView.ImageView) and window.View.ZoomMode != "FIT_TO_SCREEN":
            window.FitToScreenModeFlag=0
            window.OriginalZoomMode=window.View.ZoomMode
            window.View.AddMenuSeparator()
            window.FitToScreenModeMenuItem=window.View.AddMenuPopupItem("Mode Fit to Screen",Command.Command(self._CmdFitToScreenMode,window),'checkbutton')
            window.View.GetPopupMenu().CheckItem(window.FitToScreenModeMenuItem,window.FitToScreenModeFlag)
            self._CmdFitToScreenMode(window)

                
    def _CmdFitToScreenMode(self,window):
        if window.FitToScreenModeFlag:
            window.FitToScreenModeFlag=0
            window.View.ZoomMode=window.OriginalZoomMode
            window.View.Drawable.ZoomMode=window.OriginalZoomMode
            window.View.SetZoom(com="normal")
            self._EnableZoomItems(window,1)
        else:
            window.FitToScreenModeFlag=1
            window.View.ZoomMode="FIT_TO_SCREEN"
            window.View.Drawable.ZoomMode="FIT_TO_SCREEN"
            window.View.SetZoom(com="fit")
            self._EnableZoomItems(window,0)

        window.View.GetPopupMenu().CheckItem(window.FitToScreenModeMenuItem,window.FitToScreenModeFlag)

    def _EnableZoomItems(self,window,enable):
        menu=window.View.GetPopupMenu()            
        for index in range(menu.count()):                
            if str(menu.text(menu.idAt (index)))in ('Zoom To','Zoom +','Zoom -','Fit to Screen','Reset Zoom'):
                menu.setItemEnabled(menu.idAt (index),enable)            
        

    def GetInfoString(self):
        return "v. "+__version__

plugin=PyDisDefaultFitToScreen2D()
