"""
    PyDisWindow
    Python Generic Image Visualization Tool
"""
import sys

__version__=  '1.0.10'
__date__ =    '31/10/2002'
__author__ =  'Alexandre Gobbo (gobbo@esrf.fr)'


from QMdiApp.mdi import *
import qt
import qttable

from   PyDVT.Binding import Pen,Brush,Menu,Dialog
import PyDVT.ImageView as ImageView
import PyDVT.ExtendedImageView as ExtendedImageView
import PyDVT.GraphView as GraphView
import PyDVT.TableView as TableView
import PyDVT.MeshView as MeshView
import PyDVT.ContourView as ContourView
import PyDVT.DataInfoView as DataInfoView
import PyDVT.View as View

import PyDVT.EdfFileData as EdfFileData
import PyDVT.ImageFileData as ImageFileData
import PyDVT.Filter as Filter
import PyDVT.DataSelection as DataSelection
import PyDVT.GraphViewSelect as GraphViewSelect
import PyDVT.ImageViewSelect as ImageViewSelect
import PyDVT.Transf2DFilter as Transf2DFilter


import Command
import Numeric
import string
import os
import stat

   
currentApplicationWindow=[None]


def ReadDictio(fname):
            import pickle
            return pickle.load(open(fname,"r") ) 

        
def WriteDictio(config,fname ):
 try:
     f=open(fname,"w" )
     import pickle
     pickle.dump(config,  f)
     f.close()
 except:
     import traceback
     traceback.print_exc()
    

def FilterWantedPlugins(strplugins,available_plugins, config ):


    result=[]
    for i in range(len(strplugins) ):
        plnam=strplugins[i]
        pl = available_plugins[i]
        if( config["use_plugins"].has_key(plnam) ) :
          if config["use_plugins"][plnam]==1 :
            result.append( available_plugins[i] )
        else:
          config["use_plugins"][plnam]=1 
          result.append( available_plugins[i] )
    return result

        

class PyDisWindow(ApplicationWindow):

    def __init__(self,parent = None, name = None, fl = 0, plugin_list=[], optimization=0, user_options={}, arguments=[]):
        currentApplicationWindow[0]=self
        self.plugins=[]
        self.available_plugins=[]
        strplugins=[]
        self.strplugins=[]
        
        local_dir=os.path.dirname(__file__)
        if local_dir=="": local_dir="."
        if "plugins" in os.listdir(local_dir) and stat.S_ISDIR(os.stat(local_dir+'/plugins')[stat.ST_MODE]):
            plugin_list.append(local_dir+'/plugins')

        for plugin_location in plugin_list:
            if stat.S_ISDIR(os.stat(plugin_location)[stat.ST_MODE]):
                for file in os.listdir(plugin_location):
                    if file[-3:]==".py": strplugins.append(file[:-3])
                #sys.path.insert(0,plugin_location)
                sys.path.append(plugin_location)
            else:
                if plugin_location[-3:]==".py": strplugins.append(plugin_location[:-3])         

        for module in strplugins:
            if module not in self.strplugins:
                try:
                    exec("import "+module)
                    exec("plugin="+module +".plugin")
                    if plugin.OnStartInit():
                        self.plugins.append(plugin)
                        self.strplugins.append(module)
                except: 
		    print "ERROR loading plugin module", module
                    import traceback
                    traceback.print_exception(sys.exc_type, sys.exc_value, sys.exc_traceback)

	options= {"FileToolBar": 1, "WinToolBar": 1, "MenuFile": 1, "MenuTools": 0, "MenuWindow": 1, "MenuHelp": 1,
                  "MenuPlugins":1}
        options.update(user_options)

        self.available_plugins=self.plugins
        self.plugins=[]
        config = {"use_plugins": dict([  [ self.strplugins[i] , 1 ]   for i in range(len(self.strplugins) )] )   }
        
        ####### try to read (write)configuration file
        try:
            old_config = ReadDictio(options["config_file"] )
            config.update(old_config)
        except:
            import traceback
            traceback.print_exc()
            ### try to write anyway a config file for next time
            WriteDictio(config,options["default_config_file"] )


        self.plugins = FilterWantedPlugins( self.strplugins,self.available_plugins ,config )
        
        ApplicationWindow.__init__(self,parent,name, fl,options)

        self.config=config
        self.options=options

        
        self.CurPath='.'
        self.Semaphore=0
        self.ChangingPage=0
        self.optimization=optimization
        for plugin in self.plugins: plugin.OnFinishInit(self)
        for plugin in self.plugins: plugin.processArguments(arguments)

    def EditProperties(self):
        self.editprop_input=cmdln_QTextEdit(None , "editprop_input")
        self.editprop_input.setCaption("editprop_input")
        s="self.config="+self.config.__repr__()+"\n"
        s=s+"self.RefilterPlugins()"+"\n"
        
        self.editprop_input.setText(s)
        self.editprop_input.resize(800,400)
        self.editprop_input.show()
        self.connect(self.editprop_input,
                     qt.PYSIGNAL("cmdln_QTextEdit_execute_sgnl()"),
                     self.Execute)

    def Execute(self, command ):
		command=str(command)
		if(command == ""): return
		COMMAND = str(command)
		if(command[-1]!="\n"): COMMAND=COMMAND+"\n"

		globs= globals()
                self.variables={"self":self}
                
                for key in globs.keys():
                    if ( key not in self.variables.keys() ):
                        self.variables[key] = globs[key]
                exec( COMMAND ,self.variables ,self.variables )
               
    def RefilterPlugins(self):
        
        for plugin in self.plugins: plugin.desactivatePlugin()
        
        self.plugins = FilterWantedPlugins( self.strplugins,self.available_plugins ,self.config )

        self.PluginsMenu.clear()
        
        # for plugin in self.plugins:  plugin.OnFinishInit(self)
        
        self.onInitPluginsMenu(self.PluginsMenu)

        for plugin in self.plugins: plugin.reactivatePlugin()

        WriteDictio(self.config,self.options["default_config_file"] )

    #----------------------------
    #mdi class overridables
    #----------------------------
    def onInitMenuBar(self, menubar):
        for plugin in self.plugins: plugin.OnInitMenuBar(menubar)        
        menufile = menubar.children()[0]
        menufile.insertItem('&Edit properties',self.EditProperties)


        
    



    def onInitPluginsMenu(self, PluginsMenu):
        for plugin in self.plugins: plugin.onInitPluginsMenu(PluginsMenu)
        


    def onOpen(self):
        standard_formats=("EDF files  (*)","Image files (*.png *.jpg *.gif *.bmp)")
        filter=""
        for format in standard_formats: filter=filter+format+";;"

        plugin_formats_dict={}
        for plugin in self.plugins:
            plugin_formats=plugin.GetOpenFormatList()
            for format in plugin_formats:
                filter=filter+format+";;"
                plugin_formats_dict[format]=plugin             
            
        if qt.qVersion()>="3.0.0":
            selected=qt.QString()
            fn = qt.QFileDialog.getOpenFileName(self.CurPath,filter,self,None,qt.QString.null,selected)
        else:
            dlg=qt.QFileDialog(self.CurPath,filter,self,None,1)
            dlg.setCaption("Open")
            dlg.show()
            fn=dlg.selectedFile()
            selected=dlg.selectedFilter()
        if fn.isEmpty(): return
        filename = str(fn)
        format_str=str(selected)
        if format_str in standard_formats:
            format=format_str[-4:-1]
            if string.upper(format) not in ("EDF","PNG","JPG","GIF","BMP"): format="EDF"
            self.loadFile (filename,format)
        else:
            plugin_formats_dict[format_str].OnFileOpen(filename,format_str)
        self.CurPath=os.path.dirname(filename)


    def onLoadInViewFileHighLightedSlot(self,s):
        filename = str(s)
        try:
            self.onLoadInViewData.Delete({"MadeByLoadInView":1})
        except:
            print "MadeByLoadInView has not been found "

        self.onLoadInViewData.SetSource(filename)
        self.onLoadInViewData.LoadSource(append=1)

        n=self.onLoadInViewData.GetNumberPages()
        Info = self.onLoadInViewData.Pages[n-1].Info["MadeByLoadInView"]=1;

        self.onLoadInViewDataSelection.Reconfig(index_list = n-1 )
        self.onLoadInViewWindow.setCaption(s)

        
        self.onLoadInViewData.Invalidate( page_list={"reconfiguremoithis":n-1} )
        
##        data_sel_update_list=[]
##         for win in self.mdi.windowList():
##                 try:
##                     if hasattr(win,"master_window") and win.master_window is self.onLoadInViewWindow:
##                         data_sel=win.View.GetSource()[0].GetDataSelection()
##                         # if data_sel.GetInfo() == self.onLoadInViewWindow.View.GetSource()[0].GetDataSelection().GetInfo():
##                         data_sel_update_list.append(data_sel)
##                 except:
##                     pass
##                 for ds in data_sel_update_list:
##                     ds.Reconfig(index_list=[n-1,])




    def onLoadInView(self):
        window=self.mdi.activeWindow()
        if window==None: return
        view=window.View
        sources=view.GetSource()
        if(len(sources)>1):
            print " YOU ARE TRYING TO LOAD INSIDE A VIEW HAVING SEVERAL SOURCES "
            print " THIS IS IN PRINCIPLE POSSIBLE BUT NOT IPLEMENTED YES "
            print " BY NOW JUST LOAD IN MONODATA VIEWS "
            return
        source = sources[0]
        data=source.GetData()
        dataselection = source.GetDataSelection()
        activepage = dataselection.GetInfo()['index_list'][0]
        filename =   data.GetPageInfo(index=activepage) ['SourceName']
        oldPath=self.CurPath
        self.CurPath=os.path.dirname(filename)
        basename = os.path.basename(filename)
        pos = string.rfind(basename,".")
        
        formats = ("this view (*"+basename[pos:]+")",      "any file (*)" )
        filter=""
        for format in formats: filter=filter+format+";;"

        selected=qt.QString()

        self.DiagW = qt.QFileDialog ( self.CurPath, filter , self, str(view) )
        self.DiagW.setCaption( str(view))
        self.DiagW.show()

        self.onLoadInViewData =data
        self.onLoadInViewDataSelection = dataselection
        self.onLoadInViewWindow=window
        
        self.connect(self.DiagW,qt.SIGNAL("fileHighlighted(const QString&)"),self.onLoadInViewFileHighLightedSlot)

        self.CurPath=oldPath



    def onSaveAs(self):
        window=self.mdi.activeWindow()
        if window==None: return
        filter=""
        standard_formats=[]
        try:
            for fmt in window.View.GetSaveFormats(): standard_formats.append (fmt+" files (*."+string.lower(fmt)+")")
            for format in standard_formats: filter=filter+format+";;"
        except:
            ## my mlab plugin has no View by the moment. Alessandro
            pass

        plugin_formats_dict={}
        for plugin in self.plugins:
            plugin_formats=plugin.GetSaveFormatList(window)
            for format in plugin_formats:
                filter=filter+format+";;"
                plugin_formats_dict[format]=plugin                     
        
        if filter=="":
            self.statusBar().message('No file format supported by view object',4000)
            return
                    
        if qt.qVersion()>="3.0.0":
            selected=qt.QString()
            fn = qt.QFileDialog.getSaveFileName(self.CurPath,filter,self,None,qt.QString.null,selected)
        else:
            dlg=qt.QFileDialog(self.CurPath,filter,self,None,1)
            dlg.setCaption("Save As")
            dlg.show()            
            fn=dlg.selectedFile()
            selected=dlg.selectedFilter()
        if fn.isEmpty(): return
        filename = str(fn)
        format_str=str(selected)

        if not fn.isEmpty():
            window.filename = fn
            if format_str in standard_formats:
                window.save_plugin=None
                window.format=string.upper(format_str[-4:-1])
            else:
                window.save_plugin=plugin_formats_dict[format_str]
                window.format=format_str
            if window.format==".PS":window.format="PS"
            self.onSave()
            self.CurPath=os.path.dirname(filename)
        else:
            self.statusBar().message('Saving aborted',2000)        


    def onSave(self):
        window=self.mdi.activeWindow()
        if window is not None:
            if hasattr (window,"filename")==0 or window.filename.isEmpty():
                self.onSaveAs()
                return
            if window.save_plugin==None: ret=window.View.Save(str(window.filename),str(window.format))
            else: ret= window.save_plugin.OnFileSave(window,str(window.filename),window.format)
            if  ret==0: self.statusBar().message('Error writing file',4000)
                

    def onPrint(self):
        import os
        window=self.mdi.activeWindow()
        if window==None: return

        for plugin in self.plugins:
            if plugin.OnFilePrint(window): return
            
        if "PS" not in window.View.GetSaveFormats():
            self.statusBar().message('Unable to print',4000)
            return
        try:
            if self.printer.setup(self):
                self.statusBar().message('Printing...')
                if self.printer.outputToFile()==1:
			print 'Saving in a file...'
			filename=str(self.printer.outputFileName())
			print filename
			if filename[-3:]!=".ps": filename=filename+'.ps'
			window.View.Save(filename,"PS")
			return
                    
                window.View.Save("_tmp.ps","PS")
                
                printername= str(self.printer.printerName())
                if sys.platform!= "win32":
                    os.system("lp -c -d " + printername + " _tmp.ps")
                else:
                    import win32print
                    printer=win32print.OpenPrinter(printername)
                    win32print.StartDocPrinter(printer,1,("PyDis Doc",None,None))
                    psfile=open("_tmp.ps",'r')
                    win32print.WritePrinter(printer,psfile.read())
                    win32print.EndDocPrinter(printer)
                    win32print.ClosePrinter(printer)
                    psfile.close()                     
                os.remove("_tmp.ps")
                self.statusBar().message('Printing completed',4000)
            else:
                self.statusBar().message('Printing aborted',4000)
        except:
            import traceback
            traceback.print_exc()
            self.statusBar().message('Error printing file',4000)        

    
    def onAbout(self):
        import PyDVT
        import mdi
        msg='PyDis - Generic Image Visualization Tool,\n'
        msg=msg + 'Version: '+ __version__ +'  (PyDVT v'+PyDVT.Binding.__version__+' mdi v'+mdi.__version__+')\n\n'
        msg=msg + 'Plugins: \n'        
        for i in range(len(self.strplugins)):
            msg=msg + self.strplugins[i]+': '+ self.plugins[i].GetInfoString() +'\n'
        msg=msg+'\nBug report: ' + __author__       
        qt.QMessageBox.about(self,'PyDis',msg)

    
    #----------------------------
    #File loading
    #----------------------------
    def setCurPath(self,path):
        self.CurPath=path


    def loadFile (self,filename,type):
        try:
            type=string.upper(type)
            short_name= os.path.split(filename)[1]
            if string.upper(type)=="EDF":
                window=ViewWindow (self.mdi,ExtendedImageView.ExtendedImageView,short_name,{"AddSelection":0,"SelectionCallback":self.EventSelection,"UseColormapWidget":1,"AddReduc":1})
                window.shortName=short_name
                window.fileName=filename
                window.Data=EdfFileData.EdfFileData()
                if self.optimization > 0:
                    window.Data.SetSource(filename)
                    window.Data.LoadSource()
                    window.manages_optimization=1
                else:                    
                    window.Data.SetSource(filename)
                    window.DataSelection=DataSelection.RectSelection(window.Data)
                    window.Filter=ImageView.ColormapFilter(None,window.DataSelection)
                    window.View.SetSource(window.Filter)                    
                info=window.Data.GetSourceInfo()
                window.NumImages=info["Size"]
                if self.optimization > 1:
                    window.Filters=[]
                    for i in range(window.NumImages):
                        window.Filters.append(Filter.Filter(ImageView.ColormapFilter(None,DataSelection.RectSelection(window.Data,page=i)),buffer_input=1))
                        if self.optimization ==3: window.Filters[i].GetOutput()
                self.SetEdfViewMenu(window)
                self.PageSelect(window,0)                
		# --- the method ConvertInformation is missing !!
		# --- so i commented all that. EP
		#info=window.Data.GetPageInfo(0)
		#if info.has_key('PSize_1') and info.has_key('PSize_2'): 
		    #value1=self.ConvertInformation(info['PSize_1'],'um')
		    #value2=self.ConvertInformation(info['PSize_2'],'um')
		    #if value1!=None and value2!=None: window.pixelsize=(value1,value2)
		#if info.has_key('Center_1') and info.has_key('Center_2'): 
		    #value1=self.ConvertInformation(info['Center_1'])
		    #value2=self.ConvertInformation(info['Center_2'])
		    #if value1!=None and value2!=None: window.center=(value1,value2)
		#if info.has_key('WaveLength'): 
		    #value=self.ConvertInformation(info['WaveLength'],'angstroms')
		    #if value!=None: window.wavelength=value
		#if info.has_key('SampleDistance'): 
		    #value=self.ConvertInformation(info['SampleDistance'],'mm')
		    #if value!=None: window.distance=value           
            elif (type=="JPG" or type=="GIF" or type=="BMP" or type=="PNG"):
                window=ViewWindow (self.mdi,ExtendedImageView.ExtendedImageView,short_name,{"AddSelection":0,"AddColormap":0,"AddReduc":0})
                window.fileName=filename
                window.Data=ImageFileData.ImageFileData()
                window.Data.SetSource(filename)
                window.DataSelection=DataSelection.RectSelection(window.Data)
                window.Filter=ImageView.ImageFilter(None,window.DataSelection)
                window.View.SetSource(window.Filter)
                window.View.AddMenuPopupItem("Data Info",self.DataInfo)                       
                window.Data.LoadSource()
            else:
                window.close()
                self.statusBar().message('Unknown file type',4000)
        except:
            import traceback
            traceback.print_exc()
            try:
                window.close()
            except:
                import traceback
                traceback.print_exception(sys.exc_type, sys.exc_value, sys.exc_traceback)
                pass
            self.statusBar().message('Error loading file',4000)

    #----------------------------
    #Default Menus
    #----------------------------

    def Set1DViewMenu(self,window):
        window.View.AddMenuSeparator()
        window.View.AddMenuPopupItem("Set Color",self.SelectColor)
        window.View.AddMenuPopupItem("Table",self.Table)
        window.View.AddMenuPopupItem("Data Info",self.DataInfo)
        for plugin in self.plugins:plugin.OnInitWindowPopupMenu(window)        

            
    def Set2DViewMenu(self,window):
        window.View.AddMenuSeparator()
        window.View.AddMenuPopupItem("Histogram",Command.Command(self.Histogram,window))
        window.View.AddMenuPopupItem("Contour Plot",Command.Command(self.ContourPlot,window))
        window.View.AddMenuPopupItem("Mesh Plot",Command.Command(self.MeshPlot,window))
        window.View.AddMenuPopupItem("Table",self.Table)
        window.View.AddMenuPopupItem("Data Info",self.DataInfo)
	window.CheckStat= window.View.AddMenuPopupItem("Stat Info", 
				Command.Command(self.StatInfo, window), "checkbutton")
        for plugin in self.plugins: plugin.OnInitWindowPopupMenu(window)


    def SetEdfViewMenu(self,window):
        window.View.AddMenuSeparator()
        cascademenu=Menu(window.View.GetPopupMenu())
        cascademenu.AddCommand("Horizontal",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectHLine),"radiobutton")
        cascademenu.AddCommand("Vertical",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectVLine),"radiobutton")
        cascademenu.AddCommand("Line",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectLine),"radiobutton")
        cascademenu.AddCommand("Rectangle",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectRect),"radiobutton")
        cascademenu.AddSeparator()
        if hasattr(window,"NumImages" ):
         if window.NumImages > 1:
            cascademenu.AddCommand("Depth Point",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectPoint,callback=self.EventDepthSelection),"radiobutton")        
            cascademenu.AddCommand("Depth Horizontal",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectHLine,callback=self.EventDepthSelection),"radiobutton")
            cascademenu.AddCommand("Depth Vertical",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectVLine,callback=self.EventDepthSelection),"radiobutton")
            cascademenu.AddSeparator()
        cascademenu.AddCommand("Clear Selection",window.View.ClearViewSelect,"radiobutton")
        cascademenu.SetCheckedRadio("Clear Selection")
        window.View.AddMenuPopupCascade("Selection",cascademenu)
        self.Set2DViewMenu(window)
        window.View.AddMenuSeparator()
        if hasattr(window,"NumImages" ):
         if window.NumImages > 1:
            window.image_selection_menu=Menu(window.View.GetPopupMenu())
            for i in range(window.NumImages): window.image_selection_menu.AddCommand(str(i+1),Command.Command(self.PageSelect,window,i),"radiobutton")
            window.image_selection_menu.SetCheckedRadio("1")
            window.View.AddMenuPopupCascade("Select Image",window.image_selection_menu)
            self.AddImageSlider(window,self.onImageSelectionSliderChanged)

    def SetContourViewMenu(self,window,target_window):
        window.View.AddMenuSeparator()
        popupMenu=Menu(window.View.GetPopupMenu())
        for op in ('None','Transpose','FlipY','FlipX','FlipXY','Rotate90','Rotate180','Rotate270'):
            popupMenu.AddCommand(op,Command.Command(self.ContourTransf, window, op) ,"radiobutton")
        popupMenu.SetCheckedRadio('None')                    
        window.View.AddMenuPopupCascade("Transformation",popupMenu)                
        window.View.AddMenuSeparator()
        window.View.AddMenuPopupItem("Mesh Plot",Command.Command(self.MeshPlot,target_window))
        window.View.AddMenuPopupItem("Table",self.Table)
        window.View.AddMenuPopupItem("Data Info",self.DataInfo)
        for plugin in self.plugins: plugin.OnInitWindowPopupMenu(window)        

    def SetMeshViewMenu(self,window,target_window):
        window.View.AddMenuPopupItem("Set Color",self.SelectColor)
        window.View.AddMenuSeparator()
        window.View.AddMenuPopupItem("Contour Plot",Command.Command(self.ContourPlot,target_window))
        window.View.AddMenuPopupItem("Table",self.Table)
        window.View.AddMenuPopupItem("Data Info",self.DataInfo)
        for plugin in self.plugins: plugin.OnInitWindowPopupMenu(window)        

    def SetTableViewMenu(self,window):
        window.View.AddMenuSeparator()
        window.View.AddMenuPopupItem("Data Info",self.DataInfo)
        for plugin in self.plugins: plugin.OnInitWindowPopupMenu(window)        

    #----------------------------
    #View operations
    #----------------------------
    def AddImageSlider(self,window,callback):
        SliderFrame=qt.QHBox(window.View)
        window.SliderLabel=qt.QLabel(SliderFrame)
        window.Slider=qt.QSlider(0,window.NumImages-1,1,0,qt.Qt.Horizontal,SliderFrame)
        window.Slider.setTickmarks(qt.QSlider.Below)
        self.connect(window.Slider,qt.SIGNAL("valueChanged(int)"),callback)
        window.SliderLabel.setText("Image: 999" )
        qt.qApp.processEvents()
        window.SliderLabel.setFixedWidth(window.SliderLabel.width())
        window.SliderLabel.setText("Image: 1" )
        SliderFrame.show()

    def StatInfo(self, window):
        if window.View.GetPopupMenu().IsItemChecked(window.CheckStat):
	    self.HideStatInfo(window)
	    window.View.GetPopupMenu().CheckItem(window.CheckStat, 0)
        else:
	    self.ShowStatInfo(window)
	    window.View.GetPopupMenu().CheckItem(window.CheckStat, 1)

    def ShowStatInfo(self, window):
	window.StatView= ImageStatView(window.View)
	window.View.setStretchFactor(window.StatView, 1)
	window.View.setStretchFactor(window.View.Drawable, 5)
	window.StatFilter= ImageView.ImageStatFilter(None, window.DataSelection)
	window.StatView.SetSource(window.StatFilter)
	window.StatView.show()

    def HideStatInfo(self, window):
	window.StatView.hide()
	window.StatView.Destroy()
	window.StatFilter.Destroy()
	window.StatView= None
	window.StatFilter= None

    def Table(self):
        window=self.mdi.activeWindow()
        prefix= "Table - "
        window_name=prefix + str(window)
        tableWindow=self.GetWindow(window_name)
        if tableWindow is None:            
            tableWindow=ViewWindow (self.mdi,TableView.TableView,window_name,master_window=window)
            self.SetTableViewMenu(tableWindow)
            tableWindow.SetTitle(None,prefix=prefix)
            tableWindow.View.SetSource(window.View.GetSource())
        else: tableWindow.setFocus()

    def DataInfo(self):
        window=self.mdi.activeWindow()
        prefix= "Data Info - "
        window_name=prefix + str(window)
        dataInfoWindow=self.GetWindow(window_name)
        if dataInfoWindow is None:
            dataInfoWindow=ViewWindow (self.mdi,DataInfoView.DataInfoView,window_name,master_window=window)
            dataInfoWindow.SetTitle(None,prefix=prefix)
            dataInfoWindow.View.SetSource(window.View.GetSource())
        else: dataInfoWindow.setFocus()


    def EventHistSelection(self,source):
        ((x0,y0),(x1,y1))=source.GetSelection()["BoundingRect"]        
        ColormapPars=source.Target.GetColormapParameters()
        ColormapPars["MinMax"]=(x0,x1)
        ColormapPars["AutoScale"]=0
        source.Target.SetColormapParameters(ColormapPars)        
        

    def DefineColormap(self,histWindow):
        if histWindow.View.GetPopupMenu().IsItemChecked(histWindow.chkColormap):
            histWindow.View.GetPopupMenu().CheckItem(histWindow.chkColormap,0)
            histWindow.View.GetPopupMenu().EnableItem(histWindow.View.ZoomMenuItem)
            if hasattr(histWindow,"Select") and histWindow.Select is not None:
                histWindow.Select.Destroy()
            histWindow.Select=None
        else:
            histWindow.View.GetPopupMenu().CheckItem(histWindow.chkColormap,1)
            histWindow.View.GetPopupMenu().DisableItem(histWindow.View.ZoomMenuItem)
            data=histWindow.View.GetSource()[0].GetData()
            if data==None: return
            if hasattr(histWindow,"Select") and histWindow.Select is not None:
                histWindow.Select.Destroy()
            histWindow.Select=GraphViewSelect.GraphViewSelectHRect(data,self.EventHistSelection)
            histWindow.Select.SetBrush(Brush((240,240,240),"fill_100"))
            histWindow.Select.Target=histWindow.master_window.Filter
            histWindow.Select.ConnectView(histWindow.View)        
        

    def Histogram(self,window):        
        if (window.Filter is not  None):
            prefix= "Histogram - "
            window_name=prefix + str(window)                    
            histWindow=self.GetWindow(window_name)
            if histWindow is None:
                histWindow=ViewWindow (self.mdi,GraphView.GraphView,window_name,{"AddStyleSelect":1,"AddCursorSelect":1,"AddStatus":1,"AutoHideStatus":1},master_window=window)
                histWindow.SetTitle(window.caption(),prefix=prefix) 
                histWindow.View.AddMenuSeparator()
                histWindow.chkColormap=histWindow.View.AddMenuPopupItem("Define Colormap",Command.Command(self.DefineColormap,histWindow),"checkbutton")
                histWindow.View.AddMenuPopupItem("Table",self.Table)
                histWindow.View.AddMenuPopupItem("Set Color",self.SelectColor)
                histWindow.DataSelection=window.DataSelection
                histWindow.pen=Pen((0,196,0),1,"solid")
                histWindow.Filter=GraphView.HistFilter("1",histWindow.DataSelection,pen=histWindow.pen)
                histWindow.Filter.SetDivisions(100)
                histWindow.View.SetStyle("Bars")
                histWindow.View.SetLabels(x_label="Value",y_label="Count")
                histWindow.View.SetSource(histWindow.Filter)
            else:
                histWindow.setFocus()

            
    def ContourTransf(self, contourWindow, transf):
        if transf in ('Transpose','Rotate90','Rotate270'): contourWindow.View.SetLabels(x_label="(y)",y_label="(x)")        
        else: contourWindow.View.SetLabels(x_label="(x)",y_label="(y)")
        contourWindow.Filter.SetTransformation(transf,refresh=1)


    def ContourPlot(self,window):
        if (window.Filter != None):
            prefix="Contour Plot - "
            window_name= prefix+ str(window)
            contourWindow=self.GetWindow(window_name)
            if contourWindow is None:
                contourWindow=ViewWindow (self.mdi,ContourView.ContourView,window_name,master_window=window)
                contourWindow.SetTitle(window.caption(),prefix=prefix)
                self.SetContourViewMenu(contourWindow,window)
                contourWindow.DataSelection=window.DataSelection
                contourWindow.Filter=Transf2DFilter.Transf2DFilter(ContourView.ContourFilter("1",contourWindow.DataSelection))
                contourWindow.View.SetLabels(x_label="(x)",y_label="(y)")
                contourWindow.View.SetSource(contourWindow.Filter)
            else:
                contourWindow.setFocus()


    def MeshPlot(self,window):
        if (window.Filter != None):
            prefix="Mesh Plot - "
            window_name=prefix + str(window)        
            meshWindow=self.GetWindow(window_name)
            if meshWindow is None:
                meshWindow=ViewWindow (self.mdi,MeshView.MeshView,window_name,master_window=window)
                meshWindow.SetTitle(window.caption(),prefix=prefix)
                self.SetMeshViewMenu(meshWindow,window)
                meshWindow.pen=Pen((128,128,128),1,"solid")  
                meshWindow.View.SetLabels(x_label="(x)",y_label="(y)",z_label="")
                meshWindow.DataSelection=window.DataSelection
                meshWindow.Filter=MeshView.MeshFilter(name="1",source=meshWindow.DataSelection,pen=meshWindow.pen)
                meshWindow.View.SetSource(meshWindow.Filter)
            else:
                meshWindow.setFocus()
            

    def PageSelect(self,window,page):
        window.SelectedPage=page
        self.ChangingPage=1
        if window.NumImages > 1:                   
            window.SetTitle(window.shortName + " - %d/%d" % (page+1,window.NumImages))
            window.image_selection_menu.SetCheckedRadio(str(page+1))
            window.SliderLabel.setText("Image: %d" %(page+1,))            
            if window.Slider.value() != page: window.Slider.setValue(page)
        if hasattr(window,"manages_optimization")==0  or window.manages_optimization==0:
            window.Data.LoadSource(page)
        else:
            data_sel_update_list=[]
            for win in self.mdi.windowList():
                try:
                    if hasattr(win,"master_window") and win.master_window is window:
                        data_sel=win.View.GetSource()[0].GetDataSelection()
                        if data_sel.GetInfo() == window.View.GetSource()[0].GetDataSelection().GetInfo():
                            data_sel_update_list.append(data_sel)
                except: pass
            if self.optimization == 1:
                window.DataSelection=DataSelection.RectSelection(window.Data,page=page)
                window.Filter=ImageView.ColormapFilter(None,window.DataSelection,buffer_input=1)
                window.View.SetSource(window.Filter)
            else:
                window.Filter=window.Filters[page]
                window.DataSelection=window.Filter.GetDataSelection()
                window.View.SetSource(window.Filters[page])            
            view_select=window.View.GetViewSelect()
            for data_sel in data_sel_update_list: data_sel.Reconfig(index_list=[page,])
            if view_select is not None: view_select.NotifySelection()

        self.ChangingPage=0

            
    def onImageSelectionSliderChanged(self,page):
        window=self.mdi.activeWindow()
        if hasattr (window,"SelectedPage") and page != window.SelectedPage: self.PageSelect(window,page)
        window.setFocus()
        

                        
    def SelectColor(self):
        window=self.mdi.activeWindow()
        if not hasattr(window,"pen"): window.pen=Pen((0,0,0),1,"solid")
        color = qt.QColorDialog.getColor(qt.QColor(window.pen.color[0],window.pen.color[1],window.pen.color[2]))
        window.pen=Pen((color.red(),color.green(),color.blue()),window.pen.width,window.pen.style)
        window.View.SetPen("1",window.pen)                  
        

    def EventSelection(self,source,depth_selection=0):        
        sel=source.GetDataSelection()
        origin=self.mdi.activeWindow()
        if sel==None or origin==None or hasattr(origin,"View")==0:return
        if origin.View.__class__ is not ExtendedImageView.ExtendedImageView or hasattr(origin,"sufix"):return
        if self.Semaphore: return
        self.Semaphore=1
        try:
            if hasattr(origin,"manages_optimization")==0 or origin.manages_optimization==0: optimization=0
            else: optimization= self.optimization
            if depth_selection==0:
                if optimization>0 :page=origin.SelectedPage
                else: page=0
                if source.GetType() == "Rect":
                    windowname=str(origin)+" - Rect"                    
                    window=self.GetWindow(windowname)
                    sufix=" - Rectangle Selection (%d,%d) to (%d,%d)" % (sel.Position[0],sel.Position[1],sel.Position[0]+sel.Size[0],sel.Position[1]+sel.Size[1])
                    
                    if window is None:
                        window=ViewWindow (self.mdi,ExtendedImageView.ExtendedImageView,windowname,{"ZoomMode":"FIT_TO_SCREEN","ScrollMode":"OFF","AddSelection":0,"AddReduc":0,"SelectionCallback":self.EventSelection,"UseColormapWidget":1},master_window=origin)
                        window.SetTitle(origin.caption(),sufix=sufix)  
                        self.Set2DViewMenu(window)
                        window.DataSelection=DataSelection.XYRectSelection(source.Data,position=sel.Position,size=sel.Size,page=page)
                        window.Filter=ImageView.ColormapFilter(None,window.DataSelection)
                        window.Filter.SetColormapParameters(origin.View.GetColormapFilter().GetColormapParameters())
                        window.View.SetSource(window.Filter)
                    else:
                        window.SetTitle(origin.caption(),sufix=sufix)  
                        window.DataSelection.Reconfig(position=sel.Position,size=sel.Size,index_list=page)                    
                elif source.GetType() in ("HLine","VLine","Line"):                
                    if   source.GetType()=="HLine":
                        windowname=str(origin)+" - HLine"
                        sufix=" - Horizontal Selection (y=%d)" % (sel.Position[1],)
                    elif source.GetType()=="VLine":
                        windowname=str(origin)+" - VLine"
                        sufix=" - Vertical Selection (x=%d)" % (sel.Position[0],)
                    elif source.GetType()=="Line":
                        windowname=str(origin)+" - Line"
                        sufix=" - Line Selection (%d,%d) to (%d,%d)" % (sel.Begin[0],sel.Begin[1],sel.End[0],sel.End[1])
                    window=self.GetWindow(windowname)
                    if window is None:
                        window=ViewWindow (self.mdi,GraphView.GraphView,windowname,{"AddCursorSelect":1,"AddStyleSelect":1,"ScrollMode":"ON","AddStatus":1,"AutoHideStatus":1,},master_window=origin)
                        window.SetTitle(origin.caption(),sufix=sufix)  
                        self.Set1DViewMenu(window)
                        if not hasattr(window,"pen"): window.pen=Pen((0,196,0),1,"solid")
                        if source.GetType()=="Line":
                            window.DataSelection=DataSelection.LineSelection(source.Data,begin=sel.Begin,end=sel.End,page=page)
                        else:
                            window.DataSelection=DataSelection.OrthoLineSelection(source.Data,position=sel.Position,size=sel.Size,page=page)
                        window.Filter=GraphView.GraphFilter("1",window.DataSelection,pen=window.pen)
                        window.View.SetLabels(x_label="Point",y_label="Value")
                        window.View.SetSource(window.Filter)
                    else:
                        window.SetTitle(origin.caption(),sufix=sufix)  
                        window.View.SetLabels(x_label="Point",y_label="Value")
                        if source.GetType()=="Line":
                            window.DataSelection.Reconfig(begin=sel.Begin,end=sel.End,index_list=page)
                        else:
                            window.DataSelection.Reconfig(position=sel.Position,size=sel.Size,index_list=page)                    
            else:
                pos = source.GetSelection()["BoundingRect"][0]
                if source.GetType()=="Point":
                    windowname=str(origin)+" - Depth Point"
                    sufix=" - Depth Point Selection (x=%d y=%d)" % pos.PageCoord                
                    classname=GraphView.GraphView
                    opts={"AddCursorSelect":1,"AddStyleSelect":1,"ScrollMode":"ON","AddStatus":1,"AutoHideStatus":1,}
                else:
                    if source.GetType()=="VLine":   
                        windowname=str(origin)+" - Depth VLine"                    
                        sufix=" - Depth Vertical Selection (x=%d)" % (pos.PageCoord[0],)
                    else:
                        windowname=str(origin)+" - Depth HLine"                    
                        sufix=" - Depth Horizontal Selection (y=%d)" % (pos.PageCoord[1],)
                    classname=ExtendedImageView.ExtendedImageView
                    ###I'm setting "UseImageValues" to 1 because I don't have so far a DataSelection with coords convertion for cross-page selection
                    opts={"UseImageValues":1,"AddSelection":0,"SelectionCallback":self.EventSelection,"UseColormapWidget":1}
                window=self.GetWindow(windowname)
                if window is None:
                    window=ViewWindow (self.mdi,classname,windowname,opts,master_window=origin)
                    if source.GetType()=="Point":
                        window.View.SetStyle("PointsLine")
                        self.Set1DViewMenu(window)
                    else:
                        self.Set2DViewMenu(window)
                window.SetTitle(origin.shortName,sufix=sufix)
                if optimization==0:
                    if hasattr(window,"Data")==0 or window.Data is None:
                        window.Data=EdfFileData.EdfFileData()
                        window.Data.SetSource(origin.fileName)
                
                if source.GetType()=="Point":
                    window.View.SetLabels(x_label="Image",y_label="Value")
                    if optimization==0: window.Data.LoadSource(pos=pos.PageCoord, size=(1,1),invalidate=0)
                    if not hasattr(window,"pen"): window.pen=Pen((255,0,0),2,"solid")
                    if optimization != 0 or hasattr(window,"DataSelection")==0:
                        if optimization==0: window.DataSelection=DataSelection.DataSelection(window.Data,(0,0),(1,1),"ALL",1)
                        else: window.DataSelection=DataSelection.DataSelection(origin.Data,pos.PageCoord,(1,1),"ALL",1)
                        window.Filter=GraphView.GraphFilter("1",window.DataSelection,pen=window.pen)
                        window.View.SetSource(window.Filter)
                    else:
                        if optimization==0: window.Data.Invalidate()
                else:
                    if source.GetType()=="VLine":
                        if optimization==0: window.Data.LoadSource(pos=(pos.PageCoord[0],0), size=(1,"ALL"),invalidate=0)
                    else:
                        if optimization==0: window.Data.LoadSource(pos=(0,pos.PageCoord[1]), size=("ALL",1),invalidate=0)                    
                    if  hasattr(window,"DataSelection")==0:
                        if source.GetType()=="VLine":
                            if optimization==0: window.DataSelection=DataSelection.RectSelection(window.Data,(0,0),(1,"ALL"),"ALL")
                            else: window.DataSelection=DataSelection.RectSelection(origin.Data,(pos.PageCoord[0],0),(1,"ALL"),"ALL")
                        else:
                            if optimization==0: window.DataSelection=DataSelection.RectSelection(window.Data,(0,0),("ALL",1),"ALL")
                            else: window.DataSelection=DataSelection.RectSelection(origin.Data,(0,pos.PageCoord[1]),("ALL",1),"ALL")
                        window.Filter=ImageView.ColormapFilter("",window.DataSelection)
                        window.View.SetSource(window.Filter)
                    else:
                        if optimization == 0:
                            window.Data.Invalidate()
                        else:
                            if source.GetType()=="VLine":
                                window.DataSelection.Reconfig(position=(pos.PageCoord[0],0),size=(1,"ALL"),index_list="ALL")
                            else:
                                window.DataSelection.Reconfig(position=(0,pos.PageCoord[1]),size=("ALL",1),index_list="ALL")
        except: 
            import traceback
            traceback.print_exc()
        self.Semaphore=0


    def EventDepthSelection  (self,source):
        if self.ChangingPage == 0:
            self.EventSelection(source,depth_selection=1)


    def GetWindow(self,name):
        for window in self.mdi.windowList():
            if window.name==name:
                return window
        return None

       
class ViewWindow(ChildWindow):
    
    def __init__(self,parent,view_class,name="",view_pars={},master_window=None):
        view_pars["AddOnLine"]=1
        view_pars["AddLockPosition"]=1
        view_pars["AddRefresh"]=1
        view_pars["DataChangedCallback"]=self.DataChangedCallback
        activewindow=parent.activeWindow()
        if activewindow is not None:
            if qt.qVersion()>="3.0.0":
                if activewindow.isMaximized():
                    activewindow.showNormal()
            else:
                activewindow.showNormal()
                
        ChildWindow.__init__(self,parent,name,master_window,qt.Qt.WDestructiveClose)
        self.name=name
        self.parent=parent
        self.OnLine=1
        self.LockZoom=0
        self.View =view_class(self,view_pars)
        self.SetTitle(name)
        self.setCaption(name)
	self.View.SetSize(self.width(), self.height())
        self.View.Show()

        self.view_class = view_class
        self.master_window = master_window
        self.view_pars= view_pars



    def __getstate__(self):
        print " GETSTATE ViewWindow "
     	ret={}
        ret['view']=self.View
        ret['name']=self.name
	print self
        ret['view_class']=self.view_class
        
        ret['master_window']=self.master_window 
        print self.view_pars
        if "DataChangedCallback" in self.view_pars.keys():
           self.view_pars["DataChangedCallback"] =None
        ret['view_pars']=self.view_pars
        print ret
        return ret

    def __setstate__(self, dict):

        print " SETSTATE ViewWindow "
        
	ViewWindow.__init__(self, 
		currentApplicationWindow[0].mdi,
		dict["view_class"],
		dict["name"],
		dict["view_pars"],
		dict["master_window"])

        if dict["view"] is None:
            return
        for key in dict["view"].__dict__.keys():
            if(key=='Source'):
                pass
            elif(key != 'eh'):
                self.View.__dict__[key] = dict["view"].__dict__[key]


        for key in dict["view"].drawable_dict.keys():
            self.View.Drawable.__dict__[key] = dict["view"].drawable_dict[key]

        
        source=dict["view"].__dict__['Source']
        for sel in source:
            if sel.eh is not None:
                sel.eh.unregister("DataChange",dict["view"]._DataChanged)
                sel.eh.unregister("DeleteEvent",dict["view"]._DataDeleted)                    
 
        self.View.SetSource( source )

        if hasattr(self.View, "UpdateAfterPickleLoad") :
            self.View.UpdateAfterPickleLoad()
        ###self.View.DataChanged()

        
    def SetTitle(self,title=None,prefix=None,sufix=None):
        if prefix is not None: self.prefix=prefix
        if sufix is not None: self.sufix=sufix
        
        if hasattr(self,"sufix"): title=str(title)+self.sufix
        if title is None:
            if hasattr(self,"master_window"):
                title=self.master_window.OriginalCaption
        self.OriginalCaption=str(title)

        for window in self.parent.windowList():            
            if hasattr(window,"master_window") and window.master_window is self:
                window.SetTitle(title)

    def DataChangedCallback(self,view,source=None):
        if hasattr(self,"prefix"): ChildWindow.setCaption(self,self.prefix+self.OriginalCaption)
        else: ChildWindow.setCaption(self,self.OriginalCaption)

    def resizeEvent(self,e):
        if hasattr(self,"View"): self.View.SetSize(self.width(),self.height())


    def focusInEvent (self,e):
        if hasattr(self,"View"): self.View.GetDrawable().setFocus()


    def closeEvent(self,ce):
        for window in self.parent.windowList():            
            if hasattr(window,"master_window") and window.master_window is self: window.close(1)
        
        if hasattr(self,"Select") and self.Select is not None: self.Select.Destroy()
        if hasattr(self,"Data") and self.Data is not None: self.Data.Destroy()
        if hasattr(self,"View") and self.View is not None: self.View.Destroy()
        self.Data=None
        self.Filter=None
        self.DataSelection=None
        self.View=None
        ChildWindow.closeEvent(self,ce)
        self.parent=None

class ImageStatView(View.View): 
    names= ["min", "max", "mean", "std"]

    def __init__(self, parent=None):
        View.View.__init__(self, parent)

    def CreateDrawable(self):
	group= qt.QHGroupBox(self)
	group.setInsideSpacing(0)
	group.setInsideMargin(3)
	self.table= qttable.QTable(group)
	self.table.setNumCols(len(self.names))
	self.table.setNumRows(1)
	self.table.adjustRow(0)
	for idx in range(len(self.names)):
	    self.table.horizontalHeader().setLabel(idx, self.names[idx])
	    self.table.setColumnReadOnly(idx, 1)
	    self.table.adjustColumn(idx)
	self.table.verticalHeader().hide()
	self.table.setLeftMargin(0)
	self.table.show()
	group.show()

    def DataChanged(self, source=None):
        if self.Source!=():
            data= self.Source[0].GetOutput()
	    for idx in range(len(self.names)):
		value= data.get(self.names[idx], None)
		if value is None:
			text= ""
		else:	text= "%g"%value
		self.table.setText(0, idx, text)
		self.table.adjustColumn(idx)
			

class Plugin:
    def OnStartInit (self):
        return 1

    def OnInitMenuBar (self,menu_bar):
        pass

    def onInitPluginsMenu (self,menu):
        pass

    def OnFinishInit (self,app_window):
        pass

    def OnInitWindowPopupMenu (self,window):
        pass

    def OnFileOpen (self,filename,format_string):
        pass

    def OnFileSave (self,window,filename,format_string):
        return 1

    def OnFilePrint(self,window):
        return 0
    
    def GetOpenFormatList(self):
        return []

    def GetSaveFormatList(self,window):
        return []

    def GetInfoString(self):
        return ""



    def desactivatePlugin(self):
        pass
    
    def reactivatePlugin(self):
        pass


    def processArguments(self, arguments):
        pass

	
class cmdln_QTextEdit(qt.QTextEdit):
	def __init__(self,*args,**keys):
		qt.QTextEdit.__init__(self,*args,**keys)
                self.masterWindow=args[0]
        def keyPressEvent( self,  e ):
		tx=  e.ascii()
		sta = e.state()
		if( sta ==qt.Qt.ShiftButton  and tx==13):
			s=self.selectedText()
			if(str(s)==""):
				(para,inde)=self.getCursorPosition()
				s=self.text(para)
			self.emit(qt.PYSIGNAL("cmdln_QTextEdit_execute_sgnl()"),(s,))
		else:
			qt.QTextEdit.keyPressEvent(self,e)
	
