#!/usr/bin/env python
import sys, getopt, string, os.path
import qt

def printHelp():
	help= """
PyDis - Command line arguments

Usage: PyDis [-opt1 <par1>] [-opt2 <par2>] ...

***Data options:
-f (--filename=) filename
	File to be open on startup window
-t (--filetype=) filetype
	Can be: edf,jpg,png,bmp,...  If omitted, use filename extension.
	If more than one (-f) option is specified, (-t) is applied 
	on preceding (-f)
-a (--specarray=) specname:array
	Open shared array named <array> from spec session <specname>
-d (--directory=) <directory_name>
	Sets working directory

***Application options:
-p (--plugin) <filename_or_dirname>
	Sets plugin file or directory to read plugins from.
	If directory, assumes all files inside are plugins.
	If file, it must be inside PyDis directory or in Python path.
	Several (-p) options can be specified.
-r (--repaint)
	If set, windows are repaint while resizing
-o (--optimize) <0..3>
	This parameter sets if and how data is buffered in memory.
	0 (default): 	optimize memory usage. The only data buffered
			is the actual displayed image. Best performance for X.
			The default should be kept in the majority of cases.
	1:	buffers all data. All image data in a file is loaded in a data object.
	2:	buffers data and images. Colormap transformed images are buffered
		in a filter and are ready for display.
	3:	Same as 2, but all images are generated when the file is loaded.
		Scrolling between images very fast when executing locally, but it
		takes memory and load time
-q (--qwt)
	Use QWT plot widget instead of PlPlot for 2D graphs

-C (--cf=) <file name> Reads configuration from a specified file.
			
***Graphic options:
-S (--Style=) <qt_style>
	Sets application style (Windows,Motif,MotifPlus,CDE,SGI,Platinum)
	If omitted uses qt's default
-F (--Font=) <font>:<size>:<weight>:<italic>
	Sets application font. If omitted uses qt's default
		<font>: helvetica, times, ...
		<size>: font size, default=12
		<weight>: 0 to 100. Normal=50, Bold=100
		<italic>: 0 or 1
-M (--Maximized)
	Starts PyDis maximized
-s (--size=) <width>x<height>
	Setup window size (default=600x400)
"""
	print help
	sys.exit(0)
		
def parseArguments():
	import getopt

##########################################################################
# - in case you run with a poor qt missing features use this
# -       qt_styles= {}
# -       if hasattr(qt,"QWindowsStyle"):  qt_styles["Windows"]=qt.QWindowsStyle
# -       if hasattr(qt,"QMotifPlusStyle"):  qt_styles["MotifPlus"]=qt.QMotifPlusStyle
# -       if hasattr(qt,"QMotifStyle"):  qt_styles["Motif"]=qt.QMotifStyle
# -       if hasattr(qt,"QCDEStyle"):  qt_styles["CDE"]=qt.QCDEStyle
# -       if hasattr(qt,"QSGIStyle"):  qt_styles["SGI"]=qt.QSGIStyle
# -       if hasattr(qt,"QPlatinumStyle"):  qt_styles["Platinum"]=qt.QPlatinumStyle
###########################################################################################

        try:
		qt_styles= {
		"Windows":	qt.QWindowsStyle,
		"MotifPlus":	qt.QMotifPlusStyle,
		"Motif":	qt.QMotifStyle,
		"CDE":		qt.QCDEStyle,
		"SGI":		qt.QSGIStyle,
		"Platinum":	qt.QPlatinumStyle }
	except:
		qt_styles= {}
		if hasattr(qt,"QWindowsStyle"):  qt_styles["Windows"]=qt.QWindowsStyle
		if hasattr(qt,"QMotifPlusStyle"):  qt_styles["MotifPlus"]=qt.QMotifPlusStyle
		if hasattr(qt,"QMotifStyle"):  qt_styles["Motif"]=qt.QMotifStyle
		if hasattr(qt,"QCDEStyle"):  qt_styles["CDE"]=qt.QCDEStyle
		if hasattr(qt,"QSGIStyle"):  qt_styles["SGI"]=qt.QSGIStyle
		if hasattr(qt,"QPlatinumStyle"):  qt_styles["Platinum"]=qt.QPlatinumStyle
		
	short= ["f:", 		"t:", 		"a:",
		"d:",		"p:",		"r",
		"o:",		"q",		"S:",
		"F:",		"M",		"s:",
		"h" ,           "C:"                     ]
	long= [	"filename=",	"filetype=",	"specarray=",
		"directory=",	"plugin=",	"repaint",
		"optimize=",	"qwt",		"Style=",
		"Font=",	"Maximized",	"size=",
		"help" ,        "cf="                         ]

	try:
		opts, args= getopt.getopt(sys.argv[1:], string.join(short), long)
	except getopt.error, msg:
		print "%s: ERROR while parsing command line arguments"%sys.argv[0]
		print "\t%s"%msg
		sys.exit(0)

    
	options= {"plugins":      [],
		  "filename":     [],
		  "specarray":    [] ,
		  "config_file":  os.getenv("HOME")+"/"+".pydis.conf",
		  "default_config_file":  os.getenv("HOME")+"/"+".pydis.conf",
		  }

        print opts 
	for opt,arg in opts:
		if opt in ("-h", "--help"):
			printHelp()
		if opt in ("-f", "--filename"):
			options["filename"].append([arg,None])
		if opt in ("-t", "--filetype"):
			if len(options.get("filename",[])):
				options["filename"][len(options["filename"])-1][1]= arg
		if opt in ("-a", "--specarray"):
			par= arg.split(":")
			if len(par)==2:
				options["specarray"].append([par[0], par[1]])
			else:
				print "WARNING: Cannot parse specarray option (%s)"%arg
		if opt in ("-d", "--directory"):
			options["directory"]= arg
		if opt in ("-p", "--plugin"):
			options["plugins"].append(arg)
		if opt in ("-r", "--repaint"):
			options["repaint"]= 1
		if opt in ("-o", "--optimize"):
			try:
				options["optimize"]= int(arg)
				if options["optimize"]<0 or options["optimize"]>3:
					options["optimize"]= 0
			except:
				print "WARNING: wrong value for optimize option"
		if opt in ("-q", "--qwt"):
			options["qwt"]= 1
		if opt in ("-S", "--Style"):
			if arg in styles.keys():
				options["style"]= styles[arg]
			else:
				print "WARNING: unknow style (%s)"%arg
		if opt in ("-F", "--Font"):
			fnt= arg.split(":")
			if len(fnt)==4:
				try:
					fnt[1]= int[fnt[1]]
					fnt[2]= int[fnt[2]]
					fnt[3]= int[fnt[3]]
					options["font"]= fnt
				except:
					print "WARNING: error in font definition (%s)"%arg
			else:
				print "WARNING: error in font definition (%s)"%arg
		if opt in ("-M", "--Maximized"):
			options["maximized"]= 1	
		if opt in ("-s", "--size"):
			size= string.split(arg, "x")
			if len(size)==2:
				try:
					(x,y)= (int(size[0]), int(size[1]))
					options["size"]= (x,y)
				except:
					print "WARNING: Cannot parse size option (%s)"%size
		if opt in ("-C", "--cf"):
			options["config_file"]= arg
	return options, args


if __name__ == "__main__":

	# --- parse options
	options, args= parseArguments()

	import qt
	import PyDVT
	if options.get("qwt", 0):
		PyDVT.SetBinding("QwtBinding")
	from PyDisWindow import PyDisWindow,MDIApp


	# --- application
	qt.qApp.setColorSpec(qt.qApp.CustomColor)

	if options.get("repaint", 0): app= qt.QApplication(sys.argv)
	else: app= MDIApp(sys.argv)

	font= options.get("font", None)
	if font is not None:
		app.setFont(qt.QFont(font[0], font[1], font[2], font[3]))

	style= options.get("style", None)
	if style is not None:
		app.setStyle(style)

	# --- create main window
	mw= PyDisWindow(None, None, qt.Qt.WDestructiveClose, plugin_list=options["plugins"],
				optimization=options.get("optimization", 0), user_options=options, arguments=args)
	mw.setCaption('PyDis')

	if options.get("maximized", 0):
		mw.showMaximized()
	else:	
		if options.has_key("size"):
			mw.resize(options["size"][0], options["size"][1])
		mw.show()

	# --- open images
	if options.has_key("directory"):
		mw.setCurPath(options["directory"])

	data= 0
	for (filename, filetype) in options["filename"]:
		if filetype is None:
			filetype= os.path.splitext(filename)[1][1:]
		if not os.path.isfile(filename) and options.has_key("directory"):
			filename= options["directory"]+"/"+filename
		print "Load file", filename, filetype
		mw.loadFile(filename, filetype)
		data+=1

	if "PyDisSPS" in mw.strplugins:
		spsplug= mw.plugins[mw.strplugins.index("PyDisSPS")]
		for (specname, arrname) in options["specarray"]:
			print "Load Spec array", specname, arrname
			spsplug.loadSpec(specname, arrname)
			data+=1

	if data: mw.mdi.tile()

	# --- main loop
	app.setMainWidget(mw)
	app.exec_loop()
