
"""
    TkBinding.py
    Tkinter binding to View classes
        
"""

from PyDVT import __version__,__date__,__author__


import Tkinter

#Keyboard Codes
KeyCodes = {
    "KEY_LEFT"    : 37,
    "KEY_UP"      : 38,
    "KEY_RIGHT"   : 39,
    "KEY_DOWN"    : 40,
    }

################################################################################

class Pen:
    def __init__(self,color,width,style):
        self.color=color
        self.width=width
        self.style=style

    def GetStyle(self):
        if   self.style=="solid":          return ""
        elif self.style=="dashed":         return "gray25"
        elif self.style=="dotted":         return "gray25"
        else:                              raise  "TkBinding: Pen style error"

    def GetColor(self):
        return "#%02x%02x%02x" % self.color

    def GetWidth(self):
        return self.width



    def GetBlt(self, marker=0):
        cnf= {}
        cnf['linewidth']= self.width
        if marker:	cnf['outline']= self.GetColor()
        else:		cnf['color']= self.GetColor()
        if self.style=="solid":		cnf['dashes']= ""
        elif self.style=='dashed':	cnf['dashes']= (1, 1)
        elif self.style=='dotted':	cnf['dashes']= (10, 5)
        elif self.style=='hidden':	cnf['linewidth']= 0
        return cnf


class Brush:
    def __init__(self,color,style):
        self.color=color
        self.style=style
    
    def GetStyle(self):
        if   self.style=="fill_100":       return ""
        elif self.style=="fill_75":        return "gray75"
        elif self.style=="fill_50":        return "gray50"
        elif self.style=="fill_25":        return "gray25"
        elif self.style=="fill_12":        return "gray12"
        elif self.style=="fill_0":         return ""
        else:                              raise  "TkBinding: Brush style error"


    def GetColor(self):
        if self.style=="fill_0":           return None
        return "#%02x%02x%02x" % self.color

    def GetBlt(self):
        cnf= {}
        if self.GetColor() is None: cnf['fill']=''
        else: cnf['fill']= self.GetColor()
        cnf['stipple']= self.GetStyle()
        return cnf


class Container(Tkinter.Frame):
    def __init__(self,parent=None,**kw):
        Tkinter.Frame.__init__(self,parent,**kw)
        self.parent=parent
        self.rowconfigure(0, weight=1)
        self.rowconfigure(1, weight=0)
        self.columnconfigure(0, weight=1)
        self.columnconfigure(1, weight=0)
        # create scroll bars

    def GetHeight(self):
        return self.winfo_height()

    def GetWidth(self):
        return self.winfo_width()

    def IsVisible(self):
        return self.winfo_exists()
        
    def Show(self):
        self.pack(side=Tkinter.TOP, fill=Tkinter.BOTH, expand=Tkinter.YES)        

    def SetSize(self,width,height):
        ###TODO: Doesn't work for table widget (self.Drawable.cellsTable.config(width=Width, height=Height) works just for small tables)
        try:
            self.Drawable.qpl.config(width=width, height=height)
        except:
            try:
                self.Drawable.config(width=width, height=height)
            except:
                pass

    def SetPointer(self,pointer):
        if pointer=="arrow":self.Drawable.configure (cursor="left_ptr")
        elif pointer=="cross":self.Drawable.configure (cursor="crosshair")
        elif pointer=="wait": self.Drawable.configure (cursor="watch")
        elif pointer=="h_double_arrow":self.Drawable.configure (cursor="sb_h_double_arrow")
        elif pointer=="v_double_arrow":self.Drawable.configure (cursor="sb_v_double_arrow")



        
class Scrollbar(Tkinter.Scrollbar):
    def __init__(self,parent,drawable,type="vertical"):
        self.type=type
        self.Drawable=drawable
        if type=="horizontal":
            Tkinter.Scrollbar.__init__(self,parent,orient=Tkinter.HORIZONTAL)
            drawable.configure(xscrollcommand=self.set,xscrollincrement='1p')
        else:
            Tkinter.Scrollbar.__init__(self,parent,orient=Tkinter.VERTICAL)        
            drawable.configure(yscrollcommand=self.set,yscrollincrement='1p')
            

    def SetContinousScroll(self,flag):
        if (flag):  self.configure(jump=Tkinter.FALSE)
        else:       self.configure(jump=Tkinter.TRUE) 

    def SetCommand(self,command):
        self.Command=command
        self.configure(command=self._EventScroll)

    def GetHeight(self):
        return self.winfo_height()

    def GetWidth(self):
        return self.winfo_width()

    def Erase(self):
        self.grid_forget()

    def Show(self):
        if self.type=="horizontal": self.grid(row=1,column=0,sticky="nswe")
        else:                       self.grid(row=0,column=1,sticky="nswe")

    def GetPosition(self):
        return self.get()
        
        

    def _EventScroll(self, *arguments, **keywords):
        self.Command()
        if self.type=="horizontal": self.Drawable.xview(*arguments, **keywords)
        else:                       self.Drawable.yview(*arguments, **keywords)
        



class Menu(Tkinter.Menu):
    def __init__(self,parent):
        self.parent=parent
        Tkinter.Menu.__init__(self,parent,tearoff=0)
        self.MenuCheckVar={}
        self.nbEntry=-1
        self.MenuCheckVar["RadioButtons"]=Tkinter.IntVar()
        
    def AddCommand(self,label,command,style='command'):
        if style == 'command':
            self.add_command(label=label,command=command)
            self.nbEntry+=1
            return self.nbEntry
        elif style == 'checkbutton':
            self.MenuCheckVar[label]=Tkinter.IntVar()
            self.add_checkbutton(label=label,variable=self.MenuCheckVar[label], command=command)
            self.nbEntry+=1
            return self.nbEntry
        elif style == 'radiobutton':            
            #self.add_radiobutton(label=label,variable=self.MenuCheckVar["RadioButtons"], command=command)
            self.add_radiobutton(label=label,variable=self.MenuCheckVar["RadioButtons"], command=command)
            self.nbEntry+=1
            return self.nbEntry
        else:
            print "unknown menu item style : only 'command', 'checkbutton' allowed"
            return 

    def AddCascade (self,label,menu):
        self.add_cascade(label=label,menu=menu)
        self.nbEntry+=1
        return self.nbEntry
        
    def AddSeparator (self):
        self.add_separator()
        self.nbEntry+=1
        return self.nbEntry

    def GetItemType(self,index):
        return self.type(index)
    
    def CheckItem(self,index,check):
        entryLabel=self.entrycget(index,'label')
        self.MenuCheckVar[entryLabel].set(check)

    def SetCheckedRadio(self,name):
        self.MenuCheckVar["RadioButtons"].set(name)
        pass
        

    def IsItemChecked(self,index):
        #TODO return the wrong value : temporary to fit to Qt Functionning which hasn't got menu checkbutton entry : in Qt, toggle to call explicitely        
        entryLabel=self.entrycget(index,'label')
        return not self.MenuCheckVar[entryLabel].get()

    def DisableItem (self,index):
        self.entryconfig(index, state=Tkinter.DISABLED)    

    def EnableItem (self,index):
        self.entryconfig(index, state=Tkinter.ACTIVE)    

    def DeleteItem (self,index):
        if self.GetItemType(index)=='checkbutton':
            del self.MenuCheckVar[self.entrycget(index,'label')]
        self.delete(index)

    def Show (self,Position):
        self.tk_popup(Position.x + self.parent.winfo_rootx(),
                           Position.y + self.parent.winfo_rooty())

    def Destroy(self):
        pass #TODO: Add cleanup code if needed

        
class Dialog(Tkinter.Toplevel):

    def __init__(self, parent, title = None, modal=1,resizable=0,expand_container=0):        
        Tkinter.Toplevel.__init__(self, parent)
        #TODO: not considering resizable parameter
        self.transient(parent)
        if title:       self.title(title)
        self.parent = parent
        self.modal=modal
        if expand_container: self.bind("<Configure>",self.resizeEvent)
        self.Destroyed=0
        self.protocol("WM_DELETE_WINDOW", self.cancel)
        self.geometry("+%d+%d" % (parent.winfo_rootx()+50,
                                  parent.winfo_rooty()+50))
        self.focus_set()

    def AddContainer(self,container):
        self.Container=container
        self.Container.grid(row=0,column=0,sticky="nsew")

    def cancel(self, event=None):

        # put focus back to the parent window
        self.parent.focus_set()
        self.Destroyed=1
        self.destroy()
        
    def resizeEvent(self, event=None):
        if hasattr(self,"Container"): self.Container.SetSize(self.winfo_width(),self.winfo_height())        

    def Show(self):
        if self.modal:
            self.grab_set()
            self.wait_window(self)

    def SetSize(self,width,height):
        self.geometry('%dx%d' % (width, height))

    def IsDestroyed(self):
        return self.Destroyed


class Label(Tkinter.Label):
    def __init__(self,parent):
        Tkinter.Label.__init__(self,parent, bd=1, relief=Tkinter.SUNKEN, anchor=Tkinter.W)
        
    def Show(self):
        self.grid(row=2,column=0,columnspan=2,sticky="ew")

    def Hide(self):
        self.grid_forget()

    def SetText(self,str):
        self.config(text=str)

class Timer:
    def __init__(self,parent,callback):
        self.callback=callback
        if parent==None: self.parent=Tkinter.Frame()
        else: self.parent=parent
        self.Interval=0        
        self.Started=0
        self.SingleShot=0
        self.EvId=None
        
    def Start(self,interval,single_shot=0):
        self.SingleShot=single_shot
        self.Interval=interval 
        self.Started=1        
        self.EvId=self.parent.after(self.Interval, self._timeout)

    def Stop(self):
        if self.EvId!=None:
            self.parent.after_cancel(self.EvId)
            self.EvId=None
        self.Started=0
    
    def _timeout(self):
        if self.Started:
            self.callback()
            if self.SingleShot:
                self.Started=0
                return            
            self.EvId=self.parent.after(self.Interval, self._timeout)


def GetDisplayProperties():
    if Tkinter.Frame().winfo_depth()==8: DISPLAY_DEPTH=8
    else: DISPLAY_DEPTH=32    
    return {"SPSLUT_MODE":"RGBX","ALIGN_8BIT_IMAGES":0,"DISPLAY_DEPTH":DISPLAY_DEPTH}		
