import qt
import qtgl
import OpenGL.GL as opengl
#from Binding import Pen,Brush
opengl.GL_BGR =0x80E0
opengl.GL_BGRA=0x80E1
TIMING  = 1
DEBUG   = 1
TEXTURE = 0
if TIMING:
    import time
#
# constants unknown to the binding
#
opengl.GL_BGR =0x80E0
opengl.GL_BGRA=0x80E1
import Numeric
import spslut



class GLScrollView(qt.QScrollView):
    def __init__( self, parent=None,name=None,fl=0 ):
        qt.QScrollView.__init__(self,parent,name,fl)
        layout = qt.QVBoxLayout(self.viewport())
        layout.setAutoAdd(1)
        self.gl=GLImageView(self.viewport())
        self.addChild(self.gl)
        self.setImage=self.gl.setImage
        self.setImageFromData=self.gl.setImageFromData

    """
    def resizeEvent(self,event):
        if DEBUG:
            print "GLScrollView resize event called!"
        
        qt.QScrollView.resizeEvent(self,event)
        print self.viewport().width(),self.viewport().height()
    """
    """
    def drawContents(self, painter, cx=None, cy=None, cw=None, ch=None, *args, **argss):
        if DEBUG:
            print "ScrollView drawcontents"
            print painter,cx,cy,cw,ch
            print "clipx =",cx,"clipy = ",cy,"clipwidth =",cw,"clipheight = ",ch
    """
    """
    def viewportPaintEvent(self, painter):
        if DEBUG:
            print "Viewport Paint Event"
    """
    def DrawImage(self,image_string,image_size,depth,colormap_table,reset_zoom=0):
        if DEBUG:
            print "DrawImage ",image_size,depth,colormap_table,reset_zoom
        if reset_zoom:
            pass
        else:
            pass
        if image_string != self.imagestring:
            self.imagestring=image_string       
            self.gl.setImageFromData(image_string,image_size[0],image_size[1])
        if (self.gl.width()!=image_size[0])or(self.gl.height()!=image_size[1]):
            self.gl.resize(image_size[0],image_size[1])
        self.gl.update()
        
class GLImageView(qtgl.QGLWidget):
    """QGLWidget-derived class for OpenGL image display"""
    def __init__(self, parent=None, name=None,width=100,height=100):
        """Constructor

        Parameters :
          parent -- the parent QObject
          width -- the desired width of the OpenGL viewport
          height -- the desired height of the OpenGL viewport"""
        qtgl.QGLWidget.__init__(self, parent)
        #self.setMinimumSize(qt.QSize(width,height))
        self.setSizePolicy(qt.QSizePolicy.Expanding,qt.QSizePolicy.Expanding)
        #specific
        self.imgWidth = 1
        self.imgHeight = 1
        self.zoomx  = 1
        self.zoomy  = 1
        """
        data=Numeric.zeros(( self.imgWidth,self.imgHeight),Numeric.Float)
        for i in range(self.imgWidth):
            for j in range(self.imgHeight):
                data[i,j]= i + j
        (image,size,minmax)= spslut.transform(data, (1,0), (spslut.LINEAR,3.0),
                                 "RGBX", spslut.TEMP, 1, (0,max(max(data))))
        self.dummyImage =  image

        data=Numeric.zeros(( self.imgWidth,self.imgHeight),Numeric.Float)
        for i in range(self.imgWidth):
            for j in range(self.imgHeight):
                data[i,j]= i + j
        (image,size,minmax)= spslut.transform(data, (1,0), (spslut.LINEAR,3.0),
                                 "RGBX", spslut.TEMP, 1, (0,max(max(data))))
        self.testImage = '0'*768*576*4
        """
        self.pixmap = None
        # mouse Cursor
        self.setCursor(qt.QCursor(qt.Qt.CrossCursor))

    def drawContents(self, painter, cx, cy, cw, ch):
    	print "drawCOntents called"
        self.cx = cx
        self.cy = cy
        self.cw = cw
        self.ch = ch
        
    def initializeGL(self):
        if DEBUG:
            print "InitializeGL"
        if TEXTURE:
            opengl.glClearColor(0.0,0.0,0.0,1.0)
            opengl.glClearDepth(1.0)
            opengl.glDisable(opengl.GL_DEPTH_TEST)
            opengl.glDisable(opengl.GL_DITHER)
            opengl.glDisable(opengl.GL_LIGHTING)
            opengl.glDisable(opengl.GL_STENCIL_TEST)
            opengl.glOrtho(0.0,1.0,0.0,1.0,-1.0,1.0)
            opengl.glMatrixMode(opengl.GL_MODELVIEW)
            opengl.glLoadIdentity()
            opengl.glHint(opengl.GL_PERSPECTIVE_CORRECTION_HINT,opengl.GL_FASTEST)    
        else:
            self.initializeGLNoTEXTURE()  
                 
    def initializeGLNoTEXTURE(self):
        """Initialize OpenGL. Set optimized settings for blitting"""
        if DEBUG:
            print "InitializeGL No texture"
        opengl.glClearColor(0.0,0.0,0.0,1.0)
        opengl.glDisable(opengl.GL_ALPHA_TEST)
        opengl.glDisable(opengl.GL_BLEND)
        opengl.glDisable(opengl.GL_DEPTH_TEST)
        opengl.glDisable(opengl.GL_DITHER)
        opengl.glDisable(opengl.GL_FOG)
        opengl.glDisable(opengl.GL_LIGHTING)
        opengl.glDisable(opengl.GL_LOGIC_OP)
        opengl.glDisable(opengl.GL_STENCIL_TEST)
        opengl.glDisable(opengl.GL_TEXTURE_1D)
        opengl.glDisable(opengl.GL_TEXTURE_2D)
        opengl.glPixelTransferi(opengl.GL_MAP_COLOR, opengl.GL_FALSE)
        opengl.glPixelTransferi(opengl.GL_RED_SCALE, 1)
        opengl.glPixelTransferi(opengl.GL_RED_BIAS, 0)
        opengl.glPixelTransferi(opengl.GL_GREEN_SCALE, 1)
        opengl.glPixelTransferi(opengl.GL_GREEN_BIAS, 0)
        opengl.glPixelTransferi(opengl.GL_BLUE_SCALE, 1)
        opengl.glPixelTransferi(opengl.GL_BLUE_BIAS, 0)
        opengl.glPixelTransferi(opengl.GL_ALPHA_SCALE, 1)
        opengl.glPixelTransferi(opengl.GL_ALPHA_BIAS, 0)
        opengl.glViewport(0, 0, self.width(), self.height())
        opengl.glMatrixMode(opengl.GL_PROJECTION)
        opengl.glLoadIdentity()
        opengl.glOrtho(0.0,1.0,0.0,1.0,-1.0,1.0)
        opengl.glMatrixMode(opengl.GL_MODELVIEW)
        opengl.glLoadIdentity()
        x, y, width, height = opengl.glGetDoublev(opengl.GL_VIEWPORT)
        opengl.glRasterPos4f(0,1,0,1)
        if opengl.glGetDouble(opengl.GL_CURRENT_RASTER_POSITION_VALID):
            opengl.glPixelZoom(width/self.imgWidth,-height/self.imgHeight)        
           
    def OWNmouseReleaseEvent(self, event):
        """Emit a signal when the image viewport is clicked

        Emitted signals :
          imageClicked (<x pos. in image>, <y pos. in image>, <x pos. in viewport>, <y pos. in viewport>) --"""
        x = event.x()
        y = event.y()
        #zx = opengl.glGetFloatv(opengl.GL_ZOOM_X)
        zx = self.zoomx
        if zx == 0:
            zx = 1.0            
        zy = self.zoomy
        #opengl.glGetFloatv(opengl.GL_ZOOM_Y)
        if zy == 0:
            zy = 1.0
        print (x/zx, -y/zy, x, y, )
        self.emit(qt.PYSIGNAL('imageClicked'), (x/zx, -y/zy, x, y, ))

    
    def setImageSize(self, width, height):
        return
        """Set the OpenGL viewport size

        Displayed images will be resized accordingly"""
        if DEBUG:
            print "setImageSize"

        if self.pixmap is None:
            self.imgWidth = width
            self.imgHeight = height
            
        #self.setFixedSize(width, height)
       

    def setImage(self, img):
        """Set the image to display from a QtImage

        Parameters :
          img -- a valid QImage object to display"""
        if DEBUG:
            print "setImage"

        self.painting = 1

        if self.pixmap is None:
            if TEXTURE:
                self.createtexture()
            
        if img.width() != self.imgWidth or img.height() != self.imgHeight:
            self.imgWidth = img.width()
            self.imgHeight = img.height()
            #self.setMinimumSize(qt.QSize(width,height))
            if TEXTURE:
                self.createtexture()
            #qt.QApplication.sendEvent(self, qt.QResizeEvent(qt.QSize(self.width(),
            #                          self.height()), qt.QSize(self.width(), self.height())))           
        
        
        self.pixmap = self.img.bits().asstring(self.imgWidth*self.imgHeight*4)        
        #self.update()


    def setImageFromData(self, pixmap, width, height):
        """Set the image to display

        Parameters :
          pixmap -- a valid string object to display
          width  -- its width
          height -- its height"""
        if DEBUG:
            print "setImageFromData"
        self.pixmap   = pixmap
        self.painting = 1
        if width != self.imgWidth or height != self.imgHeight:
            self.imgWidth  = width
            self.imgHeight = height
            #self.setMinimumSize(qt.QSize(width,height))
            if TEXTURE:
                self.createtexture()
            #qt.QApplication.sendEvent(self, qt.QResizeEvent(qt.QSize(self.width(),
            #                          self.height()), qt.QSize(self.width(), self.height())))           
        #This is not good
        #self.updateGL()
        #replaced by
        #self.update()
        
    def createtexture(self):
        print "create texture"
        opengl.glFinish()
        opengl.glBindTexture(opengl.GL_TEXTURE_2D,0)
        opengl.glTexParameterf(opengl.GL_TEXTURE_2D, opengl.GL_TEXTURE_WRAP_S,
                                opengl.GL_CLAMP)
        opengl.glTexParameterf(opengl.GL_TEXTURE_2D, opengl.GL_TEXTURE_WRAP_T,
                                opengl.GL_CLAMP)
        if 0:
            opengl.glTexParameterf(opengl.GL_TEXTURE_2D, opengl.GL_TEXTURE_MAG_FILTER,
                                opengl.GL_LINEAR)
            opengl.glTexParameterf(opengl.GL_TEXTURE_2D, opengl.GL_TEXTURE_MIN_FILTER,
                                opengl.GL_LINEAR)
            opengl.glTexEnvf(opengl.GL_TEXTURE_ENV, opengl.GL_TEXTURE_ENV_MODE,
                                opengl.GL_MODULATE)
        else:
            opengl.glTexParameterf(opengl.GL_TEXTURE_2D, opengl.GL_TEXTURE_MAG_FILTER,
                                opengl.GL_NEAREST)
            opengl.glTexParameterf(opengl.GL_TEXTURE_2D, opengl.GL_TEXTURE_MIN_FILTER,
                                opengl.GL_NEAREST)
            opengl.glTexEnvf(opengl.GL_TEXTURE_ENV, opengl.GL_TEXTURE_ENV_MODE,
                                opengl.GL_REPLACE)
        
        opengl.glTexImage2D(opengl.GL_TEXTURE_2D, 0, 4,
                            self.imgWidth,
                            self.imgHeight,
                            0, opengl.GL_RGBA,
                            opengl.GL_UNSIGNED_BYTE,self.pixmap)
        
        opengl.glEnable(opengl.GL_TEXTURE_2D)
        opengl.glBindTexture(opengl.GL_TEXTURE_2D,0)
        opengl.glNewList(1,opengl.GL_COMPILE)
        opengl.glBegin(opengl.GL_QUADS)
        opengl.glTexCoord2f(0,0)
        opengl.glVertex3d(0.0,0,0.0)
        opengl.glTexCoord2f(0,1)
        opengl.glVertex3d(0.0,1.0,0.0)
        opengl.glTexCoord2f(1,1)
        opengl.glVertex3d( 1, 1,0.0)
        opengl.glTexCoord2f(1,0)
        opengl.glVertex3d( 1.0,0.0,0.0)
        opengl.glEnd()
        opengl.glEndList()

    """
    def resizeEvent(self,event):
        if DEBUG:
            print "QGLWidget ResizeEvent called"
    """

    def resizeGL(self, width, height):
        """Resize the OpenGL viewport and set pixel zoom"""
        if DEBUG:
            print "ResizeGL",width, height,self.imgWidth,self.imgHeight
        """
        while (self.mutex):
            self.mutex=1
            print "I had to wait! because of painting"
            pass
        width=self.width()
        height=self.height()
        """
        opengl.glViewport(0, 0, width, height)       
        opengl.glMatrixMode(opengl.GL_PROJECTION)
        opengl.glLoadIdentity()
        #opengl.glOrtho(0.0,width,0.0,height,-1.0,1.0)
        opengl.glOrtho(0.0,1.0,0.0,1.0,-1.0,1.0)
        
        opengl.glMatrixMode(opengl.GL_MODELVIEW)
        opengl.glLoadIdentity()
        """
        opengl.glFlush()
        #x, y, width, height = opengl.glGetDoublev(opengl.GL_VIEWPORT)
        opengl.glRasterPos2i(0,1)
        """
        self.painting = 1
        #self.mutex=0
            
    def paintGL(self):
        """Paint the OpenGL viewport with the image previously set"""
        if DEBUG:
            print "paintGL"
        """
        while (self.mutex):
            print "I had to wait! because of resizing"
            pass
        self.makeCurrent()
        """
        #print "double buffer = ",self.doubleBuffer()
        opengl.glFlush()
	if self.pixmap is not None:
            if TIMING:
                t0=time.time()
            if TEXTURE:
                        #opengl.glClear(opengl.GL_COLOR_BUFFER_BIT | opengl.GL_DEPTH_BUFFER_BIT)
        
                        #set up the model view matrix
                        opengl.glMatrixMode(opengl.GL_MODELVIEW)
                        opengl.glLoadIdentity()
                        #print  self.imgWidth, self.imgHeight
                        opengl.glTexSubImage2D(opengl.GL_TEXTURE_2D, 0, 0, 0,
                            self.imgWidth,
                            self.imgHeight,
                            opengl.GL_RGBA,
                            opengl.GL_UNSIGNED_BYTE,self.pixmap)
                        opengl.glEnable(opengl.GL_TEXTURE_2D)
                        opengl.glBindTexture(opengl.GL_TEXTURE_2D,0)
                        print "Texturing took ",time.time()-t0
                        opengl.glCallList(1)
                        self.swapBuffers()
                        opengl.glFlush()
                        print "paint with texturing took ",time.time()-t0
                        return
            if self.painting:
                self.painting = 1
                x, y, width, height = opengl.glGetDoublev(opengl.GL_VIEWPORT)
                print "viewport = ",x, y, width, height
                opengl.glRasterPos4f(0,1,0,1)
                self.zoomx =   width/self.imgWidth
                self.zoomy =  -height/self.imgHeight                   
                opengl.glPixelZoom(self.zoomx,self.zoomy)
                opengl.glDrawPixels(self.imgWidth, self.imgHeight, opengl.GL_RGBA,
                                     opengl.GL_UNSIGNED_BYTE, self.pixmap)
                opengl.glPixelZoom(1.0,1.0)
            else:
                if not opengl.glGetDouble(opengl.GL_CURRENT_RASTER_POSITION_VALID):
                    x, y, width, height = opengl.glGetDoublev(opengl.GL_VIEWPORT)
                    opengl.glRasterPos2i(0,1)
                    self.painting = 1
                    opengl.glPixelZoom(width/self.imgWidth,-height/self.imgHeight)
                    opengl.glDrawPixels(self.imgWidth, self.imgHeight, opengl.GL_RGBA,
                                     opengl.GL_UNSIGNED_BYTE, self.pixmap)
                    opengl.glPixelZoom(1.0,1.0)
                else:
                    opengl.glCopyPixels(0,0,self.imgWidth,self.imgHeight,opengl.GL_COLOR)
            if TIMING:
                print "paintGL took ",time.time()-t0
        #self.mutex=0
                
                
if __name__ == '__main__':
    import sys
    import spslut
    import Numeric
    a=qt.QApplication(sys.argv)
    qt.QObject.connect(a,qt.SIGNAL("lastWindowClosed()"),a,qt.SLOT("quit()"))
    w=qt.QMainWindow()
    #w.resize(400,400)
    glcontainer=GLScrollView(w)
    w.setCentralWidget(glcontainer)
    #glcontainer.resize(400,400)
    a.setMainWidget(w)
    w.show()
    glwidget=glcontainer.gl
    #,width=500,height=500)
    (xsize, ysize) = (512,512)
    data = Numeric.zeros((xsize,ysize),Numeric.Float)
    for i in range(xsize):
        for j in range(ysize):
            data[i,j] = i + j
    (image,size,minmax)= spslut.transform(data, (1,0), (spslut.LINEAR,3.0),
                                 "RGBX", spslut.TEMP, 1, (0,max(max(data))))
    glwidget.setImageFromData(image, size[0], size[1])
    a.exec_loop() 
         
