"""
    MccdFileData.py
    Data derived class to access Mccd files    
"""

__date__='18/02/2003'
__author__='Anne-Cecile Gendrin'

  
from Data import *
import MccdFile

SOURCE_TYPE = "MccdFile"


class MccdFileData(Data):
    """
    Specializes Data class in order to access Mccd files.    
    Interface: Data class interface.
    """
    def __init__(self,refresh_interval=None,info={}):
        """
        See Data.__init__
        """
        self.MccdObj=None
        info["Class"]="MccdFileData"        
        Data.__init__(self,refresh_interval,info)


    def SetSource (self,source_name=None):
        """
        Sets a new source for data retrieving, an Mccd file.
        If the file exists, self.Source will be the MccdFile
        object associated to this file.
        Parameters:
        source_name: name of the Mccd file 
        """
        if source_name==self.SourceName: return 1
        if (source_name != None): 
            try:
                self.Source = MccdFile.MccdFile(source_name)
            except:
                self.SourceName=None
                self.Source=None
                return 0
        else:
            self.Source=None
        self.SourceName=source_name
        return 1


    def GetSourceInfo (self):
        """
        Returns information about the MccdFile object created by
        SetSource, to give application possibility to know about
        it before loading.
        Returns a dictionary with the keys "Size" (number of possible
        keys to this source) and "KeyList" (list of all available keys
        in this source). Each element in "KeyList" is an integer
        meaning the index of the array in the file.
        """        
        if self.SourceName == None: return None
        NumImages=1
        source_info={}
        source_info["Size"]=NumImages
        source_info["KeyList"]=range(NumImages)
        return source_info        

        
    
    def LoadSource(self,key_list="ALL",append=0,invalidate=1,pos=None,size=None):
        """
        Creates one page, getting data from the source (set by SetSource)
        Parameters:
        Parameters:
        key_list: list of all keys to be read from source. It is a list of
                 integers, meaning the indexes to be read from the file.
                 It can be also one integer, if only one array is to be read.
        append: If non-zero appends to the end of page list.
                Otherwise, initializes the page list                
        invalidate: if non-zero performas an invalidade call after
                    loading
	pos and size: (x), (x,y) or (x,y,z) tuples defining a roi
                      If not defined, takes full array
                      Stored in page's info
        """
        if append==0: Data.Delete(self)
	
	numimages=1
        if key_list == "ALL": key_list=range(numimages)
        elif type(key_list) is types.IntType: key_list=[key_list]

        key_list_to_update=[]
        first_pos= self.GetNumberPages()
        for k in key_list:
            key_list_to_update.append(k+first_pos)


        if pos is not None:
            mccd_pos=list(pos)
            for i in range(len(mccd_pos)):
                if mccd_pos[i]=="ALL":mccd_pos[i]=0
        else: mccd_pos=None
            
        if size is not None:
            mccd_size=list(size)
            for i in range(len(mccd_size)):
                if mccd_size[i]=="ALL":mccd_size[i]=0
        else: mccd_size=None
	
	info={}
        info["SourceType"]=SOURCE_TYPE
        info["SourceName"]=self.SourceName
        info["Source"]=self.Source
	info["pos"]=pos
	info["size"]=size
	
	array=self.Source.GetData(Pos=mccd_pos,Size=mccd_size)
        self.AppendPage(info,array)
	if invalidate: self.Invalidate(page_list = key_list_to_update )      


#---------------------------------------------------------------------------
    
if __name__ == "__main__":
    import sys,time
    try:
        #Filename=sys.argv[1]  
	Filename='../data/sc837_behenate_0001.mccd'
	
	t1=time.time()
	data=MccdFileData()
	data.SetSource(Filename)
	t2=time.time()
	data.LoadSource()
	print 'time:',t2-t1
	
    except:
        print "Usage: MccdFileData.py <filename> <image>"
        sys.exit()
    
    print obj,dir(obj)
    print obj.GetPageArrayRegion((0,0),(2,2))
    

        
