"""
    GUIBinding.py
    GUI Binding interface to View classes

    This file and the Drawable classes define the Binding interface, implemented
    for each GUI Toolkit.
"""

from PyDVT import __version__,__date__,__author__


KeyCodes = {
    "KEY_LEFT"    : "???",
    "KEY_UP"      : "???",
    "KEY_RIGHT"   : "???",
    "KEY_DOWN"    : "???",
    }

################################################################################


class Pen:
    """
    Structure, defines a pen object, used to set the way lines are drawn

    Public propereties:
    - color
    - width
    - style
    """
    def __init__(self,color,width,style):
        """
        Parameters:
            color: tuple (R,G,B), values between 0 and 255
            width: integer
            style: "solid", "dashed" or "dotted"
        """        
        pass

        

class Brush:
    """
    Structure, define a brush object, used to set the way regions are filled.
    Public propereties:
    - color
    - style
    """
    def __init__(self,color,style):
        """
        Parameters:
            color: tuple (R,G,B), values between 0 and 255
            style: "fill_0", "fill_25", "fill_50", "fill_75" or "fill_100"
        """        
        pass
    


class Container:
    """
    This class defines a widget, from which View class derive from.
    This widget is going to be the container of a drawable widget (and maybe more).
    Every Drawable receives a reference to this parent Container on its constructor.    
    """
    def __init__(self,parent=None,**kw):
        """
        Parameters:
            parent: parent widget
            **kw: keywords for specific initialization
        """
        pass

    def GetHeight(self):
        """
        Returns height of the widget
        """
        pass

    def GetWidth(self):
        """
        Returns width of the widget
        """
        pass

    def IsVisible(self):
        """
        Returns if widget is still visible on screen (if it's top-level hasn't been closed)
        """
        pass

    def Show(self):
        """
        Displays widget
        """
        pass

    def SetSize(self,width,height):
        """
        Resizes widget
        """
        pass

    def SetPointer(self,pointer):
        """
        Changes the mouse pointer over the drawable
        Parameters:
            pointer: "arrow"
                     "wait"
                     "cross"
                     "h_double_arrow"
                     "v_double_arrow"
        """
        pass                        



class Menu:
    """
    This class defines a menu, used to the built-in popup menu of View objects.
    Cascade entries in this popup menu can be added by creating new Menu objects.
    """
    def __init__(self,parent):
        """
        Parameters:
            parent: parent widget or Menu object (if cascade)
        """
        pass
            
    def AddCommand(self,label,command,style='command'):        
        """
        Parameters:
            label: text of the entry
            command: callback function
            style: 'command' or 'checkbutton'
        Returns: Index of the entry
        """
        pass            

    def AddCascade (self,label,menu):
        """
        Parameters:
            label: text of the entry
            menu: Menu object to be cascaded
        Returns: Index of the entry
        """
        pass            
        
    def AddSeparator (self):
        """
        """
        pass            

    def GetItemType(self,index):
        """
        Parameters:
            index: identifier of the entry as returned by AddCommand or AddCascade
        Returns 'command' or 'checkbutton'
        """     
        pass            
    
    def CheckItem(self,index,check):
        """
        Parameters:
            index: identifier of the entry as returned by AddCommand or AddCascade
            check: If non-zero sets check-mark on the entry. If zero, resets it.
        """
        pass            

    def IsItemChecked(self,index):
        """
        Parameters:
            index: identifier of the entry as returned by AddCommand or AddCascade
        Returns non-zero if item is checked
        """
        pass            


    def SetCheckedRadio(self,name):
        """
        Sets current radio entry (if any) in a menu
        Parameters:
            name: text of selected item
        """

    def DisableItem (self,index):
        """
        Parameters:
            index: identifier of the entry as returned by AddCommand or AddCascade
        """
        pass            

    def EnableItem (self,index):
        """
        Parameters:
            index: identifier of the entry as returned by AddCommand or AddCascade
        """
        pass            

    def DeleteItem (self,index):
        """
        Parameters:
            index: identifier of the entry as returned by AddCommand or AddCascade
        """
        pass            

    def Show (self,Position):
        """
        Parameters:
            Position: Absolute position on which the menu is going to be displayed
                      (as returned by right mouse press calback of drawables)
        """
        pass            

    def Destroy(self):
        """
        Cleanup
        """
        pass            

        
class Dialog:
    """
    This class defines a top-level widget.
    """
    def __init__(self, parent, title = None, modal=0,resizable=0,expand_container=0):
        """
        Parameters:
            parent: parent widget
            title: text on the title bar
            modal: if non-zero builds a modal top-level
            resizable: if non-zero the top-level can be resized
            expand_container: if non-zero resizes container (set by AddContainer)
                              to the Dialog size, on every resize event.
        """
        pass            

    def AddContainer(self,container):
        """
        Parameters:
            container: widget to be drawn on the dialog
        """
        pass            
    
    def Show(self):
        """
        Displays top-level
        """
        pass            

    def SetSize(self,width,height):
        """
        Resizes top-level
        """
        pass            

    def IsDestroyed(self):
        """
        Returns if top-level hasn't been closed
        """
        pass



class Label:
    """
    This class defines a label (or status bar) to be put on Containers, below
    Drawable widgets.
    """
    def __init__(self,parent):
        """
        Parameters:
            parent: parent widget
        """
        pass            
        
    def Show(self):
        """
        Displays label
        """
        pass            

    def Hide(self):
        """
        Hides label
        """
        pass            

    def SetText(self,str):
        """
        Parameters:
            str: text displayed on the label
        """
        pass            



class Timer:
    """
    This class defines a timer
    """
    def __init__(self,parent,callback):
        """
        Parameters:
            parent: parent widget
            callback: function to be called on timer events
        """
        pass            
        
    def Start(self,interval,single_shot=0):
        """
        Parameters:
            interval: time in milisseconds between timer events
            single_shot: if non-zero, raises just one callback after the interval
        """
        pass            

    def Stop(self):
        """
        """
        pass            


def GetDisplayProperties():
    """
    Returns dictionary with information about display.
    Keys:
        "SPSLUT_MODE": "RGBX" or "BRGX"
        "ALIGN_8BIT_IMAGES": If 1 binding needs image data always to be 32 bits
                             aligned in the beggining of each row, when in 8 bits
                             depth
        "DISPLAY_DEPTH": 32 (RGBX) or 8 (256 levels)
    """
    pass