/* C code to create dynamically loaded library to implement pyqt_plplot module*/

#include "plmodule.c"
//#include "plplot/plmodule.h"
//#include "plplot/plplotP.h"


extern void
plD_open_xw(PLStream *pls);



static char doc_expose[]="expose the whole   window";

static PyObject * pl_expose(PyObject *self, PyObject *args)
{
    TRY (PyArg_ParseTuple(args, ":expose"));

    pl_cmd(PLESC_EXPOSE, (void *) NULL);     
	
    Py_INCREF(Py_None);
    return Py_None;
 
}



static char doc_resize[]="resize the window";

static PyObject * pl_resize(PyObject *self, PyObject *args)
{
	PLINT width, height ;
	PLDisplay pldis;
	TRY (PyArg_ParseTuple(args, "ii:resize", &width, &height));

	pldis.width=width;
	pldis.height=height;
	pl_cmd(PLESC_RESIZE, (void *) &(pldis));     
	pl_cmd(PLESC_EXPOSE, (void *) NULL);  	

	Py_INCREF(Py_None);
	return Py_None;

}



static char doc_partialInitXw[]="Partially init a new device (X Window) ";

static PyObject * pl_partialInitXw(PyObject *self, PyObject *args)
{
	PLINT ipls;
	PLStream *pls;  
	TRY (PyArg_ParseTuple(args, ":pl_partialInitXw"));
	ipls=0;

	plmkstrm(&ipls);
	plgpls(&pls);   // pls points directly to a structure PLStream 

#ifndef WIN32
	plD_open_xw(pls);
#endif
	return Py_BuildValue("i", ipls);
}


static char doc_getwin3hwnd[]="Inits on an existing win32 window";

static PyObject * pl_getwin3hwnd(PyObject *self, PyObject *args)
{
	PyObject *obj;
	void *ptr;
	PLINT i;

	TRY (PyArg_ParseTuple(args, "O", &obj));
	ptr=PyCObject_AsVoidPtr(obj);
		
	i=(PLINT)ptr;
	return Py_BuildValue("i", i);
}



static PyMethodDef pyqt_pl_methods[] = {
    {"plexpose",	pl_expose, 1, doc_expose},    	
    {"plresize",	pl_resize, 1, doc_resize},
    {"plpartialInitXw",	pl_partialInitXw, 1, doc_partialInitXw},
    {"plgetwin3hwnd",	pl_getwin3hwnd, 1, doc_getwin3hwnd},

	{NULL,			NULL}
};






static PyMethodDef methods[(sizeof(pl_methods)+sizeof(pyqt_pl_methods))/sizeof(PyMethodDef)-1];

void initpyqt_pl(void)
{
    PyObject *m;
    PyObject *d;
    PyObject *v;
	
	memcpy(&methods[0],&pl_methods[0],sizeof(pl_methods));
	memcpy(&methods[(sizeof(pl_methods)/sizeof(PyMethodDef))-1],&pyqt_pl_methods[0],sizeof(pyqt_pl_methods));
    import_array();

    /* Create the module and add the functions */
    m = Py_InitModule("pyqt_pl", methods);
	//m = Py_InitModule("pyqt_pl", pyqt_pl_methods);
    d = PyModule_GetDict(m);

    /* Add some symbolic constants to the module */
    v = PyInt_FromLong(PL_PARSE_PARTIAL);
    PyDict_SetItemString(d, "PARSE_PARTIAL", v);
    Py_XDECREF(v);

    v = PyInt_FromLong(PL_PARSE_FULL);
    PyDict_SetItemString(d, "PARSE_FULL", v);
    Py_XDECREF(v);

    v = PyInt_FromLong(PL_PARSE_QUIET);
    PyDict_SetItemString(d, "PARSE_QUIET", v);
    Py_XDECREF(v);

    v = PyInt_FromLong(PL_PARSE_NODELETE);
    PyDict_SetItemString(d, "PARSE_NODELETE", v);
    Py_XDECREF(v);

    v = PyInt_FromLong(PL_PARSE_SHOWALL);
    PyDict_SetItemString(d, "PARSE_SHOWALL", v);
    Py_XDECREF(v);

    v = PyInt_FromLong(PL_PARSE_OVERRIDE);
    PyDict_SetItemString(d, "PARSE_OVERRIDE", v);
    Py_XDECREF(v);

    v = PyInt_FromLong(PL_PARSE_NOPROGRAM);
    PyDict_SetItemString(d, "PARSE_NOPROGRAM", v);
    Py_XDECREF(v);

    v = PyInt_FromLong(PL_PARSE_NODASH);
    PyDict_SetItemString(d, "PARSE_NODASH", v);
    Py_XDECREF(v);

    /* Check for errors */
    if (PyErr_Occurred())
	Py_FatalError("pl module initialization failed");
}










