"""
    GenDoc.py

    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""

import sys
import os
import string

import PyDVT.GUIBinding
import mypydoc as pydoc
import SetPath

##################################
#GENERATE MODULE DOCS
##################################
outputdir="Doc/ModDoc/"
package="PyDVT"
pydoc.writedoc(package,outputdir=outputdir)
for file in os.listdir("PyDVT"):
    if  string.upper(file[-3:]) =='.PY':
        pydoc.writedoc(package+"."+file[:-3],outputdir=outputdir)

package="PyDVT.GUIBinding"
pydoc.writedoc(package,outputdir=outputdir)
for file in os.listdir("PyDVT/GUIBinding"):
    if  string.upper(file[-3:]) =='.PY':
        pydoc.writedoc(package+"."+file[:-3],outputdir=outputdir)


##################################
#COPY DEMO FILES
##################################
filelist=[]
for file in os.listdir("Demo"):
    if  (string.upper(file[:4]) =='DEMO' and string.upper(file[-3:]) =='.PY'):
        filelist.append(file)

filelist.sort()
filelist.append("single_image.edf")
filelist.append("multi_image.edf")
filelist.append("specfile.dat")
filelist.append("scisoft.dat")
filelist.append("image.png")
filelist.append("DemoScanCircularBufferQt.mac")


for file in filelist:
    filecopy = open( "Demo/"+file, "r" )
    z = filecopy.read()
    filecopy.close()
    filenew = open ("Doc/DemoFiles/"+file, "w")
    filenew.write(z)
    z=""
    filenew.close()

def GenDirIndex(title,dir):
    filelist=os.listdir(dir)
    filelist.sort()
    indexfile=open(dir+"index.html",'w+')
    indexfile.write('<HTML>\n')
    indexfile.write('<HEAD>\n')
    indexfile.write('</HEAD>\n')
    indexfile.write('<BODY LINK="#0000ff" VLINK="#800080">\n')
    indexfile.write('<FONT SIZE=6 COLOR="#000080"><P>'+title+'<BR><UL>\n')
    for file in filelist:
        if str(file) != "index.html":
            indexfile.write('</FONT><LI><A HREF="'+str(file)+'"><FONT SIZE=3>'+str(file)+'</FONT></A><FONT SIZE=5> </LI>')
    indexfile.write('</HTML>\n')
    indexfile.close()

GenDirIndex("PyDVT Demo Files","Doc/DemoFiles/")

        
