"""
    DemoSpecFileQt.py
    Specfile (Scan/MCA) navigation/plotting demo application 
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
    
"""


import qt
import sys
import string
import Command
import string
import Numeric

import PyDVT.TableView as TableView
import PyDVT.DataInfoView as DataInfoView
import PyDVT.SpecFileData as SpecFileData
import PyDVT.Filter as Filter
import PyDVT.DataSelection as DataSelection
import PyDVT.Binding as Binding
import PyDVT.GraphView as GraphView



class SpecFileFilter(Filter.Filter):
    def GetOutput(self):
        sel=self.GetInput()

        try:
            data=self.GetData()
            datasel=self.GetDataSelection()
            page=datasel.GetInfo()["index_list"][0]
            page_info=data.GetPageInfo(page)
        
            if "data" in sel.keys():
                if page_info["KeyType"]=="scan":
                    if page_info["col"]=="ALL":
                        sel["xdata"]=page_info['AllLabels']
                    else:
                        sel["xdata"]=[page_info["col"]]
                    if page_info["row"]!="ALL":
                        sel["ydata"]=[page_info['row']]
                    else:
                        sel["ydata"]=Numeric.arrayrange(sel["data"].shape[0])
                elif page_info["KeyType"]=="mca":
                    sel["xdata"]=Numeric.arrayrange(sel["data"].shape[0])

        except:
            return {}
        return sel

                    

def PlotGraph(view):
    if str(view.caption())[:3]=="MCA":        
        filt=GraphView.GraphFilter("1",view.GetSource()[0])
    elif str(view.caption())[:4]=="SCAN":
        selection=view.Drawable.selection(0)
        if selection.isActive():
            data=view.GetSource()[0].GetOutput()["data"]            
            if selection.anchorRow() == selection.topRow() == selection.bottomRow():
                filt=GraphView.Graph(data[selection.anchorRow()])
            elif selection.anchorCol()== selection.leftCol() == selection.rightCol():
                arr=Numeric.take(data, (selection.anchorCol(),),1)
                filt=GraphView.Graph(Numeric.reshape(arr,(arr.shape[0],)))   
            else:
                qt.QMessageBox.warning(None,'DemoSpecFile',"Select row or column to plot")
                return
        else:
            qt.QMessageBox.warning(None,'DemoSpecFile',"Select row or column to plot")
            return
    else:return

    dlg=GraphView.GraphView(None,{"AddStyleSelect":1,"AddCursorSelect":1,"AddStatus":1,"AutoHideStatus":1})    
    dlg.SetSource(filt)
    dlg.SetOnLine(0)
    dlg.resize(400,300)
    dlg.Show()

def DataInfo(view):        
    infoView = DataInfoView.DataInfoView(None)            
    infoView.SetSource(data)
    infoView.resize(400,300)
    infoView.Drawable.AdjustColumn(2)
    infoView.Show()



def LoadKey(key,data,view):    
    view.SetOnLine(0)
    data.LoadSource(key)
    if string.count(key, '.') == 1:
        view.SetSource(SpecFileFilter(DataSelection.RectSelection(data)))
        view.setCaption("SCAN " + key)        
    else:
        view.SetSource(SpecFileFilter(DataSelection.OrthoLineSelection(data)))
        view.setCaption("MCA " + key)        
    view.SetOnLine(1)
    view.Refresh()
    

def SaveAs(view):    
    filter=""
    for fmt in view.GetSaveFormats():
        filter=filter+"%s files (*.%s);;" % (fmt,string.lower(fmt))
    if filter=="":
        qt.QMessageBox.warning(None,'Save',"No file format supported by view object")
        return
    if qt.qVersion()>="3.0.0":
        selected=qt.QString()
        fn = qt.QFileDialog.getSaveFileName(qt.QString.null,filter,view,None,qt.QString.null,selected)
    else:
        dlg=qt.QFileDialog(qt.QString.null,filter,view,None,1)
        dlg.setCaption("Save As")
        dlg.show()            
        fn=dlg.selectedFile()
        selected=dlg.selectedFilter()
    if fn.isEmpty(): return None
    save_filename = str(fn)
    format=string.upper(str(selected)[-4:-1])
    if format==".PS":format="PS"
    if view.Save(save_filename,format): return (save_filename,format)
    return None
        
try:
    filename=sys.argv[1]                   
    app = qt.QApplication(sys.argv)  
    view = TableView.TableView(None)

    data=SpecFileData.SpecFileData()
    data.SetSource(filename)
    info=data.GetSourceInfo()['KeyList']
    nummca=data.GetSourceInfo()['NumMca']

    selcascademenu=Binding.Menu(view.GetPopupMenu())
    for index in range (len(info)):
        scancascademenu=Binding.Menu(selcascademenu)
        scan=info[index]
        nmca=nummca[index]
        scancascademenu.AddCommand("Scan data",Command.Command(LoadKey, scan, data, view))
        mcacascademenu=Binding.Menu(scancascademenu)
        for i in range(int(nmca)):
            key="%s.%i" %(scan,i+1)
            mcacascademenu.AddCommand(key,Command.Command(LoadKey, key,  data, view))
        scancascademenu.AddCascade("MCA",mcacascademenu)
        selcascademenu.AddCascade(scan,scancascademenu)
    view.AddMenuPopupCascade("Select Scan",selcascademenu)
            
    view.AddMenuSeparator()
    view.AddMenuPopupItem("Plot Graph",Command.Command(PlotGraph, view))
    view.AddMenuPopupItem("Data Info",Command.Command(DataInfo, view))
    view.AddMenuPopupItem("Save",Command.Command(SaveAs, view))
    view.SetSource(SpecFileFilter(None))
     
    app.setMainWidget(view)
    view.resize(400,300)
    view.Show()
    app.exec_loop()
    
except:
    import traceback
    traceback.print_exc()
    print "Usage: DemoSpecFileQt <filename>"





